/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hudi.storage.StoragePathInfo;

public class HoodieRollbackStat
implements Serializable {
    private final String partitionPath;
    private final List<String> successDeleteFiles;
    private final List<String> failedDeleteFiles;
    private final Map<StoragePathInfo, Long> commandBlocksCount;
    private final Map<String, Long> logFilesFromFailedCommit;

    public HoodieRollbackStat(String partitionPath, List<String> successDeleteFiles, List<String> failedDeleteFiles, Map<StoragePathInfo, Long> commandBlocksCount, Map<String, Long> logFilesFromFailedCommit) {
        this.partitionPath = partitionPath;
        this.successDeleteFiles = successDeleteFiles;
        this.failedDeleteFiles = failedDeleteFiles;
        this.commandBlocksCount = commandBlocksCount;
        this.logFilesFromFailedCommit = logFilesFromFailedCommit;
    }

    public Map<StoragePathInfo, Long> getCommandBlocksCount() {
        return this.commandBlocksCount;
    }

    public String getPartitionPath() {
        return this.partitionPath;
    }

    public List<String> getSuccessDeleteFiles() {
        return this.successDeleteFiles;
    }

    public List<String> getFailedDeleteFiles() {
        return this.failedDeleteFiles;
    }

    public Map<String, Long> getLogFilesFromFailedCommit() {
        return this.logFilesFromFailedCommit;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private List<String> successDeleteFiles;
        private List<String> failedDeleteFiles;
        private Map<StoragePathInfo, Long> commandBlocksCount;
        private Map<String, Long> logFilesFromFailedCommit;
        private String partitionPath;

        public Builder withDeletedFileResults(Map<StoragePathInfo, Boolean> deletedFiles) {
            this.successDeleteFiles = deletedFiles.entrySet().stream().filter(s -> (Boolean)s.getValue()).map(s -> ((StoragePathInfo)s.getKey()).getPath().toString()).collect(Collectors.toList());
            this.failedDeleteFiles = deletedFiles.entrySet().stream().filter(s -> (Boolean)s.getValue() == false).map(s -> ((StoragePathInfo)s.getKey()).getPath().toString()).collect(Collectors.toList());
            return this;
        }

        public Builder withDeletedFileResult(String fileName, boolean isDeleted) {
            if (isDeleted) {
                this.successDeleteFiles = Collections.singletonList(fileName);
            } else {
                this.failedDeleteFiles = Collections.singletonList(fileName);
            }
            return this;
        }

        public Builder withRollbackBlockAppendResults(Map<StoragePathInfo, Long> commandBlocksCount) {
            this.commandBlocksCount = commandBlocksCount;
            return this;
        }

        public Builder withPartitionPath(String partitionPath) {
            this.partitionPath = partitionPath;
            return this;
        }

        public Builder withLogFilesFromFailedCommit(Map<String, Long> logFilesFromFailedCommit) {
            this.logFilesFromFailedCommit = logFilesFromFailedCommit;
            return this;
        }

        public HoodieRollbackStat build() {
            if (this.successDeleteFiles == null) {
                this.successDeleteFiles = Collections.EMPTY_LIST;
            }
            if (this.failedDeleteFiles == null) {
                this.failedDeleteFiles = Collections.EMPTY_LIST;
            }
            if (this.commandBlocksCount == null) {
                this.commandBlocksCount = Collections.EMPTY_MAP;
            }
            if (this.logFilesFromFailedCommit == null) {
                this.logFilesFromFailedCommit = Collections.EMPTY_MAP;
            }
            return new HoodieRollbackStat(this.partitionPath, this.successDeleteFiles, this.failedDeleteFiles, this.commandBlocksCount, this.logFilesFromFailedCommit);
        }
    }
}

