/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.callback.util;

import org.apache.hudi.callback.HoodieWriteCommitCallback;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.config.HoodieWriteCommitCallbackConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieCommitCallbackException;

public class HoodieCommitCallbackFactory {
    public static HoodieWriteCommitCallback create(HoodieWriteConfig config) {
        String callbackClass = config.getCallbackClass();
        if (!StringUtils.isNullOrEmpty(callbackClass)) {
            Object instance = ReflectionUtils.loadClass(callbackClass, config);
            if (!(instance instanceof HoodieWriteCommitCallback)) {
                throw new HoodieCommitCallbackException(callbackClass + " is not a subclass of " + HoodieWriteCommitCallback.class.getSimpleName());
            }
            return (HoodieWriteCommitCallback)instance;
        }
        throw new HoodieCommitCallbackException(String.format("The value of the config option %s can not be null or empty", HoodieWriteCommitCallbackConfig.CALLBACK_CLASS_NAME.key()));
    }
}

