/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.parquet.vector.reader;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.sql.Timestamp;
import java.util.concurrent.TimeUnit;
import org.apache.flink.formats.parquet.vector.reader.AbstractColumnReader;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.data.columnar.vector.writable.WritableIntVector;
import org.apache.flink.table.data.columnar.vector.writable.WritableTimestampVector;
import org.apache.parquet.Preconditions;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.Dictionary;
import org.apache.parquet.column.page.PageReader;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.PrimitiveType;

public class TimestampColumnReader
extends AbstractColumnReader<WritableTimestampVector> {
    public static final int JULIAN_EPOCH_OFFSET_DAYS = 2440588;
    public static final long MILLIS_IN_DAY = TimeUnit.DAYS.toMillis(1L);
    public static final long NANOS_PER_MILLISECOND = TimeUnit.MILLISECONDS.toNanos(1L);
    public static final long NANOS_PER_SECOND = TimeUnit.SECONDS.toNanos(1L);
    private final boolean utcTimestamp;

    public TimestampColumnReader(boolean utcTimestamp, ColumnDescriptor descriptor, PageReader pageReader) throws IOException {
        super(descriptor, pageReader);
        this.utcTimestamp = utcTimestamp;
        this.checkTypeName(PrimitiveType.PrimitiveTypeName.INT96);
    }

    @Override
    protected boolean supportLazyDecode() {
        return this.utcTimestamp;
    }

    @Override
    protected void readBatch(int rowId, int num, WritableTimestampVector column) {
        for (int i = 0; i < num; ++i) {
            if (this.runLenDecoder.readInteger() == this.maxDefLevel) {
                ByteBuffer buffer = this.readDataBuffer(12);
                column.setTimestamp(rowId + i, TimestampColumnReader.int96ToTimestamp(this.utcTimestamp, buffer.getLong(), buffer.getInt()));
                continue;
            }
            column.setNullAt(rowId + i);
        }
    }

    @Override
    protected void readBatchFromDictionaryIds(int rowId, int num, WritableTimestampVector column, WritableIntVector dictionaryIds) {
        for (int i = rowId; i < rowId + num; ++i) {
            if (column.isNullAt(i)) continue;
            column.setTimestamp(i, TimestampColumnReader.decodeInt96ToTimestamp(this.utcTimestamp, this.dictionary, dictionaryIds.getInt(i)));
        }
    }

    public static TimestampData decodeInt96ToTimestamp(boolean utcTimestamp, Dictionary dictionary, int id) {
        Binary binary = dictionary.decodeToBinary(id);
        Preconditions.checkArgument(binary.length() == 12, "Timestamp with int96 should be 12 bytes.");
        ByteBuffer buffer = binary.toByteBuffer().order(ByteOrder.LITTLE_ENDIAN);
        return TimestampColumnReader.int96ToTimestamp(utcTimestamp, buffer.getLong(), buffer.getInt());
    }

    public static TimestampData int96ToTimestamp(boolean utcTimestamp, long nanosOfDay, int julianDay) {
        long millisecond = TimestampColumnReader.julianDayToMillis(julianDay) + nanosOfDay / NANOS_PER_MILLISECOND;
        if (utcTimestamp) {
            int nanoOfMillisecond = (int)(nanosOfDay % NANOS_PER_MILLISECOND);
            return TimestampData.fromEpochMillis((long)millisecond, (int)nanoOfMillisecond);
        }
        Timestamp timestamp = new Timestamp(millisecond);
        timestamp.setNanos((int)(nanosOfDay % NANOS_PER_SECOND));
        return TimestampData.fromTimestamp((Timestamp)timestamp);
    }

    private static long julianDayToMillis(int julianDay) {
        return (long)(julianDay - 2440588) * MILLIS_IN_DAY;
    }
}

