/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.marker;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.HoodieWrapperFileSystem;
import org.apache.hudi.common.table.marker.MarkerType;
import org.apache.hudi.common.util.MarkerUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.marker.WriteMarkers;
import org.apache.hudi.table.marker.WriteMarkersFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarkerBasedRollbackUtils {
    private static final Logger LOG = LoggerFactory.getLogger(MarkerBasedRollbackUtils.class);

    public static List<String> getAllMarkerPaths(HoodieTable table, HoodieEngineContext context, String instant, int parallelism) throws IOException {
        String markerDir = table.getMetaClient().getMarkerFolderPath(instant);
        HoodieWrapperFileSystem fileSystem2 = table.getMetaClient().getFs();
        Option<MarkerType> markerTypeOption = MarkerUtils.readMarkerType(fileSystem2, markerDir);
        if (!markerTypeOption.isPresent()) {
            WriteMarkers writeMarkers = WriteMarkersFactory.get(MarkerType.DIRECT, table, instant);
            try {
                return new ArrayList<String>(writeMarkers.allMarkerFilePaths());
            }
            catch (IOException | IllegalArgumentException e) {
                LOG.warn(String.format("%s not present and %s marker failed with error: %s. So, falling back to %s marker", new Object[]{"MARKERS.type", MarkerType.DIRECT, e.getMessage(), MarkerType.TIMELINE_SERVER_BASED}));
                return MarkerBasedRollbackUtils.getTimelineServerBasedMarkers(context, parallelism, markerDir, fileSystem2);
            }
        }
        switch (markerTypeOption.get()) {
            case TIMELINE_SERVER_BASED: {
                return MarkerBasedRollbackUtils.getTimelineServerBasedMarkers(context, parallelism, markerDir, fileSystem2);
            }
        }
        throw new HoodieException("The marker type \"" + markerTypeOption.get().name() + "\" is not supported.");
    }

    private static List<String> getTimelineServerBasedMarkers(HoodieEngineContext context, int parallelism, String markerDir, FileSystem fileSystem2) {
        Map<String, Set<String>> markersMap = MarkerUtils.readTimelineServerBasedMarkersFromFileSystem(markerDir, fileSystem2, context, parallelism);
        return markersMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }
}

