/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.cluster.strategy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.avro.model.HoodieClusteringGroup;
import org.apache.hudi.avro.model.HoodieClusteringPlan;
import org.apache.hudi.avro.model.HoodieClusteringStrategy;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.cluster.ClusteringPlanPartitionFilter;
import org.apache.hudi.table.action.cluster.strategy.ClusteringPlanStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PartitionAwareClusteringPlanStrategy<T, I, K, O>
extends ClusteringPlanStrategy<T, I, K, O> {
    private static final Logger LOG = LoggerFactory.getLogger(PartitionAwareClusteringPlanStrategy.class);

    public PartitionAwareClusteringPlanStrategy(HoodieTable table, HoodieEngineContext engineContext, HoodieWriteConfig writeConfig) {
        super(table, engineContext, writeConfig);
    }

    protected Stream<HoodieClusteringGroup> buildClusteringGroupsForPartition(String partitionPath, List<FileSlice> fileSlices) {
        HoodieWriteConfig writeConfig = this.getWriteConfig();
        ArrayList fileSliceGroups = new ArrayList();
        ArrayList<FileSlice> currentGroup = new ArrayList<FileSlice>();
        ArrayList<FileSlice> sortedFileSlices = new ArrayList<FileSlice>(fileSlices);
        sortedFileSlices.sort((o1, o2) -> (int)((o2.getBaseFile().isPresent() ? o2.getBaseFile().get().getFileSize() : writeConfig.getParquetMaxFileSize()) - (o1.getBaseFile().isPresent() ? o1.getBaseFile().get().getFileSize() : writeConfig.getParquetMaxFileSize())));
        long totalSizeSoFar = 0L;
        for (FileSlice currentSlice : sortedFileSlices) {
            long currentSize;
            long l = currentSize = currentSlice.getBaseFile().isPresent() ? currentSlice.getBaseFile().get().getFileSize() : writeConfig.getParquetMaxFileSize();
            if (totalSizeSoFar + currentSize > writeConfig.getClusteringMaxBytesInGroup() && !currentGroup.isEmpty()) {
                int numOutputGroups = this.getNumberOfOutputFileGroups(totalSizeSoFar, writeConfig.getClusteringTargetFileMaxBytes());
                LOG.info("Adding one clustering group " + totalSizeSoFar + " max bytes: " + writeConfig.getClusteringMaxBytesInGroup() + " num input slices: " + currentGroup.size() + " output groups: " + numOutputGroups);
                fileSliceGroups.add(Pair.of(currentGroup, numOutputGroups));
                currentGroup = new ArrayList();
                totalSizeSoFar = 0L;
                if (fileSliceGroups.size() >= writeConfig.getClusteringMaxNumGroups()) {
                    LOG.info("Having generated the maximum number of groups : " + writeConfig.getClusteringMaxNumGroups());
                    break;
                }
            }
            currentGroup.add(currentSlice);
            totalSizeSoFar += currentSize;
        }
        if (!currentGroup.isEmpty() && (currentGroup.size() > 1 || writeConfig.shouldClusteringSingleGroup())) {
            int numOutputGroups = this.getNumberOfOutputFileGroups(totalSizeSoFar, writeConfig.getClusteringTargetFileMaxBytes());
            LOG.info("Adding final clustering group " + totalSizeSoFar + " max bytes: " + writeConfig.getClusteringMaxBytesInGroup() + " num input slices: " + currentGroup.size() + " output groups: " + numOutputGroups);
            fileSliceGroups.add(Pair.of(currentGroup, numOutputGroups));
        }
        return fileSliceGroups.stream().map(fileSliceGroup -> HoodieClusteringGroup.newBuilder().setSlices(PartitionAwareClusteringPlanStrategy.getFileSliceInfo((List)fileSliceGroup.getLeft())).setNumOutputFileGroups((Integer)fileSliceGroup.getRight()).setMetrics(this.buildMetrics((List)fileSliceGroup.getLeft())).build());
    }

    protected List<String> filterPartitionPaths(List<String> partitionPaths) {
        List<String> filteredPartitions = ClusteringPlanPartitionFilter.filter(partitionPaths, this.getWriteConfig());
        LOG.debug("Filtered to the following partitions: " + filteredPartitions);
        return filteredPartitions;
    }

    @Override
    public Option<HoodieClusteringPlan> generateClusteringPlan() {
        if (!this.checkPrecondition()) {
            return Option.empty();
        }
        HoodieTableMetaClient metaClient = this.getHoodieTable().getMetaClient();
        LOG.info("Scheduling clustering for " + metaClient.getBasePath());
        HoodieWriteConfig config = this.getWriteConfig();
        String partitionSelected = config.getClusteringPartitionSelected();
        LOG.info("Scheduling clustering partitionSelected: " + partitionSelected);
        List<String> partitionPaths = StringUtils.isNullOrEmpty(partitionSelected) ? this.getRegexPatternMatchedPartitions(config, FSUtils.getAllPartitionPaths(this.getEngineContext(), config.getMetadataConfig(), metaClient.getBasePath())) : Arrays.asList(partitionSelected.split(","));
        partitionPaths = this.filterPartitionPaths(partitionPaths);
        LOG.info("Scheduling clustering partitionPaths: " + partitionPaths);
        if (partitionPaths.isEmpty()) {
            return Option.empty();
        }
        List<HoodieClusteringGroup> clusteringGroups = this.getEngineContext().flatMap(partitionPaths, partitionPath -> {
            List<FileSlice> fileSlicesEligible = this.getFileSlicesEligibleForClustering((String)partitionPath).collect(Collectors.toList());
            return this.buildClusteringGroupsForPartition((String)partitionPath, fileSlicesEligible).limit(this.getWriteConfig().getClusteringMaxNumGroups());
        }, partitionPaths.size()).stream().limit(this.getWriteConfig().getClusteringMaxNumGroups()).collect(Collectors.toList());
        if (clusteringGroups.isEmpty()) {
            LOG.warn("No data available to cluster");
            return Option.empty();
        }
        HoodieClusteringStrategy strategy = HoodieClusteringStrategy.newBuilder().setStrategyClassName(this.getWriteConfig().getClusteringExecutionStrategyClass()).setStrategyParams(this.getStrategyParams()).build();
        return Option.of(HoodieClusteringPlan.newBuilder().setStrategy(strategy).setInputGroups(clusteringGroups).setExtraMetadata(this.getExtraMetadata()).setVersion(this.getPlanVersion()).setPreserveHoodieMetadata(true).build());
    }

    public List<String> getRegexPatternMatchedPartitions(HoodieWriteConfig config, List<String> partitionPaths) {
        String pattern = config.getClusteringPartitionFilterRegexPattern();
        if (!StringUtils.isNullOrEmpty(pattern)) {
            partitionPaths = partitionPaths.stream().filter(partition -> Pattern.matches(pattern, partition)).collect(Collectors.toList());
        }
        return partitionPaths;
    }

    protected int getNumberOfOutputFileGroups(long groupSize, long targetFileSize) {
        return (int)Math.ceil((double)groupSize / (double)targetFileSize);
    }
}

