/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.objenesis.instantiator.sun;

import java.lang.reflect.Constructor;
import org.apache.hudi.org.objenesis.ObjenesisException;
import org.apache.hudi.org.objenesis.instantiator.ObjectInstantiator;
import org.apache.hudi.org.objenesis.instantiator.annotations.Instantiator;
import org.apache.hudi.org.objenesis.instantiator.annotations.Typology;
import org.apache.hudi.org.objenesis.instantiator.sun.SunReflectionFactoryHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Instantiator(value=Typology.STANDARD)
public class SunReflectionFactoryInstantiator<T>
implements ObjectInstantiator<T> {
    private final Constructor<T> mungedConstructor;

    public SunReflectionFactoryInstantiator(Class<T> type) {
        Constructor<Object> javaLangObjectConstructor = SunReflectionFactoryInstantiator.getJavaLangObjectConstructor();
        this.mungedConstructor = SunReflectionFactoryHelper.newConstructorForSerialization(type, javaLangObjectConstructor);
        this.mungedConstructor.setAccessible(true);
    }

    @Override
    public T newInstance() {
        try {
            return this.mungedConstructor.newInstance(null);
        }
        catch (Exception e) {
            throw new ObjenesisException(e);
        }
    }

    private static Constructor<Object> getJavaLangObjectConstructor() {
        try {
            return Object.class.getConstructor(null);
        }
        catch (NoSuchMethodException e) {
            throw new ObjenesisException(e);
        }
    }
}

