/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.replication.regionserver;

import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.org.apache.hadoop.hbase.Cell;
import org.apache.hudi.org.apache.hadoop.hbase.CellUtil;
import org.apache.hudi.org.apache.hadoop.hbase.replication.WALEntryFilter;
import org.apache.hudi.org.apache.hadoop.hbase.replication.regionserver.ReplicationSource;
import org.apache.hudi.org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceLogQueue;
import org.apache.hudi.org.apache.hadoop.hbase.replication.regionserver.WALEntryBatch;
import org.apache.hudi.org.apache.hadoop.hbase.replication.regionserver.WALEntryFilterRetryableException;
import org.apache.hudi.org.apache.hadoop.hbase.replication.regionserver.WALEntryStream;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.WALProtos;
import org.apache.hudi.org.apache.hadoop.hbase.util.Pair;
import org.apache.hudi.org.apache.hadoop.hbase.util.Threads;
import org.apache.hudi.org.apache.hadoop.hbase.wal.AbstractFSWALProvider;
import org.apache.hudi.org.apache.hadoop.hbase.wal.WAL;
import org.apache.hudi.org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hudi.org.apache.hadoop.hbase.wal.WALKeyImpl;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
class ReplicationSourceWALReader
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(ReplicationSourceWALReader.class);
    private final ReplicationSourceLogQueue logQueue;
    private final FileSystem fs;
    private final Configuration conf;
    private final WALEntryFilter filter;
    private final ReplicationSource source;
    @InterfaceAudience.Private
    final BlockingQueue<WALEntryBatch> entryBatchQueue;
    private final long replicationBatchSizeCapacity;
    private final int replicationBatchCountCapacity;
    private long currentPosition;
    private final long sleepForRetries;
    private final int maxRetriesMultiplier;
    private final boolean eofAutoRecovery;
    private boolean isReaderRunning = true;
    private AtomicLong totalBufferUsed;
    private long totalBufferQuota;
    private final String walGroupId;

    public ReplicationSourceWALReader(FileSystem fs, Configuration conf, ReplicationSourceLogQueue logQueue, long startPosition, WALEntryFilter filter, ReplicationSource source, String walGroupId) {
        this.logQueue = logQueue;
        this.currentPosition = startPosition;
        this.fs = fs;
        this.conf = conf;
        this.filter = filter;
        this.source = source;
        this.replicationBatchSizeCapacity = this.conf.getLong("replication.source.size.capacity", 0x4000000L);
        this.replicationBatchCountCapacity = this.conf.getInt("replication.source.nb.capacity", 25000);
        int batchCount = conf.getInt("replication.source.nb.batches", 1);
        this.totalBufferUsed = source.getSourceManager().getTotalBufferUsed();
        this.totalBufferQuota = source.getSourceManager().getTotalBufferLimit();
        this.sleepForRetries = this.conf.getLong("replication.source.sleepforretries", 1000L);
        this.maxRetriesMultiplier = this.conf.getInt("replication.source.maxretriesmultiplier", 300);
        this.eofAutoRecovery = conf.getBoolean("replication.source.eof.autorecovery", false);
        this.entryBatchQueue = new LinkedBlockingQueue<WALEntryBatch>(batchCount);
        this.walGroupId = walGroupId;
        LOG.info("peerClusterZnode=" + source.getQueueId() + ", ReplicationSourceWALReaderThread : " + source.getPeerId() + " inited, replicationBatchSizeCapacity=" + this.replicationBatchSizeCapacity + ", replicationBatchCountCapacity=" + this.replicationBatchCountCapacity + ", replicationBatchQueueCapacity=" + batchCount);
    }

    @Override
    public void run() {
        int sleepMultiplier = 1;
        while (this.isReaderRunning()) {
            WALEntryBatch batch = null;
            try {
                WALEntryStream entryStream = new WALEntryStream(this.logQueue, this.conf, this.currentPosition, this.source.getWALFileLengthProvider(), this.source.getServerWALsBelongTo(), this.source.getSourceMetrics(), this.walGroupId);
                Throwable throwable = null;
                try {
                    while (this.isReaderRunning()) {
                        batch = null;
                        if (!this.source.isPeerEnabled()) {
                            Threads.sleep(this.sleepForRetries);
                            continue;
                        }
                        if (!this.checkQuota()) continue;
                        batch = this.tryAdvanceStreamAndCreateWALBatch(entryStream);
                        if (batch == null) {
                            this.handleEmptyWALEntryBatch();
                            entryStream.reset();
                            continue;
                        }
                        if (!batch.isEndOfFile()) {
                            this.readWALEntries(entryStream, batch);
                            this.currentPosition = entryStream.getPosition();
                        }
                        LOG.debug("Read {} WAL entries eligible for replication", (Object)batch.getNbEntries());
                        this.entryBatchQueue.put(batch);
                        sleepMultiplier = 1;
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (entryStream == null) continue;
                    if (throwable != null) {
                        try {
                            entryStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    entryStream.close();
                }
            }
            catch (IOException | WALEntryFilterRetryableException e) {
                if (this.handleEofException(e, batch)) continue;
                LOG.warn("Failed to read stream of replication entries", (Throwable)e);
                if (sleepMultiplier < this.maxRetriesMultiplier) {
                    ++sleepMultiplier;
                }
                Threads.sleep(this.sleepForRetries * (long)sleepMultiplier);
            }
            catch (InterruptedException e) {
                LOG.trace("Interrupted while sleeping between WAL reads or adding WAL batch to ship queue");
                Thread.currentThread().interrupt();
            }
        }
    }

    protected final boolean addEntryToBatch(WALEntryBatch batch, WAL.Entry entry) {
        WALEdit edit = entry.getEdit();
        if (edit == null || edit.isEmpty()) {
            LOG.debug("Edit null or empty for entry {} ", (Object)entry);
            return false;
        }
        LOG.debug("updating TimeStampOfLastAttempted to {}, from entry {}, for source queue: {}", new Object[]{entry.getKey().getWriteTime(), entry.getKey(), this.source.getQueueId()});
        long entrySize = this.getEntrySizeIncludeBulkLoad(entry);
        long entrySizeExcludeBulkLoad = ReplicationSourceWALReader.getEntrySizeExcludeBulkLoad(entry);
        batch.addEntry(entry, entrySize);
        this.updateBatchStats(batch, entry, entrySize);
        boolean totalBufferTooLarge = this.acquireBufferQuota(entrySizeExcludeBulkLoad);
        return totalBufferTooLarge || batch.getHeapSize() >= this.replicationBatchSizeCapacity || batch.getNbEntries() >= this.replicationBatchCountCapacity;
    }

    protected static final boolean switched(WALEntryStream entryStream, Path path) {
        Path newPath = entryStream.getCurrentPath();
        return newPath == null || !path.getName().equals(newPath.getName());
    }

    protected void readWALEntries(WALEntryStream entryStream, WALEntryBatch batch) throws IOException, InterruptedException {
        boolean hasNext;
        Path currentPath = entryStream.getCurrentPath();
        do {
            WAL.Entry entry = entryStream.next();
            batch.setLastWalPosition(entryStream.getPosition());
            entry = this.filterEntry(entry);
            if (entry != null && this.addEntryToBatch(batch, entry)) break;
            hasNext = entryStream.hasNext();
            if (!ReplicationSourceWALReader.switched(entryStream, currentPath)) continue;
            batch.setEndOfFile(true);
            break;
        } while (hasNext);
    }

    private void handleEmptyWALEntryBatch() throws InterruptedException {
        LOG.trace("Didn't read any new entries from WAL");
        if (this.logQueue.getQueue(this.walGroupId).isEmpty()) {
            LOG.debug("Stopping the replication source wal reader");
            this.setReaderRunning(false);
            this.entryBatchQueue.put(WALEntryBatch.NO_MORE_DATA);
        } else {
            Thread.sleep(this.sleepForRetries);
        }
    }

    private WALEntryBatch tryAdvanceStreamAndCreateWALBatch(WALEntryStream entryStream) throws IOException {
        Path currentPath = entryStream.getCurrentPath();
        if (!entryStream.hasNext()) {
            if (currentPath != null && ReplicationSourceWALReader.switched(entryStream, currentPath)) {
                return WALEntryBatch.endOfFile(currentPath);
            }
            return null;
        }
        if (currentPath != null && ReplicationSourceWALReader.switched(entryStream, currentPath)) {
            return WALEntryBatch.endOfFile(currentPath);
        }
        return this.createBatch(entryStream);
    }

    private boolean handleEofException(Exception e, WALEntryBatch batch) {
        PriorityBlockingQueue<Path> queue = this.logQueue.getQueue(this.walGroupId);
        if ((e instanceof EOFException || e.getCause() instanceof EOFException) && (this.source.isRecovered() || queue.size() > 1) && this.eofAutoRecovery) {
            Path path = queue.peek();
            try {
                if (!this.fs.exists(path)) {
                    path = AbstractFSWALProvider.findArchivedLog(path, this.conf);
                }
                if (path != null && this.fs.getFileStatus(path).getLen() == 0L) {
                    LOG.warn("Forcing removal of 0 length log in queue: {}", (Object)path);
                    this.logQueue.remove(this.walGroupId);
                    this.currentPosition = 0L;
                    if (batch != null) {
                        this.addBatchToShippingQueue(batch);
                    }
                    return true;
                }
            }
            catch (IOException ioe) {
                LOG.warn("Couldn't get file length information about log " + path, (Throwable)ioe);
            }
            catch (InterruptedException ie) {
                LOG.trace("Interrupted while adding WAL batch to ship queue");
                Thread.currentThread().interrupt();
            }
        }
        return false;
    }

    private void addBatchToShippingQueue(WALEntryBatch batch) throws InterruptedException {
        LOG.debug("Read {} WAL entries eligible for replication", (Object)batch.getNbEntries());
        this.entryBatchQueue.put(batch);
    }

    public Path getCurrentPath() {
        WALEntryBatch batchQueueHead = (WALEntryBatch)this.entryBatchQueue.peek();
        if (batchQueueHead != null) {
            return batchQueueHead.getLastWalPath();
        }
        return this.logQueue.getQueue(this.walGroupId).peek();
    }

    private boolean checkQuota() {
        if (this.totalBufferUsed.get() > this.totalBufferQuota) {
            LOG.warn("peer={}, can't read more edits from WAL as buffer usage {}B exceeds limit {}B", new Object[]{this.source.getPeerId(), this.totalBufferUsed.get(), this.totalBufferQuota});
            Threads.sleep(this.sleepForRetries);
            return false;
        }
        return true;
    }

    private WALEntryBatch createBatch(WALEntryStream entryStream) {
        return new WALEntryBatch(this.replicationBatchCountCapacity, entryStream.getCurrentPath());
    }

    protected final WAL.Entry filterEntry(WAL.Entry entry) {
        WAL.Entry filtered = this.filter.filter(entry);
        if (entry != null && (filtered == null || filtered.getEdit().size() == 0)) {
            LOG.debug("Filtered entry for replication: {}", (Object)entry);
            this.source.getSourceMetrics().incrLogEditsFiltered();
        }
        return filtered;
    }

    public WALEntryBatch take() throws InterruptedException {
        return this.entryBatchQueue.take();
    }

    public WALEntryBatch poll(long timeout) throws InterruptedException {
        return this.entryBatchQueue.poll(timeout, TimeUnit.MILLISECONDS);
    }

    private long getEntrySizeIncludeBulkLoad(WAL.Entry entry) {
        WALEdit edit = entry.getEdit();
        return ReplicationSourceWALReader.getEntrySizeExcludeBulkLoad(entry) + (long)this.sizeOfStoreFilesIncludeBulkLoad(edit);
    }

    public static long getEntrySizeExcludeBulkLoad(WAL.Entry entry) {
        WALEdit edit = entry.getEdit();
        WALKeyImpl key = entry.getKey();
        return edit.heapSize() + key.estimatedSerializedSizeOf();
    }

    private void updateBatchStats(WALEntryBatch batch, WAL.Entry entry, long entrySize) {
        WALEdit edit = entry.getEdit();
        batch.incrementHeapSize(entrySize);
        Pair<Integer, Integer> nbRowsAndHFiles = this.countDistinctRowKeysAndHFiles(edit);
        batch.incrementNbRowKeys(nbRowsAndHFiles.getFirst());
        batch.incrementNbHFiles(nbRowsAndHFiles.getSecond());
    }

    private Pair<Integer, Integer> countDistinctRowKeysAndHFiles(WALEdit edit) {
        ArrayList<Cell> cells = edit.getCells();
        int distinctRowKeys = 1;
        int totalHFileEntries = 0;
        Cell lastCell = (Cell)cells.get(0);
        int totalCells = edit.size();
        for (int i = 0; i < totalCells; ++i) {
            if (CellUtil.matchingQualifier((Cell)cells.get(i), WALEdit.BULK_LOAD)) {
                try {
                    WALProtos.BulkLoadDescriptor bld = WALEdit.getBulkLoadDescriptor((Cell)cells.get(i));
                    List<WALProtos.StoreDescriptor> stores = bld.getStoresList();
                    int totalStores = stores.size();
                    for (int j = 0; j < totalStores; ++j) {
                        totalHFileEntries += stores.get(j).getStoreFileList().size();
                    }
                }
                catch (IOException e) {
                    LOG.error("Failed to deserialize bulk load entry from wal edit. Then its hfiles count will not be added into metric.", (Throwable)e);
                }
            }
            if (!CellUtil.matchingRows((Cell)cells.get(i), lastCell)) {
                ++distinctRowKeys;
            }
            lastCell = (Cell)cells.get(i);
        }
        Pair<Integer, Integer> result = new Pair<Integer, Integer>(distinctRowKeys, totalHFileEntries);
        return result;
    }

    private int sizeOfStoreFilesIncludeBulkLoad(WALEdit edit) {
        ArrayList<Cell> cells = edit.getCells();
        int totalStoreFilesSize = 0;
        int totalCells = edit.size();
        for (int i = 0; i < totalCells; ++i) {
            if (!CellUtil.matchingQualifier((Cell)cells.get(i), WALEdit.BULK_LOAD)) continue;
            try {
                WALProtos.BulkLoadDescriptor bld = WALEdit.getBulkLoadDescriptor((Cell)cells.get(i));
                List<WALProtos.StoreDescriptor> stores = bld.getStoresList();
                int totalStores = stores.size();
                for (int j = 0; j < totalStores; ++j) {
                    totalStoreFilesSize = (int)((long)totalStoreFilesSize + stores.get(j).getStoreFileSizeBytes());
                }
                continue;
            }
            catch (IOException e) {
                LOG.error("Failed to deserialize bulk load entry from wal edit. Size of HFiles part of cell will not be considered in replication request size calculation.", (Throwable)e);
            }
        }
        return totalStoreFilesSize;
    }

    private boolean acquireBufferQuota(long size) {
        long newBufferUsed = this.totalBufferUsed.addAndGet(size);
        this.source.getSourceManager().getGlobalMetrics().setWALReaderEditsBufferBytes(newBufferUsed);
        return newBufferUsed >= this.totalBufferQuota;
    }

    public boolean isReaderRunning() {
        return this.isReaderRunning && !this.isInterrupted();
    }

    public void setReaderRunning(boolean readerRunning) {
        this.isReaderRunning = readerRunning;
    }
}

