/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.hudi.org.apache.hadoop.hbase.Cell;
import org.apache.hudi.org.apache.hadoop.hbase.CellComparator;
import org.apache.hudi.org.apache.hadoop.hbase.CellUtil;
import org.apache.hudi.org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.AbstractMultiFileWriter;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.StoreFileWriter;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.StripeStoreFileManager;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public abstract class StripeMultiFileWriter
extends AbstractMultiFileWriter {
    private static final Logger LOG = LoggerFactory.getLogger(StripeMultiFileWriter.class);
    protected final CellComparator comparator;
    protected List<StoreFileWriter> existingWriters;
    protected List<byte[]> boundaries;
    private boolean doWriteStripeMetadata = true;

    public StripeMultiFileWriter(CellComparator comparator) {
        this.comparator = comparator;
    }

    public void setNoStripeMetadata() {
        this.doWriteStripeMetadata = false;
    }

    @Override
    protected Collection<StoreFileWriter> writers() {
        return this.existingWriters;
    }

    protected abstract void preCommitWritersInternal() throws IOException;

    @Override
    protected final void preCommitWriters() throws IOException {
        assert (this.existingWriters != null);
        this.preCommitWritersInternal();
        assert (this.boundaries.size() == this.existingWriters.size() + 1);
    }

    @Override
    protected void preCloseWriter(StoreFileWriter writer) throws IOException {
        if (this.doWriteStripeMetadata) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Write stripe metadata for " + writer.getPath().toString());
            }
            int index = this.existingWriters.indexOf(writer);
            writer.appendFileInfo(StripeStoreFileManager.STRIPE_START_KEY, this.boundaries.get(index));
            writer.appendFileInfo(StripeStoreFileManager.STRIPE_END_KEY, this.boundaries.get(index + 1));
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Skip writing stripe metadata for " + writer.getPath().toString());
        }
    }

    protected void sanityCheckLeft(byte[] left, Cell cell) throws IOException {
        if (!Arrays.equals(StripeStoreFileManager.OPEN_KEY, left) && this.comparator.compareRows(cell, left, 0, left.length) < 0) {
            String error = "The first row is lower than the left boundary of [" + Bytes.toString(left) + "]: [" + Bytes.toString(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength()) + "]";
            LOG.error(error);
            throw new IOException(error);
        }
    }

    protected void sanityCheckRight(byte[] right, Cell cell) throws IOException {
        if (!Arrays.equals(StripeStoreFileManager.OPEN_KEY, right) && this.comparator.compareRows(cell, right, 0, right.length) >= 0) {
            String error = "The last row is higher or equal than the right boundary of [" + Bytes.toString(right) + "]: [" + Bytes.toString(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength()) + "]";
            LOG.error(error);
            throw new IOException(error);
        }
    }

    public static class SizeMultiWriter
    extends StripeMultiFileWriter {
        private int targetCount;
        private long targetCells;
        private byte[] left;
        private byte[] right;
        private Cell lastCell;
        private StoreFileWriter currentWriter;
        protected byte[] lastRowInCurrentWriter = null;
        private long cellsInCurrentWriter = 0L;
        private long cellsSeen = 0L;
        private long cellsSeenInPrevious = 0L;

        public SizeMultiWriter(CellComparator comparator, int targetCount, long targetKvs, byte[] left, byte[] right) {
            super(comparator);
            this.targetCount = targetCount;
            this.targetCells = targetKvs;
            this.left = left;
            this.right = right;
            int preallocate = Math.min(this.targetCount, 64);
            this.existingWriters = new ArrayList(preallocate);
            this.boundaries = new ArrayList(preallocate + 1);
        }

        @Override
        public void append(Cell cell) throws IOException {
            boolean doCreateWriter = false;
            if (this.currentWriter == null) {
                this.sanityCheckLeft(this.left, cell);
                doCreateWriter = true;
            } else if (this.lastRowInCurrentWriter != null && !PrivateCellUtil.matchingRows(cell, this.lastRowInCurrentWriter, 0, this.lastRowInCurrentWriter.length)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Stopping to use a writer after [" + Bytes.toString(this.lastRowInCurrentWriter) + "] row; wrote out " + this.cellsInCurrentWriter + " kvs");
                }
                this.lastRowInCurrentWriter = null;
                this.cellsInCurrentWriter = 0L;
                this.cellsSeenInPrevious += this.cellsSeen;
                doCreateWriter = true;
            }
            if (doCreateWriter) {
                byte[] boundary;
                byte[] byArray = boundary = this.existingWriters.isEmpty() ? this.left : CellUtil.cloneRow(cell);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Creating new writer starting at [" + Bytes.toString(boundary) + "]");
                }
                this.currentWriter = this.writerFactory.createWriter();
                this.boundaries.add(boundary);
                this.existingWriters.add(this.currentWriter);
            }
            this.currentWriter.append(cell);
            this.lastCell = cell;
            ++this.cellsInCurrentWriter;
            this.cellsSeen = this.cellsInCurrentWriter;
            if (this.sourceScanner != null) {
                this.cellsSeen = Math.max(this.cellsSeen, this.sourceScanner.getEstimatedNumberOfKvsScanned() - this.cellsSeenInPrevious);
            }
            if (this.lastRowInCurrentWriter == null && this.existingWriters.size() < this.targetCount && this.cellsSeen >= this.targetCells) {
                this.lastRowInCurrentWriter = CellUtil.cloneRow(cell);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Preparing to start a new writer after [" + Bytes.toString(this.lastRowInCurrentWriter) + "] row; observed " + this.cellsSeen + " kvs and wrote out " + this.cellsInCurrentWriter + " kvs");
                }
            }
        }

        @Override
        protected void preCommitWritersInternal() throws IOException {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Stopping with " + this.cellsInCurrentWriter + " kvs in last writer" + (this.sourceScanner == null ? "" : "; observed estimated " + this.sourceScanner.getEstimatedNumberOfKvsScanned() + " KVs total"));
            }
            if (this.lastCell != null) {
                this.sanityCheckRight(this.right, this.lastCell);
            }
            if (this.existingWriters.isEmpty() && 1 == this.targetCount) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Merge expired stripes into one, create an empty file to preserve metadata.");
                }
                this.boundaries.add(this.left);
                this.existingWriters.add(this.writerFactory.createWriter());
            }
            this.boundaries.add(this.right);
        }
    }

    public static class BoundaryMultiWriter
    extends StripeMultiFileWriter {
        private StoreFileWriter currentWriter;
        private byte[] currentWriterEndKey;
        private Cell lastCell;
        private long cellsInCurrentWriter = 0L;
        private int majorRangeFromIndex = -1;
        private int majorRangeToIndex = -1;
        private boolean hasAnyWriter = false;

        public BoundaryMultiWriter(CellComparator comparator, List<byte[]> targetBoundaries, byte[] majorRangeFrom, byte[] majorRangeTo) throws IOException {
            super(comparator);
            this.boundaries = targetBoundaries;
            this.existingWriters = new ArrayList(this.boundaries.size() - 1);
            assert (majorRangeFrom == null == (majorRangeTo == null));
            if (majorRangeFrom != null) {
                this.majorRangeFromIndex = Arrays.equals(majorRangeFrom, StripeStoreFileManager.OPEN_KEY) ? 0 : Collections.binarySearch(this.boundaries, majorRangeFrom, Bytes.BYTES_COMPARATOR);
                int n = this.majorRangeToIndex = Arrays.equals(majorRangeTo, StripeStoreFileManager.OPEN_KEY) ? this.boundaries.size() : Collections.binarySearch(this.boundaries, majorRangeTo, Bytes.BYTES_COMPARATOR);
                if (this.majorRangeFromIndex < 0 || this.majorRangeToIndex < 0) {
                    throw new IOException("Major range does not match writer boundaries: [" + Bytes.toString(majorRangeFrom) + "] [" + Bytes.toString(majorRangeTo) + "]; from " + this.majorRangeFromIndex + " to " + this.majorRangeToIndex);
                }
            }
        }

        @Override
        public void append(Cell cell) throws IOException {
            if (this.currentWriter == null && this.existingWriters.isEmpty()) {
                this.sanityCheckLeft((byte[])this.boundaries.get(0), cell);
            }
            this.prepareWriterFor(cell);
            this.currentWriter.append(cell);
            this.lastCell = cell;
            ++this.cellsInCurrentWriter;
        }

        private boolean isCellAfterCurrentWriter(Cell cell) {
            return !Arrays.equals(this.currentWriterEndKey, StripeStoreFileManager.OPEN_KEY) && this.comparator.compareRows(cell, this.currentWriterEndKey, 0, this.currentWriterEndKey.length) >= 0;
        }

        @Override
        protected void preCommitWritersInternal() throws IOException {
            this.stopUsingCurrentWriter();
            while (this.existingWriters.size() < this.boundaries.size() - 1) {
                this.createEmptyWriter();
            }
            if (this.lastCell != null) {
                this.sanityCheckRight((byte[])this.boundaries.get(this.boundaries.size() - 1), this.lastCell);
            }
        }

        private void prepareWriterFor(Cell cell) throws IOException {
            if (this.currentWriter != null && !this.isCellAfterCurrentWriter(cell)) {
                return;
            }
            this.stopUsingCurrentWriter();
            while (this.isCellAfterCurrentWriter(cell)) {
                this.checkCanCreateWriter();
                this.createEmptyWriter();
            }
            this.checkCanCreateWriter();
            this.hasAnyWriter = true;
            this.currentWriter = this.writerFactory.createWriter();
            this.existingWriters.add(this.currentWriter);
        }

        private void createEmptyWriter() throws IOException {
            int index = this.existingWriters.size();
            boolean isInMajorRange = index >= this.majorRangeFromIndex && index < this.majorRangeToIndex;
            boolean isLastWriter = !this.hasAnyWriter && index == this.boundaries.size() - 2;
            boolean needEmptyFile = isInMajorRange || isLastWriter;
            this.existingWriters.add(needEmptyFile ? this.writerFactory.createWriter() : null);
            this.hasAnyWriter |= needEmptyFile;
            this.currentWriterEndKey = this.existingWriters.size() + 1 == this.boundaries.size() ? null : (byte[])this.boundaries.get(this.existingWriters.size() + 1);
        }

        private void checkCanCreateWriter() throws IOException {
            int maxWriterCount = this.boundaries.size() - 1;
            assert (this.existingWriters.size() <= maxWriterCount);
            if (this.existingWriters.size() >= maxWriterCount) {
                throw new IOException("Cannot create any more writers (created " + this.existingWriters.size() + " out of " + maxWriterCount + " - row might be out of range of all valid writers");
            }
        }

        private void stopUsingCurrentWriter() {
            if (this.currentWriter != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Stopping to use a writer after [" + Bytes.toString(this.currentWriterEndKey) + "] row; wrote out " + this.cellsInCurrentWriter + " kvs");
                }
                this.cellsInCurrentWriter = 0L;
            }
            this.currentWriter = null;
            this.currentWriterEndKey = this.existingWriters.size() + 1 == this.boundaries.size() ? null : (byte[])this.boundaries.get(this.existingWriters.size() + 1);
        }
    }
}

