/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase;

import java.io.IOException;
import java.util.List;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.hudi.org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.apache.hudi.org.apache.hadoop.hbase.zookeeper.ZKListener;
import org.apache.hudi.org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hudi.org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hudi.org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.common.collect.Sets;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ZKNamespaceManager
extends ZKListener {
    private static final Logger LOG = LoggerFactory.getLogger(ZKNamespaceManager.class);
    private final String nsZNode;
    private final NavigableMap<String, NamespaceDescriptor> cache;

    public ZKNamespaceManager(ZKWatcher zkw) throws IOException {
        super(zkw);
        this.nsZNode = zkw.getZNodePaths().namespaceZNode;
        this.cache = new ConcurrentSkipListMap<String, NamespaceDescriptor>();
    }

    public void start() throws IOException {
        this.watcher.registerListener((ZKListener)this);
        try {
            if (ZKUtil.watchAndCheckExists((ZKWatcher)this.watcher, (String)this.nsZNode)) {
                List existing = ZKUtil.getChildDataAndWatchForNewChildren((ZKWatcher)this.watcher, (String)this.nsZNode);
                if (existing != null) {
                    this.refreshNodes(existing);
                }
            } else {
                ZKUtil.createWithParents((ZKWatcher)this.watcher, (String)this.nsZNode);
            }
        }
        catch (KeeperException e) {
            throw new IOException("Failed to initialize ZKNamespaceManager", e);
        }
    }

    public void stop() throws IOException {
        this.watcher.unregisterListener((ZKListener)this);
    }

    public NamespaceDescriptor get(String name) {
        return (NamespaceDescriptor)this.cache.get(name);
    }

    public void update(NamespaceDescriptor ns) throws IOException {
        this.writeNamespace(ns);
        this.cache.put(ns.getName(), ns);
    }

    public void remove(String name) throws IOException {
        this.deleteNamespace(name);
        this.cache.remove(name);
    }

    public NavigableSet<NamespaceDescriptor> list() throws IOException {
        TreeSet<NamespaceDescriptor> ret = Sets.newTreeSet(NamespaceDescriptor.NAMESPACE_DESCRIPTOR_COMPARATOR);
        for (NamespaceDescriptor ns : this.cache.values()) {
            ret.add(ns);
        }
        return ret;
    }

    public void nodeCreated(String path) {
        if (this.nsZNode.equals(path)) {
            try {
                List nodes = ZKUtil.getChildDataAndWatchForNewChildren((ZKWatcher)this.watcher, (String)this.nsZNode);
                this.refreshNodes(nodes);
            }
            catch (KeeperException ke) {
                String msg = "Error reading data from zookeeper";
                LOG.error(msg, (Throwable)ke);
                this.watcher.abort(msg, (Throwable)ke);
            }
            catch (IOException e) {
                String msg = "Error parsing data from zookeeper";
                LOG.error(msg, (Throwable)e);
                this.watcher.abort(msg, (Throwable)e);
            }
        }
    }

    public void nodeDeleted(String path) {
        if (this.nsZNode.equals(ZKUtil.getParent((String)path))) {
            String nsName = ZKUtil.getNodeName((String)path);
            this.cache.remove(nsName);
        }
    }

    public void nodeDataChanged(String path) {
        if (this.nsZNode.equals(ZKUtil.getParent((String)path))) {
            try {
                byte[] data = ZKUtil.getDataAndWatch((ZKWatcher)this.watcher, (String)path);
                NamespaceDescriptor ns = ProtobufUtil.toNamespaceDescriptor(HBaseProtos.NamespaceDescriptor.parseFrom(data));
                this.cache.put(ns.getName(), ns);
            }
            catch (KeeperException ke) {
                String msg = "Error reading data from zookeeper for node " + path;
                LOG.error(msg, (Throwable)ke);
                this.watcher.abort(msg, (Throwable)ke);
            }
            catch (IOException ioe) {
                String msg = "Error deserializing namespace: " + path;
                LOG.error(msg, (Throwable)ioe);
                this.watcher.abort(msg, (Throwable)ioe);
            }
        }
    }

    public void nodeChildrenChanged(String path) {
        if (this.nsZNode.equals(path)) {
            try {
                List nodes = ZKUtil.getChildDataAndWatchForNewChildren((ZKWatcher)this.watcher, (String)this.nsZNode);
                this.refreshNodes(nodes);
            }
            catch (KeeperException ke) {
                LOG.error("Error reading data from zookeeper for path " + path, (Throwable)ke);
                this.watcher.abort("ZooKeeper error get node children for path " + path, (Throwable)ke);
            }
            catch (IOException e) {
                LOG.error("Error deserializing namespace child from: " + path, (Throwable)e);
                this.watcher.abort("Error deserializing namespace child from: " + path, (Throwable)e);
            }
        }
    }

    private void deleteNamespace(String name) throws IOException {
        String zNode = ZNodePaths.joinZNode(this.nsZNode, name);
        try {
            ZKUtil.deleteNode((ZKWatcher)this.watcher, (String)zNode);
        }
        catch (KeeperException e) {
            if (e instanceof KeeperException.NoNodeException) {
                LOG.warn("The ZNode " + zNode + " for namespace " + name + " does not exist.");
            }
            LOG.error("Failed updating permissions for namespace " + name, (Throwable)e);
            throw new IOException("Failed updating permissions for namespace " + name, e);
        }
    }

    private void writeNamespace(NamespaceDescriptor ns) throws IOException {
        String zNode = ZNodePaths.joinZNode(this.nsZNode, ns.getName());
        try {
            ZKUtil.createWithParents((ZKWatcher)this.watcher, (String)zNode);
            ZKUtil.updateExistingNodeData((ZKWatcher)this.watcher, (String)zNode, (byte[])ProtobufUtil.toProtoNamespaceDescriptor(ns).toByteArray(), (int)-1);
        }
        catch (KeeperException e) {
            LOG.error("Failed updating permissions for namespace " + ns.getName(), (Throwable)e);
            throw new IOException("Failed updating permissions for namespace " + ns.getName(), e);
        }
    }

    private void refreshNodes(List<ZKUtil.NodeAndData> nodes) throws IOException {
        for (ZKUtil.NodeAndData n : nodes) {
            if (n.isEmpty()) continue;
            String path = n.getNode();
            String namespace = ZKUtil.getNodeName((String)path);
            byte[] nodeData = n.getData();
            if (LOG.isTraceEnabled()) {
                LOG.trace("Updating namespace cache from node " + namespace + " with data: " + Bytes.toStringBinary(nodeData));
            }
            NamespaceDescriptor ns = ProtobufUtil.toNamespaceDescriptor(HBaseProtos.NamespaceDescriptor.parseFrom(nodeData));
            this.cache.put(ns.getName(), ns);
        }
    }
}

