/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metrics;

import java.text.ParseException;
import java.time.Duration;
import java.time.Instant;
import org.apache.flink.metrics.MetricGroup;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieInstantTimeGenerator;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.metrics.FlinkWriteMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkCompactionMetrics
extends FlinkWriteMetrics {
    private static final Logger LOG = LoggerFactory.getLogger(FlinkCompactionMetrics.class);
    private static final String COMPACTION_KEY = "compaction";
    private int pendingCompactionCount;
    private long compactionDelay;
    private long compactionCost;

    public FlinkCompactionMetrics(MetricGroup metricGroup) {
        super(metricGroup, COMPACTION_KEY);
    }

    @Override
    public void registerMetrics() {
        super.registerMetrics();
        this.metricGroup.gauge(this.getMetricsName(this.actionType, "pendingCompactionCount"), () -> this.pendingCompactionCount);
        this.metricGroup.gauge(this.getMetricsName(this.actionType, "compactionDelay"), () -> this.compactionDelay);
        this.metricGroup.gauge(this.getMetricsName(this.actionType, "compactionCost"), () -> this.compactionCost);
    }

    public void setPendingCompactionCount(int pendingCompactionCount) {
        this.pendingCompactionCount = pendingCompactionCount;
    }

    public void setFirstPendingCompactionInstant(Option<HoodieInstant> firstPendingCompactionInstant) {
        try {
            if (!firstPendingCompactionInstant.isPresent()) {
                this.compactionDelay = 0L;
            } else {
                Instant start2 = HoodieInstantTimeGenerator.parseDateFromInstantTime(firstPendingCompactionInstant.get().getTimestamp()).toInstant();
                this.compactionDelay = Duration.between(start2, Instant.now()).getSeconds();
            }
        }
        catch (ParseException e) {
            LOG.warn("Invalid input compaction instant" + firstPendingCompactionInstant);
        }
    }

    public void startCompaction() {
        this.startTimer(COMPACTION_KEY);
    }

    public void endCompaction() {
        this.compactionCost = this.stopTimer(COMPACTION_KEY);
    }
}

