/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieOperation;
import org.apache.hudi.common.model.HoodiePartitionMetadata;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.model.IOType;
import org.apache.hudi.common.model.MetadataValues;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieInsertException;
import org.apache.hudi.io.HoodieWriteHandle;
import org.apache.hudi.io.storage.HoodieFileWriter;
import org.apache.hudi.io.storage.HoodieFileWriterFactory;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.org.apache.avro.Schema;
import org.apache.hudi.table.HoodieTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class HoodieCreateHandle<T, I, K, O>
extends HoodieWriteHandle<T, I, K, O> {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieCreateHandle.class);
    protected HoodieFileWriter fileWriter;
    protected final Path path;
    protected long recordsWritten = 0L;
    protected long insertRecordsWritten = 0L;
    protected long recordsDeleted = 0L;
    private Map<String, HoodieRecord<T>> recordMap;
    private boolean useWriterSchema = false;
    private final boolean preserveMetadata;

    public HoodieCreateHandle(HoodieWriteConfig config, String instantTime, HoodieTable<T, I, K, O> hoodieTable, String partitionPath, String fileId, TaskContextSupplier taskContextSupplier) {
        this(config, instantTime, hoodieTable, partitionPath, fileId, Option.empty(), taskContextSupplier, false);
    }

    public HoodieCreateHandle(HoodieWriteConfig config, String instantTime, HoodieTable<T, I, K, O> hoodieTable, String partitionPath, String fileId, TaskContextSupplier taskContextSupplier, boolean preserveMetadata) {
        this(config, instantTime, hoodieTable, partitionPath, fileId, Option.empty(), taskContextSupplier, preserveMetadata);
    }

    public HoodieCreateHandle(HoodieWriteConfig config, String instantTime, HoodieTable<T, I, K, O> hoodieTable, String partitionPath, String fileId, Option<Schema> overriddenSchema, TaskContextSupplier taskContextSupplier) {
        this(config, instantTime, hoodieTable, partitionPath, fileId, overriddenSchema, taskContextSupplier, false);
    }

    public HoodieCreateHandle(HoodieWriteConfig config, String instantTime, HoodieTable<T, I, K, O> hoodieTable, String partitionPath, String fileId, Option<Schema> overriddenSchema, TaskContextSupplier taskContextSupplier, boolean preserveMetadata) {
        super(config, instantTime, partitionPath, fileId, hoodieTable, overriddenSchema, taskContextSupplier);
        this.preserveMetadata = preserveMetadata;
        this.writeStatus.setFileId(fileId);
        this.writeStatus.setPartitionPath(partitionPath);
        this.writeStatus.setStat(new HoodieWriteStat());
        this.path = this.makeNewPath(partitionPath);
        try {
            HoodiePartitionMetadata partitionMetadata = new HoodiePartitionMetadata(this.fs, instantTime, new Path(config.getBasePath()), FSUtils.getPartitionPath(config.getBasePath(), partitionPath), hoodieTable.getPartitionMetafileFormat());
            partitionMetadata.trySave(this.getPartitionId());
            this.createMarkerFile(partitionPath, FSUtils.makeBaseFileName(this.instantTime, this.writeToken, this.fileId, hoodieTable.getBaseFileExtension()));
            this.fileWriter = HoodieFileWriterFactory.getFileWriter(instantTime, this.path, hoodieTable.getHadoopConf(), config, this.writeSchemaWithMetaFields, this.taskContextSupplier, config.getRecordMerger().getRecordType());
        }
        catch (IOException e) {
            throw new HoodieInsertException("Failed to initialize HoodieStorageWriter for path " + this.path, e);
        }
        LOG.info("New CreateHandle for partition :" + partitionPath + " with fileId " + fileId);
    }

    public HoodieCreateHandle(HoodieWriteConfig config, String instantTime, HoodieTable<T, I, K, O> hoodieTable, String partitionPath, String fileId, Map<String, HoodieRecord<T>> recordMap, TaskContextSupplier taskContextSupplier) {
        this(config, instantTime, hoodieTable, partitionPath, fileId, taskContextSupplier, !HoodieTableMetadata.isMetadataTable(config.getBasePath()));
        this.recordMap = recordMap;
        this.useWriterSchema = true;
    }

    @Override
    public boolean canWrite(HoodieRecord record) {
        return this.fileWriter.canWrite() && record.getPartitionPath().equals(this.writeStatus.getPartitionPath()) || this.layoutControlsNumFiles();
    }

    @Override
    protected void doWrite(HoodieRecord record, Schema schema, TypedProperties props) {
        Option<Map<String, String>> recordMetadata = record.getMetadata();
        try {
            if (!HoodieOperation.isDelete(record.getOperation()) && !record.isDelete(schema, this.config.getProps())) {
                if (record.shouldIgnore(schema, this.config.getProps())) {
                    return;
                }
                MetadataValues metadataValues = new MetadataValues().setFileName(this.path.getName());
                HoodieRecord populatedRecord = record.prependMetaFields(schema, this.writeSchemaWithMetaFields, metadataValues, this.config.getProps());
                if (this.preserveMetadata) {
                    this.fileWriter.write(record.getRecordKey(), populatedRecord, this.writeSchemaWithMetaFields);
                } else {
                    this.fileWriter.writeWithMetadata(record.getKey(), populatedRecord, this.writeSchemaWithMetaFields);
                }
                record.unseal();
                record.setNewLocation(this.newRecordLocation);
                record.seal();
                ++this.recordsWritten;
                ++this.insertRecordsWritten;
            } else {
                ++this.recordsDeleted;
            }
            this.writeStatus.markSuccess(record, recordMetadata);
            record.deflate();
        }
        catch (Throwable t) {
            this.writeStatus.markFailure(record, t, recordMetadata);
            LOG.error("Error writing record " + record, t);
        }
    }

    public void write() {
        Iterator keyIterator = this.hoodieTable.requireSortedRecords() ? this.recordMap.keySet().stream().sorted().iterator() : this.recordMap.keySet().stream().iterator();
        while (keyIterator.hasNext()) {
            String key = (String)keyIterator.next();
            HoodieRecord<T> record = this.recordMap.get(key);
            this.write(record, this.useWriterSchema ? this.writeSchemaWithMetaFields : this.writeSchema, this.config.getProps());
        }
    }

    @Override
    public IOType getIOType() {
        return IOType.CREATE;
    }

    @Override
    public List<WriteStatus> close() {
        LOG.info("Closing the file " + this.writeStatus.getFileId() + " as we are done with all the records " + this.recordsWritten);
        try {
            if (this.isClosed()) {
                return Collections.emptyList();
            }
            this.markClosed();
            if (this.fileWriter != null) {
                this.fileWriter.close();
                this.fileWriter = null;
            }
            this.setupWriteStatus();
            LOG.info(String.format("CreateHandle for partitionPath %s fileID %s, took %d ms.", this.writeStatus.getStat().getPartitionPath(), this.writeStatus.getStat().getFileId(), this.writeStatus.getStat().getRuntimeStats().getTotalCreateTime()));
            return Collections.singletonList(this.writeStatus);
        }
        catch (IOException e) {
            throw new HoodieInsertException("Failed to close the Insert Handle for path " + this.path, e);
        }
    }

    protected void setupWriteStatus() throws IOException {
        HoodieWriteStat stat = this.writeStatus.getStat();
        stat.setPartitionPath(this.writeStatus.getPartitionPath());
        stat.setNumWrites(this.recordsWritten);
        stat.setNumDeletes(this.recordsDeleted);
        stat.setNumInserts(this.insertRecordsWritten);
        stat.setPrevCommit("null");
        stat.setFileId(this.writeStatus.getFileId());
        stat.setPath(new Path(this.config.getBasePath()), this.path);
        stat.setTotalWriteErrors(this.writeStatus.getTotalErrorRecords());
        long fileSize = FSUtils.getFileSize(this.fs, this.path);
        stat.setTotalWriteBytes(fileSize);
        stat.setFileSizeInBytes(fileSize);
        HoodieWriteStat.RuntimeStats runtimeStats = new HoodieWriteStat.RuntimeStats();
        runtimeStats.setTotalCreateTime(this.timer.endTimer());
        stat.setRuntimeStats(runtimeStats);
    }
}

