/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.expression;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.expression.BindVisitor;
import org.apache.hudi.expression.BoundReference;
import org.apache.hudi.expression.Expression;
import org.apache.hudi.expression.NameReference;
import org.apache.hudi.expression.Predicate;
import org.apache.hudi.expression.Predicates;
import org.apache.hudi.internal.schema.Types;

public class PartialBindVisitor
extends BindVisitor {
    public PartialBindVisitor(Types.RecordType recordType, boolean caseSensitive) {
        super(recordType, caseSensitive);
    }

    @Override
    public Expression visitNameReference(NameReference attribute) {
        Types.Field field;
        Types.Field field2 = field = this.caseSensitive ? this.recordType.fieldByName(attribute.getName()) : this.recordType.fieldByNameCaseInsensitive(attribute.getName());
        if (field == null) {
            return null;
        }
        return new BoundReference(field.fieldId(), field.type());
    }

    @Override
    public Expression visitPredicate(Predicate predicate) {
        if (predicate instanceof Predicates.BinaryComparison) {
            Predicates.BinaryComparison binaryExp = (Predicates.BinaryComparison)predicate;
            Expression left = binaryExp.getLeft().accept(this);
            if (left == null) {
                return this.alwaysTrue();
            }
            Expression right = binaryExp.getRight().accept(this);
            if (right == null) {
                return this.alwaysTrue();
            }
            return new Predicates.BinaryComparison(left, binaryExp.getOperator(), right);
        }
        if (predicate instanceof Predicates.Not) {
            Expression expr2 = ((Predicates.Not)predicate).child.accept(this);
            if (expr2 instanceof Predicates.TrueExpression) {
                return this.alwaysFalse();
            }
            if (expr2 instanceof Predicates.FalseExpression) {
                return this.alwaysTrue();
            }
            return Predicates.not(expr2);
        }
        if (predicate instanceof Predicates.In) {
            Predicates.In in = (Predicates.In)predicate;
            Expression valueExpression = in.value.accept(this);
            if (valueExpression == null) {
                return this.alwaysTrue();
            }
            List<Expression> validValues = in.validValues.stream().map(validValue -> validValue.accept(this)).collect(Collectors.toList());
            if (validValues.stream().anyMatch(Objects::isNull)) {
                return this.alwaysTrue();
            }
            return Predicates.in(valueExpression, validValues);
        }
        if (predicate instanceof Predicates.IsNull) {
            Predicates.IsNull isNull = (Predicates.IsNull)predicate;
            return Option.ofNullable(isNull.child.accept(this)).map(expr -> Predicates.isNull(expr)).orElse(this.alwaysTrue());
        }
        if (predicate instanceof Predicates.IsNotNull) {
            Predicates.IsNotNull isNotNull = (Predicates.IsNotNull)predicate;
            return Option.ofNullable(isNotNull.child.accept(this)).map(expr -> Predicates.isNotNull(expr)).orElse(this.alwaysTrue());
        }
        if (predicate instanceof Predicates.StringStartsWith) {
            Predicates.StringStartsWith startsWith = (Predicates.StringStartsWith)predicate;
            Expression left = startsWith.getLeft().accept(this);
            if (left == null) {
                return this.alwaysTrue();
            }
            Expression right = startsWith.getRight().accept(this);
            if (right == null) {
                return this.alwaysTrue();
            }
            return Predicates.startsWith(left, right);
        }
        if (predicate instanceof Predicates.StringContains) {
            Predicates.StringContains contains = (Predicates.StringContains)predicate;
            Expression left = contains.getLeft().accept(this);
            if (left == null) {
                return this.alwaysTrue();
            }
            Expression right = contains.getRight().accept(this);
            if (right == null) {
                return this.alwaysTrue();
            }
            return Predicates.contains(left, right);
        }
        throw new IllegalArgumentException("The expression " + predicate + " cannot be visited as predicate");
    }
}

