/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util.collection;

import java.util.Iterator;
import java.util.NoSuchElementException;

public final class FlatteningIterator<T, I extends Iterator<T>>
implements Iterator<T> {
    private final Iterator<I> sourceIterator;
    private Iterator<T> innerSourceIterator;

    public FlatteningIterator(Iterator<I> source) {
        this.sourceIterator = source;
    }

    @Override
    public boolean hasNext() {
        while (this.innerSourceIterator == null || !this.innerSourceIterator.hasNext()) {
            if (this.sourceIterator.hasNext()) {
                this.innerSourceIterator = (Iterator)this.sourceIterator.next();
                continue;
            }
            return false;
        }
        return true;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.innerSourceIterator.next();
    }
}

