/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.bloom.BloomFilterFactory;
import org.apache.hudi.common.bloom.BloomFilterTypeCode;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.OrcUtils;
import org.apache.hudi.common.util.ParquetUtils;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.keygen.BaseKeyGenerator;
import org.apache.hudi.org.apache.avro.Schema;
import org.apache.hudi.org.apache.avro.generic.GenericRecord;

public abstract class BaseFileUtils {
    public static BaseFileUtils getInstance(String path) {
        if (path.endsWith(HoodieFileFormat.PARQUET.getFileExtension())) {
            return new ParquetUtils();
        }
        if (path.endsWith(HoodieFileFormat.ORC.getFileExtension())) {
            return new OrcUtils();
        }
        throw new UnsupportedOperationException("The format for file " + path + " is not supported yet.");
    }

    public static BaseFileUtils getInstance(HoodieFileFormat fileFormat) {
        if (HoodieFileFormat.PARQUET.equals((Object)fileFormat)) {
            return new ParquetUtils();
        }
        if (HoodieFileFormat.ORC.equals((Object)fileFormat)) {
            return new OrcUtils();
        }
        throw new UnsupportedOperationException(fileFormat.name() + " format not supported yet.");
    }

    public static BaseFileUtils getInstance(HoodieTableMetaClient metaClient) {
        return BaseFileUtils.getInstance(metaClient.getTableConfig().getBaseFileFormat());
    }

    public Set<String> readRowKeys(Configuration configuration, Path filePath) {
        return this.filterRowKeys(configuration, filePath, new HashSet<String>());
    }

    public BloomFilter readBloomFilterFromMetadata(Configuration configuration, Path filePath) {
        Map<String, String> footerVals = this.readFooter(configuration, false, filePath, "org.apache.hudi.bloomfilter", "com.uber.hoodie.bloomfilter", "hoodie_bloom_filter_type_code");
        String footerVal = footerVals.get("org.apache.hudi.bloomfilter");
        if (null == footerVal) {
            footerVal = footerVals.get("com.uber.hoodie.bloomfilter");
        }
        BloomFilter toReturn = null;
        if (footerVal != null) {
            toReturn = footerVals.containsKey("hoodie_bloom_filter_type_code") ? BloomFilterFactory.fromString(footerVal, footerVals.get("hoodie_bloom_filter_type_code")) : BloomFilterFactory.fromString(footerVal, BloomFilterTypeCode.SIMPLE.name());
        }
        return toReturn;
    }

    public String[] readMinMaxRecordKeys(Configuration configuration, Path filePath) {
        Map<String, String> minMaxKeys = this.readFooter(configuration, true, filePath, "hoodie_min_record_key", "hoodie_max_record_key");
        if (minMaxKeys.size() != 2) {
            throw new HoodieException(String.format("Could not read min/max record key out of footer correctly from %s. read) : %s", filePath, minMaxKeys));
        }
        return new String[]{minMaxKeys.get("hoodie_min_record_key"), minMaxKeys.get("hoodie_max_record_key")};
    }

    public abstract List<GenericRecord> readAvroRecords(Configuration var1, Path var2);

    public abstract List<GenericRecord> readAvroRecords(Configuration var1, Path var2, Schema var3);

    public abstract Map<String, String> readFooter(Configuration var1, boolean var2, Path var3, String ... var4);

    public abstract long getRowCount(Configuration var1, Path var2);

    public abstract Set<String> filterRowKeys(Configuration var1, Path var2, Set<String> var3);

    public abstract List<HoodieKey> fetchHoodieKeys(Configuration var1, Path var2);

    public abstract ClosableIterator<HoodieKey> getHoodieKeyIterator(Configuration var1, Path var2, Option<BaseKeyGenerator> var3);

    public abstract ClosableIterator<HoodieKey> getHoodieKeyIterator(Configuration var1, Path var2);

    public abstract List<HoodieKey> fetchHoodieKeys(Configuration var1, Path var2, Option<BaseKeyGenerator> var3);

    public abstract Schema readAvroSchema(Configuration var1, Path var2);

    public abstract HoodieFileFormat getFormat();
}

