/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.io.IOException;
import java.util.Properties;
import org.apache.hudi.common.model.OverwriteWithLatestAvroPayload;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.org.apache.avro.Schema;
import org.apache.hudi.org.apache.avro.generic.GenericRecord;
import org.apache.hudi.org.apache.avro.generic.IndexedRecord;

public class AWSDmsAvroPayload
extends OverwriteWithLatestAvroPayload {
    public static final String OP_FIELD = "Op";

    public AWSDmsAvroPayload(GenericRecord record, Comparable orderingVal) {
        super(record, orderingVal);
    }

    public AWSDmsAvroPayload(Option<GenericRecord> record) {
        this(record.isPresent() ? record.get() : null, Integer.valueOf(0));
    }

    private Option<IndexedRecord> handleDeleteOperation(IndexedRecord insertValue) throws IOException {
        boolean delete = false;
        if (insertValue instanceof GenericRecord) {
            GenericRecord record = (GenericRecord)insertValue;
            delete = AWSDmsAvroPayload.isDMSDeleteRecord(record);
        }
        return delete ? Option.empty() : Option.of(insertValue);
    }

    @Override
    public Option<IndexedRecord> getInsertValue(Schema schema, Properties properties) throws IOException {
        return this.getInsertValue(schema);
    }

    @Override
    public Option<IndexedRecord> getInsertValue(Schema schema) throws IOException {
        IndexedRecord insertValue = super.getInsertValue(schema).get();
        return this.handleDeleteOperation(insertValue);
    }

    @Override
    public Option<IndexedRecord> combineAndGetUpdateValue(IndexedRecord currentValue, Schema schema, Properties properties) throws IOException {
        return this.combineAndGetUpdateValue(currentValue, schema);
    }

    @Override
    public Option<IndexedRecord> combineAndGetUpdateValue(IndexedRecord currentValue, Schema schema) throws IOException {
        Option<IndexedRecord> insertValue = super.getInsertValue(schema);
        if (!insertValue.isPresent()) {
            return Option.empty();
        }
        return this.handleDeleteOperation(insertValue.get());
    }

    @Override
    protected boolean isDeleteRecord(GenericRecord record) {
        return AWSDmsAvroPayload.isDMSDeleteRecord(record) || super.isDeleteRecord(record);
    }

    private static boolean isDMSDeleteRecord(GenericRecord record) {
        return record.get(OP_FIELD) != null && record.get(OP_FIELD).toString().equalsIgnoreCase("D");
    }
}

