/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.avro.model;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.hudi.org.apache.avro.AvroMissingFieldException;
import org.apache.hudi.org.apache.avro.AvroRuntimeException;
import org.apache.hudi.org.apache.avro.Conversions;
import org.apache.hudi.org.apache.avro.Schema;
import org.apache.hudi.org.apache.avro.data.RecordBuilder;
import org.apache.hudi.org.apache.avro.data.TimeConversions;
import org.apache.hudi.org.apache.avro.io.DatumReader;
import org.apache.hudi.org.apache.avro.io.DatumWriter;
import org.apache.hudi.org.apache.avro.message.BinaryMessageDecoder;
import org.apache.hudi.org.apache.avro.message.BinaryMessageEncoder;
import org.apache.hudi.org.apache.avro.message.SchemaStore;
import org.apache.hudi.org.apache.avro.specific.AvroGenerated;
import org.apache.hudi.org.apache.avro.specific.SpecificData;
import org.apache.hudi.org.apache.avro.specific.SpecificRecord;
import org.apache.hudi.org.apache.avro.specific.SpecificRecordBase;
import org.apache.hudi.org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class HoodieMetadataColumnStats
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = -2606839461509618679L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"HoodieMetadataColumnStats\",\"namespace\":\"org.apache.hudi.avro.model\",\"doc\":\"Data file column statistics\",\"fields\":[{\"name\":\"fileName\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"File name for which this column statistics applies\",\"default\":null},{\"name\":\"columnName\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Column name for which this column statistics applies\",\"default\":null},{\"name\":\"minValue\",\"type\":[\"null\",{\"type\":\"record\",\"name\":\"BooleanWrapper\",\"doc\":\"A record wrapping boolean type to be able to be used it w/in Avro's Union\",\"fields\":[{\"name\":\"value\",\"type\":\"boolean\"}]},{\"type\":\"record\",\"name\":\"IntWrapper\",\"doc\":\"A record wrapping int type to be able to be used it w/in Avro's Union\",\"fields\":[{\"name\":\"value\",\"type\":\"int\"}]},{\"type\":\"record\",\"name\":\"LongWrapper\",\"doc\":\"A record wrapping long type to be able to be used it w/in Avro's Union\",\"fields\":[{\"name\":\"value\",\"type\":\"long\"}]},{\"type\":\"record\",\"name\":\"FloatWrapper\",\"doc\":\"A record wrapping float type to be able to be used it w/in Avro's Union\",\"fields\":[{\"name\":\"value\",\"type\":\"float\"}]},{\"type\":\"record\",\"name\":\"DoubleWrapper\",\"doc\":\"A record wrapping double type to be able to be used it w/in Avro's Union\",\"fields\":[{\"name\":\"value\",\"type\":\"double\"}]},{\"type\":\"record\",\"name\":\"BytesWrapper\",\"doc\":\"A record wrapping bytes type to be able to be used it w/in Avro's Union\",\"fields\":[{\"name\":\"value\",\"type\":\"bytes\"}]},{\"type\":\"record\",\"name\":\"StringWrapper\",\"doc\":\"A record wrapping string type to be able to be used it w/in Avro's Union\",\"fields\":[{\"name\":\"value\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"}}]},{\"type\":\"record\",\"name\":\"DateWrapper\",\"doc\":\"A record wrapping Date logical type to be able to be used it w/in Avro's Union\",\"fields\":[{\"name\":\"value\",\"type\":\"int\"}]},{\"type\":\"record\",\"name\":\"DecimalWrapper\",\"doc\":\"A record wrapping Decimal logical type to be able to be used it w/in Avro's Union\",\"fields\":[{\"name\":\"value\",\"type\":{\"type\":\"bytes\",\"logicalType\":\"decimal\",\"precision\":30,\"scale\":15}}]},{\"type\":\"record\",\"name\":\"TimeMicrosWrapper\",\"doc\":\"A record wrapping Time-micros logical type to be able to be used it w/in Avro's Union\",\"fields\":[{\"name\":\"value\",\"type\":{\"type\":\"long\",\"logicalType\":\"time-micros\"}}]},{\"type\":\"record\",\"name\":\"TimestampMicrosWrapper\",\"doc\":\"A record wrapping Timestamp-micros logical type to be able to be used it w/in Avro's Union\",\"fields\":[{\"name\":\"value\",\"type\":\"long\"}]}],\"doc\":\"Minimum value in the range. Based on user data table schema, we can convert this to appropriate type\",\"default\":null},{\"name\":\"maxValue\",\"type\":[\"null\",\"BooleanWrapper\",\"IntWrapper\",\"LongWrapper\",\"FloatWrapper\",\"DoubleWrapper\",\"BytesWrapper\",\"StringWrapper\",\"DateWrapper\",\"DecimalWrapper\",\"TimeMicrosWrapper\",\"TimestampMicrosWrapper\"],\"doc\":\"Maximum value in the range. Based on user data table schema, we can convert it to appropriate type\",\"default\":null},{\"name\":\"valueCount\",\"type\":[\"null\",\"long\"],\"doc\":\"Total count of values\",\"default\":null},{\"name\":\"nullCount\",\"type\":[\"null\",\"long\"],\"doc\":\"Total count of null values\",\"default\":null},{\"name\":\"totalSize\",\"type\":[\"null\",\"long\"],\"doc\":\"Total storage size on disk\",\"default\":null},{\"name\":\"totalUncompressedSize\",\"type\":[\"null\",\"long\"],\"doc\":\"Total uncompressed storage size on disk\",\"default\":null},{\"name\":\"isDeleted\",\"type\":\"boolean\",\"doc\":\"Column range entry valid/deleted flag\"}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<HoodieMetadataColumnStats> ENCODER;
    private static final BinaryMessageDecoder<HoodieMetadataColumnStats> DECODER;
    private String fileName;
    private String columnName;
    private Object minValue;
    private Object maxValue;
    private Long valueCount;
    private Long nullCount;
    private Long totalSize;
    private Long totalUncompressedSize;
    private boolean isDeleted;
    private static final DatumWriter<HoodieMetadataColumnStats> WRITER$;
    private static final DatumReader<HoodieMetadataColumnStats> READER$;

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<HoodieMetadataColumnStats> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<HoodieMetadataColumnStats> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<HoodieMetadataColumnStats> createDecoder(SchemaStore resolver2) {
        return new BinaryMessageDecoder<HoodieMetadataColumnStats>(MODEL$, SCHEMA$, resolver2);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode(this);
    }

    public static HoodieMetadataColumnStats fromByteBuffer(ByteBuffer b) throws IOException {
        return (HoodieMetadataColumnStats)DECODER.decode(b);
    }

    public HoodieMetadataColumnStats() {
    }

    public HoodieMetadataColumnStats(String fileName, String columnName, Object minValue, Object maxValue, Long valueCount, Long nullCount, Long totalSize, Long totalUncompressedSize, Boolean isDeleted) {
        this.fileName = fileName;
        this.columnName = columnName;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.valueCount = valueCount;
        this.nullCount = nullCount;
        this.totalSize = totalSize;
        this.totalUncompressedSize = totalUncompressedSize;
        this.isDeleted = isDeleted;
    }

    @Override
    public SpecificData getSpecificData() {
        return MODEL$;
    }

    @Override
    public Schema getSchema() {
        return SCHEMA$;
    }

    @Override
    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.fileName;
            }
            case 1: {
                return this.columnName;
            }
            case 2: {
                return this.minValue;
            }
            case 3: {
                return this.maxValue;
            }
            case 4: {
                return this.valueCount;
            }
            case 5: {
                return this.nullCount;
            }
            case 6: {
                return this.totalSize;
            }
            case 7: {
                return this.totalUncompressedSize;
            }
            case 8: {
                return this.isDeleted;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    @Override
    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.fileName = value$ != null ? value$.toString() : null;
                break;
            }
            case 1: {
                this.columnName = value$ != null ? value$.toString() : null;
                break;
            }
            case 2: {
                this.minValue = value$;
                break;
            }
            case 3: {
                this.maxValue = value$;
                break;
            }
            case 4: {
                this.valueCount = (Long)value$;
                break;
            }
            case 5: {
                this.nullCount = (Long)value$;
                break;
            }
            case 6: {
                this.totalSize = (Long)value$;
                break;
            }
            case 7: {
                this.totalUncompressedSize = (Long)value$;
                break;
            }
            case 8: {
                this.isDeleted = (Boolean)value$;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String value) {
        this.fileName = value;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String value) {
        this.columnName = value;
    }

    public Object getMinValue() {
        return this.minValue;
    }

    public void setMinValue(Object value) {
        this.minValue = value;
    }

    public Object getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(Object value) {
        this.maxValue = value;
    }

    public Long getValueCount() {
        return this.valueCount;
    }

    public void setValueCount(Long value) {
        this.valueCount = value;
    }

    public Long getNullCount() {
        return this.nullCount;
    }

    public void setNullCount(Long value) {
        this.nullCount = value;
    }

    public Long getTotalSize() {
        return this.totalSize;
    }

    public void setTotalSize(Long value) {
        this.totalSize = value;
    }

    public Long getTotalUncompressedSize() {
        return this.totalUncompressedSize;
    }

    public void setTotalUncompressedSize(Long value) {
        this.totalUncompressedSize = value;
    }

    public boolean getIsDeleted() {
        return this.isDeleted;
    }

    public void setIsDeleted(boolean value) {
        this.isDeleted = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(HoodieMetadataColumnStats other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write(this, SpecificData.getEncoder(out));
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        READER$.read(this, SpecificData.getDecoder(in));
    }

    static {
        MODEL$.addLogicalTypeConversion(new TimeConversions.TimeMicrosConversion());
        MODEL$.addLogicalTypeConversion(new Conversions.DecimalConversion());
        ENCODER = new BinaryMessageEncoder(MODEL$, SCHEMA$);
        DECODER = new BinaryMessageDecoder(MODEL$, SCHEMA$);
        WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
        READER$ = MODEL$.createDatumReader(SCHEMA$);
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<HoodieMetadataColumnStats>
    implements RecordBuilder<HoodieMetadataColumnStats> {
        private String fileName;
        private String columnName;
        private Object minValue;
        private Object maxValue;
        private Long valueCount;
        private Long nullCount;
        private Long totalSize;
        private Long totalUncompressedSize;
        private boolean isDeleted;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super(other);
            if (Builder.isValidValue(this.fields()[0], other.fileName)) {
                this.fileName = this.data().deepCopy(this.fields()[0].schema(), other.fileName);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue(this.fields()[1], other.columnName)) {
                this.columnName = this.data().deepCopy(this.fields()[1].schema(), other.columnName);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue(this.fields()[2], other.minValue)) {
                this.minValue = this.data().deepCopy(this.fields()[2].schema(), other.minValue);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue(this.fields()[3], other.maxValue)) {
                this.maxValue = this.data().deepCopy(this.fields()[3].schema(), other.maxValue);
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
            if (Builder.isValidValue(this.fields()[4], other.valueCount)) {
                this.valueCount = this.data().deepCopy(this.fields()[4].schema(), other.valueCount);
                this.fieldSetFlags()[4] = other.fieldSetFlags()[4];
            }
            if (Builder.isValidValue(this.fields()[5], other.nullCount)) {
                this.nullCount = this.data().deepCopy(this.fields()[5].schema(), other.nullCount);
                this.fieldSetFlags()[5] = other.fieldSetFlags()[5];
            }
            if (Builder.isValidValue(this.fields()[6], other.totalSize)) {
                this.totalSize = this.data().deepCopy(this.fields()[6].schema(), other.totalSize);
                this.fieldSetFlags()[6] = other.fieldSetFlags()[6];
            }
            if (Builder.isValidValue(this.fields()[7], other.totalUncompressedSize)) {
                this.totalUncompressedSize = this.data().deepCopy(this.fields()[7].schema(), other.totalUncompressedSize);
                this.fieldSetFlags()[7] = other.fieldSetFlags()[7];
            }
            if (Builder.isValidValue(this.fields()[8], other.isDeleted)) {
                this.isDeleted = this.data().deepCopy(this.fields()[8].schema(), other.isDeleted);
                this.fieldSetFlags()[8] = other.fieldSetFlags()[8];
            }
        }

        private Builder(HoodieMetadataColumnStats other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue(this.fields()[0], other.fileName)) {
                this.fileName = this.data().deepCopy(this.fields()[0].schema(), other.fileName);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue(this.fields()[1], other.columnName)) {
                this.columnName = this.data().deepCopy(this.fields()[1].schema(), other.columnName);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue(this.fields()[2], other.minValue)) {
                this.minValue = this.data().deepCopy(this.fields()[2].schema(), other.minValue);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue(this.fields()[3], other.maxValue)) {
                this.maxValue = this.data().deepCopy(this.fields()[3].schema(), other.maxValue);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue(this.fields()[4], other.valueCount)) {
                this.valueCount = this.data().deepCopy(this.fields()[4].schema(), other.valueCount);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue(this.fields()[5], other.nullCount)) {
                this.nullCount = this.data().deepCopy(this.fields()[5].schema(), other.nullCount);
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue(this.fields()[6], other.totalSize)) {
                this.totalSize = this.data().deepCopy(this.fields()[6].schema(), other.totalSize);
                this.fieldSetFlags()[6] = true;
            }
            if (Builder.isValidValue(this.fields()[7], other.totalUncompressedSize)) {
                this.totalUncompressedSize = this.data().deepCopy(this.fields()[7].schema(), other.totalUncompressedSize);
                this.fieldSetFlags()[7] = true;
            }
            if (Builder.isValidValue(this.fields()[8], other.isDeleted)) {
                this.isDeleted = this.data().deepCopy(this.fields()[8].schema(), other.isDeleted);
                this.fieldSetFlags()[8] = true;
            }
        }

        public String getFileName() {
            return this.fileName;
        }

        public Builder setFileName(String value) {
            this.validate(this.fields()[0], value);
            this.fileName = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasFileName() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearFileName() {
            this.fileName = null;
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public Builder setColumnName(String value) {
            this.validate(this.fields()[1], value);
            this.columnName = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasColumnName() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearColumnName() {
            this.columnName = null;
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public Object getMinValue() {
            return this.minValue;
        }

        public Builder setMinValue(Object value) {
            this.validate(this.fields()[2], value);
            this.minValue = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasMinValue() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearMinValue() {
            this.minValue = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public Object getMaxValue() {
            return this.maxValue;
        }

        public Builder setMaxValue(Object value) {
            this.validate(this.fields()[3], value);
            this.maxValue = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasMaxValue() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearMaxValue() {
            this.maxValue = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public Long getValueCount() {
            return this.valueCount;
        }

        public Builder setValueCount(Long value) {
            this.validate(this.fields()[4], value);
            this.valueCount = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasValueCount() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearValueCount() {
            this.valueCount = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public Long getNullCount() {
            return this.nullCount;
        }

        public Builder setNullCount(Long value) {
            this.validate(this.fields()[5], value);
            this.nullCount = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasNullCount() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearNullCount() {
            this.nullCount = null;
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public Long getTotalSize() {
            return this.totalSize;
        }

        public Builder setTotalSize(Long value) {
            this.validate(this.fields()[6], value);
            this.totalSize = value;
            this.fieldSetFlags()[6] = true;
            return this;
        }

        public boolean hasTotalSize() {
            return this.fieldSetFlags()[6];
        }

        public Builder clearTotalSize() {
            this.totalSize = null;
            this.fieldSetFlags()[6] = false;
            return this;
        }

        public Long getTotalUncompressedSize() {
            return this.totalUncompressedSize;
        }

        public Builder setTotalUncompressedSize(Long value) {
            this.validate(this.fields()[7], value);
            this.totalUncompressedSize = value;
            this.fieldSetFlags()[7] = true;
            return this;
        }

        public boolean hasTotalUncompressedSize() {
            return this.fieldSetFlags()[7];
        }

        public Builder clearTotalUncompressedSize() {
            this.totalUncompressedSize = null;
            this.fieldSetFlags()[7] = false;
            return this;
        }

        public boolean getIsDeleted() {
            return this.isDeleted;
        }

        public Builder setIsDeleted(boolean value) {
            this.validate(this.fields()[8], value);
            this.isDeleted = value;
            this.fieldSetFlags()[8] = true;
            return this;
        }

        public boolean hasIsDeleted() {
            return this.fieldSetFlags()[8];
        }

        public Builder clearIsDeleted() {
            this.fieldSetFlags()[8] = false;
            return this;
        }

        @Override
        public HoodieMetadataColumnStats build() {
            try {
                HoodieMetadataColumnStats record = new HoodieMetadataColumnStats();
                record.fileName = this.fieldSetFlags()[0] ? this.fileName : (String)this.defaultValue(this.fields()[0]);
                record.columnName = this.fieldSetFlags()[1] ? this.columnName : (String)this.defaultValue(this.fields()[1]);
                record.minValue = this.fieldSetFlags()[2] ? this.minValue : this.defaultValue(this.fields()[2]);
                record.maxValue = this.fieldSetFlags()[3] ? this.maxValue : this.defaultValue(this.fields()[3]);
                record.valueCount = this.fieldSetFlags()[4] ? this.valueCount : (Long)this.defaultValue(this.fields()[4]);
                record.nullCount = this.fieldSetFlags()[5] ? this.nullCount : (Long)this.defaultValue(this.fields()[5]);
                record.totalSize = this.fieldSetFlags()[6] ? this.totalSize : (Long)this.defaultValue(this.fields()[6]);
                record.totalUncompressedSize = this.fieldSetFlags()[7] ? this.totalUncompressedSize : (Long)this.defaultValue(this.fields()[7]);
                record.isDeleted = this.fieldSetFlags()[8] ? this.isDeleted : (Boolean)this.defaultValue(this.fields()[8]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException(e);
            }
        }
    }
}

