/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.avro;

import java.util.HashMap;
import java.util.Map;
import org.apache.hudi.common.bloom.BloomFilter;

public abstract class HoodieBloomFilterWriteSupport<T extends Comparable<T>> {
    public static final String HOODIE_MIN_RECORD_KEY_FOOTER = "hoodie_min_record_key";
    public static final String HOODIE_MAX_RECORD_KEY_FOOTER = "hoodie_max_record_key";
    public static final String HOODIE_BLOOM_FILTER_TYPE_CODE = "hoodie_bloom_filter_type_code";
    private final BloomFilter bloomFilter;
    private T minRecordKey;
    private T maxRecordKey;

    public HoodieBloomFilterWriteSupport(BloomFilter bloomFilter) {
        this.bloomFilter = bloomFilter;
    }

    public void addKey(T recordKey) {
        this.bloomFilter.add(this.getUTF8Bytes(recordKey));
        if (this.minRecordKey == null || this.minRecordKey.compareTo(recordKey) > 0) {
            this.minRecordKey = this.dereference(recordKey);
        }
        if (this.maxRecordKey == null || this.maxRecordKey.compareTo(recordKey) < 0) {
            this.maxRecordKey = this.dereference(recordKey);
        }
    }

    public Map<String, String> finalizeMetadata() {
        HashMap<String, String> extraMetadata = new HashMap<String, String>();
        extraMetadata.put("org.apache.hudi.bloomfilter", this.bloomFilter.serializeToString());
        if (this.bloomFilter.getBloomFilterTypeCode().name().contains("DYNAMIC")) {
            extraMetadata.put(HOODIE_BLOOM_FILTER_TYPE_CODE, this.bloomFilter.getBloomFilterTypeCode().name());
        }
        if (this.minRecordKey != null && this.maxRecordKey != null) {
            extraMetadata.put(HOODIE_MIN_RECORD_KEY_FOOTER, this.minRecordKey.toString());
            extraMetadata.put(HOODIE_MAX_RECORD_KEY_FOOTER, this.maxRecordKey.toString());
        }
        return extraMetadata;
    }

    protected abstract byte[] getUTF8Bytes(T var1);

    protected T dereference(T key) {
        return key;
    }
}

