/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.GenericTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.java.typeutils.runtime.KryoUtils;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.InstantiationUtil;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hudi.com.esotericsoftware.kryo.Kryo;
import org.apache.hudi.org.objenesis.strategy.StdInstantiatorStrategy;

@Internal
public final class WritableSerializer<T extends Writable>
extends TypeSerializer<T> {
    private static final long serialVersionUID = 1L;
    private final Class<T> typeClass;
    private transient Kryo kryo;
    private transient T copyInstance;

    public WritableSerializer(Class<T> typeClass) {
        this.typeClass = typeClass;
    }

    public T createInstance() {
        if (this.typeClass == NullWritable.class) {
            return (T)NullWritable.get();
        }
        return (T)((Writable)InstantiationUtil.instantiate(this.typeClass));
    }

    public T copy(T from) {
        this.checkKryoInitialized();
        return (T)((Writable)KryoUtils.copy(from, (Kryo)this.kryo, (TypeSerializer)this));
    }

    public T copy(T from, T reuse) {
        this.checkKryoInitialized();
        return (T)((Writable)KryoUtils.copy(from, reuse, (Kryo)this.kryo, (TypeSerializer)this));
    }

    public int getLength() {
        return -1;
    }

    public void serialize(T record, DataOutputView target) throws IOException {
        record.write((DataOutput)target);
    }

    public T deserialize(DataInputView source) throws IOException {
        return this.deserialize(this.createInstance(), source);
    }

    public T deserialize(T reuse, DataInputView source) throws IOException {
        reuse.readFields((DataInput)source);
        return reuse;
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        this.ensureInstanceInstantiated();
        this.copyInstance.readFields((DataInput)source);
        this.copyInstance.write((DataOutput)target);
    }

    public boolean isImmutableType() {
        return false;
    }

    public WritableSerializer<T> duplicate() {
        return new WritableSerializer<T>(this.typeClass);
    }

    private void ensureInstanceInstantiated() {
        if (this.copyInstance == null) {
            this.copyInstance = this.createInstance();
        }
    }

    private void checkKryoInitialized() {
        if (this.kryo == null) {
            this.kryo = new Kryo();
            Kryo.DefaultInstantiatorStrategy instantiatorStrategy = new Kryo.DefaultInstantiatorStrategy();
            instantiatorStrategy.setFallbackInstantiatorStrategy(new StdInstantiatorStrategy());
            this.kryo.setInstantiatorStrategy(instantiatorStrategy);
            this.kryo.setAsmEnabled(true);
            this.kryo.register(this.typeClass);
        }
    }

    public int hashCode() {
        return this.typeClass.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof WritableSerializer) {
            WritableSerializer other = (WritableSerializer)((Object)obj);
            return this.typeClass == other.typeClass;
        }
        return false;
    }

    public TypeSerializerSnapshot<T> snapshotConfiguration() {
        return new WritableSerializerSnapshot<T>(this.typeClass);
    }

    public static final class WritableSerializerSnapshot<T extends Writable>
    extends GenericTypeSerializerSnapshot<T, WritableSerializer> {
        public WritableSerializerSnapshot() {
        }

        WritableSerializerSnapshot(Class<T> typeClass) {
            super(typeClass);
        }

        protected TypeSerializer<T> createSerializer(Class<T> typeClass) {
            return new WritableSerializer<T>(typeClass);
        }

        protected Class<T> getTypeClass(WritableSerializer serializer) {
            return serializer.typeClass;
        }

        protected Class<?> serializerClass() {
            return WritableSerializer.class;
        }
    }
}

