/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.jetty;

import io.javalin.core.util.JavalinLogger;
import io.javalin.http.staticfiles.ResourceHandler;
import io.javalin.http.staticfiles.StaticFileConfig;
import io.javalin.jetty.ConfigurableHandler;
import io.javalin.jetty.JettyPrecompressingResourceHandler;
import io.javalin.jetty.JettyUtil;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.hudi.javax.servlet.ServletOutputStream;
import org.apache.hudi.javax.servlet.http.HttpServletRequest;
import org.apache.hudi.javax.servlet.http.HttpServletResponse;
import org.apache.hudi.org.apache.jetty.server.Request;
import org.apache.hudi.org.apache.jetty.util.resource.Resource;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001e\u0010\u0012\u001a\u00020\r*\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u000e\u0010\u0018\u001a\u00020\r*\u0004\u0018\u00010\u0013H\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0019"}, d2={"Lio/javalin/jetty/JettyResourceHandler;", "Lio/javalin/http/staticfiles/ResourceHandler;", "()V", "handlers", "", "Lio/javalin/jetty/ConfigurableHandler;", "getHandlers", "()Ljava/util/List;", "addStaticFileConfig", "", "config", "Lio/javalin/http/staticfiles/StaticFileConfig;", "handle", "", "httpRequest", "Lorg/apache/hudi/javax/servlet/http/HttpServletRequest;", "httpResponse", "Lorg/apache/hudi/javax/servlet/http/HttpServletResponse;", "isDirectoryWithWelcomeFile", "Lorg/apache/hudi/org/apache/jetty/util/resource/Resource;", "handler", "Lorg/apache/hudi/org/apache/jetty/server/handler/ResourceHandler;", "target", "", "isFile", "javalin"})
public final class JettyResourceHandler
implements ResourceHandler {
    @NotNull
    private final List<ConfigurableHandler> handlers;

    public JettyResourceHandler() {
        JettyUtil.disableJettyLogger();
        boolean bl = false;
        this.handlers = new ArrayList();
    }

    @NotNull
    public final List<ConfigurableHandler> getHandlers() {
        return this.handlers;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addStaticFileConfig(@NotNull StaticFileConfig config) {
        void $this$addStaticFileConfig_u24lambda_u2d0;
        Intrinsics.checkNotNullParameter(config, "config");
        ConfigurableHandler configurableHandler = new ConfigurableHandler(config);
        boolean bl = false;
        boolean bl2 = false;
        ConfigurableHandler configurableHandler2 = configurableHandler;
        List<ConfigurableHandler> list = this.handlers;
        boolean bl3 = false;
        $this$addStaticFileConfig_u24lambda_u2d0.start();
        Unit unit = Unit.INSTANCE;
        list.add(configurableHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public boolean handle(@NotNull HttpServletRequest httpRequest, @NotNull HttpServletResponse httpResponse) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(httpRequest, "httpRequest");
        Intrinsics.checkNotNullParameter(httpResponse, "httpResponse");
        Object object = httpRequest.getAttribute("jetty-target");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
        }
        String target = (String)object;
        Object object2 = httpRequest.getAttribute("jetty-request");
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.eclipse.jetty.server.Request");
        }
        Request baseRequest = (Request)object2;
        Iterable $this$filter$iv = this.handlers;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ConfigurableHandler it = (ConfigurableHandler)element$iv$iv;
            boolean bl = false;
            if (!(it.getConfig().skipFileFunction.invoke(httpRequest) == false)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ConfigurableHandler handler = (ConfigurableHandler)element$iv;
            boolean bl = false;
            try {
                Resource resource = handler.getResource(target);
                if (!this.isFile(resource) && !this.isDirectoryWithWelcomeFile(resource, handler, target)) continue;
                Map<String, String> $this$forEach$iv2 = handler.getConfig().headers;
                boolean $i$f$forEach2 = false;
                Map<String, String> map = $this$forEach$iv2;
                boolean bl2 = false;
                Iterator<Map.Entry<String, String>> iterator2 = map.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry<String, String> element$iv2;
                    Map.Entry<String, String> it = element$iv2 = iterator2.next();
                    boolean bl3 = false;
                    httpResponse.setHeader(it.getKey(), it.getValue());
                }
                if (handler.getConfig().precompress && JettyPrecompressingResourceHandler.INSTANCE.handle(resource, httpRequest, httpResponse)) {
                    return true;
                }
                httpResponse.setContentType(null);
                Closeable closeable = httpResponse.getOutputStream();
                boolean bl4 = false;
                boolean bl5 = false;
                Throwable throwable = null;
                try {
                    ServletOutputStream it = (ServletOutputStream)closeable;
                    boolean bl6 = false;
                    handler.handle(target, baseRequest, httpRequest, httpResponse);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally(closeable, throwable);
                }
                httpRequest.setAttribute("handled-as-static-file", true);
                return true;
            }
            catch (Exception e) {
                if (JettyUtil.INSTANCE.isClientAbortException(e)) continue;
                JavalinLogger.info("Exception occurred while handling static resource", e);
            }
        }
        return false;
    }

    private final boolean isFile(Resource $this$isFile) {
        return $this$isFile != null && $this$isFile.exists() && !$this$isFile.isDirectory();
    }

    private final boolean isDirectoryWithWelcomeFile(Resource $this$isDirectoryWithWelcomeFile, org.apache.hudi.org.apache.jetty.server.handler.ResourceHandler handler, String target) {
        Resource resource;
        return $this$isDirectoryWithWelcomeFile != null && $this$isDirectoryWithWelcomeFile.isDirectory() && ((resource = handler.getResource(Intrinsics.stringPlus(StringsKt.removeSuffix(target, (CharSequence)"/"), "/index.html"))) == null ? false : resource.exists());
    }
}

