/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.util;

import java.util.Iterator;
import java.util.function.Function;
import org.apache.hudi.common.util.Functions;
import org.apache.hudi.common.util.queue.BoundedInMemoryExecutor;
import org.apache.hudi.common.util.queue.DisruptorExecutor;
import org.apache.hudi.common.util.queue.ExecutorType;
import org.apache.hudi.common.util.queue.HoodieConsumer;
import org.apache.hudi.common.util.queue.HoodieExecutor;
import org.apache.hudi.common.util.queue.SimpleExecutor;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;

public class ExecutorFactory {
    public static <I, O, E> HoodieExecutor<E> create(HoodieWriteConfig config, Iterator<I> inputItr, HoodieConsumer<O, E> consumer, Function<I, O> transformFunction) {
        return ExecutorFactory.create(config, inputItr, consumer, transformFunction, Functions.noop());
    }

    public static <I, O, E> HoodieExecutor<E> create(HoodieWriteConfig config, Iterator<I> inputItr, HoodieConsumer<O, E> consumer, Function<I, O> transformFunction, Runnable preExecuteRunnable) {
        ExecutorType executorType = config.getExecutorType();
        switch (executorType) {
            case BOUNDED_IN_MEMORY: {
                return new BoundedInMemoryExecutor<I, O, E>(config.getWriteBufferLimitBytes(), inputItr, consumer, transformFunction, preExecuteRunnable);
            }
            case DISRUPTOR: {
                return new DisruptorExecutor<I, O, E>(config.getWriteExecutorDisruptorWriteBufferLimitBytes(), inputItr, consumer, transformFunction, config.getWriteExecutorDisruptorWaitStrategy(), preExecuteRunnable);
            }
            case SIMPLE: {
                return new SimpleExecutor<I, O, E>(inputItr, consumer, transformFunction);
            }
        }
        throw new HoodieException("Unsupported Executor Type " + (Object)((Object)executorType));
    }

    public static boolean isBufferingRecords(HoodieWriteConfig config) {
        ExecutorType executorType = config.getExecutorType();
        switch (executorType) {
            case BOUNDED_IN_MEMORY: 
            case DISRUPTOR: {
                return true;
            }
            case SIMPLE: {
                return false;
            }
        }
        throw new HoodieException("Unsupported Executor Type " + (Object)((Object)executorType));
    }
}

