/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.upgrade;

import java.util.Hashtable;
import java.util.Map;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.metadata.HoodieTableMetadataUtil;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.hudi.table.upgrade.SupportsUpgradeDowngrade;
import org.apache.hudi.table.upgrade.UpgradeHandler;

public class ThreeToFourUpgradeHandler
implements UpgradeHandler {
    @Override
    public Map<ConfigProperty, String> upgrade(HoodieWriteConfig config, HoodieEngineContext context, String instantTime, SupportsUpgradeDowngrade upgradeDowngradeHelper) {
        Hashtable<ConfigProperty, String> tablePropsToAdd = new Hashtable<ConfigProperty, String>();
        tablePropsToAdd.put(HoodieTableConfig.TABLE_CHECKSUM, String.valueOf(HoodieTableConfig.generateChecksum(config.getProps())));
        if (config.isMetadataTableEnabled() && HoodieTableMetadataUtil.metadataPartitionExists(config.getBasePath(), context, MetadataPartitionType.FILES)) {
            tablePropsToAdd.put(HoodieTableConfig.TABLE_METADATA_PARTITIONS, MetadataPartitionType.FILES.getPartitionPath());
        }
        return tablePropsToAdd;
    }
}

