/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.format;

import java.io.IOException;
import java.util.Map;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.DataType;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.common.util.ClosableIterator;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.table.format.CastMap;
import org.apache.hudi.table.format.InternalSchemaManager;
import org.apache.hudi.table.format.ParquetSplitRecordIterator;
import org.apache.hudi.table.format.SchemaEvolvedRecordIterator;
import org.apache.hudi.table.format.cow.ParquetSplitReaderUtil;
import org.apache.hudi.util.RowDataProjection;

public abstract class RecordIterators {
    public static ClosableIterator<RowData> getParquetRecordIterator(InternalSchemaManager internalSchemaManager, boolean utcTimestamp, boolean caseSensitive, Configuration conf, String[] fieldNames, DataType[] fieldTypes, Map<String, Object> partitionSpec, int[] selectedFields, int batchSize, Path path, long splitStart, long splitLength) throws IOException {
        InternalSchema mergeSchema = internalSchemaManager.getMergeSchema(path.getName());
        if (mergeSchema.isEmptySchema()) {
            return new ParquetSplitRecordIterator(ParquetSplitReaderUtil.genPartColumnarRowReader(utcTimestamp, caseSensitive, conf, fieldNames, fieldTypes, partitionSpec, selectedFields, batchSize, path, splitStart, splitLength));
        }
        CastMap castMap = internalSchemaManager.getCastMap(mergeSchema, fieldNames, fieldTypes, selectedFields);
        Option<RowDataProjection> castProjection = castMap.toRowDataProjection(selectedFields);
        ParquetSplitRecordIterator itr = new ParquetSplitRecordIterator(ParquetSplitReaderUtil.genPartColumnarRowReader(utcTimestamp, caseSensitive, conf, internalSchemaManager.getMergeFieldNames(mergeSchema, fieldNames), castMap.getFileFieldTypes(), partitionSpec, selectedFields, batchSize, path, splitStart, splitLength));
        if (castProjection.isPresent()) {
            return new SchemaEvolvedRecordIterator(itr, castProjection.get());
        }
        return itr;
    }
}

