/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.format;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.binary.BinaryStringData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.util.RowDataCastProjection;
import org.apache.hudi.util.RowDataProjection;

public final class CastMap
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<Integer, Cast> castMap = new HashMap<Integer, Cast>();
    private DataType[] fileFieldTypes;

    public Option<RowDataProjection> toRowDataProjection(int[] selectedFields) {
        if (this.castMap.isEmpty()) {
            return Option.empty();
        }
        LogicalType[] requiredType = new LogicalType[selectedFields.length];
        for (int i = 0; i < selectedFields.length; ++i) {
            requiredType[i] = this.fileFieldTypes[selectedFields[i]].getLogicalType();
        }
        return Option.of(new RowDataCastProjection(requiredType, this));
    }

    public Object castIfNeeded(int pos, Object val) {
        Cast cast = this.castMap.get(pos);
        if (cast == null) {
            return val;
        }
        return cast.convert(val);
    }

    public DataType[] getFileFieldTypes() {
        return this.fileFieldTypes;
    }

    public void setFileFieldTypes(DataType[] fileFieldTypes) {
        this.fileFieldTypes = fileFieldTypes;
    }

    @VisibleForTesting
    void add(int pos, LogicalType fromType, LogicalType toType) {
        Function<Object, Object> conversion = this.getConversion(fromType, toType);
        if (conversion == null) {
            throw new IllegalArgumentException(String.format("Cannot create cast %s => %s at pos %s", fromType, toType, pos));
        }
        this.add(pos, new Cast(fromType, toType, conversion));
    }

    @Nullable
    private Function<Object, Object> getConversion(LogicalType fromType, LogicalType toType) {
        LogicalTypeRoot from = fromType.getTypeRoot();
        LogicalTypeRoot to = toType.getTypeRoot();
        switch (to) {
            case BIGINT: {
                if (from != LogicalTypeRoot.INTEGER) break;
                return val -> ((Number)val).longValue();
            }
            case FLOAT: {
                if (from != LogicalTypeRoot.INTEGER && from != LogicalTypeRoot.BIGINT) break;
                return val -> Float.valueOf(((Number)val).floatValue());
            }
            case DOUBLE: {
                if (from == LogicalTypeRoot.INTEGER || from == LogicalTypeRoot.BIGINT) {
                    return val -> ((Number)val).doubleValue();
                }
                if (from != LogicalTypeRoot.FLOAT) break;
                return val -> Double.parseDouble(val.toString());
            }
            case DECIMAL: {
                if (from == LogicalTypeRoot.INTEGER || from == LogicalTypeRoot.BIGINT || from == LogicalTypeRoot.DOUBLE) {
                    return val -> this.toDecimalData((Number)val, toType);
                }
                if (from == LogicalTypeRoot.FLOAT) {
                    return val -> this.toDecimalData(Double.parseDouble(val.toString()), toType);
                }
                if (from == LogicalTypeRoot.VARCHAR) {
                    return val -> this.toDecimalData(Double.parseDouble(val.toString()), toType);
                }
                if (from != LogicalTypeRoot.DECIMAL) break;
                return val -> this.toDecimalData(((DecimalData)val).toBigDecimal(), toType);
            }
            case VARCHAR: {
                if (from == LogicalTypeRoot.INTEGER || from == LogicalTypeRoot.BIGINT || from == LogicalTypeRoot.FLOAT || from == LogicalTypeRoot.DOUBLE || from == LogicalTypeRoot.DECIMAL) {
                    return val -> new BinaryStringData(String.valueOf(val));
                }
                if (from != LogicalTypeRoot.DATE) break;
                return val -> new BinaryStringData(LocalDate.ofEpochDay(((Integer)val).longValue()).toString());
            }
            case DATE: {
                if (from != LogicalTypeRoot.VARCHAR) break;
                return val -> (int)LocalDate.parse(val.toString()).toEpochDay();
            }
        }
        return null;
    }

    private void add(int pos, Cast cast) {
        this.castMap.put(pos, cast);
    }

    private DecimalData toDecimalData(Number val, LogicalType decimalType) {
        BigDecimal valAsDecimal = BigDecimal.valueOf(val.doubleValue());
        return this.toDecimalData(valAsDecimal, decimalType);
    }

    private DecimalData toDecimalData(BigDecimal valAsDecimal, LogicalType decimalType) {
        return DecimalData.fromBigDecimal((BigDecimal)valAsDecimal, (int)((DecimalType)decimalType).getPrecision(), (int)((DecimalType)decimalType).getScale());
    }

    public String toString() {
        return this.castMap.entrySet().stream().map(e -> e.getKey() + ": " + e.getValue()).collect(Collectors.joining(", ", "{", "}"));
    }

    private static final class Cast
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final LogicalType from;
        private final LogicalType to;
        private final Function<Object, Object> conversion;

        Cast(LogicalType from, LogicalType to, Function<Object, Object> conversion) {
            this.from = from;
            this.to = to;
            this.conversion = conversion;
        }

        Object convert(Object val) {
            return this.conversion.apply(val);
        }

        public String toString() {
            return this.from + " => " + this.to;
        }
    }
}

