/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.restore;

import java.io.IOException;
import org.apache.hudi.avro.model.HoodieRestorePlan;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.rollback.RestorePlanActionExecutor;

public class RestoreUtils {
    public static HoodieRestorePlan getRestorePlan(HoodieTableMetaClient metaClient, HoodieInstant restoreInstant) throws IOException {
        HoodieInstant requested = HoodieTimeline.getRollbackRequestedInstant(restoreInstant);
        return TimelineMetadataUtils.deserializeAvroMetadata(metaClient.getActiveTimeline().readRestoreInfoAsBytes(requested).get(), HoodieRestorePlan.class);
    }

    public static String getSavepointToRestoreTimestampV1Schema(HoodieTable table, HoodieRestorePlan plan) {
        String firstRollback = plan.getInstantsToRollback().get(plan.getInstantsToRollback().size() - 1).getCommitTime();
        Option<HoodieInstant> savepointInstance = table.getActiveTimeline().getSavePointTimeline().findInstantsBefore(firstRollback).lastInstant();
        return savepointInstance.isPresent() ? savepointInstance.get().getTimestamp() : null;
    }

    public static String getSavepointToRestoreTimestamp(HoodieTable table, HoodieInstant restoreInstant) throws IOException {
        HoodieRestorePlan plan = RestoreUtils.getRestorePlan(table.getMetaClient(), restoreInstant);
        if (plan.getVersion().compareTo(RestorePlanActionExecutor.RESTORE_PLAN_VERSION_1) > 0) {
            return plan.getSavepointToRestoreTimestamp();
        }
        return RestoreUtils.getSavepointToRestoreTimestampV1Schema(table, plan);
    }
}

