/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sink.compact;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.api.common.functions.AbstractRichFunction;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.common.model.CompactionOperation;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.sink.compact.CompactionPlanEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionPlanSourceFunction
extends AbstractRichFunction
implements SourceFunction<CompactionPlanEvent> {
    protected static final Logger LOG = LoggerFactory.getLogger(CompactionPlanSourceFunction.class);
    private final List<Pair<String, HoodieCompactionPlan>> compactionPlans;

    public CompactionPlanSourceFunction(List<Pair<String, HoodieCompactionPlan>> compactionPlans) {
        this.compactionPlans = compactionPlans;
    }

    public void open(Configuration parameters) throws Exception {
    }

    public void run(SourceFunction.SourceContext sourceContext) throws Exception {
        for (Pair<String, HoodieCompactionPlan> pair : this.compactionPlans) {
            HoodieCompactionPlan compactionPlan = pair.getRight();
            List operations = compactionPlan.getOperations().stream().map(CompactionOperation::convertFromAvroRecordInstance).collect(Collectors.toList());
            LOG.info("CompactionPlanFunction compacting " + operations + " files");
            for (CompactionOperation operation : operations) {
                sourceContext.collect((Object)new CompactionPlanEvent(pair.getLeft(), operation));
            }
        }
    }

    public void close() throws Exception {
    }

    public void cancel() {
    }
}

