/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.jetty.io;

import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hudi.org.apache.jetty.io.CyclicTimeout;
import org.apache.hudi.org.apache.jetty.util.component.Destroyable;
import org.apache.hudi.org.apache.jetty.util.log.Log;
import org.apache.hudi.org.apache.jetty.util.log.Logger;
import org.apache.hudi.org.apache.jetty.util.thread.Scheduler;

public abstract class CyclicTimeouts<T extends Expirable>
implements Destroyable {
    private static final Logger LOG = Log.getLogger(CyclicTimeouts.class);
    private final AtomicLong earliestTimeout = new AtomicLong(Long.MAX_VALUE);
    private final CyclicTimeout cyclicTimeout;

    public CyclicTimeouts(Scheduler scheduler) {
        this.cyclicTimeout = new Timeouts(scheduler);
    }

    protected abstract Iterator<T> iterator();

    protected abstract boolean onExpired(T var1);

    private void onTimeoutExpired() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Timeouts check for {}", this);
        }
        long now = System.nanoTime();
        long earliest = Long.MAX_VALUE;
        this.earliestTimeout.set(earliest);
        Iterator<T> iterator2 = this.iterator();
        if (iterator2 == null) {
            return;
        }
        while (iterator2.hasNext()) {
            Expirable expirable = (Expirable)iterator2.next();
            long expiresAt = expirable.getExpireNanoTime();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Entity {} expires in {} ms for {}", expirable, TimeUnit.NANOSECONDS.toMillis(expiresAt - now), this);
            }
            if (expiresAt == -1L) continue;
            if (expiresAt <= now) {
                boolean remove = this.onExpired(expirable);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Entity {} expired, remove={} for {}", expirable, remove, this);
                }
                if (!remove) continue;
                iterator2.remove();
                continue;
            }
            earliest = Math.min(earliest, expiresAt);
        }
        if (earliest < Long.MAX_VALUE) {
            this.schedule(earliest);
        }
    }

    public void schedule(T expirable) {
        long expiresAt = expirable.getExpireNanoTime();
        if (expiresAt < Long.MAX_VALUE) {
            this.schedule(expiresAt);
        }
    }

    private void schedule(long expiresAt) {
        long prevEarliest = this.earliestTimeout.getAndUpdate(t -> Math.min(t, expiresAt));
        long expires = expiresAt;
        while (expires < prevEarliest) {
            long delay = Math.max(0L, expires - System.nanoTime());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Scheduling timeout in {} ms for {}", TimeUnit.NANOSECONDS.toMillis(delay), this);
            }
            this.schedule(this.cyclicTimeout, delay, TimeUnit.NANOSECONDS);
            prevEarliest = expires;
            expires = this.earliestTimeout.get();
        }
    }

    @Override
    public void destroy() {
        this.cyclicTimeout.destroy();
    }

    boolean schedule(CyclicTimeout cyclicTimeout, long delay, TimeUnit unit) {
        return cyclicTimeout.schedule(delay, unit);
    }

    private class Timeouts
    extends CyclicTimeout {
        private Timeouts(Scheduler scheduler) {
            super(scheduler);
        }

        @Override
        public void onTimeoutExpired() {
            CyclicTimeouts.this.onTimeoutExpired();
        }
    }

    public static interface Expirable {
        public long getExpireNanoTime();
    }
}

