/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.hudi.org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hudi.org.apache.hadoop.hbase.TableName;
import org.apache.hudi.org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hudi.org.apache.hadoop.hbase.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public interface AsyncTableRegionLocator {
    public TableName getName();

    default public CompletableFuture<HRegionLocation> getRegionLocation(byte[] row) {
        return this.getRegionLocation(row, false);
    }

    default public CompletableFuture<HRegionLocation> getRegionLocation(byte[] row, boolean reload) {
        return this.getRegionLocation(row, 0, reload);
    }

    default public CompletableFuture<HRegionLocation> getRegionLocation(byte[] row, int replicaId) {
        return this.getRegionLocation(row, replicaId, false);
    }

    public CompletableFuture<HRegionLocation> getRegionLocation(byte[] var1, int var2, boolean var3);

    default public CompletableFuture<List<HRegionLocation>> getRegionLocations(byte[] row) {
        return this.getRegionLocations(row, false);
    }

    public CompletableFuture<List<HRegionLocation>> getRegionLocations(byte[] var1, boolean var2);

    public CompletableFuture<List<HRegionLocation>> getAllRegionLocations();

    default public CompletableFuture<List<byte[]>> getStartKeys() throws IOException {
        return this.getStartEndKeys().thenApply(startEndKeys -> startEndKeys.stream().map(Pair::getFirst).collect(Collectors.toList()));
    }

    default public CompletableFuture<List<byte[]>> getEndKeys() throws IOException {
        return this.getStartEndKeys().thenApply(startEndKeys -> startEndKeys.stream().map(Pair::getSecond).collect(Collectors.toList()));
    }

    default public CompletableFuture<List<Pair<byte[], byte[]>>> getStartEndKeys() throws IOException {
        return this.getAllRegionLocations().thenApply(locs -> locs.stream().filter(loc -> RegionReplicaUtil.isDefaultReplica(loc.getRegion())).map(HRegionLocation::getRegion).map(r -> Pair.newPair(r.getStartKey(), r.getEndKey())).collect(Collectors.toList()));
    }

    public void clearRegionLocationCache();
}

