/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.model.BooleanWrapper;
import org.apache.hudi.avro.model.BytesWrapper;
import org.apache.hudi.avro.model.DateWrapper;
import org.apache.hudi.avro.model.DecimalWrapper;
import org.apache.hudi.avro.model.DoubleWrapper;
import org.apache.hudi.avro.model.FloatWrapper;
import org.apache.hudi.avro.model.HoodieMetadataBloomFilter;
import org.apache.hudi.avro.model.HoodieMetadataColumnStats;
import org.apache.hudi.avro.model.HoodieMetadataFileInfo;
import org.apache.hudi.avro.model.HoodieMetadataRecord;
import org.apache.hudi.avro.model.IntWrapper;
import org.apache.hudi.avro.model.LongWrapper;
import org.apache.hudi.avro.model.StringWrapper;
import org.apache.hudi.avro.model.TimestampMicrosWrapper;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieAvroRecord;
import org.apache.hudi.common.model.HoodieColumnRangeMetadata;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.util.DateTimeUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.TypeUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.hash.ColumnIndexID;
import org.apache.hudi.common.util.hash.FileIndexID;
import org.apache.hudi.common.util.hash.PartitionIndexID;
import org.apache.hudi.exception.HoodieMetadataException;
import org.apache.hudi.hadoop.CachingPath;
import org.apache.hudi.metadata.HoodieTableMetadataUtil;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.hudi.org.apache.avro.Conversions;
import org.apache.hudi.org.apache.avro.LogicalTypes;
import org.apache.hudi.org.apache.avro.Schema;
import org.apache.hudi.org.apache.avro.generic.GenericRecord;
import org.apache.hudi.org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.org.apache.avro.util.Utf8;
import org.apache.hudi.util.Lazy;

public class HoodieMetadataPayload
implements HoodieRecordPayload<HoodieMetadataPayload> {
    protected static final int METADATA_TYPE_PARTITION_LIST = 1;
    protected static final int METADATA_TYPE_FILE_LIST = 2;
    protected static final int METADATA_TYPE_COLUMN_STATS = 3;
    protected static final int METADATA_TYPE_BLOOM_FILTER = 4;
    public static final String KEY_FIELD_NAME = "key";
    public static final String SCHEMA_FIELD_NAME_TYPE = "type";
    public static final String SCHEMA_FIELD_NAME_METADATA = "filesystemMetadata";
    public static final String SCHEMA_FIELD_ID_COLUMN_STATS = "ColumnStatsMetadata";
    public static final String SCHEMA_FIELD_ID_BLOOM_FILTER = "BloomFilterMetadata";
    private static final String FIELD_IS_DELETED = "isDeleted";
    private static final String BLOOM_FILTER_FIELD_TYPE = "type";
    private static final String BLOOM_FILTER_FIELD_TIMESTAMP = "timestamp";
    private static final String BLOOM_FILTER_FIELD_BLOOM_FILTER = "bloomFilter";
    private static final String BLOOM_FILTER_FIELD_IS_DELETED = "isDeleted";
    public static final String COLUMN_STATS_FIELD_MIN_VALUE = "minValue";
    public static final String COLUMN_STATS_FIELD_MAX_VALUE = "maxValue";
    public static final String COLUMN_STATS_FIELD_NULL_COUNT = "nullCount";
    public static final String COLUMN_STATS_FIELD_VALUE_COUNT = "valueCount";
    public static final String COLUMN_STATS_FIELD_TOTAL_SIZE = "totalSize";
    public static final String COLUMN_STATS_FIELD_FILE_NAME = "fileName";
    public static final String COLUMN_STATS_FIELD_COLUMN_NAME = "columnName";
    public static final String COLUMN_STATS_FIELD_TOTAL_UNCOMPRESSED_SIZE = "totalUncompressedSize";
    public static final String COLUMN_STATS_FIELD_IS_DELETED = "isDeleted";
    private static final Conversions.DecimalConversion AVRO_DECIMAL_CONVERSION = new Conversions.DecimalConversion();
    private static final Lazy<HoodieMetadataColumnStats.Builder> METADATA_COLUMN_STATS_BUILDER_STUB = Lazy.lazily(HoodieMetadataColumnStats::newBuilder);
    private static final Lazy<StringWrapper.Builder> STRING_WRAPPER_BUILDER_STUB = Lazy.lazily(StringWrapper::newBuilder);
    private static final Lazy<BytesWrapper.Builder> BYTES_WRAPPER_BUILDER_STUB = Lazy.lazily(BytesWrapper::newBuilder);
    private static final Lazy<DoubleWrapper.Builder> DOUBLE_WRAPPER_BUILDER_STUB = Lazy.lazily(DoubleWrapper::newBuilder);
    private static final Lazy<FloatWrapper.Builder> FLOAT_WRAPPER_BUILDER_STUB = Lazy.lazily(FloatWrapper::newBuilder);
    private static final Lazy<LongWrapper.Builder> LONG_WRAPPER_BUILDER_STUB = Lazy.lazily(LongWrapper::newBuilder);
    private static final Lazy<IntWrapper.Builder> INT_WRAPPER_BUILDER_STUB = Lazy.lazily(IntWrapper::newBuilder);
    private static final Lazy<BooleanWrapper.Builder> BOOLEAN_WRAPPER_BUILDER_STUB = Lazy.lazily(BooleanWrapper::newBuilder);
    private static final Lazy<TimestampMicrosWrapper.Builder> TIMESTAMP_MICROS_WRAPPER_BUILDER_STUB = Lazy.lazily(TimestampMicrosWrapper::newBuilder);
    private static final Lazy<DecimalWrapper.Builder> DECIMAL_WRAPPER_BUILDER_STUB = Lazy.lazily(DecimalWrapper::newBuilder);
    private static final Lazy<DateWrapper.Builder> DATE_WRAPPER_BUILDER_STUB = Lazy.lazily(DateWrapper::newBuilder);
    private String key = null;
    private int type = 0;
    private Map<String, HoodieMetadataFileInfo> filesystemMetadata = null;
    private HoodieMetadataBloomFilter bloomFilterMetadata = null;
    private HoodieMetadataColumnStats columnStatMetadata = null;

    public HoodieMetadataPayload(GenericRecord record, Comparable<?> orderingVal) {
        this(Option.of(record));
    }

    public HoodieMetadataPayload(Option<GenericRecord> recordOpt) {
        if (recordOpt.isPresent()) {
            GenericRecord record = recordOpt.get();
            this.key = record.get(KEY_FIELD_NAME).toString();
            this.type = (Integer)record.get("type");
            Map metadata = (Map)HoodieMetadataPayload.getNestedFieldValue(record, SCHEMA_FIELD_NAME_METADATA);
            if (metadata != null) {
                this.filesystemMetadata = metadata;
                this.filesystemMetadata.keySet().forEach(k -> {
                    GenericRecord v = this.filesystemMetadata.get(k);
                    this.filesystemMetadata.put((String)k, new HoodieMetadataFileInfo((Long)v.get("size"), (Boolean)v.get("isDeleted")));
                });
            }
            if (this.type == 4) {
                GenericRecord bloomFilterRecord = (GenericRecord)HoodieMetadataPayload.getNestedFieldValue(record, SCHEMA_FIELD_ID_BLOOM_FILTER);
                if (bloomFilterRecord == null) {
                    ValidationUtils.checkArgument(record.getSchema().getField(SCHEMA_FIELD_ID_BLOOM_FILTER) == null, String.format("Valid %s record expected for type: %s", SCHEMA_FIELD_ID_BLOOM_FILTER, 3));
                } else {
                    this.bloomFilterMetadata = new HoodieMetadataBloomFilter((String)bloomFilterRecord.get("type"), (String)bloomFilterRecord.get(BLOOM_FILTER_FIELD_TIMESTAMP), (ByteBuffer)bloomFilterRecord.get(BLOOM_FILTER_FIELD_BLOOM_FILTER), (Boolean)bloomFilterRecord.get("isDeleted"));
                }
            }
            if (this.type == 3) {
                GenericRecord columnStatsRecord = (GenericRecord)HoodieMetadataPayload.getNestedFieldValue(record, SCHEMA_FIELD_ID_COLUMN_STATS);
                if (columnStatsRecord == null) {
                    ValidationUtils.checkArgument(record.getSchema().getField(SCHEMA_FIELD_ID_COLUMN_STATS) == null, String.format("Valid %s record expected for type: %s", SCHEMA_FIELD_ID_COLUMN_STATS, 3));
                } else {
                    this.columnStatMetadata = HoodieMetadataColumnStats.newBuilder(METADATA_COLUMN_STATS_BUILDER_STUB.get()).setFileName((String)columnStatsRecord.get(COLUMN_STATS_FIELD_FILE_NAME)).setColumnName((String)columnStatsRecord.get(COLUMN_STATS_FIELD_COLUMN_NAME)).setMinValue(HoodieMetadataPayload.wrapStatisticValue(HoodieMetadataPayload.unwrapStatisticValueWrapper(columnStatsRecord.get(COLUMN_STATS_FIELD_MIN_VALUE)))).setMaxValue(HoodieMetadataPayload.wrapStatisticValue(HoodieMetadataPayload.unwrapStatisticValueWrapper(columnStatsRecord.get(COLUMN_STATS_FIELD_MAX_VALUE)))).setValueCount((Long)columnStatsRecord.get(COLUMN_STATS_FIELD_VALUE_COUNT)).setNullCount((Long)columnStatsRecord.get(COLUMN_STATS_FIELD_NULL_COUNT)).setTotalSize((Long)columnStatsRecord.get(COLUMN_STATS_FIELD_TOTAL_SIZE)).setTotalUncompressedSize((Long)columnStatsRecord.get(COLUMN_STATS_FIELD_TOTAL_UNCOMPRESSED_SIZE)).setIsDeleted((Boolean)columnStatsRecord.get("isDeleted")).build();
                }
            }
        }
    }

    private HoodieMetadataPayload(String key, int type, Map<String, HoodieMetadataFileInfo> filesystemMetadata) {
        this(key, type, filesystemMetadata, null, null);
    }

    private HoodieMetadataPayload(String key, HoodieMetadataBloomFilter metadataBloomFilter) {
        this(key, 4, null, metadataBloomFilter, null);
    }

    private HoodieMetadataPayload(String key, HoodieMetadataColumnStats columnStats) {
        this(key, 3, null, null, columnStats);
    }

    protected HoodieMetadataPayload(String key, int type, Map<String, HoodieMetadataFileInfo> filesystemMetadata, HoodieMetadataBloomFilter metadataBloomFilter, HoodieMetadataColumnStats columnStats) {
        this.key = key;
        this.type = type;
        this.filesystemMetadata = filesystemMetadata;
        this.bloomFilterMetadata = metadataBloomFilter;
        this.columnStatMetadata = columnStats;
    }

    public static HoodieRecord<HoodieMetadataPayload> createPartitionListRecord(List<String> partitions) {
        return HoodieMetadataPayload.createPartitionListRecord(partitions, false);
    }

    public static HoodieRecord<HoodieMetadataPayload> createPartitionListRecord(List<String> partitions, boolean isDeleted) {
        HashMap<String, HoodieMetadataFileInfo> fileInfo = new HashMap<String, HoodieMetadataFileInfo>();
        partitions.forEach(partition -> fileInfo.put(HoodieTableMetadataUtil.getPartitionIdentifier(partition), new HoodieMetadataFileInfo(0L, isDeleted)));
        HoodieKey key = new HoodieKey("__all_partitions__", MetadataPartitionType.FILES.getPartitionPath());
        HoodieMetadataPayload payload = new HoodieMetadataPayload(key.getRecordKey(), 1, fileInfo);
        return new HoodieAvroRecord<HoodieMetadataPayload>(key, payload);
    }

    public static HoodieRecord<HoodieMetadataPayload> createPartitionListRecord(List<String> partitionsAdded, List<String> partitionsDeleted) {
        HashMap<String, HoodieMetadataFileInfo> fileInfo = new HashMap<String, HoodieMetadataFileInfo>();
        partitionsAdded.forEach(partition -> fileInfo.put((String)partition, new HoodieMetadataFileInfo(0L, false)));
        partitionsDeleted.forEach(partition -> fileInfo.put((String)partition, new HoodieMetadataFileInfo(0L, true)));
        HoodieKey key = new HoodieKey("__all_partitions__", MetadataPartitionType.FILES.getPartitionPath());
        HoodieMetadataPayload payload = new HoodieMetadataPayload(key.getRecordKey(), 1, fileInfo);
        return new HoodieAvroRecord<HoodieMetadataPayload>(key, payload);
    }

    public static HoodieRecord<HoodieMetadataPayload> createPartitionFilesRecord(String partition, Option<Map<String, Long>> filesAdded, Option<List<String>> filesDeleted) {
        HashMap<String, HoodieMetadataFileInfo> fileInfo = new HashMap<String, HoodieMetadataFileInfo>();
        filesAdded.ifPresent(filesMap -> fileInfo.putAll(filesMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            long fileSize = (Long)entry.getValue();
            ValidationUtils.checkState(fileSize > 0L);
            return new HoodieMetadataFileInfo(fileSize, false);
        }))));
        filesDeleted.ifPresent(filesList -> fileInfo.putAll(filesList.stream().collect(Collectors.toMap(Function.identity(), ignored -> new HoodieMetadataFileInfo(0L, true)))));
        HoodieKey key = new HoodieKey(partition, MetadataPartitionType.FILES.getPartitionPath());
        HoodieMetadataPayload payload = new HoodieMetadataPayload(key.getRecordKey(), 2, fileInfo);
        return new HoodieAvroRecord<HoodieMetadataPayload>(key, payload);
    }

    public static HoodieRecord<HoodieMetadataPayload> createBloomFilterMetadataRecord(String partitionName, String baseFileName, String timestamp, String bloomFilterType, ByteBuffer bloomFilter, boolean isDeleted) {
        ValidationUtils.checkArgument(!baseFileName.contains("/") && FSUtils.isBaseFile(new Path(baseFileName)), "Invalid base file '" + baseFileName + "' for MetaIndexBloomFilter!");
        String bloomFilterIndexKey = new PartitionIndexID(partitionName).asBase64EncodedString().concat(new FileIndexID(baseFileName).asBase64EncodedString());
        HoodieKey key = new HoodieKey(bloomFilterIndexKey, MetadataPartitionType.BLOOM_FILTERS.getPartitionPath());
        HoodieMetadataBloomFilter metadataBloomFilter = new HoodieMetadataBloomFilter(bloomFilterType, timestamp, bloomFilter, isDeleted);
        HoodieMetadataPayload metadataPayload = new HoodieMetadataPayload(key.getRecordKey(), metadataBloomFilter);
        return new HoodieAvroRecord<HoodieMetadataPayload>(key, metadataPayload);
    }

    @Override
    public HoodieMetadataPayload preCombine(HoodieMetadataPayload previousRecord) {
        ValidationUtils.checkArgument(previousRecord.type == this.type, "Cannot combine " + previousRecord.type + " with " + this.type);
        switch (this.type) {
            case 1: 
            case 2: {
                Map<String, HoodieMetadataFileInfo> combinedFileInfo = this.combineFileSystemMetadata(previousRecord);
                return new HoodieMetadataPayload(this.key, this.type, combinedFileInfo);
            }
            case 4: {
                HoodieMetadataBloomFilter combineBloomFilterMetadata = this.combineBloomFilterMetadata(previousRecord);
                return new HoodieMetadataPayload(this.key, combineBloomFilterMetadata);
            }
            case 3: {
                return new HoodieMetadataPayload(this.key, this.combineColumnStatsMetadata(previousRecord));
            }
        }
        throw new HoodieMetadataException("Unknown type of HoodieMetadataPayload: " + this.type);
    }

    private HoodieMetadataBloomFilter combineBloomFilterMetadata(HoodieMetadataPayload previousRecord) {
        return this.bloomFilterMetadata;
    }

    private HoodieMetadataColumnStats combineColumnStatsMetadata(HoodieMetadataPayload previousRecord) {
        ValidationUtils.checkArgument(previousRecord.getColumnStatMetadata().isPresent());
        ValidationUtils.checkArgument(this.getColumnStatMetadata().isPresent());
        HoodieMetadataColumnStats previousColStatsRecord = previousRecord.getColumnStatMetadata().get();
        HoodieMetadataColumnStats newColumnStatsRecord = this.getColumnStatMetadata().get();
        return HoodieMetadataPayload.mergeColumnStatsRecords(previousColStatsRecord, newColumnStatsRecord);
    }

    @Override
    public Option<IndexedRecord> combineAndGetUpdateValue(IndexedRecord oldRecord, Schema schema, Properties properties) throws IOException {
        HoodieMetadataPayload anotherPayload = new HoodieMetadataPayload(Option.of((GenericRecord)oldRecord));
        HoodieMetadataPayload combinedPayload = this.preCombine(anotherPayload);
        return combinedPayload.getInsertValue(schema, properties);
    }

    @Override
    public Option<IndexedRecord> combineAndGetUpdateValue(IndexedRecord oldRecord, Schema schema) throws IOException {
        return this.combineAndGetUpdateValue(oldRecord, schema, new Properties());
    }

    @Override
    public Option<IndexedRecord> getInsertValue(Schema schemaIgnored, Properties propertiesIgnored) throws IOException {
        if (this.key == null) {
            return Option.empty();
        }
        HoodieMetadataRecord record = new HoodieMetadataRecord(this.key, this.type, this.filesystemMetadata, this.bloomFilterMetadata, this.columnStatMetadata);
        return Option.of(record);
    }

    @Override
    public Option<IndexedRecord> getInsertValue(Schema schema) throws IOException {
        return this.getInsertValue(schema, new Properties());
    }

    public List<String> getFilenames() {
        return this.filterFileInfoEntries(false).map(Map.Entry::getKey).sorted().collect(Collectors.toList());
    }

    public List<String> getDeletions() {
        return this.filterFileInfoEntries(true).map(Map.Entry::getKey).sorted().collect(Collectors.toList());
    }

    public Option<HoodieMetadataBloomFilter> getBloomFilterMetadata() {
        if (this.bloomFilterMetadata == null) {
            return Option.empty();
        }
        return Option.of(this.bloomFilterMetadata);
    }

    public Option<HoodieMetadataColumnStats> getColumnStatMetadata() {
        if (this.columnStatMetadata == null) {
            return Option.empty();
        }
        return Option.of(this.columnStatMetadata);
    }

    public FileStatus[] getFileStatuses(Configuration hadoopConf, Path partitionPath) throws IOException {
        FileSystem fs = partitionPath.getFileSystem(hadoopConf);
        return this.getFileStatuses(fs, partitionPath);
    }

    public FileStatus[] getFileStatuses(FileSystem fs, Path partitionPath) {
        long blockSize = fs.getDefaultBlockSize(partitionPath);
        return (FileStatus[])this.filterFileInfoEntries(false).map(e -> {
            CachingPath filePath = new CachingPath(partitionPath, (Path)CachingPath.createRelativePathUnsafe((String)e.getKey()));
            return new FileStatus(((HoodieMetadataFileInfo)e.getValue()).getSize(), false, 0, blockSize, 0L, 0L, null, null, null, (Path)filePath);
        }).toArray(FileStatus[]::new);
    }

    private Stream<Map.Entry<String, HoodieMetadataFileInfo>> filterFileInfoEntries(boolean isDeleted) {
        if (this.filesystemMetadata == null) {
            return Stream.empty();
        }
        return this.filesystemMetadata.entrySet().stream().filter(e -> ((HoodieMetadataFileInfo)e.getValue()).getIsDeleted() == isDeleted);
    }

    private Map<String, HoodieMetadataFileInfo> combineFileSystemMetadata(HoodieMetadataPayload previousRecord) {
        HashMap<String, HoodieMetadataFileInfo> combinedFileInfo = new HashMap<String, HoodieMetadataFileInfo>();
        if (previousRecord.filesystemMetadata != null) {
            combinedFileInfo.putAll(previousRecord.filesystemMetadata);
        }
        if (this.filesystemMetadata != null) {
            HoodieMetadataPayload.validatePayload(this.type, this.filesystemMetadata);
            this.filesystemMetadata.forEach((key, fileInfo) -> combinedFileInfo.merge((String)key, (HoodieMetadataFileInfo)fileInfo, (oldFileInfo, newFileInfo) -> newFileInfo.getIsDeleted() ? null : new HoodieMetadataFileInfo(Math.max(newFileInfo.getSize(), oldFileInfo.getSize()), false)));
        }
        return combinedFileInfo;
    }

    public static String getBloomFilterIndexKey(PartitionIndexID partitionIndexID, FileIndexID fileIndexID) {
        return partitionIndexID.asBase64EncodedString().concat(fileIndexID.asBase64EncodedString());
    }

    public static String getColumnStatsIndexKey(PartitionIndexID partitionIndexID, FileIndexID fileIndexID, ColumnIndexID columnIndexID) {
        return columnIndexID.asBase64EncodedString().concat(partitionIndexID.asBase64EncodedString()).concat(fileIndexID.asBase64EncodedString());
    }

    public static String getColumnStatsIndexKey(String partitionName, HoodieColumnRangeMetadata<Comparable> columnRangeMetadata) {
        PartitionIndexID partitionIndexID = new PartitionIndexID(partitionName);
        FileIndexID fileIndexID = new FileIndexID(new Path(columnRangeMetadata.getFilePath()).getName());
        ColumnIndexID columnIndexID = new ColumnIndexID(columnRangeMetadata.getColumnName());
        return HoodieMetadataPayload.getColumnStatsIndexKey(partitionIndexID, fileIndexID, columnIndexID);
    }

    public static Stream<HoodieRecord> createColumnStatsRecords(String partitionName, Collection<HoodieColumnRangeMetadata<Comparable>> columnRangeMetadataList, boolean isDeleted) {
        return columnRangeMetadataList.stream().map(columnRangeMetadata -> {
            HoodieKey key = new HoodieKey(HoodieMetadataPayload.getColumnStatsIndexKey(partitionName, columnRangeMetadata), MetadataPartitionType.COLUMN_STATS.getPartitionPath());
            HoodieMetadataPayload payload = new HoodieMetadataPayload(key.getRecordKey(), HoodieMetadataColumnStats.newBuilder().setFileName(new Path(columnRangeMetadata.getFilePath()).getName()).setColumnName(columnRangeMetadata.getColumnName()).setMinValue(HoodieMetadataPayload.wrapStatisticValue(columnRangeMetadata.getMinValue())).setMaxValue(HoodieMetadataPayload.wrapStatisticValue(columnRangeMetadata.getMaxValue())).setNullCount(columnRangeMetadata.getNullCount()).setValueCount(columnRangeMetadata.getValueCount()).setTotalSize(columnRangeMetadata.getTotalSize()).setTotalUncompressedSize(columnRangeMetadata.getTotalUncompressedSize()).setIsDeleted(isDeleted).build());
            return new HoodieAvroRecord<HoodieMetadataPayload>(key, payload);
        });
    }

    private static HoodieMetadataColumnStats mergeColumnStatsRecords(HoodieMetadataColumnStats prevColumnStats, HoodieMetadataColumnStats newColumnStats) {
        ValidationUtils.checkArgument(Objects.equals(prevColumnStats.getFileName(), newColumnStats.getFileName()));
        ValidationUtils.checkArgument(Objects.equals(prevColumnStats.getColumnName(), newColumnStats.getColumnName()));
        if (newColumnStats.getIsDeleted() || prevColumnStats.getIsDeleted()) {
            return newColumnStats;
        }
        Comparable minValue = Stream.of(HoodieMetadataPayload.unwrapStatisticValueWrapper(prevColumnStats.getMinValue()), HoodieMetadataPayload.unwrapStatisticValueWrapper(newColumnStats.getMinValue())).filter(Objects::nonNull).min(Comparator.naturalOrder()).orElse(null);
        Comparable maxValue = Stream.of(HoodieMetadataPayload.unwrapStatisticValueWrapper(prevColumnStats.getMaxValue()), HoodieMetadataPayload.unwrapStatisticValueWrapper(newColumnStats.getMaxValue())).filter(Objects::nonNull).max(Comparator.naturalOrder()).orElse(null);
        return HoodieMetadataColumnStats.newBuilder(METADATA_COLUMN_STATS_BUILDER_STUB.get()).setFileName(newColumnStats.getFileName()).setColumnName(newColumnStats.getColumnName()).setMinValue(HoodieMetadataPayload.wrapStatisticValue(minValue)).setMaxValue(HoodieMetadataPayload.wrapStatisticValue(maxValue)).setValueCount(prevColumnStats.getValueCount() + newColumnStats.getValueCount()).setNullCount(prevColumnStats.getNullCount() + newColumnStats.getNullCount()).setTotalSize(prevColumnStats.getTotalSize() + newColumnStats.getTotalSize()).setTotalUncompressedSize(prevColumnStats.getTotalUncompressedSize() + newColumnStats.getTotalUncompressedSize()).setIsDeleted(newColumnStats.getIsDeleted()).build();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof HoodieMetadataPayload)) {
            return false;
        }
        HoodieMetadataPayload otherMetadataPayload = (HoodieMetadataPayload)other;
        return this.type == otherMetadataPayload.type && Objects.equals(this.key, otherMetadataPayload.key) && Objects.equals(this.filesystemMetadata, otherMetadataPayload.filesystemMetadata) && Objects.equals(this.bloomFilterMetadata, otherMetadataPayload.bloomFilterMetadata) && Objects.equals(this.columnStatMetadata, otherMetadataPayload.columnStatMetadata);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.type, this.filesystemMetadata, this.bloomFilterMetadata, this.columnStatMetadata);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("HoodieMetadataPayload {");
        sb.append("key=").append(this.key).append(", ");
        sb.append("type=").append(this.type).append(", ");
        sb.append("creations=").append(Arrays.toString(this.getFilenames().toArray())).append(", ");
        sb.append("deletions=").append(Arrays.toString(this.getDeletions().toArray())).append(", ");
        if (this.type == 4) {
            ValidationUtils.checkState(this.getBloomFilterMetadata().isPresent());
            sb.append("BloomFilter: {");
            sb.append("bloom size: ").append(this.getBloomFilterMetadata().get().getBloomFilter().array().length).append(", ");
            sb.append("timestamp: ").append(this.getBloomFilterMetadata().get().getTimestamp()).append(", ");
            sb.append("deleted: ").append(this.getBloomFilterMetadata().get().getIsDeleted());
            sb.append("}");
        }
        if (this.type == 3) {
            ValidationUtils.checkState(this.getColumnStatMetadata().isPresent());
            sb.append("ColStats: {");
            sb.append(this.getColumnStatMetadata().get());
            sb.append("}");
        }
        sb.append('}');
        return sb.toString();
    }

    private static Object wrapStatisticValue(Comparable<?> statValue) {
        if (statValue == null) {
            return null;
        }
        if (statValue instanceof Date || statValue instanceof LocalDate) {
            LocalDate localDate = statValue instanceof LocalDate ? (LocalDate)statValue : ((Date)statValue).toLocalDate();
            return DateWrapper.newBuilder(DATE_WRAPPER_BUILDER_STUB.get()).setValue((int)localDate.toEpochDay()).build();
        }
        if (statValue instanceof BigDecimal) {
            Schema valueSchema = DecimalWrapper.SCHEMA$.getField("value").schema();
            BigDecimal upcastDecimal = HoodieTableMetadataUtil.tryUpcastDecimal((BigDecimal)statValue, (LogicalTypes.Decimal)valueSchema.getLogicalType());
            return DecimalWrapper.newBuilder(DECIMAL_WRAPPER_BUILDER_STUB.get()).setValue(AVRO_DECIMAL_CONVERSION.toBytes(upcastDecimal, valueSchema, valueSchema.getLogicalType())).build();
        }
        if (statValue instanceof Timestamp) {
            Instant instant = ((Timestamp)statValue).toInstant();
            return TimestampMicrosWrapper.newBuilder(TIMESTAMP_MICROS_WRAPPER_BUILDER_STUB.get()).setValue(DateTimeUtils.instantToMicros(instant)).build();
        }
        if (statValue instanceof Boolean) {
            return BooleanWrapper.newBuilder(BOOLEAN_WRAPPER_BUILDER_STUB.get()).setValue((Boolean)statValue).build();
        }
        if (statValue instanceof Integer) {
            return IntWrapper.newBuilder(INT_WRAPPER_BUILDER_STUB.get()).setValue((Integer)statValue).build();
        }
        if (statValue instanceof Long) {
            return LongWrapper.newBuilder(LONG_WRAPPER_BUILDER_STUB.get()).setValue((Long)statValue).build();
        }
        if (statValue instanceof Float) {
            return FloatWrapper.newBuilder(FLOAT_WRAPPER_BUILDER_STUB.get()).setValue(((Float)statValue).floatValue()).build();
        }
        if (statValue instanceof Double) {
            return DoubleWrapper.newBuilder(DOUBLE_WRAPPER_BUILDER_STUB.get()).setValue((Double)statValue).build();
        }
        if (statValue instanceof ByteBuffer) {
            return BytesWrapper.newBuilder(BYTES_WRAPPER_BUILDER_STUB.get()).setValue((ByteBuffer)statValue).build();
        }
        if (statValue instanceof String || statValue instanceof Utf8) {
            return StringWrapper.newBuilder(STRING_WRAPPER_BUILDER_STUB.get()).setValue(statValue.toString()).build();
        }
        throw new UnsupportedOperationException(String.format("Unsupported type of the statistic (%s)", statValue.getClass()));
    }

    public static Comparable<?> unwrapStatisticValueWrapper(Object statValueWrapper) {
        if (statValueWrapper == null) {
            return null;
        }
        if (statValueWrapper instanceof DateWrapper) {
            return LocalDate.ofEpochDay(((DateWrapper)statValueWrapper).getValue());
        }
        if (statValueWrapper instanceof DecimalWrapper) {
            Schema valueSchema = DecimalWrapper.SCHEMA$.getField("value").schema();
            return AVRO_DECIMAL_CONVERSION.fromBytes(((DecimalWrapper)statValueWrapper).getValue(), valueSchema, valueSchema.getLogicalType());
        }
        if (statValueWrapper instanceof TimestampMicrosWrapper) {
            return DateTimeUtils.microsToInstant(((TimestampMicrosWrapper)statValueWrapper).getValue());
        }
        if (statValueWrapper instanceof BooleanWrapper) {
            return ((BooleanWrapper)statValueWrapper).getValue();
        }
        if (statValueWrapper instanceof IntWrapper) {
            return ((IntWrapper)statValueWrapper).getValue();
        }
        if (statValueWrapper instanceof LongWrapper) {
            return ((LongWrapper)statValueWrapper).getValue();
        }
        if (statValueWrapper instanceof FloatWrapper) {
            return Float.valueOf(((FloatWrapper)statValueWrapper).getValue());
        }
        if (statValueWrapper instanceof DoubleWrapper) {
            return ((DoubleWrapper)statValueWrapper).getValue();
        }
        if (statValueWrapper instanceof BytesWrapper) {
            return ((BytesWrapper)statValueWrapper).getValue();
        }
        if (statValueWrapper instanceof StringWrapper) {
            return ((StringWrapper)statValueWrapper).getValue();
        }
        if (statValueWrapper instanceof GenericRecord) {
            GenericRecord record = (GenericRecord)statValueWrapper;
            return (Comparable)record.get("value");
        }
        throw new UnsupportedOperationException(String.format("Unsupported type of the statistic (%s)", statValueWrapper.getClass()));
    }

    private static void validatePayload(int type, Map<String, HoodieMetadataFileInfo> filesystemMetadata) {
        if (type == 2) {
            filesystemMetadata.forEach((fileName, fileInfo) -> ValidationUtils.checkState(fileInfo.getIsDeleted() || fileInfo.getSize() > 0L, "Existing files should have size > 0"));
        }
    }

    private static <T> T getNestedFieldValue(GenericRecord record, String fieldName) {
        if (record.getSchema().getField(fieldName) == null) {
            return null;
        }
        return TypeUtils.unsafeCast(record.get(fieldName));
    }
}

