/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage.row.parquet;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.api.common.typeinfo.BasicArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.SqlTimeTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.typeutils.MapTypeInfo;
import org.apache.flink.api.java.typeutils.ObjectArrayTypeInfo;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParquetSchemaConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParquetSchemaConverter.class);
    public static final String MAP_VALUE = "value";
    public static final String LIST_ARRAY_TYPE = "array";
    public static final String LIST_ELEMENT = "element";
    public static final String LIST_GROUP_NAME = "list";
    public static final String MESSAGE_ROOT = "root";

    public static TypeInformation<?> fromParquetType(MessageType type) {
        return ParquetSchemaConverter.convertFields(type.getFields());
    }

    public static MessageType toParquetType(TypeInformation<?> typeInformation, boolean legacyMode) {
        return (MessageType)ParquetSchemaConverter.convertField(null, typeInformation, Type.Repetition.OPTIONAL, legacyMode);
    }

    public static TypeInformation<?> convertFields(List<Type> parquetFields) {
        ArrayList types = new ArrayList();
        ArrayList<String> names = new ArrayList<String>();
        for (Type field : parquetFields) {
            TypeInformation<?> subType = ParquetSchemaConverter.convertParquetTypeToTypeInfo(field);
            if (subType != null) {
                types.add(subType);
                names.add(field.getName());
                continue;
            }
            LOGGER.error("Parquet field {} in schema type {} can not be converted to Flink Internal Type", (Object)field.getName(), (Object)field.getOriginalType().name());
        }
        return new RowTypeInfo(types.toArray(new TypeInformation[0]), names.toArray(new String[0]));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TypeInformation<?> convertParquetTypeToTypeInfo(Type fieldType) {
        if (fieldType.isPrimitive()) {
            OriginalType originalType = fieldType.getOriginalType();
            PrimitiveType primitiveType = fieldType.asPrimitiveType();
            switch (primitiveType.getPrimitiveTypeName()) {
                case BINARY: {
                    if (originalType == null) return BasicTypeInfo.STRING_TYPE_INFO;
                    switch (originalType) {
                        case DECIMAL: {
                            return BasicTypeInfo.BIG_DEC_TYPE_INFO;
                        }
                        case UTF8: 
                        case ENUM: 
                        case JSON: 
                        case BSON: {
                            return BasicTypeInfo.STRING_TYPE_INFO;
                        }
                    }
                    throw new UnsupportedOperationException("Unsupported original type : " + originalType.name() + " for primitive type BINARY");
                }
                case BOOLEAN: {
                    return BasicTypeInfo.BOOLEAN_TYPE_INFO;
                }
                case INT32: {
                    if (originalType == null) return BasicTypeInfo.INT_TYPE_INFO;
                    switch (originalType) {
                        case TIME_MICROS: 
                        case TIME_MILLIS: {
                            return SqlTimeTypeInfo.TIME;
                        }
                        case TIMESTAMP_MICROS: 
                        case TIMESTAMP_MILLIS: {
                            return SqlTimeTypeInfo.TIMESTAMP;
                        }
                        case DATE: {
                            return SqlTimeTypeInfo.DATE;
                        }
                        case UINT_8: 
                        case UINT_16: 
                        case UINT_32: {
                            return BasicTypeInfo.INT_TYPE_INFO;
                        }
                        case INT_8: {
                            return Types.BYTE;
                        }
                        case INT_16: {
                            return Types.SHORT;
                        }
                        case INT_32: {
                            return BasicTypeInfo.INT_TYPE_INFO;
                        }
                    }
                    throw new UnsupportedOperationException("Unsupported original type : " + originalType.name() + " for primitive type INT32");
                }
                case INT64: {
                    if (originalType == null) return BasicTypeInfo.LONG_TYPE_INFO;
                    switch (originalType) {
                        case TIME_MICROS: {
                            return SqlTimeTypeInfo.TIME;
                        }
                        case TIMESTAMP_MICROS: 
                        case TIMESTAMP_MILLIS: {
                            return SqlTimeTypeInfo.TIMESTAMP;
                        }
                        case DECIMAL: 
                        case INT_64: {
                            return BasicTypeInfo.LONG_TYPE_INFO;
                        }
                    }
                    throw new UnsupportedOperationException("Unsupported original type : " + originalType.name() + " for primitive type INT64");
                }
                case INT96: {
                    return SqlTimeTypeInfo.TIMESTAMP;
                }
                case FLOAT: {
                    return BasicTypeInfo.FLOAT_TYPE_INFO;
                }
                case DOUBLE: {
                    return BasicTypeInfo.DOUBLE_TYPE_INFO;
                }
                case FIXED_LEN_BYTE_ARRAY: {
                    if (originalType == null) return BasicTypeInfo.BIG_DEC_TYPE_INFO;
                    switch (originalType) {
                        case DECIMAL: {
                            return BasicTypeInfo.BIG_DEC_TYPE_INFO;
                        }
                    }
                    throw new UnsupportedOperationException("Unsupported original type : " + originalType.name() + " for primitive type FIXED_LEN_BYTE_ARRAY");
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported schema: " + fieldType);
                }
            }
        }
        GroupType parquetGroupType = fieldType.asGroupType();
        OriginalType originalType = parquetGroupType.getOriginalType();
        if (originalType == null) return ParquetSchemaConverter.convertFields(parquetGroupType.getFields());
        switch (originalType) {
            case LIST: {
                if (parquetGroupType.getFieldCount() != 1) {
                    throw new UnsupportedOperationException("Invalid list type " + parquetGroupType);
                }
                Type repeatedType = parquetGroupType.getType(0);
                if (!repeatedType.isRepetition(Type.Repetition.REPEATED)) {
                    throw new UnsupportedOperationException("Invalid list type " + parquetGroupType);
                }
                if (repeatedType.isPrimitive()) {
                    return ParquetSchemaConverter.convertParquetPrimitiveListToFlinkArray(repeatedType);
                }
                GroupType elementType = repeatedType.asGroupType();
                if (elementType.getFieldCount() > 1) {
                    Type type;
                    Iterator<Type> iterator2 = elementType.getFields().iterator();
                    do {
                        if (!iterator2.hasNext()) return ObjectArrayTypeInfo.getInfoFor(ParquetSchemaConverter.convertParquetTypeToTypeInfo(elementType));
                    } while ((type = iterator2.next()).isRepetition(Type.Repetition.REQUIRED));
                    throw new UnsupportedOperationException(String.format("List field [%s] in List [%s] has to be required. ", type.toString(), fieldType.getName()));
                }
                Type internalType = elementType.getType(0);
                if (internalType.isPrimitive()) {
                    return ParquetSchemaConverter.convertParquetPrimitiveListToFlinkArray(internalType);
                }
                GroupType tupleGroup = internalType.asGroupType();
                if (tupleGroup.getFieldCount() != 1 || !tupleGroup.getFields().get(0).isRepetition(Type.Repetition.REQUIRED)) throw new UnsupportedOperationException(String.format("Unrecgonized List schema [%s] according to Parquet standard", parquetGroupType.toString()));
                return ObjectArrayTypeInfo.getInfoFor(ParquetSchemaConverter.convertParquetTypeToTypeInfo(internalType));
            }
            case MAP_KEY_VALUE: 
            case MAP: {
                if (parquetGroupType.getFieldCount() != 1) throw new UnsupportedOperationException("Invalid map type " + parquetGroupType);
                if (parquetGroupType.getType(0).isPrimitive()) {
                    throw new UnsupportedOperationException("Invalid map type " + parquetGroupType);
                }
                GroupType mapKeyValType = parquetGroupType.getType(0).asGroupType();
                if (!mapKeyValType.isRepetition(Type.Repetition.REPEATED)) throw new UnsupportedOperationException("The middle level of Map should be single field named key_value. Invalid map type " + parquetGroupType);
                if (mapKeyValType.getFieldCount() != 2) {
                    throw new UnsupportedOperationException("The middle level of Map should be single field named key_value. Invalid map type " + parquetGroupType);
                }
                Type keyType = mapKeyValType.getType(0);
                if (!keyType.isPrimitive()) throw new IllegalArgumentException("Map key type must be required binary (UTF8): " + keyType);
                if (!keyType.isRepetition(Type.Repetition.REQUIRED)) throw new IllegalArgumentException("Map key type must be required binary (UTF8): " + keyType);
                if (!keyType.asPrimitiveType().getPrimitiveTypeName().equals((Object)PrimitiveType.PrimitiveTypeName.BINARY)) throw new IllegalArgumentException("Map key type must be required binary (UTF8): " + keyType);
                if (!keyType.getOriginalType().equals((Object)OriginalType.UTF8)) {
                    throw new IllegalArgumentException("Map key type must be required binary (UTF8): " + keyType);
                }
                Type valueType = mapKeyValType.getType(1);
                return new MapTypeInfo((TypeInformation)BasicTypeInfo.STRING_TYPE_INFO, ParquetSchemaConverter.convertParquetTypeToTypeInfo(valueType));
            }
            default: {
                throw new UnsupportedOperationException("Unsupported schema: " + fieldType);
            }
        }
    }

    private static TypeInformation<?> convertParquetPrimitiveListToFlinkArray(Type type) {
        TypeInformation<?> flinkType = ParquetSchemaConverter.convertParquetTypeToTypeInfo(type);
        if (flinkType.isBasicType()) {
            return BasicArrayTypeInfo.getInfoFor(Array.newInstance(flinkType.getTypeClass(), 0).getClass());
        }
        return ObjectArrayTypeInfo.getInfoFor(flinkType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Type convertField(String fieldName, TypeInformation<?> typeInfo, Type.Repetition inheritRepetition, boolean legacyMode) {
        Type.Repetition repetition;
        Type fieldType = null;
        Type.Repetition repetition2 = repetition = inheritRepetition == null ? Type.Repetition.OPTIONAL : inheritRepetition;
        if (typeInfo instanceof BasicTypeInfo) {
            BasicTypeInfo basicTypeInfo = (BasicTypeInfo)typeInfo;
            if (basicTypeInfo.equals((Object)BasicTypeInfo.BIG_DEC_TYPE_INFO)) return (Type)((Types.PrimitiveBuilder)org.apache.parquet.schema.Types.primitive(PrimitiveType.PrimitiveTypeName.BINARY, repetition).as(OriginalType.DECIMAL)).named(fieldName);
            if (basicTypeInfo.equals((Object)BasicTypeInfo.BIG_INT_TYPE_INFO)) {
                return (Type)((Types.PrimitiveBuilder)org.apache.parquet.schema.Types.primitive(PrimitiveType.PrimitiveTypeName.BINARY, repetition).as(OriginalType.DECIMAL)).named(fieldName);
            }
            if (basicTypeInfo.equals((Object)BasicTypeInfo.INT_TYPE_INFO)) {
                return (Type)((Types.PrimitiveBuilder)org.apache.parquet.schema.Types.primitive(PrimitiveType.PrimitiveTypeName.INT32, repetition).as(OriginalType.INT_32)).named(fieldName);
            }
            if (basicTypeInfo.equals((Object)BasicTypeInfo.DOUBLE_TYPE_INFO)) {
                return (Type)org.apache.parquet.schema.Types.primitive(PrimitiveType.PrimitiveTypeName.DOUBLE, repetition).named(fieldName);
            }
            if (basicTypeInfo.equals((Object)BasicTypeInfo.FLOAT_TYPE_INFO)) {
                return (Type)org.apache.parquet.schema.Types.primitive(PrimitiveType.PrimitiveTypeName.FLOAT, repetition).named(fieldName);
            }
            if (basicTypeInfo.equals((Object)BasicTypeInfo.LONG_TYPE_INFO)) {
                return (Type)((Types.PrimitiveBuilder)org.apache.parquet.schema.Types.primitive(PrimitiveType.PrimitiveTypeName.INT64, repetition).as(OriginalType.INT_64)).named(fieldName);
            }
            if (basicTypeInfo.equals((Object)BasicTypeInfo.SHORT_TYPE_INFO)) {
                return (Type)((Types.PrimitiveBuilder)org.apache.parquet.schema.Types.primitive(PrimitiveType.PrimitiveTypeName.INT32, repetition).as(OriginalType.INT_16)).named(fieldName);
            }
            if (basicTypeInfo.equals((Object)BasicTypeInfo.BYTE_TYPE_INFO)) {
                return (Type)((Types.PrimitiveBuilder)org.apache.parquet.schema.Types.primitive(PrimitiveType.PrimitiveTypeName.INT32, repetition).as(OriginalType.INT_8)).named(fieldName);
            }
            if (basicTypeInfo.equals((Object)BasicTypeInfo.CHAR_TYPE_INFO)) {
                return (Type)((Types.PrimitiveBuilder)org.apache.parquet.schema.Types.primitive(PrimitiveType.PrimitiveTypeName.BINARY, repetition).as(OriginalType.UTF8)).named(fieldName);
            }
            if (basicTypeInfo.equals((Object)BasicTypeInfo.BOOLEAN_TYPE_INFO)) {
                return (Type)org.apache.parquet.schema.Types.primitive(PrimitiveType.PrimitiveTypeName.BOOLEAN, repetition).named(fieldName);
            }
            if (basicTypeInfo.equals((Object)BasicTypeInfo.DATE_TYPE_INFO)) return (Type)((Types.PrimitiveBuilder)org.apache.parquet.schema.Types.primitive(PrimitiveType.PrimitiveTypeName.BINARY, repetition).as(OriginalType.UTF8)).named(fieldName);
            if (!basicTypeInfo.equals((Object)BasicTypeInfo.STRING_TYPE_INFO)) return fieldType;
            return (Type)((Types.PrimitiveBuilder)org.apache.parquet.schema.Types.primitive(PrimitiveType.PrimitiveTypeName.BINARY, repetition).as(OriginalType.UTF8)).named(fieldName);
        }
        if (typeInfo instanceof MapTypeInfo) {
            MapTypeInfo mapTypeInfo = (MapTypeInfo)typeInfo;
            if (!mapTypeInfo.getKeyTypeInfo().equals((Object)BasicTypeInfo.STRING_TYPE_INFO)) throw new UnsupportedOperationException(String.format("Can not convert Flink MapTypeInfo %s to Parquet Map type as key has to be String", typeInfo));
            return (Type)((Types.MapBuilder)org.apache.parquet.schema.Types.map(repetition).value(ParquetSchemaConverter.convertField(MAP_VALUE, mapTypeInfo.getValueTypeInfo(), Type.Repetition.OPTIONAL, legacyMode))).named(fieldName);
        }
        if (typeInfo instanceof ObjectArrayTypeInfo) {
            ObjectArrayTypeInfo objectArrayTypeInfo = (ObjectArrayTypeInfo)typeInfo;
            GroupType componentGroup = (GroupType)ParquetSchemaConverter.convertField(LIST_ELEMENT, objectArrayTypeInfo.getComponentInfo(), Type.Repetition.REQUIRED, legacyMode);
            GroupType elementGroup = (GroupType)org.apache.parquet.schema.Types.repeatedGroup().named(LIST_ELEMENT);
            elementGroup = elementGroup.withNewFields(componentGroup.getFields());
            return (Type)((Types.GroupBuilder)((Types.GroupBuilder)org.apache.parquet.schema.Types.buildGroup(repetition).addField(elementGroup)).as(OriginalType.LIST)).named(fieldName);
        }
        if (typeInfo instanceof BasicArrayTypeInfo) {
            BasicArrayTypeInfo basicArrayType = (BasicArrayTypeInfo)typeInfo;
            if (legacyMode) {
                Type listGroup = (Type)((Types.GroupBuilder)org.apache.parquet.schema.Types.repeatedGroup().addField(ParquetSchemaConverter.convertField(LIST_ELEMENT, basicArrayType.getComponentInfo(), Type.Repetition.REQUIRED, legacyMode))).named(LIST_GROUP_NAME);
                return (Type)((Types.GroupBuilder)((Types.GroupBuilder)org.apache.parquet.schema.Types.buildGroup(repetition).addField(listGroup)).as(OriginalType.LIST)).named(fieldName);
            }
            PrimitiveType primitiveTyp = ParquetSchemaConverter.convertField(fieldName, basicArrayType.getComponentInfo(), Type.Repetition.REQUIRED, legacyMode).asPrimitiveType();
            return (Type)((Types.GroupBuilder)((Types.GroupBuilder)((Types.PrimitiveBuilder)org.apache.parquet.schema.Types.buildGroup(repetition).repeated(primitiveTyp.getPrimitiveTypeName()).as(primitiveTyp.getOriginalType())).named(LIST_ARRAY_TYPE)).as(OriginalType.LIST)).named(fieldName);
        }
        if (typeInfo instanceof SqlTimeTypeInfo) {
            if (typeInfo.equals((Object)SqlTimeTypeInfo.DATE)) {
                return (Type)((Types.PrimitiveBuilder)org.apache.parquet.schema.Types.primitive(PrimitiveType.PrimitiveTypeName.INT32, repetition).as(OriginalType.DATE)).named(fieldName);
            }
            if (typeInfo.equals((Object)SqlTimeTypeInfo.TIME)) {
                return (Type)((Types.PrimitiveBuilder)org.apache.parquet.schema.Types.primitive(PrimitiveType.PrimitiveTypeName.INT32, repetition).as(OriginalType.TIME_MILLIS)).named(fieldName);
            }
            if (!typeInfo.equals((Object)SqlTimeTypeInfo.TIMESTAMP)) throw new UnsupportedOperationException("Unsupported SqlTimeTypeInfo " + typeInfo.toString());
            return (Type)((Types.PrimitiveBuilder)org.apache.parquet.schema.Types.primitive(PrimitiveType.PrimitiveTypeName.INT64, repetition).as(OriginalType.TIMESTAMP_MILLIS)).named(fieldName);
        }
        RowTypeInfo rowTypeInfo = (RowTypeInfo)typeInfo;
        ArrayList<Type> types = new ArrayList<Type>();
        String[] fieldNames = rowTypeInfo.getFieldNames();
        TypeInformation[] fieldTypes = rowTypeInfo.getFieldTypes();
        for (int i = 0; i < rowTypeInfo.getArity(); ++i) {
            types.add(ParquetSchemaConverter.convertField(fieldNames[i], fieldTypes[i], repetition, legacyMode));
        }
        if (fieldName != null) return new GroupType(repetition, fieldName, types);
        return new MessageType(MESSAGE_ROOT, types);
    }

    public static MessageType convertToParquetMessageType(String name, RowType rowType) {
        Type[] types = new Type[rowType.getFieldCount()];
        for (int i = 0; i < rowType.getFieldCount(); ++i) {
            LogicalType fieldType;
            String fieldName = (String)rowType.getFieldNames().get(i);
            types[i] = ParquetSchemaConverter.convertToParquetType(fieldName, fieldType, (fieldType = rowType.getTypeAt(i)).isNullable() ? Type.Repetition.OPTIONAL : Type.Repetition.REQUIRED);
        }
        return new MessageType(name, types);
    }

    private static Type convertToParquetType(String name, LogicalType type, Type.Repetition repetition) {
        switch (type.getTypeRoot()) {
            case CHAR: 
            case VARCHAR: {
                return (Type)((Types.PrimitiveBuilder)org.apache.parquet.schema.Types.primitive(PrimitiveType.PrimitiveTypeName.BINARY, repetition).as(OriginalType.UTF8)).named(name);
            }
            case BOOLEAN: {
                return (Type)org.apache.parquet.schema.Types.primitive(PrimitiveType.PrimitiveTypeName.BOOLEAN, repetition).named(name);
            }
            case BINARY: 
            case VARBINARY: {
                return (Type)org.apache.parquet.schema.Types.primitive(PrimitiveType.PrimitiveTypeName.BINARY, repetition).named(name);
            }
            case DECIMAL: {
                int precision = ((DecimalType)type).getPrecision();
                int scale = ((DecimalType)type).getScale();
                int numBytes = ParquetSchemaConverter.computeMinBytesForDecimalPrecision(precision);
                return (Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)org.apache.parquet.schema.Types.primitive(PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, repetition).as(LogicalTypeAnnotation.decimalType(scale, precision))).length(numBytes)).named(name);
            }
            case TINYINT: {
                return (Type)((Types.PrimitiveBuilder)org.apache.parquet.schema.Types.primitive(PrimitiveType.PrimitiveTypeName.INT32, repetition).as(LogicalTypeAnnotation.intType(8, true))).named(name);
            }
            case SMALLINT: {
                return (Type)((Types.PrimitiveBuilder)org.apache.parquet.schema.Types.primitive(PrimitiveType.PrimitiveTypeName.INT32, repetition).as(LogicalTypeAnnotation.intType(16, true))).named(name);
            }
            case INTEGER: {
                return (Type)org.apache.parquet.schema.Types.primitive(PrimitiveType.PrimitiveTypeName.INT32, repetition).named(name);
            }
            case BIGINT: {
                return (Type)org.apache.parquet.schema.Types.primitive(PrimitiveType.PrimitiveTypeName.INT64, repetition).named(name);
            }
            case FLOAT: {
                return (Type)org.apache.parquet.schema.Types.primitive(PrimitiveType.PrimitiveTypeName.FLOAT, repetition).named(name);
            }
            case DOUBLE: {
                return (Type)org.apache.parquet.schema.Types.primitive(PrimitiveType.PrimitiveTypeName.DOUBLE, repetition).named(name);
            }
            case DATE: {
                return (Type)((Types.PrimitiveBuilder)org.apache.parquet.schema.Types.primitive(PrimitiveType.PrimitiveTypeName.INT32, repetition).as(LogicalTypeAnnotation.dateType())).named(name);
            }
            case TIME_WITHOUT_TIME_ZONE: {
                return (Type)((Types.PrimitiveBuilder)org.apache.parquet.schema.Types.primitive(PrimitiveType.PrimitiveTypeName.INT32, repetition).as(LogicalTypeAnnotation.timeType(true, LogicalTypeAnnotation.TimeUnit.MILLIS))).named(name);
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                TimestampType timestampType = (TimestampType)type;
                if (timestampType.getPrecision() == 3) {
                    return (Type)((Types.PrimitiveBuilder)org.apache.parquet.schema.Types.primitive(PrimitiveType.PrimitiveTypeName.INT64, repetition).as(LogicalTypeAnnotation.timestampType(true, LogicalTypeAnnotation.TimeUnit.MILLIS))).named(name);
                }
                return (Type)org.apache.parquet.schema.Types.primitive(PrimitiveType.PrimitiveTypeName.INT96, repetition).named(name);
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                LocalZonedTimestampType localZonedTimestampType = (LocalZonedTimestampType)type;
                if (localZonedTimestampType.getPrecision() == 3) {
                    return (Type)((Types.PrimitiveBuilder)org.apache.parquet.schema.Types.primitive(PrimitiveType.PrimitiveTypeName.INT64, repetition).as(LogicalTypeAnnotation.timestampType(false, LogicalTypeAnnotation.TimeUnit.MILLIS))).named(name);
                }
                return (Type)org.apache.parquet.schema.Types.primitive(PrimitiveType.PrimitiveTypeName.INT96, repetition).named(name);
            }
            case ARRAY: {
                ArrayType arrayType = (ArrayType)type;
                LogicalType elementType = arrayType.getElementType();
                return (Type)((Types.GroupBuilder)((Types.GroupBuilder)org.apache.parquet.schema.Types.buildGroup(repetition).as(OriginalType.LIST)).addField((Type)((Types.GroupBuilder)org.apache.parquet.schema.Types.repeatedGroup().addField(ParquetSchemaConverter.convertToParquetType(LIST_ELEMENT, elementType, repetition))).named(LIST_GROUP_NAME))).named(name);
            }
            case MAP: {
                MapType mapType = (MapType)type;
                LogicalType keyType = mapType.getKeyType();
                LogicalType valueType = mapType.getValueType();
                return (Type)((Types.GroupBuilder)((Types.GroupBuilder)org.apache.parquet.schema.Types.buildGroup(repetition).as(OriginalType.MAP)).addField((Type)((Types.GroupBuilder)((Types.GroupBuilder)org.apache.parquet.schema.Types.repeatedGroup().addField(ParquetSchemaConverter.convertToParquetType("key", keyType, repetition))).addField(ParquetSchemaConverter.convertToParquetType(MAP_VALUE, valueType, repetition))).named("key_value"))).named(name);
            }
            case ROW: {
                RowType rowType = (RowType)type;
                Types.GroupBuilder<GroupType> builder = org.apache.parquet.schema.Types.buildGroup(repetition);
                rowType.getFields().forEach(field -> {
                    Types.GroupBuilder cfr_ignored_0 = (Types.GroupBuilder)builder.addField(ParquetSchemaConverter.convertToParquetType(field.getName(), field.getType(), repetition));
                });
                return (Type)builder.named(name);
            }
        }
        throw new UnsupportedOperationException("Unsupported type: " + type);
    }

    public static int computeMinBytesForDecimalPrecision(int precision) {
        int numBytes = 1;
        while (Math.pow(2.0, 8 * numBytes - 1) < Math.pow(10.0, precision)) {
            ++numBytes;
        }
        return numBytes;
    }
}

