/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index.bloom;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.BaseStream;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.data.HoodiePairData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.EmptyHoodieRecordPayload;
import org.apache.hudi.common.model.HoodieAvroRecord;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.ImmutablePair;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.index.HoodieIndexUtils;
import org.apache.hudi.index.bloom.BaseHoodieBloomIndexHelper;
import org.apache.hudi.index.bloom.BloomIndexFileInfo;
import org.apache.hudi.index.bloom.HoodieBloomIndex;
import org.apache.hudi.index.bloom.IndexFileFilter;
import org.apache.hudi.index.bloom.IntervalTreeBasedGlobalIndexFileFilter;
import org.apache.hudi.index.bloom.ListBasedGlobalIndexFileFilter;
import org.apache.hudi.table.HoodieTable;

public class HoodieGlobalBloomIndex
extends HoodieBloomIndex {
    public HoodieGlobalBloomIndex(HoodieWriteConfig config, BaseHoodieBloomIndexHelper bloomIndexHelper) {
        super(config, bloomIndexHelper);
    }

    @Override
    List<Pair<String, BloomIndexFileInfo>> loadColumnRangesFromFiles(List<String> partitions, HoodieEngineContext context, HoodieTable hoodieTable) {
        HoodieTableMetaClient metaClient = hoodieTable.getMetaClient();
        List<String> allPartitionPaths = FSUtils.getAllPartitionPaths(context, this.config.getMetadataConfig(), metaClient.getBasePath());
        return super.loadColumnRangesFromFiles(allPartitionPaths, context, hoodieTable);
    }

    @Override
    HoodiePairData<HoodieFileGroupId, String> explodeRecordsWithFileComparisons(Map<String, List<BloomIndexFileInfo>> partitionToFileIndexInfo, HoodiePairData<String, String> partitionRecordKeyPairs) {
        IndexFileFilter indexFileFilter = this.config.useBloomIndexTreebasedFilter() ? new IntervalTreeBasedGlobalIndexFileFilter(partitionToFileIndexInfo) : new ListBasedGlobalIndexFileFilter(partitionToFileIndexInfo);
        return partitionRecordKeyPairs.map(partitionRecordKeyPair -> {
            String recordKey = (String)partitionRecordKeyPair.getRight();
            String partitionPath = (String)partitionRecordKeyPair.getLeft();
            return indexFileFilter.getMatchingFilesAndPartition(partitionPath, recordKey).stream().map(partitionFileIdPair -> new ImmutablePair<HoodieFileGroupId, String>(new HoodieFileGroupId((String)partitionFileIdPair.getLeft(), (String)partitionFileIdPair.getRight()), recordKey));
        }).flatMapToPair(BaseStream::iterator);
    }

    @Override
    protected <R> HoodieData<HoodieRecord<R>> tagLocationBacktoRecords(HoodiePairData<HoodieKey, HoodieRecordLocation> keyLocationPairs, HoodieData<HoodieRecord<R>> records) {
        HoodiePairData incomingRowKeyRecordPairs = records.mapToPair(record -> new ImmutablePair<String, HoodieRecord>(record.getRecordKey(), (HoodieRecord)record));
        HoodiePairData existingRecordKeyToRecordLocationHoodieKeyMap = keyLocationPairs.mapToPair(p -> new ImmutablePair(((HoodieKey)p.getKey()).getRecordKey(), new ImmutablePair(p.getValue(), p.getKey())));
        return incomingRowKeyRecordPairs.leftOuterJoin(existingRecordKeyToRecordLocationHoodieKeyMap).values().flatMap(record -> {
            HoodieRecord hoodieRecord = (HoodieRecord)record.getLeft();
            Option recordLocationHoodieKeyPair = (Option)record.getRight();
            if (recordLocationHoodieKeyPair.isPresent()) {
                if (this.config.getBloomIndexUpdatePartitionPath() && !((HoodieKey)((Pair)recordLocationHoodieKeyPair.get()).getRight()).getPartitionPath().equals(hoodieRecord.getPartitionPath())) {
                    HoodieAvroRecord<EmptyHoodieRecordPayload> deleteRecord = new HoodieAvroRecord<EmptyHoodieRecordPayload>((HoodieKey)((Pair)recordLocationHoodieKeyPair.get()).getRight(), new EmptyHoodieRecordPayload());
                    deleteRecord.setCurrentLocation((HoodieRecordLocation)((Pair)recordLocationHoodieKeyPair.get()).getLeft());
                    deleteRecord.seal();
                    HoodieRecord insertRecord = HoodieIndexUtils.getTaggedRecord(hoodieRecord, Option.empty());
                    return Arrays.asList(deleteRecord, insertRecord).iterator();
                }
                return Collections.singletonList(HoodieIndexUtils.getTaggedRecord(new HoodieAvroRecord<HoodieRecordPayload>((HoodieKey)((Pair)recordLocationHoodieKeyPair.get()).getRight(), (HoodieRecordPayload)hoodieRecord.getData()), Option.ofNullable(((Pair)recordLocationHoodieKeyPair.get()).getLeft()))).iterator();
            }
            return Collections.singletonList(HoodieIndexUtils.getTaggedRecord(hoodieRecord, Option.empty())).iterator();
        });
    }

    @Override
    public boolean isGlobal() {
        return true;
    }
}

