/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.conflict.detection;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.ApiMaturityLevel;
import org.apache.hudi.PublicAPIClass;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.conflict.detection.EarlyConflictDetectionStrategy;
import org.apache.hudi.common.fs.HoodieWrapperFileSystem;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.util.MarkerUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

@PublicAPIClass(maturity=ApiMaturityLevel.EVOLVING)
public abstract class DirectMarkerBasedDetectionStrategy
implements EarlyConflictDetectionStrategy {
    private static final Logger LOG = LogManager.getLogger(DirectMarkerBasedDetectionStrategy.class);
    protected final FileSystem fs;
    protected final String partitionPath;
    protected final String fileId;
    protected final String instantTime;
    protected final HoodieActiveTimeline activeTimeline;
    protected final HoodieConfig config;

    public DirectMarkerBasedDetectionStrategy(HoodieWrapperFileSystem fs, String partitionPath, String fileId, String instantTime, HoodieActiveTimeline activeTimeline, HoodieConfig config) {
        this.fs = fs;
        this.partitionPath = partitionPath;
        this.fileId = fileId;
        this.instantTime = instantTime;
        this.activeTimeline = activeTimeline;
        this.config = config;
    }

    public boolean checkMarkerConflict(String basePath, long maxAllowableHeartbeatIntervalInMs) throws IOException {
        String tempFolderPath = basePath + "/" + ".hoodie/.temp";
        List<String> candidateInstants = MarkerUtils.getCandidateInstants(this.activeTimeline, Arrays.stream(this.fs.listStatus(new Path(tempFolderPath))).map(FileStatus::getPath).collect(Collectors.toList()), this.instantTime, maxAllowableHeartbeatIntervalInMs, this.fs, basePath);
        long res = candidateInstants.stream().flatMap(currentMarkerDirPath -> {
            try {
                Path markerPartitionPath = StringUtils.isNullOrEmpty(this.partitionPath) ? new Path(currentMarkerDirPath) : new Path(currentMarkerDirPath, this.partitionPath);
                if (!StringUtils.isNullOrEmpty(this.partitionPath) && !this.fs.exists(markerPartitionPath)) {
                    return Stream.empty();
                }
                return ((Stream)Arrays.stream(this.fs.listStatus(markerPartitionPath)).parallel()).filter(path -> path.toString().contains(this.fileId));
            }
            catch (IOException e) {
                throw new HoodieIOException("IOException occurs during checking marker file conflict");
            }
        }).count();
        if (res != 0L) {
            LOG.warn((Object)("Detected conflict marker files: " + this.partitionPath + "/" + this.fileId + " for " + this.instantTime));
            return true;
        }
        return false;
    }
}

