/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.utils;

import java.util.Iterator;
import java.util.function.BiFunction;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.ValidationUtils;

public class MergingIterator<T extends HoodieRecord>
implements Iterator<T> {
    private final Iterator<T> leftIterator;
    private final Iterator<T> rightIterator;
    private final BiFunction<T, T, T> mergeFunction;

    public MergingIterator(Iterator<T> leftIterator, Iterator<T> rightIterator, BiFunction<T, T, T> mergeFunction) {
        this.leftIterator = leftIterator;
        this.rightIterator = rightIterator;
        this.mergeFunction = mergeFunction;
    }

    @Override
    public boolean hasNext() {
        boolean rightHasNext;
        boolean leftHasNext = this.leftIterator.hasNext();
        ValidationUtils.checkArgument(leftHasNext == (rightHasNext = this.rightIterator.hasNext()));
        return leftHasNext;
    }

    @Override
    public T next() {
        return (T)((HoodieRecord)this.mergeFunction.apply(this.leftIterator.next(), this.rightIterator.next()));
    }
}

