/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.heartbeat;

import java.io.IOException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.client.heartbeat.HoodieHeartbeatClient;
import org.apache.hudi.common.heartbeat.HoodieHeartbeatUtils;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.table.HoodieTable;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class HeartbeatUtils {
    private static final Logger LOG = LogManager.getLogger(HeartbeatUtils.class);

    public static boolean deleteHeartbeatFile(FileSystem fs, String basePath, String instantTime) {
        boolean deleted = false;
        try {
            String heartbeatFolderPath = HoodieTableMetaClient.getHeartbeatFolderPath(basePath);
            deleted = fs.delete(new Path(heartbeatFolderPath + "/" + instantTime), false);
            if (!deleted) {
                LOG.error((Object)("Failed to delete heartbeat for instant " + instantTime));
            } else {
                LOG.info((Object)("Deleted the heartbeat for instant " + instantTime));
            }
        }
        catch (IOException io) {
            LOG.error((Object)("Unable to delete heartbeat for instant " + instantTime), (Throwable)io);
        }
        return deleted;
    }

    public static boolean deleteHeartbeatFile(FileSystem fs, String basePath, String instantTime, HoodieWriteConfig config) {
        if (config.getFailedWritesCleanPolicy().isLazy()) {
            return HeartbeatUtils.deleteHeartbeatFile(fs, basePath, instantTime);
        }
        return false;
    }

    public static void abortIfHeartbeatExpired(String instantTime, HoodieTable table, HoodieHeartbeatClient heartbeatClient, HoodieWriteConfig config) {
        ValidationUtils.checkArgument(heartbeatClient != null);
        try {
            if (config.getFailedWritesCleanPolicy().isLazy() && heartbeatClient.isHeartbeatExpired(instantTime)) {
                throw new HoodieException("Heartbeat for instant " + instantTime + " has expired, last heartbeat " + HoodieHeartbeatUtils.getLastHeartbeatTime(table.getMetaClient().getFs(), config.getBasePath(), instantTime));
            }
        }
        catch (IOException io) {
            throw new HoodieException("Unable to read heartbeat", io);
        }
    }
}

