/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.embedded;

import java.io.IOException;
import org.apache.hudi.client.embedded.EmbeddedTimelineService;
import org.apache.hudi.common.engine.EngineProperty;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class EmbeddedTimelineServerHelper {
    private static final Logger LOG = LogManager.getLogger(EmbeddedTimelineService.class);
    private static Option<EmbeddedTimelineService> TIMELINE_SERVER = Option.empty();

    public static synchronized Option<EmbeddedTimelineService> createEmbeddedTimelineService(HoodieEngineContext context, HoodieWriteConfig config) throws IOException {
        if (config.isEmbeddedTimelineServerReuseEnabled()) {
            if (!TIMELINE_SERVER.isPresent() || !TIMELINE_SERVER.get().canReuseFor(config.getBasePath())) {
                TIMELINE_SERVER = Option.of(EmbeddedTimelineServerHelper.startTimelineService(context, config));
            } else {
                EmbeddedTimelineServerHelper.updateWriteConfigWithTimelineServer(TIMELINE_SERVER.get(), config);
            }
            return TIMELINE_SERVER;
        }
        if (config.isEmbeddedTimelineServerEnabled()) {
            return Option.of(EmbeddedTimelineServerHelper.startTimelineService(context, config));
        }
        return Option.empty();
    }

    private static EmbeddedTimelineService startTimelineService(HoodieEngineContext context, HoodieWriteConfig config) throws IOException {
        LOG.info((Object)"Starting Timeline service !!");
        Option<String> hostAddr = context.getProperty(EngineProperty.EMBEDDED_SERVER_HOST);
        EmbeddedTimelineService timelineService = new EmbeddedTimelineService(context, hostAddr.orElse(null), config);
        timelineService.startServer();
        EmbeddedTimelineServerHelper.updateWriteConfigWithTimelineServer(timelineService, config);
        return timelineService;
    }

    public static void updateWriteConfigWithTimelineServer(EmbeddedTimelineService timelineServer, HoodieWriteConfig config) {
        if (config.isEmbeddedTimelineServerEnabled()) {
            config.setViewStorageConfig(timelineServer.getRemoteFileSystemViewConfig());
        }
    }
}

