/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.parquet.avro;

import java.io.Serializable;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.connector.file.src.reader.StreamFormat;
import org.apache.flink.formats.avro.typeutils.AvroTypeInfo;
import org.apache.flink.formats.avro.typeutils.GenericRecordAvroTypeInfo;
import org.apache.flink.formats.parquet.avro.AvroParquetRecordFormat;
import org.apache.flink.util.function.SerializableSupplier;
import org.apache.hudi.org.apache.avro.Schema;
import org.apache.hudi.org.apache.avro.generic.GenericData;
import org.apache.hudi.org.apache.avro.generic.GenericRecord;
import org.apache.hudi.org.apache.avro.reflect.ReflectData;
import org.apache.hudi.org.apache.avro.specific.SpecificData;
import org.apache.hudi.org.apache.avro.specific.SpecificRecordBase;

@Experimental
public class AvroParquetReaders {
    public static <T extends SpecificRecordBase> StreamFormat<T> forSpecificRecord(Class<T> typeClass) {
        return new AvroParquetRecordFormat(new AvroTypeInfo(typeClass), (SerializableSupplier<GenericData>)(SerializableSupplier & Serializable)() -> SpecificData.get());
    }

    public static <T> StreamFormat<T> forReflectRecord(Class<T> typeClass) {
        if (SpecificRecordBase.class.isAssignableFrom(typeClass)) {
            throw new IllegalArgumentException("Please use AvroParquetReaders.forSpecificRecord(Class<T>) for SpecificRecord.");
        }
        if (GenericRecord.class.isAssignableFrom(typeClass)) {
            throw new IllegalArgumentException("Please use AvroParquetReaders.forGenericRecord(Class<T>) for GenericRecord.Cannot read and create Avro GenericRecord without specifying the Avro Schema. This is because Flink needs to be able serialize the results in its data flow, which isvery inefficient without the schema. And while the Schema is stored in the Avro file header,Flink needs this schema during 'pre-flight' time when the data flow is set up and wired,which is before there is access to the files");
        }
        return new AvroParquetRecordFormat(TypeExtractor.createTypeInfo(typeClass), (SerializableSupplier<GenericData>)(SerializableSupplier & Serializable)() -> ReflectData.get());
    }

    public static StreamFormat<GenericRecord> forGenericRecord(Schema schema) {
        return new AvroParquetRecordFormat<GenericRecord>((TypeInformation<GenericRecord>)new GenericRecordAvroTypeInfo(schema), (SerializableSupplier<GenericData>)(SerializableSupplier & Serializable)() -> GenericData.get());
    }

    private AvroParquetReaders() {
    }
}

