/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.client.HoodieFlinkWriteClient;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.metrics.Registry;
import org.apache.hudi.common.model.HoodieFailedWritesCleaningPolicy;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieMetadataException;
import org.apache.hudi.exception.HoodieNotSupportedException;
import org.apache.hudi.metadata.HoodieBackedTableMetadataWriter;
import org.apache.hudi.metadata.HoodieMetadataMetrics;
import org.apache.hudi.metadata.HoodieTableMetadataWriter;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class FlinkHoodieBackedTableMetadataWriter
extends HoodieBackedTableMetadataWriter {
    private static final Logger LOG = LogManager.getLogger(FlinkHoodieBackedTableMetadataWriter.class);

    public static HoodieTableMetadataWriter create(Configuration conf, HoodieWriteConfig writeConfig, HoodieEngineContext context) {
        return FlinkHoodieBackedTableMetadataWriter.create(conf, writeConfig, context, Option.empty());
    }

    public static <T extends SpecificRecordBase> HoodieTableMetadataWriter create(Configuration conf, HoodieWriteConfig writeConfig, HoodieEngineContext context, Option<T> actionMetadata) {
        return new FlinkHoodieBackedTableMetadataWriter(conf, writeConfig, HoodieFailedWritesCleaningPolicy.EAGER, context, actionMetadata, (Option<String>)Option.empty());
    }

    public static <T extends SpecificRecordBase> HoodieTableMetadataWriter create(Configuration conf, HoodieWriteConfig writeConfig, HoodieEngineContext context, Option<T> actionMetadata, Option<String> inFlightInstantTimestamp) {
        return new FlinkHoodieBackedTableMetadataWriter(conf, writeConfig, HoodieFailedWritesCleaningPolicy.EAGER, context, actionMetadata, inFlightInstantTimestamp);
    }

    public static <T extends SpecificRecordBase> HoodieTableMetadataWriter create(Configuration conf, HoodieWriteConfig writeConfig, HoodieFailedWritesCleaningPolicy failedWritesCleaningPolicy, HoodieEngineContext context, Option<T> actionMetadata, Option<String> inFlightInstantTimestamp) {
        return new FlinkHoodieBackedTableMetadataWriter(conf, writeConfig, failedWritesCleaningPolicy, context, actionMetadata, inFlightInstantTimestamp);
    }

    <T extends SpecificRecordBase> FlinkHoodieBackedTableMetadataWriter(Configuration hadoopConf, HoodieWriteConfig writeConfig, HoodieFailedWritesCleaningPolicy failedWritesCleaningPolicy, HoodieEngineContext engineContext, Option<T> actionMetadata, Option<String> inFlightInstantTimestamp) {
        super(hadoopConf, writeConfig, failedWritesCleaningPolicy, engineContext, actionMetadata, inFlightInstantTimestamp);
    }

    protected void initRegistry() {
        if (this.metadataWriteConfig.isMetricsOn()) {
            Registry registry = Registry.getRegistry((String)"HoodieMetadata");
            this.metrics = Option.of((Object)new HoodieMetadataMetrics(registry));
        } else {
            this.metrics = Option.empty();
        }
    }

    protected <T extends SpecificRecordBase> void initialize(HoodieEngineContext engineContext, Option<T> actionMetadata, Option<String> inflightInstantTimestamp) {
        try {
            if (this.enabled) {
                this.initializeIfNeeded(this.dataMetaClient, actionMetadata, inflightInstantTimestamp);
            }
        }
        catch (IOException e) {
            LOG.error((Object)"Failed to initialize metadata table. Disabling the writer.", (Throwable)e);
            this.enabled = false;
        }
    }

    protected void commit(String instantTime, Map<MetadataPartitionType, HoodieData<HoodieRecord>> partitionRecordsMap, boolean canTriggerTableService) {
        ValidationUtils.checkState((boolean)this.enabled, (String)"Metadata table cannot be committed to as it is not enabled");
        ValidationUtils.checkState((this.metadataMetaClient != null ? 1 : 0) != 0, (String)"Metadata table is not fully initialized yet.");
        HoodieData preppedRecords = this.prepRecords(partitionRecordsMap);
        List preppedRecordList = preppedRecords.collectAsList();
        try (HoodieFlinkWriteClient writeClient = new HoodieFlinkWriteClient(this.engineContext, this.metadataWriteConfig);){
            if (canTriggerTableService) {
                this.compactIfNecessary(writeClient, instantTime);
            }
            if (!this.metadataMetaClient.getActiveTimeline().containsInstant(instantTime)) {
                writeClient.startCommitWithTime(instantTime);
                this.metadataMetaClient.getActiveTimeline().transitionRequestedToInflight("deltacommit", instantTime);
            } else {
                Option alreadyCompletedInstant = this.metadataMetaClient.getActiveTimeline().filterCompletedInstants().filter(entry -> entry.getTimestamp().equals(instantTime)).lastInstant();
                if (alreadyCompletedInstant.isPresent()) {
                    HoodieActiveTimeline.deleteInstantFile((FileSystem)this.metadataMetaClient.getFs(), (String)this.metadataMetaClient.getMetaPath(), (HoodieInstant)((HoodieInstant)alreadyCompletedInstant.get()));
                    this.metadataMetaClient.reloadActiveTimeline();
                }
                writeClient.getHeartbeatClient().start(instantTime);
            }
            List<WriteStatus> statuses = preppedRecordList.size() > 0 ? writeClient.upsertPreppedRecords(preppedRecordList, instantTime) : Collections.emptyList();
            statuses.forEach(writeStatus -> {
                if (writeStatus.hasErrors()) {
                    throw new HoodieMetadataException("Failed to commit metadata table records at instant " + instantTime);
                }
            });
            writeClient.commit(instantTime, statuses, Option.empty(), "deltacommit", Collections.emptyMap());
            this.metadataMetaClient.reloadActiveTimeline();
            if (canTriggerTableService) {
                this.cleanIfNecessary(writeClient, instantTime);
                writeClient.archive();
            }
        }
        this.metrics.ifPresent(m -> m.updateSizeMetrics(this.metadataMetaClient, this.metadata));
    }

    public void deletePartitions(String instantTime, List<MetadataPartitionType> partitions) {
        throw new HoodieNotSupportedException("Dropping metadata index not supported for Flink metadata table yet.");
    }
}

