/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.model.HoodieAvroRecord;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.log.AbstractHoodieLogRecordReader;
import org.apache.hudi.common.table.log.HoodieMergedLogRecordScanner;
import org.apache.hudi.common.table.log.InstantRange;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.SpillableMapUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.ExternalSpillableMap;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.metadata.HoodieMetadataPayload;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class HoodieMetadataMergedLogRecordReader
extends HoodieMergedLogRecordScanner {
    private static final Logger LOG = LogManager.getLogger(HoodieMetadataMergedLogRecordReader.class);

    private HoodieMetadataMergedLogRecordReader(FileSystem fs, String basePath, String partitionName, List<String> logFilePaths, Schema readerSchema, String latestInstantTime, Long maxMemorySizeInBytes, int bufferSize, String spillableMapBasePath, ExternalSpillableMap.DiskMapType diskMapType, boolean isBitCaskDiskMapCompressionEnabled, Option<InstantRange> instantRange, boolean allowFullScan) {
        super(fs, basePath, logFilePaths, readerSchema, latestInstantTime, maxMemorySizeInBytes, true, false, bufferSize, spillableMapBasePath, instantRange, diskMapType, isBitCaskDiskMapCompressionEnabled, false, allowFullScan, Option.of(partitionName), InternalSchema.getEmptyInternalSchema());
    }

    @Override
    protected HoodieAvroRecord<?> createHoodieRecord(IndexedRecord rec, HoodieTableConfig hoodieTableConfig, String payloadClassFQN, String preCombineField, boolean withOperationField, Option<Pair<String, String>> simpleKeyGenFields, Option<String> partitionName) {
        if (hoodieTableConfig.populateMetaFields()) {
            return super.createHoodieRecord(rec, hoodieTableConfig, payloadClassFQN, preCombineField, withOperationField, simpleKeyGenFields, partitionName);
        }
        return (HoodieAvroRecord)SpillableMapUtils.convertToHoodieRecordPayload((GenericRecord)rec, payloadClassFQN, preCombineField, simpleKeyGenFields.get(), withOperationField, partitionName);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public synchronized List<Pair<String, Option<HoodieRecord<HoodieMetadataPayload>>>> getRecordByKey(String key) {
        ValidationUtils.checkState(this.forceFullScan, "Record reader has to be in full-scan mode to use this API");
        return Collections.singletonList(Pair.of(key, Option.ofNullable((HoodieRecord)this.records.get(key))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<HoodieRecord<HoodieMetadataPayload>> getRecordsByKeyPrefixes(List<String> keyPrefixes) {
        HoodieMetadataMergedLogRecordReader hoodieMetadataMergedLogRecordReader = this;
        synchronized (hoodieMetadataMergedLogRecordReader) {
            this.records.clear();
            this.scanInternal(Option.of(new AbstractHoodieLogRecordReader.KeySpec(keyPrefixes, false)));
            return this.records.values().stream().filter(Objects::nonNull).map(record -> record).collect(Collectors.toList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<Pair<String, Option<HoodieRecord<HoodieMetadataPayload>>>> getRecordsByKeys(List<String> keys) {
        HoodieMetadataMergedLogRecordReader hoodieMetadataMergedLogRecordReader = this;
        synchronized (hoodieMetadataMergedLogRecordReader) {
            this.records.clear();
            this.scan(keys);
            return keys.stream().map(key -> Pair.of(key, Option.ofNullable((HoodieRecord)this.records.get(key)))).collect(Collectors.toList());
        }
    }

    @Override
    protected String getKeyField() {
        return "key";
    }

    private static class ExplicitMatchRange
    extends InstantRange {
        Set<String> instants;

        public ExplicitMatchRange(Set<String> instants) {
            super(Collections.min(instants), Collections.max(instants));
            this.instants = instants;
        }

        @Override
        public boolean isInRange(String instant) {
            return this.instants.contains(instant);
        }
    }

    public static class Builder
    extends HoodieMergedLogRecordScanner.Builder {
        private boolean allowFullScan = HoodieMetadataConfig.ENABLE_FULL_SCAN_LOG_FILES.defaultValue();

        @Override
        public Builder withFileSystem(FileSystem fs) {
            this.fs = fs;
            return this;
        }

        @Override
        public Builder withBasePath(String basePath) {
            this.basePath = basePath;
            return this;
        }

        @Override
        public Builder withLogFilePaths(List<String> logFilePaths) {
            this.logFilePaths = logFilePaths;
            return this;
        }

        @Override
        public Builder withReaderSchema(Schema schema) {
            this.readerSchema = schema;
            return this;
        }

        @Override
        public Builder withLatestInstantTime(String latestInstantTime) {
            this.latestInstantTime = latestInstantTime;
            return this;
        }

        @Override
        public Builder withReadBlocksLazily(boolean readBlocksLazily) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Builder withReverseReader(boolean reverseReader) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Builder withBufferSize(int bufferSize) {
            this.bufferSize = bufferSize;
            return this;
        }

        @Override
        public Builder withPartition(String partitionName) {
            this.partitionName = partitionName;
            return this;
        }

        @Override
        public Builder withMaxMemorySizeInBytes(Long maxMemorySizeInBytes) {
            this.maxMemorySizeInBytes = maxMemorySizeInBytes;
            return this;
        }

        @Override
        public Builder withSpillableMapBasePath(String spillableMapBasePath) {
            this.spillableMapBasePath = spillableMapBasePath;
            return this;
        }

        @Override
        public Builder withDiskMapType(ExternalSpillableMap.DiskMapType diskMapType) {
            this.diskMapType = diskMapType;
            return this;
        }

        @Override
        public Builder withBitCaskDiskMapCompressionEnabled(boolean isBitCaskDiskMapCompressionEnabled) {
            this.isBitCaskDiskMapCompressionEnabled = isBitCaskDiskMapCompressionEnabled;
            return this;
        }

        public Builder withLogBlockTimestamps(Set<String> validLogBlockTimestamps) {
            this.withInstantRange(Option.of(new ExplicitMatchRange(validLogBlockTimestamps)));
            return this;
        }

        public Builder allowFullScan(boolean enableFullScan) {
            this.allowFullScan = enableFullScan;
            return this;
        }

        @Override
        public HoodieMetadataMergedLogRecordReader build() {
            return new HoodieMetadataMergedLogRecordReader(this.fs, this.basePath, this.partitionName, this.logFilePaths, this.readerSchema, this.latestInstantTime, this.maxMemorySizeInBytes, this.bufferSize, this.spillableMapBasePath, this.diskMapType, this.isBitCaskDiskMapCompressionEnabled, this.instantRange, this.allowFullScan);
        }
    }
}

