/*
 * Copyright 2015 The Netty Project
 *
 * The Netty Project licenses this file to you under the Apache License,
 * version 2.0 (the "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at:
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/*
 * Copyright 2014 Twitter, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.hbase.thirdparty.io.netty.handler.codec.http2;

import org.apache.hbase.thirdparty.io.netty.buffer.ByteBuf;
import org.apache.hbase.thirdparty.io.netty.util.AsciiString;
import org.apache.hbase.thirdparty.io.netty.util.ByteProcessor;
import org.apache.hbase.thirdparty.io.netty.util.internal.ThrowableUtil;

import static org.apache.hbase.thirdparty.io.netty.handler.codec.http2.Http2Error.COMPRESSION_ERROR;

final class HpackHuffmanDecoder implements ByteProcessor {

    /* Scroll to the bottom! */

    private static final byte HUFFMAN_COMPLETE = 1;
    private static final byte HUFFMAN_EMIT_SYMBOL = 1 << 1;
    private static final byte HUFFMAN_FAIL = 1 << 2;

    private static final int HUFFMAN_COMPLETE_SHIFT = HUFFMAN_COMPLETE << 8;
    private static final int HUFFMAN_EMIT_SYMBOL_SHIFT = HUFFMAN_EMIT_SYMBOL << 8;
    private static final int HUFFMAN_FAIL_SHIFT = HUFFMAN_FAIL << 8;

    /**
     * A table of byte tuples (state, flags, output).   They are packed together as:
     * <p>
     * state<<16 + flags<<8 + output
     */
    private static final int[] HUFFS = new int[] {
            // Node 0 (Root Node, never emits symbols.)
            4 << 16,
            5 << 16,
            7 << 16,
            8 << 16,
            11 << 16,
            12 << 16,
            16 << 16,
            19 << 16,
            25 << 16,
            28 << 16,
            32 << 16,
            35 << 16,
            42 << 16,
            49 << 16,
            57 << 16,
            (64 << 16) + (HUFFMAN_COMPLETE << 8),

            // Node 1
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 48,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 49,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 50,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 97,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 99,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 101,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 105,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 111,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 115,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 116,
            13 << 16,
            14 << 16,
            17 << 16,
            18 << 16,
            20 << 16,
            21 << 16,

            // Node 2
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 48,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 48,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 49,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 49,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 50,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 50,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 97,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 97,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 99,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 99,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 101,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 101,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 105,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 105,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 111,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 111,

            // Node 3
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 48,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 48,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 48,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 48,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 49,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 49,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 49,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 49,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 50,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 50,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 50,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 50,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 97,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 97,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 97,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 97,

            // Node 4
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 48,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 48,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 48,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 48,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 48,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 48,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 48,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 48,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 49,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 49,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 49,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 49,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 49,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 49,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 49,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 49,

            // Node 5
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 50,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 50,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 50,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 50,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 50,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 50,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 50,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 50,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 97,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 97,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 97,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 97,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 97,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 97,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 97,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 97,

            // Node 6
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 99,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 99,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 99,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 99,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 101,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 101,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 101,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 101,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 105,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 105,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 105,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 105,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 111,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 111,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 111,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 111,

            // Node 7
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 99,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 99,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 99,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 99,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 99,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 99,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 99,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 99,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 101,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 101,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 101,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 101,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 101,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 101,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 101,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 101,

            // Node 8
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 105,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 105,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 105,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 105,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 105,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 105,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 105,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 105,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 111,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 111,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 111,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 111,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 111,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 111,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 111,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 111,

            // Node 9
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 115,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 115,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 116,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 116,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 32,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 37,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 45,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 46,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 47,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 51,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 52,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 53,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 54,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 55,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 56,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 57,

            // Node 10
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 115,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 115,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 115,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 115,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 116,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 116,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 116,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 116,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 32,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 32,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 37,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 37,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 45,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 45,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 46,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 46,

            // Node 11
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 115,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 115,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 115,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 115,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 115,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 115,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 115,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 115,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 116,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 116,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 116,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 116,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 116,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 116,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 116,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 116,

            // Node 12
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 32,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 32,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 32,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 32,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 37,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 37,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 37,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 37,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 45,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 45,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 45,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 45,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 46,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 46,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 46,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 46,

            // Node 13
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 32,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 32,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 32,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 32,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 32,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 32,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 32,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 32,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 37,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 37,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 37,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 37,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 37,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 37,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 37,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 37,

            // Node 14
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 45,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 45,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 45,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 45,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 45,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 45,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 45,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 45,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 46,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 46,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 46,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 46,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 46,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 46,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 46,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 46,

            // Node 15
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 47,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 47,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 51,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 51,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 52,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 52,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 53,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 53,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 54,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 54,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 55,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 55,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 56,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 56,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 57,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 57,

            // Node 16
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 47,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 47,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 47,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 47,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 51,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 51,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 51,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 51,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 52,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 52,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 52,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 52,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 53,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 53,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 53,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 53,

            // Node 17
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 47,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 47,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 47,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 47,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 47,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 47,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 47,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 47,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 51,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 51,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 51,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 51,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 51,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 51,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 51,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 51,

            // Node 18
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 52,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 52,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 52,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 52,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 52,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 52,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 52,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 52,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 53,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 53,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 53,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 53,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 53,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 53,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 53,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 53,

            // Node 19
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 54,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 54,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 54,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 54,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 55,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 55,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 55,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 55,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 56,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 56,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 56,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 56,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 57,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 57,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 57,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 57,

            // Node 20
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 54,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 54,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 54,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 54,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 54,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 54,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 54,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 54,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 55,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 55,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 55,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 55,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 55,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 55,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 55,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 55,

            // Node 21
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 56,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 56,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 56,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 56,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 56,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 56,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 56,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 56,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 57,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 57,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 57,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 57,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 57,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 57,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 57,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 57,

            // Node 22
            26 << 16,
            27 << 16,
            29 << 16,
            30 << 16,
            33 << 16,
            34 << 16,
            36 << 16,
            37 << 16,
            43 << 16,
            46 << 16,
            50 << 16,
            53 << 16,
            58 << 16,
            61 << 16,
            65 << 16,
            (68 << 16) + (HUFFMAN_COMPLETE << 8),

            // Node 23
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 61,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 65,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 95,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 98,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 100,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 102,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 103,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 104,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 108,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 109,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 110,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 112,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 114,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 117,
            38 << 16,
            39 << 16,

            // Node 24
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 61,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 61,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 65,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 65,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 95,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 95,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 98,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 98,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 100,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 100,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 102,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 102,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 103,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 103,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 104,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 104,

            // Node 25
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 61,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 61,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 61,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 61,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 65,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 65,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 65,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 65,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 95,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 95,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 95,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 95,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 98,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 98,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 98,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 98,

            // Node 26
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 61,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 61,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 61,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 61,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 61,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 61,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 61,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 61,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 65,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 65,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 65,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 65,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 65,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 65,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 65,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 65,

            // Node 27
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 95,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 95,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 95,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 95,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 95,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 95,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 95,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 95,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 98,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 98,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 98,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 98,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 98,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 98,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 98,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 98,

            // Node 28
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 100,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 100,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 100,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 100,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 102,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 102,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 102,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 102,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 103,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 103,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 103,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 103,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 104,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 104,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 104,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 104,

            // Node 29
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 100,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 100,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 100,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 100,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 100,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 100,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 100,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 100,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 102,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 102,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 102,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 102,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 102,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 102,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 102,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 102,

            // Node 30
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 103,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 103,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 103,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 103,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 103,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 103,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 103,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 103,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 104,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 104,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 104,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 104,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 104,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 104,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 104,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 104,

            // Node 31
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 108,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 108,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 109,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 109,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 110,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 110,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 112,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 112,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 114,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 114,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 117,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 117,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 58,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 66,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 67,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 68,

            // Node 32
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 108,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 108,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 108,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 108,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 109,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 109,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 109,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 109,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 110,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 110,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 110,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 110,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 112,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 112,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 112,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 112,

            // Node 33
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 108,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 108,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 108,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 108,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 108,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 108,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 108,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 108,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 109,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 109,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 109,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 109,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 109,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 109,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 109,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 109,

            // Node 34
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 110,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 110,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 110,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 110,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 110,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 110,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 110,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 110,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 112,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 112,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 112,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 112,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 112,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 112,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 112,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 112,

            // Node 35
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 114,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 114,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 114,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 114,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 117,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 117,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 117,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 117,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 58,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 58,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 66,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 66,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 67,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 67,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 68,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 68,

            // Node 36
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 114,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 114,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 114,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 114,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 114,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 114,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 114,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 114,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 117,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 117,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 117,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 117,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 117,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 117,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 117,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 117,

            // Node 37
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 58,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 58,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 58,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 58,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 66,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 66,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 66,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 66,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 67,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 67,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 67,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 67,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 68,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 68,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 68,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 68,

            // Node 38
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 58,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 58,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 58,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 58,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 58,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 58,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 58,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 58,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 66,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 66,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 66,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 66,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 66,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 66,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 66,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 66,

            // Node 39
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 67,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 67,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 67,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 67,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 67,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 67,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 67,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 67,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 68,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 68,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 68,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 68,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 68,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 68,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 68,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 68,

            // Node 40
            44 << 16,
            45 << 16,
            47 << 16,
            48 << 16,
            51 << 16,
            52 << 16,
            54 << 16,
            55 << 16,
            59 << 16,
            60 << 16,
            62 << 16,
            63 << 16,
            66 << 16,
            67 << 16,
            69 << 16,
            (72 << 16) + (HUFFMAN_COMPLETE << 8),

            // Node 41
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 69,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 70,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 71,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 72,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 73,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 74,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 75,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 76,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 77,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 78,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 79,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 80,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 81,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 82,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 83,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 84,

            // Node 42
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 69,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 69,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 70,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 70,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 71,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 71,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 72,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 72,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 73,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 73,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 74,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 74,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 75,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 75,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 76,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 76,

            // Node 43
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 69,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 69,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 69,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 69,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 70,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 70,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 70,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 70,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 71,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 71,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 71,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 71,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 72,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 72,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 72,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 72,

            // Node 44
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 69,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 69,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 69,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 69,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 69,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 69,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 69,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 69,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 70,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 70,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 70,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 70,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 70,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 70,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 70,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 70,

            // Node 45
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 71,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 71,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 71,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 71,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 71,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 71,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 71,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 71,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 72,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 72,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 72,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 72,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 72,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 72,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 72,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 72,

            // Node 46
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 73,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 73,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 73,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 73,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 74,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 74,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 74,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 74,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 75,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 75,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 75,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 75,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 76,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 76,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 76,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 76,

            // Node 47
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 73,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 73,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 73,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 73,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 73,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 73,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 73,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 73,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 74,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 74,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 74,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 74,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 74,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 74,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 74,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 74,

            // Node 48
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 75,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 75,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 75,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 75,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 75,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 75,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 75,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 75,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 76,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 76,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 76,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 76,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 76,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 76,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 76,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 76,

            // Node 49
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 77,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 77,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 78,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 78,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 79,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 79,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 80,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 80,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 81,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 81,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 82,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 82,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 83,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 83,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 84,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 84,

            // Node 50
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 77,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 77,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 77,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 77,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 78,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 78,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 78,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 78,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 79,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 79,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 79,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 79,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 80,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 80,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 80,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 80,

            // Node 51
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 77,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 77,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 77,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 77,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 77,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 77,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 77,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 77,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 78,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 78,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 78,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 78,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 78,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 78,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 78,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 78,

            // Node 52
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 79,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 79,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 79,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 79,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 79,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 79,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 79,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 79,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 80,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 80,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 80,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 80,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 80,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 80,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 80,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 80,

            // Node 53
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 81,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 81,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 81,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 81,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 82,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 82,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 82,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 82,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 83,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 83,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 83,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 83,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 84,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 84,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 84,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 84,

            // Node 54
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 81,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 81,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 81,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 81,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 81,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 81,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 81,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 81,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 82,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 82,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 82,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 82,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 82,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 82,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 82,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 82,

            // Node 55
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 83,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 83,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 83,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 83,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 83,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 83,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 83,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 83,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 84,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 84,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 84,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 84,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 84,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 84,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 84,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 84,

            // Node 56
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 85,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 86,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 87,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 89,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 106,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 107,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 113,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 118,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 119,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 120,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 121,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 122,
            70 << 16,
            71 << 16,
            73 << 16,
            (74 << 16) + (HUFFMAN_COMPLETE << 8),

            // Node 57
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 85,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 85,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 86,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 86,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 87,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 87,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 89,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 89,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 106,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 106,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 107,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 107,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 113,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 113,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 118,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 118,

            // Node 58
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 85,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 85,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 85,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 85,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 86,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 86,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 86,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 86,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 87,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 87,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 87,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 87,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 89,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 89,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 89,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 89,

            // Node 59
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 85,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 85,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 85,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 85,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 85,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 85,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 85,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 85,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 86,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 86,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 86,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 86,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 86,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 86,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 86,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 86,

            // Node 60
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 87,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 87,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 87,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 87,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 87,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 87,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 87,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 87,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 89,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 89,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 89,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 89,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 89,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 89,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 89,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 89,

            // Node 61
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 106,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 106,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 106,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 106,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 107,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 107,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 107,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 107,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 113,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 113,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 113,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 113,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 118,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 118,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 118,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 118,

            // Node 62
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 106,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 106,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 106,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 106,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 106,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 106,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 106,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 106,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 107,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 107,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 107,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 107,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 107,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 107,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 107,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 107,

            // Node 63
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 113,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 113,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 113,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 113,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 113,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 113,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 113,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 113,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 118,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 118,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 118,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 118,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 118,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 118,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 118,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 118,

            // Node 64
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 119,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 119,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 120,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 120,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 121,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 121,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 122,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 122,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 38,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 42,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 44,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 59,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 88,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 90,
            75 << 16,
            78 << 16,

            // Node 65
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 119,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 119,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 119,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 119,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 120,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 120,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 120,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 120,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 121,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 121,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 121,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 121,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 122,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 122,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 122,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 122,

            // Node 66
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 119,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 119,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 119,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 119,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 119,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 119,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 119,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 119,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 120,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 120,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 120,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 120,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 120,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 120,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 120,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 120,

            // Node 67
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 121,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 121,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 121,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 121,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 121,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 121,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 121,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 121,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 122,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 122,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 122,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 122,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 122,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 122,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 122,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 122,

            // Node 68
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 38,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 38,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 42,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 42,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 44,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 44,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 59,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 59,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 88,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 88,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 90,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 90,
            76 << 16,
            77 << 16,
            79 << 16,
            81 << 16,

            // Node 69
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 38,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 38,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 38,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 38,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 42,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 42,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 42,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 42,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 44,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 44,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 44,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 44,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 59,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 59,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 59,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 59,

            // Node 70
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 38,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 38,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 38,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 38,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 38,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 38,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 38,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 38,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 42,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 42,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 42,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 42,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 42,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 42,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 42,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 42,

            // Node 71
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 44,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 44,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 44,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 44,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 44,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 44,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 44,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 44,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 59,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 59,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 59,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 59,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 59,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 59,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 59,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 59,

            // Node 72
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 88,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 88,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 88,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 88,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 90,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 90,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 90,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 90,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 33,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 34,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 40,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 41,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 63,
            80 << 16,
            82 << 16,
            84 << 16,

            // Node 73
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 88,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 88,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 88,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 88,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 88,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 88,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 88,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 88,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 90,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 90,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 90,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 90,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 90,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 90,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 90,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 90,

            // Node 74
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 33,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 33,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 34,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 34,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 40,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 40,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 41,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 41,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 63,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 63,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 39,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 43,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 124,
            83 << 16,
            85 << 16,
            88 << 16,

            // Node 75
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 33,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 33,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 33,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 33,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 34,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 34,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 34,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 34,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 40,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 40,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 40,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 40,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 41,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 41,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 41,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 41,

            // Node 76
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 33,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 33,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 33,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 33,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 33,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 33,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 33,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 33,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 34,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 34,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 34,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 34,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 34,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 34,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 34,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 34,

            // Node 77
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 40,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 40,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 40,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 40,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 40,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 40,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 40,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 40,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 41,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 41,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 41,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 41,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 41,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 41,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 41,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 41,

            // Node 78
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 63,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 63,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 63,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 63,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 39,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 39,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 43,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 43,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 124,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 124,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 35,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 62,
            86 << 16,
            87 << 16,
            89 << 16,
            90 << 16,

            // Node 79
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 63,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 63,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 63,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 63,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 63,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 63,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 63,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 63,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 39,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 39,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 39,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 39,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 43,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 43,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 43,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 43,

            // Node 80
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 39,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 39,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 39,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 39,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 39,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 39,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 39,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 39,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 43,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 43,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 43,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 43,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 43,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 43,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 43,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 43,

            // Node 81
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 124,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 124,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 124,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 124,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 35,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 35,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 62,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 62,
            (HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 36,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 64,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 91,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 93,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 126,
            91 << 16,
            92 << 16,

            // Node 82
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 124,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 124,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 124,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 124,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 124,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 124,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 124,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 124,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 35,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 35,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 35,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 35,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 62,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 62,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 62,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 62,

            // Node 83
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 35,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 35,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 35,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 35,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 35,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 35,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 35,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 35,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 62,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 62,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 62,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 62,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 62,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 62,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 62,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 62,

            // Node 84
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8),
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8),
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 36,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 36,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 64,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 64,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 91,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 91,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 93,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 93,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 126,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 126,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 94,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 125,
            93 << 16,
            94 << 16,

            // Node 85
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8),
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8),
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8),
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8),
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 36,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 36,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 36,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 36,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 64,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 64,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 64,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 64,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 91,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 91,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 91,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 91,

            // Node 86
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8),
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8),
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8),
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8),
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8),
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8),
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8),
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8),
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 36,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 36,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 36,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 36,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 36,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 36,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 36,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 36,

            // Node 87
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 64,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 64,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 64,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 64,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 64,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 64,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 64,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 64,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 91,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 91,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 91,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 91,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 91,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 91,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 91,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 91,

            // Node 88
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 93,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 93,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 93,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 93,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 126,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 126,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 126,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 126,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 94,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 94,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 125,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 125,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 60,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 96,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 123,
            95 << 16,

            // Node 89
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 93,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 93,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 93,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 93,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 93,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 93,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 93,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 93,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 126,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 126,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 126,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 126,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 126,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 126,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 126,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 126,

            // Node 90
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 94,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 94,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 94,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 94,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 125,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 125,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 125,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 125,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 60,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 60,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 96,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 96,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 123,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 123,
            96 << 16,
            110 << 16,

            // Node 91
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 94,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 94,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 94,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 94,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 94,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 94,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 94,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 94,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 125,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 125,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 125,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 125,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 125,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 125,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 125,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 125,

            // Node 92
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 60,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 60,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 60,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 60,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 96,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 96,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 96,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 96,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 123,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 123,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 123,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 123,
            97 << 16,
            101 << 16,
            111 << 16,
            133 << 16,

            // Node 93
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 60,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 60,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 60,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 60,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 60,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 60,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 60,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 60,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 96,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 96,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 96,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 96,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 96,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 96,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 96,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 96,

            // Node 94
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 123,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 123,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 123,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 123,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 123,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 123,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 123,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 123,
            98 << 16,
            99 << 16,
            102 << 16,
            105 << 16,
            112 << 16,
            119 << 16,
            134 << 16,
            153 << 16,

            // Node 95
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 92,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 195,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 208,
            100 << 16,
            103 << 16,
            104 << 16,
            106 << 16,
            107 << 16,
            113 << 16,
            116 << 16,
            120 << 16,
            126 << 16,
            135 << 16,
            142 << 16,
            154 << 16,
            169 << 16,

            // Node 96
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 92,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 92,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 195,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 195,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 208,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 208,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 128,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 130,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 131,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 162,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 184,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 194,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 224,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 226,
            108 << 16,
            109 << 16,

            // Node 97
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 92,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 92,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 92,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 92,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 195,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 195,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 195,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 195,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 208,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 208,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 208,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 208,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 128,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 128,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 130,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 130,

            // Node 98
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 92,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 92,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 92,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 92,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 92,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 92,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 92,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 92,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 195,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 195,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 195,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 195,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 195,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 195,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 195,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 195,

            // Node 99
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 208,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 208,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 208,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 208,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 208,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 208,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 208,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 208,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 128,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 128,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 128,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 128,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 130,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 130,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 130,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 130,

            // Node 100
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 128,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 128,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 128,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 128,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 128,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 128,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 128,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 128,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 130,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 130,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 130,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 130,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 130,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 130,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 130,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 130,

            // Node 101
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 131,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 131,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 162,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 162,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 184,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 184,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 194,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 194,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 224,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 224,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 226,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 226,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 153,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 161,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 167,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 172,

            // Node 102
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 131,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 131,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 131,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 131,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 162,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 162,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 162,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 162,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 184,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 184,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 184,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 184,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 194,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 194,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 194,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 194,

            // Node 103
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 131,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 131,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 131,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 131,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 131,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 131,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 131,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 131,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 162,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 162,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 162,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 162,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 162,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 162,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 162,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 162,

            // Node 104
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 184,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 184,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 184,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 184,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 184,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 184,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 184,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 184,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 194,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 194,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 194,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 194,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 194,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 194,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 194,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 194,

            // Node 105
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 224,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 224,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 224,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 224,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 226,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 226,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 226,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 226,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 153,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 153,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 161,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 161,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 167,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 167,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 172,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 172,

            // Node 106
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 224,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 224,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 224,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 224,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 224,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 224,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 224,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 224,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 226,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 226,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 226,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 226,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 226,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 226,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 226,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 226,

            // Node 107
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 153,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 153,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 153,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 153,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 161,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 161,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 161,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 161,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 167,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 167,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 167,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 167,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 172,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 172,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 172,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 172,

            // Node 108
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 153,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 153,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 153,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 153,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 153,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 153,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 153,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 153,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 161,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 161,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 161,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 161,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 161,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 161,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 161,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 161,

            // Node 109
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 167,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 167,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 167,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 167,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 167,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 167,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 167,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 167,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 172,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 172,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 172,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 172,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 172,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 172,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 172,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 172,

            // Node 110
            114 << 16,
            115 << 16,
            117 << 16,
            118 << 16,
            121 << 16,
            123 << 16,
            127 << 16,
            130 << 16,
            136 << 16,
            139 << 16,
            143 << 16,
            146 << 16,
            155 << 16,
            162 << 16,
            170 << 16,
            180 << 16,

            // Node 111
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 176,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 177,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 179,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 209,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 216,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 217,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 227,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 229,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 230,
            122 << 16,
            124 << 16,
            125 << 16,
            128 << 16,
            129 << 16,
            131 << 16,
            132 << 16,

            // Node 112
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 176,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 176,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 177,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 177,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 179,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 179,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 209,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 209,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 216,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 216,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 217,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 217,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 227,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 227,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 229,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 229,

            // Node 113
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 176,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 176,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 176,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 176,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 177,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 177,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 177,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 177,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 179,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 179,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 179,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 179,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 209,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 209,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 209,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 209,

            // Node 114
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 176,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 176,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 176,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 176,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 176,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 176,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 176,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 176,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 177,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 177,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 177,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 177,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 177,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 177,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 177,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 177,

            // Node 115
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 179,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 179,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 179,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 179,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 179,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 179,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 179,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 179,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 209,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 209,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 209,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 209,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 209,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 209,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 209,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 209,

            // Node 116
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 216,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 216,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 216,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 216,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 217,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 217,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 217,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 217,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 227,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 227,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 227,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 227,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 229,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 229,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 229,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 229,

            // Node 117
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 216,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 216,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 216,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 216,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 216,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 216,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 216,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 216,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 217,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 217,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 217,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 217,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 217,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 217,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 217,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 217,

            // Node 118
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 227,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 227,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 227,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 227,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 227,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 227,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 227,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 227,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 229,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 229,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 229,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 229,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 229,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 229,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 229,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 229,

            // Node 119
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 230,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 230,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 129,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 132,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 133,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 134,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 136,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 146,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 154,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 156,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 160,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 163,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 164,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 169,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 170,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 173,

            // Node 120
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 230,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 230,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 230,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 230,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 129,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 129,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 132,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 132,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 133,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 133,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 134,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 134,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 136,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 136,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 146,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 146,

            // Node 121
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 230,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 230,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 230,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 230,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 230,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 230,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 230,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 230,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 129,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 129,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 129,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 129,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 132,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 132,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 132,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 132,

            // Node 122
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 129,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 129,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 129,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 129,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 129,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 129,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 129,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 129,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 132,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 132,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 132,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 132,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 132,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 132,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 132,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 132,

            // Node 123
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 133,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 133,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 133,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 133,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 134,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 134,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 134,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 134,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 136,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 136,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 136,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 136,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 146,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 146,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 146,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 146,

            // Node 124
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 133,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 133,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 133,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 133,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 133,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 133,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 133,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 133,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 134,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 134,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 134,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 134,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 134,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 134,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 134,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 134,

            // Node 125
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 136,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 136,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 136,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 136,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 136,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 136,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 136,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 136,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 146,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 146,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 146,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 146,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 146,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 146,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 146,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 146,

            // Node 126
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 154,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 154,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 156,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 156,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 160,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 160,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 163,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 163,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 164,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 164,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 169,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 169,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 170,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 170,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 173,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 173,

            // Node 127
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 154,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 154,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 154,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 154,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 156,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 156,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 156,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 156,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 160,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 160,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 160,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 160,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 163,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 163,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 163,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 163,

            // Node 128
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 154,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 154,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 154,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 154,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 154,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 154,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 154,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 154,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 156,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 156,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 156,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 156,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 156,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 156,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 156,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 156,

            // Node 129
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 160,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 160,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 160,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 160,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 160,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 160,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 160,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 160,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 163,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 163,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 163,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 163,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 163,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 163,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 163,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 163,

            // Node 130
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 164,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 164,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 164,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 164,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 169,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 169,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 169,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 169,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 170,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 170,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 170,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 170,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 173,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 173,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 173,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 173,

            // Node 131
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 164,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 164,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 164,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 164,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 164,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 164,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 164,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 164,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 169,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 169,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 169,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 169,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 169,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 169,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 169,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 169,

            // Node 132
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 170,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 170,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 170,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 170,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 170,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 170,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 170,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 170,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 173,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 173,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 173,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 173,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 173,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 173,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 173,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 173,

            // Node 133
            137 << 16,
            138 << 16,
            140 << 16,
            141 << 16,
            144 << 16,
            145 << 16,
            147 << 16,
            150 << 16,
            156 << 16,
            159 << 16,
            163 << 16,
            166 << 16,
            171 << 16,
            174 << 16,
            181 << 16,
            190 << 16,

            // Node 134
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 178,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 181,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 185,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 186,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 187,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 189,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 190,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 196,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 198,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 228,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 232,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 233,
            148 << 16,
            149 << 16,
            151 << 16,
            152 << 16,

            // Node 135
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 178,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 178,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 181,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 181,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 185,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 185,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 186,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 186,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 187,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 187,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 189,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 189,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 190,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 190,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 196,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 196,

            // Node 136
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 178,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 178,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 178,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 178,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 181,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 181,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 181,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 181,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 185,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 185,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 185,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 185,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 186,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 186,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 186,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 186,

            // Node 137
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 178,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 178,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 178,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 178,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 178,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 178,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 178,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 178,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 181,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 181,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 181,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 181,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 181,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 181,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 181,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 181,

            // Node 138
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 185,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 185,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 185,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 185,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 185,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 185,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 185,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 185,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 186,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 186,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 186,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 186,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 186,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 186,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 186,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 186,

            // Node 139
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 187,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 187,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 187,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 187,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 189,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 189,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 189,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 189,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 190,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 190,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 190,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 190,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 196,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 196,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 196,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 196,

            // Node 140
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 187,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 187,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 187,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 187,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 187,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 187,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 187,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 187,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 189,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 189,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 189,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 189,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 189,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 189,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 189,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 189,

            // Node 141
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 190,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 190,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 190,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 190,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 190,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 190,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 190,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 190,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 196,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 196,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 196,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 196,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 196,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 196,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 196,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 196,

            // Node 142
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 198,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 198,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 228,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 228,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 232,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 232,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 233,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 233,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 1,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 135,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 137,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 138,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 139,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 140,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 141,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 143,

            // Node 143
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 198,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 198,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 198,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 198,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 228,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 228,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 228,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 228,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 232,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 232,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 232,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 232,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 233,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 233,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 233,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 233,

            // Node 144
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 198,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 198,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 198,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 198,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 198,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 198,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 198,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 198,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 228,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 228,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 228,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 228,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 228,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 228,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 228,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 228,

            // Node 145
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 232,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 232,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 232,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 232,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 232,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 232,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 232,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 232,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 233,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 233,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 233,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 233,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 233,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 233,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 233,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 233,

            // Node 146
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 1,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 1,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 135,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 135,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 137,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 137,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 138,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 138,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 139,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 139,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 140,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 140,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 141,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 141,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 143,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 143,

            // Node 147
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 1,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 1,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 1,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 1,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 135,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 135,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 135,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 135,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 137,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 137,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 137,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 137,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 138,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 138,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 138,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 138,

            // Node 148
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 1,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 1,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 1,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 1,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 1,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 1,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 1,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 1,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 135,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 135,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 135,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 135,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 135,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 135,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 135,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 135,

            // Node 149
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 137,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 137,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 137,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 137,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 137,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 137,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 137,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 137,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 138,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 138,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 138,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 138,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 138,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 138,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 138,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 138,

            // Node 150
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 139,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 139,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 139,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 139,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 140,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 140,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 140,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 140,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 141,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 141,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 141,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 141,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 143,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 143,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 143,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 143,

            // Node 151
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 139,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 139,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 139,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 139,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 139,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 139,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 139,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 139,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 140,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 140,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 140,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 140,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 140,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 140,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 140,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 140,

            // Node 152
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 141,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 141,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 141,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 141,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 141,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 141,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 141,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 141,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 143,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 143,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 143,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 143,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 143,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 143,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 143,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 143,

            // Node 153
            157 << 16,
            158 << 16,
            160 << 16,
            161 << 16,
            164 << 16,
            165 << 16,
            167 << 16,
            168 << 16,
            172 << 16,
            173 << 16,
            175 << 16,
            177 << 16,
            182 << 16,
            185 << 16,
            191 << 16,
            207 << 16,

            // Node 154
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 147,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 149,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 150,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 151,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 152,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 155,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 157,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 158,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 165,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 166,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 168,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 174,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 175,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 180,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 182,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 183,

            // Node 155
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 147,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 147,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 149,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 149,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 150,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 150,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 151,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 151,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 152,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 152,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 155,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 155,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 157,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 157,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 158,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 158,

            // Node 156
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 147,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 147,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 147,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 147,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 149,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 149,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 149,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 149,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 150,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 150,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 150,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 150,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 151,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 151,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 151,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 151,

            // Node 157
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 147,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 147,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 147,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 147,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 147,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 147,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 147,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 147,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 149,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 149,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 149,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 149,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 149,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 149,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 149,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 149,

            // Node 158
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 150,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 150,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 150,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 150,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 150,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 150,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 150,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 150,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 151,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 151,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 151,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 151,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 151,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 151,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 151,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 151,

            // Node 159
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 152,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 152,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 152,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 152,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 155,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 155,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 155,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 155,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 157,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 157,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 157,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 157,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 158,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 158,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 158,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 158,

            // Node 160
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 152,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 152,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 152,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 152,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 152,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 152,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 152,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 152,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 155,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 155,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 155,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 155,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 155,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 155,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 155,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 155,

            // Node 161
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 157,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 157,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 157,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 157,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 157,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 157,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 157,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 157,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 158,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 158,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 158,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 158,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 158,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 158,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 158,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 158,

            // Node 162
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 165,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 165,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 166,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 166,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 168,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 168,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 174,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 174,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 175,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 175,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 180,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 180,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 182,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 182,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 183,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 183,

            // Node 163
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 165,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 165,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 165,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 165,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 166,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 166,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 166,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 166,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 168,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 168,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 168,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 168,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 174,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 174,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 174,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 174,

            // Node 164
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 165,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 165,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 165,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 165,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 165,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 165,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 165,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 165,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 166,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 166,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 166,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 166,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 166,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 166,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 166,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 166,

            // Node 165
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 168,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 168,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 168,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 168,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 168,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 168,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 168,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 168,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 174,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 174,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 174,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 174,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 174,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 174,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 174,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 174,

            // Node 166
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 175,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 175,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 175,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 175,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 180,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 180,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 180,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 180,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 182,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 182,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 182,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 182,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 183,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 183,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 183,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 183,

            // Node 167
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 175,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 175,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 175,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 175,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 175,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 175,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 175,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 175,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 180,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 180,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 180,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 180,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 180,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 180,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 180,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 180,

            // Node 168
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 182,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 182,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 182,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 182,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 182,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 182,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 182,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 182,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 183,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 183,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 183,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 183,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 183,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 183,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 183,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 183,

            // Node 169
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 188,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 191,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 197,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 231,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 239,
            176 << 16,
            178 << 16,
            179 << 16,
            183 << 16,
            184 << 16,
            186 << 16,
            187 << 16,
            192 << 16,
            199 << 16,
            208 << 16,
            223 << 16,

            // Node 170
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 188,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 188,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 191,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 191,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 197,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 197,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 231,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 231,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 239,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 239,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 9,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 142,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 144,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 145,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 148,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 159,

            // Node 171
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 188,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 188,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 188,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 188,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 191,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 191,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 191,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 191,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 197,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 197,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 197,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 197,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 231,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 231,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 231,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 231,

            // Node 172
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 188,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 188,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 188,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 188,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 188,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 188,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 188,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 188,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 191,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 191,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 191,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 191,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 191,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 191,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 191,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 191,

            // Node 173
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 197,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 197,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 197,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 197,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 197,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 197,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 197,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 197,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 231,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 231,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 231,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 231,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 231,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 231,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 231,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 231,

            // Node 174
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 239,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 239,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 239,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 239,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 9,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 9,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 142,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 142,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 144,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 144,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 145,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 145,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 148,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 148,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 159,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 159,

            // Node 175
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 239,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 239,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 239,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 239,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 239,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 239,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 239,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 239,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 9,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 9,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 9,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 9,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 142,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 142,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 142,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 142,

            // Node 176
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 9,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 9,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 9,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 9,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 9,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 9,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 9,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 9,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 142,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 142,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 142,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 142,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 142,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 142,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 142,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 142,

            // Node 177
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 144,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 144,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 144,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 144,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 145,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 145,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 145,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 145,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 148,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 148,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 148,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 148,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 159,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 159,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 159,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 159,

            // Node 178
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 144,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 144,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 144,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 144,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 144,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 144,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 144,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 144,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 145,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 145,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 145,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 145,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 145,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 145,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 145,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 145,

            // Node 179
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 148,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 148,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 148,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 148,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 148,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 148,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 148,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 148,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 159,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 159,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 159,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 159,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 159,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 159,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 159,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 159,

            // Node 180
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 171,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 206,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 215,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 225,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 236,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 237,
            188 << 16,
            189 << 16,
            193 << 16,
            196 << 16,
            200 << 16,
            203 << 16,
            209 << 16,
            216 << 16,
            224 << 16,
            238 << 16,

            // Node 181
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 171,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 171,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 206,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 206,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 215,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 215,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 225,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 225,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 236,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 236,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 237,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 237,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 199,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 207,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 234,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 235,

            // Node 182
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 171,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 171,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 171,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 171,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 206,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 206,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 206,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 206,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 215,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 215,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 215,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 215,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 225,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 225,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 225,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 225,

            // Node 183
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 171,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 171,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 171,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 171,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 171,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 171,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 171,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 171,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 206,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 206,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 206,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 206,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 206,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 206,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 206,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 206,

            // Node 184
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 215,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 215,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 215,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 215,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 215,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 215,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 215,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 215,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 225,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 225,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 225,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 225,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 225,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 225,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 225,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 225,

            // Node 185
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 236,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 236,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 236,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 236,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 237,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 237,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 237,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 237,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 199,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 199,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 207,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 207,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 234,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 234,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 235,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 235,

            // Node 186
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 236,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 236,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 236,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 236,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 236,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 236,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 236,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 236,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 237,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 237,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 237,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 237,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 237,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 237,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 237,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 237,

            // Node 187
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 199,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 199,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 199,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 199,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 207,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 207,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 207,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 207,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 234,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 234,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 234,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 234,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 235,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 235,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 235,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 235,

            // Node 188
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 199,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 199,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 199,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 199,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 199,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 199,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 199,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 199,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 207,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 207,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 207,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 207,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 207,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 207,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 207,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 207,

            // Node 189
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 234,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 234,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 234,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 234,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 234,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 234,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 234,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 234,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 235,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 235,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 235,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 235,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 235,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 235,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 235,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 235,

            // Node 190
            194 << 16,
            195 << 16,
            197 << 16,
            198 << 16,
            201 << 16,
            202 << 16,
            204 << 16,
            205 << 16,
            210 << 16,
            213 << 16,
            217 << 16,
            220 << 16,
            225 << 16,
            231 << 16,
            239 << 16,
            246 << 16,

            // Node 191
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 192,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 193,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 200,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 201,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 202,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 205,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 210,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 213,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 218,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 219,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 238,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 240,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 242,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 243,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 255,
            206 << 16,

            // Node 192
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 192,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 192,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 193,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 193,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 200,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 200,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 201,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 201,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 202,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 202,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 205,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 205,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 210,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 210,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 213,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 213,

            // Node 193
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 192,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 192,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 192,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 192,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 193,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 193,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 193,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 193,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 200,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 200,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 200,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 200,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 201,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 201,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 201,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 201,

            // Node 194
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 192,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 192,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 192,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 192,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 192,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 192,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 192,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 192,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 193,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 193,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 193,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 193,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 193,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 193,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 193,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 193,

            // Node 195
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 200,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 200,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 200,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 200,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 200,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 200,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 200,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 200,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 201,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 201,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 201,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 201,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 201,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 201,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 201,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 201,

            // Node 196
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 202,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 202,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 202,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 202,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 205,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 205,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 205,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 205,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 210,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 210,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 210,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 210,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 213,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 213,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 213,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 213,

            // Node 197
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 202,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 202,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 202,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 202,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 202,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 202,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 202,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 202,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 205,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 205,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 205,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 205,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 205,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 205,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 205,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 205,

            // Node 198
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 210,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 210,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 210,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 210,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 210,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 210,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 210,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 210,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 213,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 213,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 213,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 213,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 213,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 213,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 213,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 213,

            // Node 199
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 218,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 218,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 219,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 219,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 238,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 238,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 240,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 240,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 242,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 242,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 243,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 243,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 255,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 255,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 203,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 204,

            // Node 200
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 218,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 218,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 218,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 218,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 219,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 219,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 219,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 219,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 238,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 238,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 238,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 238,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 240,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 240,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 240,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 240,

            // Node 201
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 218,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 218,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 218,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 218,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 218,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 218,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 218,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 218,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 219,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 219,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 219,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 219,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 219,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 219,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 219,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 219,

            // Node 202
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 238,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 238,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 238,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 238,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 238,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 238,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 238,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 238,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 240,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 240,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 240,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 240,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 240,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 240,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 240,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 240,

            // Node 203
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 242,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 242,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 242,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 242,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 243,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 243,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 243,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 243,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 255,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 255,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 255,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 255,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 203,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 203,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 204,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 204,

            // Node 204
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 242,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 242,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 242,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 242,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 242,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 242,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 242,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 242,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 243,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 243,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 243,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 243,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 243,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 243,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 243,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 243,

            // Node 205
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 255,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 255,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 255,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 255,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 255,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 255,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 255,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 255,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 203,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 203,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 203,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 203,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 204,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 204,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 204,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 204,

            // Node 206
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 203,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 203,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 203,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 203,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 203,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 203,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 203,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 203,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 204,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 204,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 204,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 204,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 204,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 204,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 204,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 204,

            // Node 207
            211 << 16,
            212 << 16,
            214 << 16,
            215 << 16,
            218 << 16,
            219 << 16,
            221 << 16,
            222 << 16,
            226 << 16,
            228 << 16,
            232 << 16,
            235 << 16,
            240 << 16,
            243 << 16,
            247 << 16,
            250 << 16,

            // Node 208
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 211,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 212,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 214,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 221,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 222,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 223,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 241,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 244,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 245,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 246,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 247,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 248,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 250,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 251,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 252,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 253,

            // Node 209
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 211,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 211,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 212,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 212,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 214,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 214,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 221,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 221,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 222,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 222,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 223,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 223,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 241,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 241,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 244,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 244,

            // Node 210
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 211,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 211,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 211,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 211,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 212,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 212,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 212,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 212,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 214,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 214,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 214,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 214,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 221,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 221,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 221,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 221,

            // Node 211
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 211,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 211,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 211,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 211,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 211,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 211,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 211,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 211,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 212,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 212,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 212,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 212,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 212,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 212,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 212,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 212,

            // Node 212
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 214,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 214,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 214,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 214,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 214,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 214,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 214,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 214,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 221,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 221,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 221,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 221,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 221,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 221,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 221,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 221,

            // Node 213
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 222,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 222,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 222,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 222,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 223,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 223,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 223,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 223,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 241,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 241,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 241,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 241,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 244,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 244,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 244,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 244,

            // Node 214
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 222,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 222,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 222,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 222,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 222,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 222,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 222,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 222,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 223,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 223,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 223,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 223,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 223,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 223,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 223,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 223,

            // Node 215
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 241,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 241,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 241,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 241,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 241,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 241,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 241,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 241,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 244,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 244,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 244,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 244,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 244,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 244,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 244,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 244,

            // Node 216
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 245,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 245,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 246,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 246,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 247,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 247,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 248,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 248,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 250,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 250,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 251,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 251,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 252,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 252,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 253,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 253,

            // Node 217
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 245,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 245,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 245,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 245,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 246,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 246,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 246,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 246,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 247,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 247,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 247,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 247,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 248,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 248,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 248,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 248,

            // Node 218
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 245,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 245,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 245,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 245,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 245,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 245,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 245,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 245,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 246,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 246,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 246,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 246,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 246,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 246,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 246,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 246,

            // Node 219
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 247,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 247,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 247,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 247,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 247,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 247,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 247,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 247,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 248,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 248,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 248,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 248,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 248,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 248,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 248,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 248,

            // Node 220
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 250,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 250,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 250,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 250,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 251,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 251,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 251,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 251,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 252,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 252,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 252,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 252,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 253,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 253,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 253,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 253,

            // Node 221
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 250,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 250,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 250,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 250,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 250,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 250,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 250,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 250,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 251,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 251,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 251,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 251,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 251,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 251,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 251,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 251,

            // Node 222
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 252,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 252,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 252,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 252,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 252,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 252,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 252,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 252,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 253,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 253,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 253,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 253,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 253,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 253,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 253,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 253,

            // Node 223
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 254,
            227 << 16,
            229 << 16,
            230 << 16,
            233 << 16,
            234 << 16,
            236 << 16,
            237 << 16,
            241 << 16,
            242 << 16,
            244 << 16,
            245 << 16,
            248 << 16,
            249 << 16,
            251 << 16,
            252 << 16,

            // Node 224
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 254,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 254,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 2,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 3,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 4,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 5,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 6,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 7,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 8,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 11,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 12,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 14,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 15,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 16,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 17,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 18,

            // Node 225
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 254,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 254,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 254,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 254,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 2,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 2,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 3,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 3,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 4,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 4,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 5,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 5,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 6,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 6,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 7,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 7,

            // Node 226
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 254,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 254,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 254,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 254,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 254,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 254,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 254,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 254,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 2,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 2,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 2,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 2,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 3,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 3,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 3,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 3,

            // Node 227
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 2,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 2,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 2,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 2,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 2,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 2,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 2,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 2,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 3,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 3,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 3,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 3,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 3,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 3,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 3,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 3,

            // Node 228
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 4,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 4,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 4,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 4,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 5,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 5,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 5,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 5,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 6,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 6,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 6,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 6,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 7,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 7,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 7,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 7,

            // Node 229
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 4,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 4,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 4,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 4,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 4,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 4,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 4,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 4,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 5,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 5,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 5,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 5,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 5,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 5,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 5,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 5,

            // Node 230
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 6,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 6,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 6,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 6,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 6,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 6,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 6,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 6,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 7,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 7,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 7,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 7,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 7,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 7,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 7,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 7,

            // Node 231
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 8,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 8,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 11,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 11,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 12,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 12,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 14,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 14,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 15,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 15,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 16,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 16,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 17,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 17,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 18,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 18,

            // Node 232
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 8,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 8,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 8,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 8,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 11,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 11,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 11,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 11,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 12,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 12,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 12,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 12,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 14,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 14,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 14,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 14,

            // Node 233
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 8,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 8,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 8,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 8,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 8,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 8,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 8,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 8,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 11,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 11,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 11,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 11,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 11,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 11,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 11,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 11,

            // Node 234
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 12,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 12,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 12,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 12,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 12,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 12,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 12,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 12,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 14,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 14,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 14,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 14,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 14,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 14,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 14,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 14,

            // Node 235
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 15,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 15,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 15,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 15,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 16,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 16,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 16,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 16,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 17,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 17,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 17,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 17,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 18,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 18,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 18,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 18,

            // Node 236
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 15,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 15,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 15,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 15,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 15,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 15,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 15,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 15,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 16,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 16,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 16,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 16,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 16,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 16,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 16,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 16,

            // Node 237
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 17,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 17,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 17,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 17,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 17,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 17,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 17,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 17,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 18,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 18,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 18,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 18,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 18,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 18,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 18,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 18,

            // Node 238
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 19,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 20,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 21,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 23,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 24,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 25,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 26,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 27,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 28,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 29,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 30,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 31,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 127,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 220,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 249,
            253 << 16,

            // Node 239
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 19,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 19,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 20,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 20,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 21,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 21,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 23,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 23,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 24,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 24,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 25,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 25,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 26,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 26,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 27,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 27,

            // Node 240
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 19,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 19,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 19,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 19,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 20,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 20,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 20,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 20,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 21,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 21,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 21,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 21,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 23,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 23,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 23,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 23,

            // Node 241
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 19,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 19,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 19,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 19,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 19,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 19,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 19,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 19,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 20,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 20,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 20,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 20,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 20,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 20,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 20,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 20,

            // Node 242
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 21,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 21,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 21,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 21,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 21,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 21,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 21,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 21,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 23,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 23,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 23,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 23,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 23,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 23,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 23,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 23,

            // Node 243
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 24,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 24,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 24,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 24,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 25,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 25,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 25,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 25,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 26,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 26,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 26,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 26,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 27,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 27,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 27,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 27,

            // Node 244
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 24,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 24,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 24,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 24,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 24,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 24,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 24,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 24,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 25,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 25,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 25,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 25,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 25,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 25,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 25,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 25,

            // Node 245
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 26,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 26,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 26,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 26,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 26,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 26,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 26,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 26,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 27,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 27,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 27,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 27,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 27,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 27,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 27,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 27,

            // Node 246
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 28,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 28,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 29,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 29,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 30,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 30,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 31,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 31,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 127,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 127,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 220,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 220,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 249,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 249,
            254 << 16,
            255 << 16,

            // Node 247
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 28,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 28,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 28,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 28,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 29,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 29,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 29,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 29,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 30,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 30,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 30,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 30,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 31,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 31,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 31,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 31,

            // Node 248
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 28,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 28,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 28,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 28,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 28,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 28,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 28,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 28,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 29,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 29,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 29,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 29,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 29,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 29,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 29,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 29,

            // Node 249
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 30,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 30,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 30,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 30,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 30,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 30,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 30,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 30,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 31,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 31,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 31,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 31,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 31,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 31,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 31,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 31,

            // Node 250
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 127,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 127,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 127,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 127,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 220,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 220,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 220,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 220,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 249,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 249,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 249,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 249,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 10,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 13,
            ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 22,
            HUFFMAN_FAIL << 8,

            // Node 251
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 127,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 127,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 127,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 127,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 127,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 127,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 127,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 127,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 220,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 220,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 220,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 220,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 220,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 220,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 220,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 220,

            // Node 252
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 249,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 249,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 249,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 249,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 249,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 249,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 249,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 249,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 10,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 10,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 13,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 13,
            (1 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 22,
            (22 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 22,
            HUFFMAN_FAIL << 8,
            HUFFMAN_FAIL << 8,

            // Node 253
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 10,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 10,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 10,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 10,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 13,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 13,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 13,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 13,
            (2 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 22,
            (9 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 22,
            (23 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 22,
            (40 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 22,
            HUFFMAN_FAIL << 8,
            HUFFMAN_FAIL << 8,
            HUFFMAN_FAIL << 8,
            HUFFMAN_FAIL << 8,

            // Node 254
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 10,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 10,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 10,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 10,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 10,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 10,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 10,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 10,
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 13,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 13,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 13,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 13,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 13,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 13,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 13,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 13,

            // Node 255
            (3 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 22,
            (6 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 22,
            (10 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 22,
            (15 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 22,
            (24 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 22,
            (31 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 22,
            (41 << 16) + (HUFFMAN_EMIT_SYMBOL << 8) + 22,
            (56 << 16) + ((HUFFMAN_COMPLETE | HUFFMAN_EMIT_SYMBOL) << 8) + 22,
            HUFFMAN_FAIL << 8,
            HUFFMAN_FAIL << 8,
            HUFFMAN_FAIL << 8,
            HUFFMAN_FAIL << 8,
            HUFFMAN_FAIL << 8,
            HUFFMAN_FAIL << 8,
            HUFFMAN_FAIL << 8,
            HUFFMAN_FAIL << 8,
    };

    private static final Http2Exception BAD_ENCODING = ThrowableUtil.unknownStackTrace(
            Http2Exception.newStatic(COMPRESSION_ERROR, "HPACK - Bad Encoding",
                    Http2Exception.ShutdownHint.HARD_SHUTDOWN), HpackHuffmanDecoder.class, "decode(..)");

    private byte[] dest;
    private int k;
    private int state;

    HpackHuffmanDecoder() { }

    /**
     * Decompresses the given Huffman coded string literal.
     *
     * @param buf the string literal to be decoded
     * @return the output stream for the compressed data
     * @throws Http2Exception EOS Decoded
     */
    public AsciiString decode(ByteBuf buf, int length) throws Http2Exception {
        if (length == 0) {
            return AsciiString.EMPTY_STRING;
        }
        dest = new byte[length * 8 / 5];
        try {
            int readerIndex = buf.readerIndex();
            // Using ByteProcessor to reduce bounds-checking and reference-count checking during byte-by-byte
            // processing of the ByteBuf.
            int endIndex = buf.forEachByte(readerIndex, length, this);
            if (endIndex == -1) {
                // We did consume the requested length
                buf.readerIndex(readerIndex + length);
                if ((state & HUFFMAN_COMPLETE_SHIFT) != HUFFMAN_COMPLETE_SHIFT) {
                    throw BAD_ENCODING;
                }
                return new AsciiString(dest, 0, k, false);
            }

            // The process(...) method returned before the requested length was requested. This means there
            // was a bad encoding detected.
            buf.readerIndex(endIndex);
            throw BAD_ENCODING;
        } finally {
            dest = null;
            k = 0;
            state = 0;
        }
    }

    /**
     * <strong>This should never be called from anything but this class itself!</strong>
     */
    @Override
    public boolean process(byte input) {
        return processNibble(input >> 4) && processNibble(input);
    }

    private boolean processNibble(int input) {
        // The high nibble of the flags byte of each row is always zero
        // (low nibble after shifting row by 12), since there are only 3 flag bits
        int index = state >> 12 | (input & 0x0F);
        state = HUFFS[index];
        if ((state & HUFFMAN_FAIL_SHIFT) != 0) {
            return false;
        }
        if ((state & HUFFMAN_EMIT_SYMBOL_SHIFT) != 0) {
            // state is always positive so can cast without mask here
            dest[k++] = (byte) state;
        }
        return true;
    }
}
