/*
 * Copyright (c) 2012, 2019 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0, which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the
 * Eclipse Public License v. 2.0 are satisfied: GNU General Public License,
 * version 2 with the GNU Classpath Exception, which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 */

package org.apache.hbase.thirdparty.org.glassfish.org.apache.hbase.thirdparty.jersery.client.spi;

import org.apache.hbase.thirdparty.org.glassfish.org.apache.hbase.thirdparty.jersery.client.ClientResponse;

/**
 * Asynchronous connector response processing callback contract.
 *
 * @author Marek Potociar
 */
public interface AsyncConnectorCallback {

    /**
     * Invoked when a response for the asynchronously invoked request is available.
     *
     * @param response asynchronously received client response.
     */
    public void response(ClientResponse response);

    /**
     * Invoked in case the asynchronous request invocation failed.
     *
     * @param failure cause of the asynchronous request invocation failure.
     */
    public void failure(Throwable failure);
}
