/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.namequeues;

import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.shaded.protobuf.generated.TooSlowLog;
import org.apache.hadoop.hbase.slowlog.SlowLogTableAccessor;
import org.apache.hbase.thirdparty.com.google.common.collect.EvictingQueue;
import org.apache.hbase.thirdparty.com.google.common.collect.Queues;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class SlowLogPersistentService {
    private static final Logger LOG = LoggerFactory.getLogger(SlowLogPersistentService.class);
    private static final ReentrantLock LOCK = new ReentrantLock();
    private static final String SYS_TABLE_QUEUE_SIZE = "hbase.regionserver.slowlog.systable.queue.size";
    private static final int DEFAULT_SYS_TABLE_QUEUE_SIZE = 1000;
    private static final int SYSTABLE_PUT_BATCH_SIZE = 100;
    private final Queue<TooSlowLog.SlowLogPayload> queueForSysTable;
    private final Configuration configuration;

    public SlowLogPersistentService(Configuration configuration) {
        this.configuration = configuration;
        int sysTableQueueSize = configuration.getInt(SYS_TABLE_QUEUE_SIZE, 1000);
        EvictingQueue evictingQueueForTable = EvictingQueue.create((int)sysTableQueueSize);
        this.queueForSysTable = Queues.synchronizedQueue((Queue)evictingQueueForTable);
    }

    public void addToQueueForSysTable(TooSlowLog.SlowLogPayload slowLogPayload) {
        this.queueForSysTable.add(slowLogPayload);
    }

    public void addAllLogsToSysTable() {
        if (this.queueForSysTable == null) {
            LOG.trace("hbase.regionserver.slowlog.systable.enabled is turned off. Exiting.");
            return;
        }
        if (LOCK.isLocked()) {
            return;
        }
        LOCK.lock();
        try {
            ArrayList<TooSlowLog.SlowLogPayload> slowLogPayloads = new ArrayList<TooSlowLog.SlowLogPayload>();
            int i = 0;
            while (!this.queueForSysTable.isEmpty()) {
                slowLogPayloads.add(this.queueForSysTable.poll());
                if (++i != 100) continue;
                SlowLogTableAccessor.addSlowLogRecords(slowLogPayloads, (Configuration)this.configuration);
                slowLogPayloads.clear();
                i = 0;
            }
            if (slowLogPayloads.size() > 0) {
                SlowLogTableAccessor.addSlowLogRecords(slowLogPayloads, (Configuration)this.configuration);
            }
        }
        finally {
            LOCK.unlock();
        }
    }
}

