/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import java.util.NavigableMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.regionserver.MultiVersionConcurrencyControl;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.MessageOrBuilder;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.TextFormat;
import org.apache.hadoop.hbase.shaded.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALKey;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class WALUtil {
    private static final Log LOG = LogFactory.getLog(WALUtil.class);

    private WALUtil() {
    }

    public static WALKey writeCompactionMarker(WAL wal, NavigableMap<byte[], Integer> replicationScope, RegionInfo hri, WALProtos.CompactionDescriptor c, MultiVersionConcurrencyControl mvcc) throws IOException {
        WALKey walKey = WALUtil.writeMarker(wal, replicationScope, hri, WALEdit.createCompaction(hri, c), mvcc);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Appended compaction marker " + TextFormat.shortDebugString((MessageOrBuilder)c)));
        }
        return walKey;
    }

    public static WALKey writeFlushMarker(WAL wal, NavigableMap<byte[], Integer> replicationScope, RegionInfo hri, WALProtos.FlushDescriptor f, boolean sync, MultiVersionConcurrencyControl mvcc) throws IOException {
        WALKey walKey = WALUtil.doFullAppendTransaction(wal, replicationScope, hri, WALEdit.createFlushWALEdit(hri, f), mvcc, sync);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Appended flush marker " + TextFormat.shortDebugString((MessageOrBuilder)f)));
        }
        return walKey;
    }

    public static WALKey writeRegionEventMarker(WAL wal, NavigableMap<byte[], Integer> replicationScope, RegionInfo hri, WALProtos.RegionEventDescriptor r, MultiVersionConcurrencyControl mvcc) throws IOException {
        WALKey walKey = WALUtil.writeMarker(wal, replicationScope, hri, WALEdit.createRegionEventWALEdit(hri, r), mvcc);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Appended region event marker " + TextFormat.shortDebugString((MessageOrBuilder)r)));
        }
        return walKey;
    }

    public static WALKey writeBulkLoadMarkerAndSync(WAL wal, NavigableMap<byte[], Integer> replicationScope, RegionInfo hri, WALProtos.BulkLoadDescriptor desc, MultiVersionConcurrencyControl mvcc) throws IOException {
        WALKey walKey = WALUtil.writeMarker(wal, replicationScope, hri, WALEdit.createBulkLoadEvent(hri, desc), mvcc);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Appended Bulk Load marker " + TextFormat.shortDebugString((MessageOrBuilder)desc)));
        }
        return walKey;
    }

    private static WALKey writeMarker(WAL wal, NavigableMap<byte[], Integer> replicationScope, RegionInfo hri, WALEdit edit, MultiVersionConcurrencyControl mvcc) throws IOException {
        return WALUtil.doFullAppendTransaction(wal, replicationScope, hri, edit, mvcc, true);
    }

    public static WALKey doFullAppendTransaction(WAL wal, NavigableMap<byte[], Integer> replicationScope, RegionInfo hri, WALEdit edit, MultiVersionConcurrencyControl mvcc, boolean sync) throws IOException {
        WALKey walKey = new WALKey(hri.getEncodedNameAsBytes(), hri.getTable(), System.currentTimeMillis(), mvcc, replicationScope);
        long trx = -1L;
        try {
            trx = wal.append(hri, walKey, edit, false);
            if (sync) {
                wal.sync(trx);
            }
            mvcc.complete(walKey.getWriteEntry());
        }
        catch (IOException ioe) {
            mvcc.complete(walKey.getWriteEntry());
            throw ioe;
        }
        return walKey;
    }
}

