/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.quotas.ActivePolicyEnforcement;
import org.apache.hadoop.hbase.quotas.QuotaUtil;
import org.apache.hadoop.hbase.quotas.SpaceQuotaRefresherChore;
import org.apache.hadoop.hbase.quotas.SpaceQuotaSnapshot;
import org.apache.hadoop.hbase.quotas.SpaceViolationPolicyEnforcement;
import org.apache.hadoop.hbase.quotas.SpaceViolationPolicyEnforcementFactory;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class RegionServerSpaceQuotaManager {
    private static final Log LOG = LogFactory.getLog(RegionServerSpaceQuotaManager.class);
    private final RegionServerServices rsServices;
    private SpaceQuotaRefresherChore spaceQuotaRefresher;
    private AtomicReference<Map<TableName, SpaceQuotaSnapshot>> currentQuotaSnapshots;
    private boolean started = false;
    private ConcurrentHashMap<TableName, SpaceViolationPolicyEnforcement> enforcedPolicies;
    private SpaceViolationPolicyEnforcementFactory factory;

    public RegionServerSpaceQuotaManager(RegionServerServices rsServices) {
        this(rsServices, SpaceViolationPolicyEnforcementFactory.getInstance());
    }

    @VisibleForTesting
    RegionServerSpaceQuotaManager(RegionServerServices rsServices, SpaceViolationPolicyEnforcementFactory factory) {
        this.rsServices = Objects.requireNonNull(rsServices);
        this.factory = factory;
        this.enforcedPolicies = new ConcurrentHashMap();
        this.currentQuotaSnapshots = new AtomicReference(new HashMap());
    }

    public synchronized void start() throws IOException {
        if (!QuotaUtil.isQuotaEnabled(this.rsServices.getConfiguration())) {
            LOG.info((Object)"Quota support disabled, not starting space quota manager.");
            return;
        }
        if (this.started) {
            LOG.warn((Object)"RegionServerSpaceQuotaManager has already been started!");
            return;
        }
        this.spaceQuotaRefresher = new SpaceQuotaRefresherChore(this, (Connection)this.rsServices.getClusterConnection());
        this.rsServices.getChoreService().scheduleChore((ScheduledChore)this.spaceQuotaRefresher);
        this.started = true;
    }

    public synchronized void stop() {
        if (this.spaceQuotaRefresher != null) {
            this.spaceQuotaRefresher.cancel();
            this.spaceQuotaRefresher = null;
        }
        this.started = false;
    }

    public boolean isStarted() {
        return this.started;
    }

    public Map<TableName, SpaceQuotaSnapshot> copyQuotaSnapshots() {
        return new HashMap<TableName, SpaceQuotaSnapshot>(this.currentQuotaSnapshots.get());
    }

    public void updateQuotaSnapshot(Map<TableName, SpaceQuotaSnapshot> newSnapshots) {
        this.currentQuotaSnapshots.set(Objects.requireNonNull(newSnapshots));
    }

    public ActivePolicyEnforcement getActiveEnforcements() {
        return new ActivePolicyEnforcement(this.copyActiveEnforcements(), this.copyQuotaSnapshots(), this.rsServices);
    }

    public Map<TableName, SpaceQuotaSnapshot> getActivePoliciesAsMap() {
        Map<TableName, SpaceViolationPolicyEnforcement> enforcements = this.copyActiveEnforcements();
        HashMap<TableName, SpaceQuotaSnapshot> policies = new HashMap<TableName, SpaceQuotaSnapshot>();
        for (Map.Entry<TableName, SpaceViolationPolicyEnforcement> entry : enforcements.entrySet()) {
            SpaceQuotaSnapshot snapshot = entry.getValue().getQuotaSnapshot();
            if (snapshot == null) continue;
            policies.put(entry.getKey(), snapshot);
        }
        return policies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enforceViolationPolicy(TableName tableName, SpaceQuotaSnapshot snapshot) {
        SpaceQuotaSnapshot.SpaceQuotaStatus status = snapshot.getQuotaStatus();
        if (!status.isInViolation()) {
            throw new IllegalStateException(tableName + " is not in violation. Violation policy should not be enabled.");
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Enabling violation policy enforcement on " + tableName + " with policy " + status.getPolicy()));
        }
        SpaceViolationPolicyEnforcement enforcement = this.getFactory().create(this.getRegionServerServices(), tableName, snapshot);
        ConcurrentHashMap<TableName, SpaceViolationPolicyEnforcement> concurrentHashMap = this.enforcedPolicies;
        synchronized (concurrentHashMap) {
            try {
                enforcement.enable();
            }
            catch (IOException e) {
                LOG.error((Object)("Failed to enable space violation policy for " + tableName + ". This table will not enter violation."), (Throwable)e);
                return;
            }
            this.enforcedPolicies.put(tableName, enforcement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableViolationPolicyEnforcement(TableName tableName) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Disabling violation policy enforcement on " + tableName));
        }
        ConcurrentHashMap<TableName, SpaceViolationPolicyEnforcement> concurrentHashMap = this.enforcedPolicies;
        synchronized (concurrentHashMap) {
            SpaceViolationPolicyEnforcement enforcement = this.enforcedPolicies.remove(tableName);
            if (enforcement != null) {
                try {
                    enforcement.disable();
                }
                catch (IOException e) {
                    LOG.error((Object)("Failed to disable space violation policy for " + tableName + ". This table will remain in violation."), (Throwable)e);
                    this.enforcedPolicies.put(tableName, enforcement);
                }
            }
        }
    }

    public boolean areCompactionsDisabled(TableName tableName) {
        SpaceViolationPolicyEnforcement enforcement = this.enforcedPolicies.get(Objects.requireNonNull(tableName));
        if (enforcement != null) {
            return enforcement.areCompactionsDisabled();
        }
        return false;
    }

    Map<TableName, SpaceViolationPolicyEnforcement> copyActiveEnforcements() {
        return new HashMap<TableName, SpaceViolationPolicyEnforcement>(this.enforcedPolicies);
    }

    RegionServerServices getRegionServerServices() {
        return this.rsServices;
    }

    Connection getConnection() {
        return this.rsServices.getConnection();
    }

    SpaceViolationPolicyEnforcementFactory getFactory() {
        return this.factory;
    }
}

