/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RPCProtos;
import org.apache.hadoop.hbase.util.NonceKey;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public final class MasterProcedureUtil {
    private static final Log LOG = LogFactory.getLog(MasterProcedureUtil.class);
    private static final Pattern pattern = Pattern.compile(".*pv-\\d{20}.log");

    private MasterProcedureUtil() {
    }

    public static RPCProtos.UserInformation toProtoUserInfo(User user) {
        RPCProtos.UserInformation.Builder userInfoPB = RPCProtos.UserInformation.newBuilder();
        userInfoPB.setEffectiveUser(user.getName());
        if (user.getUGI().getRealUser() != null) {
            userInfoPB.setRealUser(user.getUGI().getRealUser().getUserName());
        }
        return userInfoPB.build();
    }

    public static User toUserInfo(RPCProtos.UserInformation userInfoProto) {
        if (userInfoProto.hasEffectiveUser()) {
            String effectiveUser = userInfoProto.getEffectiveUser();
            if (userInfoProto.hasRealUser()) {
                String realUser = userInfoProto.getRealUser();
                UserGroupInformation realUserUgi = UserGroupInformation.createRemoteUser((String)realUser);
                return User.create((UserGroupInformation)UserGroupInformation.createProxyUser((String)effectiveUser, (UserGroupInformation)realUserUgi));
            }
            return User.create((UserGroupInformation)UserGroupInformation.createRemoteUser((String)effectiveUser));
        }
        return null;
    }

    public static long submitProcedure(NonceProcedureRunnable runnable) throws IOException {
        ProcedureExecutor<MasterProcedureEnv> procExec = runnable.getProcedureExecutor();
        long procId = procExec.registerNonce(runnable.getNonceKey());
        if (procId >= 0L) {
            return procId;
        }
        try {
            runnable.run();
        }
        catch (IOException e) {
            procExec.setFailureResultForNonce(runnable.getNonceKey(), runnable.getDescription(), ((MasterProcedureEnv)procExec.getEnvironment()).getRequestUser(), e);
            throw e;
        }
        finally {
            procExec.unregisterNonceIfProcedureWasNotSubmitted(runnable.getNonceKey());
        }
        return runnable.getProcId();
    }

    public static boolean validateProcedureWALFilename(String filename) {
        return pattern.matcher(filename).matches();
    }

    public static abstract class NonceProcedureRunnable {
        private final MasterServices master;
        private final NonceKey nonceKey;
        private Long procId;

        public NonceProcedureRunnable(MasterServices master, long nonceGroup, long nonce) {
            this.master = master;
            this.nonceKey = this.getProcedureExecutor().createNonceKey(nonceGroup, nonce);
        }

        protected NonceKey getNonceKey() {
            return this.nonceKey;
        }

        protected MasterServices getMaster() {
            return this.master;
        }

        protected ProcedureExecutor<MasterProcedureEnv> getProcedureExecutor() {
            return this.master.getMasterProcedureExecutor();
        }

        protected long getProcId() {
            return this.procId != null ? this.procId : -1L;
        }

        protected long setProcId(long procId) {
            this.procId = procId;
            return procId;
        }

        protected abstract void run() throws IOException;

        protected abstract String getDescription();

        protected long submitProcedure(Procedure proc) {
            assert (this.procId == null) : "submitProcedure() was already called, running procId=" + this.procId;
            this.procId = this.getProcedureExecutor().submitProcedure(proc, this.nonceKey);
            return this.procId;
        }
    }
}

