/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.conf.ConfigurationObserver;
import org.apache.hadoop.hbase.ipc.BalancedQueueRpcExecutor;
import org.apache.hadoop.hbase.ipc.CallQueueInfo;
import org.apache.hadoop.hbase.ipc.CallRunner;
import org.apache.hadoop.hbase.ipc.FastPathBalancedQueueRpcExecutor;
import org.apache.hadoop.hbase.ipc.PriorityFunction;
import org.apache.hadoop.hbase.ipc.RWQueueRpcExecutor;
import org.apache.hadoop.hbase.ipc.RpcCall;
import org.apache.hadoop.hbase.ipc.RpcExecutor;
import org.apache.hadoop.hbase.ipc.RpcScheduler;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.LimitedPrivate(value={"Coprocesssor", "Phoenix"})
@InterfaceStability.Evolving
public class SimpleRpcScheduler
extends RpcScheduler
implements ConfigurationObserver {
    private int port;
    private final PriorityFunction priority;
    private final RpcExecutor callExecutor;
    private final RpcExecutor priorityExecutor;
    private final RpcExecutor replicationExecutor;
    private final int highPriorityLevel;
    private Abortable abortable = null;

    public SimpleRpcScheduler(Configuration conf, int handlerCount, int priorityHandlerCount, int replicationHandlerCount, PriorityFunction priority, Abortable server, int highPriorityLevel) {
        int maxQueueLength = conf.getInt("hbase.ipc.server.max.callqueue.length", handlerCount * 10);
        int maxPriorityQueueLength = conf.getInt("hbase.ipc.server.priority.max.callqueue.length", maxQueueLength);
        this.priority = priority;
        this.highPriorityLevel = highPriorityLevel;
        this.abortable = server;
        String callQueueType = conf.get("hbase.ipc.server.callqueue.type", "fifo");
        float callqReadShare = conf.getFloat("hbase.ipc.server.callqueue.read.ratio", 0.0f);
        this.callExecutor = callqReadShare > 0.0f ? new RWQueueRpcExecutor("default.RWQ", Math.max(2, handlerCount), maxQueueLength, priority, conf, server) : (RpcExecutor.isFifoQueueType(callQueueType) || RpcExecutor.isCodelQueueType(callQueueType) ? new FastPathBalancedQueueRpcExecutor("default.FPBQ", handlerCount, maxQueueLength, priority, conf, server) : new BalancedQueueRpcExecutor("default.BQ", handlerCount, maxQueueLength, priority, conf, server));
        this.priorityExecutor = priorityHandlerCount > 0 ? new FastPathBalancedQueueRpcExecutor("priority.FPBQ", priorityHandlerCount, "fifo", maxPriorityQueueLength, priority, conf, this.abortable) : null;
        this.replicationExecutor = replicationHandlerCount > 0 ? new FastPathBalancedQueueRpcExecutor("replication.FPBQ", replicationHandlerCount, "fifo", maxQueueLength, priority, conf, this.abortable) : null;
    }

    public SimpleRpcScheduler(Configuration conf, int handlerCount, int priorityHandlerCount, int replicationHandlerCount, PriorityFunction priority, int highPriorityLevel) {
        this(conf, handlerCount, priorityHandlerCount, replicationHandlerCount, priority, null, highPriorityLevel);
    }

    @Override
    public void onConfigurationChange(Configuration conf) {
        String callQueueType;
        this.callExecutor.resizeQueues(conf);
        if (this.priorityExecutor != null) {
            this.priorityExecutor.resizeQueues(conf);
        }
        if (this.replicationExecutor != null) {
            this.replicationExecutor.resizeQueues(conf);
        }
        if (RpcExecutor.isCodelQueueType(callQueueType = conf.get("hbase.ipc.server.callqueue.type", "fifo"))) {
            this.callExecutor.onConfigurationChange(conf);
        }
    }

    @Override
    public void init(RpcScheduler.Context context) {
        this.port = context.getListenerAddress().getPort();
    }

    @Override
    public void start() {
        this.callExecutor.start(this.port);
        if (this.priorityExecutor != null) {
            this.priorityExecutor.start(this.port);
        }
        if (this.replicationExecutor != null) {
            this.replicationExecutor.start(this.port);
        }
    }

    @Override
    public void stop() {
        this.callExecutor.stop();
        if (this.priorityExecutor != null) {
            this.priorityExecutor.stop();
        }
        if (this.replicationExecutor != null) {
            this.replicationExecutor.stop();
        }
    }

    @Override
    public boolean dispatch(CallRunner callTask) throws InterruptedException {
        RpcCall call = callTask.getRpcCall();
        int level = this.priority.getPriority(call.getHeader(), call.getParam(), call.getRequestUser().orElse(null));
        if (level == -1) {
            level = 0;
        }
        if (this.priorityExecutor != null && level > this.highPriorityLevel) {
            return this.priorityExecutor.dispatch(callTask);
        }
        if (this.replicationExecutor != null && level == 5) {
            return this.replicationExecutor.dispatch(callTask);
        }
        return this.callExecutor.dispatch(callTask);
    }

    @Override
    public int getGeneralQueueLength() {
        return this.callExecutor.getQueueLength();
    }

    @Override
    public int getPriorityQueueLength() {
        return this.priorityExecutor == null ? 0 : this.priorityExecutor.getQueueLength();
    }

    @Override
    public int getReplicationQueueLength() {
        return this.replicationExecutor == null ? 0 : this.replicationExecutor.getQueueLength();
    }

    @Override
    public int getActiveRpcHandlerCount() {
        return this.callExecutor.getActiveHandlerCount() + (this.priorityExecutor == null ? 0 : this.priorityExecutor.getActiveHandlerCount()) + (this.replicationExecutor == null ? 0 : this.replicationExecutor.getActiveHandlerCount());
    }

    @Override
    public long getNumGeneralCallsDropped() {
        return this.callExecutor.getNumGeneralCallsDropped();
    }

    @Override
    public long getNumLifoModeSwitches() {
        return this.callExecutor.getNumLifoModeSwitches();
    }

    @Override
    public int getWriteQueueLength() {
        return this.callExecutor.getWriteQueueLength();
    }

    @Override
    public int getReadQueueLength() {
        return this.callExecutor.getReadQueueLength();
    }

    @Override
    public int getScanQueueLength() {
        return this.callExecutor.getScanQueueLength();
    }

    @Override
    public int getActiveWriteRpcHandlerCount() {
        return this.callExecutor.getActiveWriteHandlerCount();
    }

    @Override
    public int getActiveReadRpcHandlerCount() {
        return this.callExecutor.getActiveReadHandlerCount();
    }

    @Override
    public int getActiveScanRpcHandlerCount() {
        return this.callExecutor.getActiveScanHandlerCount();
    }

    @Override
    public CallQueueInfo getCallQueueInfo() {
        String queueName;
        CallQueueInfo callQueueInfo = new CallQueueInfo();
        if (null != this.callExecutor) {
            queueName = "Call Queue";
            callQueueInfo.setCallMethodCount(queueName, this.callExecutor.getCallQueueCountsSummary());
            callQueueInfo.setCallMethodSize(queueName, this.callExecutor.getCallQueueSizeSummary());
        }
        if (null != this.priorityExecutor) {
            queueName = "Priority Queue";
            callQueueInfo.setCallMethodCount(queueName, this.priorityExecutor.getCallQueueCountsSummary());
            callQueueInfo.setCallMethodSize(queueName, this.priorityExecutor.getCallQueueSizeSummary());
        }
        if (null != this.replicationExecutor) {
            queueName = "Replication Queue";
            callQueueInfo.setCallMethodCount(queueName, this.replicationExecutor.getCallQueueCountsSummary());
            callQueueInfo.setCallMethodSize(queueName, this.replicationExecutor.getCallQueueSizeSummary());
        }
        return callQueueInfo;
    }
}

