// Autogenerated Jamon implementation
// /home/stack/hbase.git/hbase-server/src/main/jamon/org/apache/hadoop/hbase/tmpl/master/RegionServerListTmpl.jamon

package org.apache.hadoop.hbase.tmpl.master;

// 27, 9
import java.util.*;
// 28, 9
import org.apache.hadoop.hbase.master.HMaster;
// 29, 9
import org.apache.hadoop.hbase.ServerLoad;
// 30, 9
import org.apache.hadoop.hbase.ServerName;
// 31, 9
import org.apache.hadoop.hbase.util.VersionInfo;
// 32, 9
import org.apache.hadoop.util.StringUtils.TraditionalBinaryPrefix;

public class RegionServerListTmplImpl
  extends org.jamon.AbstractTemplateImpl
  implements org.apache.hadoop.hbase.tmpl.master.RegionServerListTmpl.Intf

{
  private final HMaster master;
  private final List<ServerName> servers;
  protected static org.apache.hadoop.hbase.tmpl.master.RegionServerListTmpl.ImplData __jamon_setOptionalArguments(org.apache.hadoop.hbase.tmpl.master.RegionServerListTmpl.ImplData p_implData)
  {
    if(! p_implData.getServers__IsNotDefault())
    {
      p_implData.setServers(null);
    }
    return p_implData;
  }
  public RegionServerListTmplImpl(org.jamon.TemplateManager p_templateManager, org.apache.hadoop.hbase.tmpl.master.RegionServerListTmpl.ImplData p_implData)
  {
    super(p_templateManager, __jamon_setOptionalArguments(p_implData));
    master = p_implData.getMaster();
    servers = p_implData.getServers();
  }
  
  @Override public void renderNoFlush(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 36, 1
    if ((servers != null && servers.size() > 0))
    {
      // 36, 47
      jamonWriter.write("\n\n");
      // 38, 1
      
ServerName [] serverNames = servers.toArray(new ServerName[servers.size()]);
Arrays.sort(serverNames);

      // 43, 1
      jamonWriter.write("<div class=\"tabbable\">\n    <ul class=\"nav nav-pills\">\n        <li class=\"active\"><a href=\"#tab_baseStats\" data-toggle=\"tab\">Base Stats</a></li>\n        <li class=\"\"><a href=\"#tab_memoryStats\" data-toggle=\"tab\">Memory</a></li>\n        <li class=\"\"><a href=\"#tab_requestStats\" data-toggle=\"tab\">Requests</a></li>\n        <li class=\"\"><a href=\"#tab_storeStats\" data-toggle=\"tab\">Storefiles</a></li>\n        <li class=\"\"><a href=\"#tab_compactStas\" data-toggle=\"tab\">Compactions</a></li>\n    </ul>\n    <div class=\"tab-content\" style=\"padding-bottom: 9px; border-bottom: 1px solid #ddd;\">\n        <div class=\"tab-pane active\" id=\"tab_baseStats\">\n            ");
      // 53, 13
      {
        // 53, 13
        __jamon_innerUnit__baseStats(jamonWriter, serverNames);
      }
      // 53, 56
      jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_memoryStats\">\n            ");
      // 56, 13
      {
        // 56, 13
        __jamon_innerUnit__memoryStats(jamonWriter, serverNames);
      }
      // 56, 58
      jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_requestStats\">\n            ");
      // 59, 13
      {
        // 59, 13
        __jamon_innerUnit__requestStats(jamonWriter, serverNames);
      }
      // 59, 59
      jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_storeStats\">\n            ");
      // 62, 13
      {
        // 62, 13
        __jamon_innerUnit__storeStats(jamonWriter, serverNames);
      }
      // 62, 57
      jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_compactStas\">\n            ");
      // 65, 13
      {
        // 65, 13
        __jamon_innerUnit__compactionStats(jamonWriter, serverNames);
      }
      // 65, 62
      jamonWriter.write("\n        </div>\n    </div>\n</div>\n\n");
    }
    // 70, 7
    jamonWriter.write("\n\n");
  }
  
  
  // 72, 1
  private void __jamon_innerUnit__baseStats(final java.io.Writer jamonWriter, final ServerName[] serverNames)
    throws java.io.IOException
  {
    // 76, 1
    jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <th>ServerName</th>\n    <th>Start time</th>\n    <th>Last contact</th>\n    <th>Version</th>\n    <th>Requests Per Second</th>\n    <th>Num. Regions</th>\n</tr>\n");
    // 85, 1
    
    int totalRegions = 0;
    int totalRequests = 0;
    int inconsistentNodeNum = 0;
    String masterVersion = VersionInfo.getVersion();
    for (ServerName serverName: serverNames) {

    ServerLoad sl = master.getServerManager().getLoad(serverName);
    String version = master.getRegionServerVersion(serverName);
    if (!masterVersion.equals(version)) {
        inconsistentNodeNum ++;
    }

    double requestsPerSecond = 0.0;
    int numRegionsOnline = 0;
    long lastContact = 0;

    if (sl != null) {
        requestsPerSecond = sl.getRequestsPerSecond();
        numRegionsOnline = sl.getNumberOfRegions();
        totalRegions += sl.getNumberOfRegions();
        // Is this correct?  Adding a rate to a measure.
        totalRequests += sl.getNumberOfRequests();
        lastContact = (System.currentTimeMillis() - sl.getReportTime())/1000;
    }
    long startcode = serverName.getStartcode();

    // 112, 1
    jamonWriter.write("<tr>\n    <td>");
    // 113, 9
    {
      // 113, 9
      __jamon_innerUnit__serverNameLink(jamonWriter, serverName, sl);
    }
    // 113, 70
    jamonWriter.write("</td>\n    <td>");
    // 114, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(new Date(startcode)), jamonWriter);
    // 114, 34
    jamonWriter.write("</td>\n    <td>");
    // 115, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(lastContact, "s", 1)), jamonWriter);
    // 115, 71
    jamonWriter.write("</td>\n    <td>");
    // 116, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(version), jamonWriter);
    // 116, 22
    jamonWriter.write("</td>\n    <td>");
    // 117, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%.0f", requestsPerSecond)), jamonWriter);
    // 117, 55
    jamonWriter.write("</td>\n    <td>");
    // 118, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(numRegionsOnline), jamonWriter);
    // 118, 31
    jamonWriter.write("</td>\n</tr>\n");
    // 120, 1
    
}

    // 123, 1
    jamonWriter.write("<tr><td>Total:");
    // 123, 15
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(servers.size()), jamonWriter);
    // 123, 35
    jamonWriter.write("</td>\n<td></td>\n<td></td>\n");
    // 126, 1
    if (inconsistentNodeNum > 0)
    {
      // 126, 31
      jamonWriter.write("\n  <td style=\"color:red;\">");
      // 127, 26
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(inconsistentNodeNum), jamonWriter);
      // 127, 51
      jamonWriter.write(" nodes with inconsistent version</td>\n");
    }
    // 128, 1
    else
    {
      // 128, 8
      jamonWriter.write("\n   <td></td>\n");
    }
    // 130, 7
    jamonWriter.write("\n<td>");
    // 131, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(totalRequests), jamonWriter);
    // 131, 24
    jamonWriter.write("</td>\n<td>");
    // 132, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(totalRegions), jamonWriter);
    // 132, 23
    jamonWriter.write("</td>\n</tr>\n</table>\n");
  }
  
  
  // 258, 1
  private void __jamon_innerUnit__compactionStats(final java.io.Writer jamonWriter, final ServerName[] serverNames)
    throws java.io.IOException
  {
    // 262, 1
    jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <th>ServerName</th>\n    <th>Num. Compacting KVs</th>\n    <th>Num. Compacted KVs</th>\n    <th>Remaining KVs</th>\n    <th>Compaction Progress</th>\n</tr>\n");
    // 270, 1
    
for (ServerName serverName: serverNames) {

ServerLoad sl = master.getServerManager().getLoad(serverName);
if (sl != null) {
String percentDone = "";
if  (sl.getTotalCompactingKVs() > 0) {
     percentDone = String.format("%.2f", 100 *
        ((float) sl.getCurrentCompactedKVs() / sl.getTotalCompactingKVs())) + "%";
}

    // 281, 1
    jamonWriter.write("<tr>\n<td>");
    // 282, 5
    {
      // 282, 5
      __jamon_innerUnit__serverNameLink(jamonWriter, serverName, sl);
    }
    // 282, 66
    jamonWriter.write("</td>\n<td>");
    // 283, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(sl.getTotalCompactingKVs()), jamonWriter);
    // 283, 37
    jamonWriter.write("</td>\n<td>");
    // 284, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(sl.getCurrentCompactedKVs()), jamonWriter);
    // 284, 38
    jamonWriter.write("</td>\n<td>");
    // 285, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(sl.getTotalCompactingKVs() - sl.getCurrentCompactedKVs()), jamonWriter);
    // 285, 67
    jamonWriter.write("</td>\n<td>");
    // 286, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(percentDone), jamonWriter);
    // 286, 22
    jamonWriter.write("</td>\n</tr>\n");
    // 288, 1
    
        }  else {
        
    // 291, 1
    {
      // 291, 1
      __jamon_innerUnit__emptyStat(jamonWriter, serverName);
    }
    // 291, 40
    jamonWriter.write("\n");
    // 292, 1
    
    }
}

    // 296, 1
    jamonWriter.write("</table>\n");
  }
  
  
  // 317, 1
  private void __jamon_innerUnit__emptyStat(final java.io.Writer jamonWriter, final ServerName serverName)
    throws java.io.IOException
  {
    // 321, 5
    jamonWriter.write("<tr>\n    <td>");
    // 322, 9
    {
      // 322, 9
      __jamon_innerUnit__serverNameLink(jamonWriter, serverName, null);
    }
    // 322, 72
    jamonWriter.write("</td>\n    <td></td>\n    <td></td>\n    <td></td>\n    <td></td>\n    <td></td>\n    <td></td>\n    </tr>\n");
  }
  
  
  // 137, 1
  private void __jamon_innerUnit__memoryStats(final java.io.Writer jamonWriter, final ServerName[] serverNames)
    throws java.io.IOException
  {
    // 141, 1
    jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <th>ServerName</th>\n    <th>Used Heap</th>\n    <th>Max Heap</th>\n    <th>Memstore Size</th>\n\n</tr>\n");
    // 149, 1
    
for (ServerName serverName: serverNames) {

    ServerLoad sl = master.getServerManager().getLoad(serverName);
    if (sl != null) {

    // 155, 1
    jamonWriter.write("<tr>\n    <td>");
    // 156, 9
    {
      // 156, 9
      __jamon_innerUnit__serverNameLink(jamonWriter, serverName, sl);
    }
    // 156, 70
    jamonWriter.write("</td>\n    <td>");
    // 157, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(sl.getUsedHeapMB()
      * TraditionalBinaryPrefix.MEGA.value, "B", 1)), jamonWriter);
    // 158, 55
    jamonWriter.write("</td>\n    <td>");
    // 159, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(sl.getMaxHeapMB()
      * TraditionalBinaryPrefix.MEGA.value, "B", 1)), jamonWriter);
    // 160, 55
    jamonWriter.write("</td>\n    <td>");
    // 161, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(sl.getMemStoreSizeMB()
      * TraditionalBinaryPrefix.MEGA.value, "B", 1)), jamonWriter);
    // 162, 55
    jamonWriter.write("</td>\n\n</tr>\n");
    // 165, 1
    
        }  else {

    // 168, 1
    {
      // 168, 1
      __jamon_innerUnit__emptyStat(jamonWriter, serverName);
    }
    // 168, 40
    jamonWriter.write("\n");
    // 169, 1
    
        }
}

    // 173, 1
    jamonWriter.write("</table>\n");
  }
  
  
  // 177, 1
  private void __jamon_innerUnit__requestStats(final java.io.Writer jamonWriter, final ServerName[] serverNames)
    throws java.io.IOException
  {
    // 181, 1
    jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <th>ServerName</th>\n    <th>Request Per Second</th>\n    <th>Read Request Count</th>\n    <th>Filtered Read Request Count</th>\n    <th>Write Request Count</th>\n</tr>\n");
    // 189, 1
    
for (ServerName serverName: serverNames) {

ServerLoad sl = master.getServerManager().getLoad(serverName);
if (sl != null) {

    // 195, 1
    jamonWriter.write("<tr>\n<td>");
    // 196, 5
    {
      // 196, 5
      __jamon_innerUnit__serverNameLink(jamonWriter, serverName, sl);
    }
    // 196, 66
    jamonWriter.write("</td>\n<td>");
    // 197, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%.0f", sl.getRequestsPerSecond())), jamonWriter);
    // 197, 59
    jamonWriter.write("</td>\n<td>");
    // 198, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(sl.getReadRequestsCount()), jamonWriter);
    // 198, 36
    jamonWriter.write("</td>\n<td>");
    // 199, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(sl.getFilteredReadRequestsCount()), jamonWriter);
    // 199, 44
    jamonWriter.write("</td>\n<td>");
    // 200, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(sl.getWriteRequestsCount()), jamonWriter);
    // 200, 37
    jamonWriter.write("</td>\n</tr>\n");
    // 202, 1
    
        }  else {
        
    // 205, 1
    {
      // 205, 1
      __jamon_innerUnit__emptyStat(jamonWriter, serverName);
    }
    // 205, 40
    jamonWriter.write("\n");
    // 206, 1
    
        }
}

    // 210, 1
    jamonWriter.write("</table>\n");
  }
  
  
  // 300, 1
  private void __jamon_innerUnit__serverNameLink(final java.io.Writer jamonWriter, final ServerName serverName, final ServerLoad serverLoad)
    throws java.io.IOException
  {
    // 305, 9
    
        int infoPort = master.getRegionServerInfoPort(serverName);
        String url = "//" + serverName.getHostname() + ":" + infoPort + "/rs-status";
        
    // 310, 9
    if (infoPort > 0)
    {
      // 310, 28
      jamonWriter.write("\n            <a href=\"");
      // 311, 22
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(url), jamonWriter);
      // 311, 31
      jamonWriter.write("\">");
      // 311, 33
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(serverName.getServerName()), jamonWriter);
      // 311, 65
      jamonWriter.write("</a>\n        ");
    }
    // 312, 9
    else
    {
      // 312, 16
      jamonWriter.write("\n            ");
      // 313, 13
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(serverName.getServerName()), jamonWriter);
      // 313, 45
      jamonWriter.write("\n        ");
    }
    // 314, 15
    jamonWriter.write("\n");
  }
  
  
  // 214, 1
  private void __jamon_innerUnit__storeStats(final java.io.Writer jamonWriter, final ServerName[] serverNames)
    throws java.io.IOException
  {
    // 218, 1
    jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <th>ServerName</th>\n    <th>Num. Stores</th>\n    <th>Num. Storefiles</th>\n    <th>Storefile Size Uncompressed</th>\n    <th>Storefile Size</th>\n    <th>Index Size</th>\n    <th>Bloom Size</th>\n</tr>\n");
    // 228, 1
    
for (ServerName serverName: serverNames) {

ServerLoad sl = master.getServerManager().getLoad(serverName);
if (sl != null) {

    // 234, 1
    jamonWriter.write("<tr>\n<td>");
    // 235, 5
    {
      // 235, 5
      __jamon_innerUnit__serverNameLink(jamonWriter, serverName, sl);
    }
    // 235, 66
    jamonWriter.write("</td>\n<td>");
    // 236, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(sl.getStores()), jamonWriter);
    // 236, 25
    jamonWriter.write("</td>\n<td>");
    // 237, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(sl.getStorefiles()), jamonWriter);
    // 237, 29
    jamonWriter.write("</td>\n<td>");
    // 238, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(
  sl.getStoreUncompressedSizeMB() * TraditionalBinaryPrefix.MEGA.value, "B", 1)), jamonWriter);
    // 239, 83
    jamonWriter.write("</td>\n<td>");
    // 240, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(sl.getStorefileSizeMB()
  * TraditionalBinaryPrefix.MEGA.value, "B", 1)), jamonWriter);
    // 241, 51
    jamonWriter.write("</td>\n<td>");
    // 242, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(sl.getTotalStaticIndexSizeKB()
  * TraditionalBinaryPrefix.KILO.value, "B", 1)), jamonWriter);
    // 243, 51
    jamonWriter.write("</td>\n<td>");
    // 244, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(sl.getTotalStaticBloomSizeKB()
  * TraditionalBinaryPrefix.KILO.value, "B", 1)), jamonWriter);
    // 245, 51
    jamonWriter.write("</td>\n</tr>\n");
    // 247, 1
    
        }  else {
        
    // 250, 1
    {
      // 250, 1
      __jamon_innerUnit__emptyStat(jamonWriter, serverName);
    }
    // 250, 40
    jamonWriter.write("\n");
    // 251, 1
    
    }
}

    // 255, 1
    jamonWriter.write("</table>\n");
  }
  
  
}
