/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import com.google.protobuf.TextFormat;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScannable;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.DroppedSnapshotException;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.MultiActionResultTooLarge;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.UnknownScannerException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.conf.ConfigurationObserver;
import org.apache.hadoop.hbase.coordination.CloseRegionCoordination;
import org.apache.hadoop.hbase.coordination.OpenRegionCoordination;
import org.apache.hadoop.hbase.exceptions.FailedSanityCheckException;
import org.apache.hadoop.hbase.exceptions.MergeRegionException;
import org.apache.hadoop.hbase.exceptions.OperationConflictException;
import org.apache.hadoop.hbase.exceptions.OutOfOrderScannerNextException;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.ipc.HBaseRPCErrorHandler;
import org.apache.hadoop.hbase.ipc.PayloadCarryingRpcController;
import org.apache.hadoop.hbase.ipc.PriorityFunction;
import org.apache.hadoop.hbase.ipc.QosPriority;
import org.apache.hadoop.hbase.ipc.RpcCallContext;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.ipc.RpcServerInterface;
import org.apache.hadoop.hbase.ipc.ServerNotRunningYetException;
import org.apache.hadoop.hbase.ipc.ServerRpcController;
import org.apache.hadoop.hbase.master.MasterRpcServices;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.RequestConverter;
import org.apache.hadoop.hbase.protobuf.ResponseConverter;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.ComparatorProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.MapReduceProtos;
import org.apache.hadoop.hbase.protobuf.generated.RPCProtos;
import org.apache.hadoop.hbase.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.quotas.OperationQuota;
import org.apache.hadoop.hbase.quotas.RegionServerQuotaManager;
import org.apache.hadoop.hbase.regionserver.AnnotationReadingPriorityFunction;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.LeaseException;
import org.apache.hadoop.hbase.regionserver.LeaseListener;
import org.apache.hadoop.hbase.regionserver.Leases;
import org.apache.hadoop.hbase.regionserver.NoSuchColumnFamilyException;
import org.apache.hadoop.hbase.regionserver.OperationStatus;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionAlreadyInTransitionException;
import org.apache.hadoop.hbase.regionserver.RegionCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.RegionServerAbortedException;
import org.apache.hadoop.hbase.regionserver.RegionServerStoppedException;
import org.apache.hadoop.hbase.regionserver.RpcSchedulerFactory;
import org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.hadoop.hbase.regionserver.SimpleRpcSchedulerFactory;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.handler.OpenMetaHandler;
import org.apache.hadoop.hbase.regionserver.handler.OpenRegionHandler;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Counter;
import org.apache.hadoop.hbase.util.DNS;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.ServerRegionReplicaUtil;
import org.apache.hadoop.hbase.util.Strings;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALKey;
import org.apache.hadoop.hbase.wal.WALSplitter;
import org.apache.hadoop.hbase.zookeeper.ZKSplitLog;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class RSRpcServices
implements HBaseRPCErrorHandler,
AdminProtos.AdminService.BlockingInterface,
ClientProtos.ClientService.BlockingInterface,
PriorityFunction,
ConfigurationObserver {
    protected static final Log LOG = LogFactory.getLog(RSRpcServices.class);
    public static final String REGION_SERVER_RPC_SCHEDULER_FACTORY_CLASS = "hbase.region.server.rpc.scheduler.factory.class";
    private static final String REGION_SERVER_RPC_MINIMUM_SCAN_TIME_LIMIT_DELTA = "hbase.region.server.rpc.minimum.scan.time.limit.delta";
    private static final long DEFAULT_REGION_SERVER_RPC_MINIMUM_SCAN_TIME_LIMIT_DELTA = 10L;
    final Counter requestCount = new Counter();
    final RpcServerInterface rpcServer;
    final InetSocketAddress isa;
    private final HRegionServer regionServer;
    private final long maxScannerResultSize;
    private final PriorityFunction priority;
    private final AtomicLong scannerIdGen = new AtomicLong(0L);
    private final ConcurrentHashMap<String, RegionScannerHolder> scanners = new ConcurrentHashMap();
    private final int scannerLeaseTimeoutPeriod;
    private final int rpcTimeout;
    private final long minimumScanTimeLimitDelta;

    private static ClientProtos.ResultOrException getResultOrException(ClientProtos.Result r, int index, ClientProtos.RegionLoadStats stats) {
        return RSRpcServices.getResultOrException(ResponseConverter.buildActionResult((ClientProtos.Result)r, (ClientProtos.RegionLoadStats)stats), index);
    }

    private static ClientProtos.ResultOrException getResultOrException(Exception e, int index) {
        return RSRpcServices.getResultOrException(ResponseConverter.buildActionResult((Throwable)e), index);
    }

    private static ClientProtos.ResultOrException getResultOrException(ClientProtos.ResultOrException.Builder builder, int index) {
        return builder.setIndex(index).build();
    }

    private long startNonceOperation(ClientProtos.MutationProto mutation, long nonceGroup) throws IOException, OperationConflictException {
        if (this.regionServer.nonceManager == null || !mutation.hasNonce()) {
            return 0L;
        }
        boolean canProceed = false;
        try {
            canProceed = this.regionServer.nonceManager.startOperation(nonceGroup, mutation.getNonce(), this.regionServer);
        }
        catch (InterruptedException ex) {
            throw new InterruptedIOException("Nonce start operation interrupted");
        }
        if (!canProceed) {
            String message = "The operation with nonce {" + nonceGroup + ", " + mutation.getNonce() + "} on row [" + Bytes.toString((byte[])mutation.getRow().toByteArray()) + "] may have already completed";
            throw new OperationConflictException(message);
        }
        return mutation.getNonce();
    }

    private void endNonceOperation(ClientProtos.MutationProto mutation, long nonceGroup, boolean success) {
        if (this.regionServer.nonceManager != null && mutation.hasNonce()) {
            this.regionServer.nonceManager.endOperation(nonceGroup, mutation.getNonce(), success);
        }
    }

    private boolean isClientCellBlockSupport() {
        RpcCallContext context = RpcServer.getCurrentCall();
        return context != null && context.isClientCellBlockSupported();
    }

    private void addResult(ClientProtos.MutateResponse.Builder builder, Result result, PayloadCarryingRpcController rpcc) {
        if (result == null) {
            return;
        }
        if (this.isClientCellBlockSupport()) {
            builder.setResult(ProtobufUtil.toResultNoData((Result)result));
            rpcc.setCellScanner(result.cellScanner());
        } else {
            ClientProtos.Result pbr = ProtobufUtil.toResult((Result)result);
            builder.setResult(pbr);
        }
    }

    private void addResults(ClientProtos.ScanResponse.Builder builder, List<Result> results, RpcController controller, boolean isDefaultRegion) {
        builder.setStale(!isDefaultRegion);
        if (results == null || results.isEmpty()) {
            return;
        }
        if (this.isClientCellBlockSupport()) {
            for (Result res : results) {
                builder.addCellsPerResult(res.size());
                builder.addPartialFlagPerResult(res.isPartial());
            }
            ((PayloadCarryingRpcController)controller).setCellScanner(CellUtil.createCellScanner(results));
        } else {
            for (Result res : results) {
                ClientProtos.Result pbr = ProtobufUtil.toResult((Result)res);
                builder.addResults(pbr);
            }
        }
    }

    private ClientProtos.RegionLoadStats mutateRows(Region region, List<ClientProtos.Action> actions, CellScanner cellScanner) throws IOException {
        if (!region.getRegionInfo().isMetaTable()) {
            this.regionServer.cacheFlusher.reclaimMemStoreMemory();
        }
        RowMutations rm = null;
        block4: for (ClientProtos.Action action : actions) {
            if (action.hasGet()) {
                throw new DoNotRetryIOException("Atomic put and/or delete only, not a Get=" + action.getGet());
            }
            ClientProtos.MutationProto.MutationType type = action.getMutation().getMutateType();
            if (rm == null) {
                rm = new RowMutations(action.getMutation().getRow().toByteArray());
            }
            switch (type) {
                case PUT: {
                    rm.add(ProtobufUtil.toPut((ClientProtos.MutationProto)action.getMutation(), (CellScanner)cellScanner));
                    continue block4;
                }
                case DELETE: {
                    rm.add(ProtobufUtil.toDelete((ClientProtos.MutationProto)action.getMutation(), (CellScanner)cellScanner));
                    continue block4;
                }
            }
            throw new DoNotRetryIOException("Atomic put and/or delete only, not " + type.name());
        }
        region.mutateRow(rm);
        return ((HRegion)region).getRegionStats();
    }

    private boolean checkAndRowMutate(Region region, List<ClientProtos.Action> actions, CellScanner cellScanner, byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, ByteArrayComparable comparator) throws IOException {
        if (!region.getRegionInfo().isMetaTable()) {
            this.regionServer.cacheFlusher.reclaimMemStoreMemory();
        }
        RowMutations rm = null;
        block4: for (ClientProtos.Action action : actions) {
            if (action.hasGet()) {
                throw new DoNotRetryIOException("Atomic put and/or delete only, not a Get=" + action.getGet());
            }
            ClientProtos.MutationProto.MutationType type = action.getMutation().getMutateType();
            if (rm == null) {
                rm = new RowMutations(action.getMutation().getRow().toByteArray());
            }
            switch (type) {
                case PUT: {
                    rm.add(ProtobufUtil.toPut((ClientProtos.MutationProto)action.getMutation(), (CellScanner)cellScanner));
                    continue block4;
                }
                case DELETE: {
                    rm.add(ProtobufUtil.toDelete((ClientProtos.MutationProto)action.getMutation(), (CellScanner)cellScanner));
                    continue block4;
                }
            }
            throw new DoNotRetryIOException("Atomic put and/or delete only, not " + type.name());
        }
        return region.checkAndRowMutate(row, family, qualifier, compareOp, comparator, rm, Boolean.TRUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result append(Region region, OperationQuota quota, ClientProtos.MutationProto m, CellScanner cellScanner, long nonceGroup) throws IOException {
        long before = EnvironmentEdgeManager.currentTime();
        Append append = ProtobufUtil.toAppend((ClientProtos.MutationProto)m, (CellScanner)cellScanner);
        quota.addMutation((Mutation)append);
        Result r = null;
        if (region.getCoprocessorHost() != null) {
            r = region.getCoprocessorHost().preAppend(append);
        }
        if (r == null) {
            long nonce = this.startNonceOperation(m, nonceGroup);
            boolean success = false;
            try {
                r = region.append(append, nonceGroup, nonce);
                success = true;
            }
            finally {
                this.endNonceOperation(m, nonceGroup, success);
            }
            if (region.getCoprocessorHost() != null) {
                region.getCoprocessorHost().postAppend(append, r);
            }
        }
        if (this.regionServer.metricsRegionServer != null) {
            this.regionServer.metricsRegionServer.updateAppend(EnvironmentEdgeManager.currentTime() - before);
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result increment(Region region, OperationQuota quota, ClientProtos.MutationProto mutation, CellScanner cells, long nonceGroup) throws IOException {
        long before = EnvironmentEdgeManager.currentTime();
        Increment increment = ProtobufUtil.toIncrement((ClientProtos.MutationProto)mutation, (CellScanner)cells);
        quota.addMutation((Mutation)increment);
        Result r = null;
        if (region.getCoprocessorHost() != null) {
            r = region.getCoprocessorHost().preIncrement(increment);
        }
        if (r == null) {
            long nonce = this.startNonceOperation(mutation, nonceGroup);
            boolean success = false;
            try {
                r = region.increment(increment, nonceGroup, nonce);
                success = true;
            }
            finally {
                this.endNonceOperation(mutation, nonceGroup, success);
            }
            if (region.getCoprocessorHost() != null) {
                r = region.getCoprocessorHost().postIncrement(increment, r);
            }
        }
        if (this.regionServer.metricsRegionServer != null) {
            this.regionServer.metricsRegionServer.updateIncrement(EnvironmentEdgeManager.currentTime() - before);
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<CellScannable> doNonAtomicRegionMutation(Region region, OperationQuota quota, ClientProtos.RegionAction actions, CellScanner cellScanner, ClientProtos.RegionActionResult.Builder builder, List<CellScannable> cellsToReturn, long nonceGroup) {
        ArrayList<ClientProtos.Action> mutations = null;
        long maxQuotaResultSize = Math.min(this.maxScannerResultSize, quota.getReadAvailable());
        RpcCallContext context = RpcServer.getCurrentCall();
        MultiActionResultTooLarge sizeIOE = null;
        Object lastBlock = null;
        for (ClientProtos.Action action : actions.getActionList()) {
            ClientProtos.ResultOrException.Builder resultOrExceptionBuilder = null;
            try {
                Result r = null;
                if (context != null && context.isRetryImmediatelySupported() && (context.getResponseCellSize() > maxQuotaResultSize || context.getResponseBlockSize() > maxQuotaResultSize)) {
                    if (sizeIOE == null) {
                        sizeIOE = new MultiActionResultTooLarge("Max size exceeded CellSize: " + context.getResponseCellSize() + " BlockSize: " + context.getResponseBlockSize());
                        this.rpcServer.getMetrics().exception((Throwable)sizeIOE);
                    }
                    resultOrExceptionBuilder = ClientProtos.ResultOrException.newBuilder().setException(ResponseConverter.buildException(sizeIOE));
                    resultOrExceptionBuilder.setIndex(action.getIndex());
                    builder.addResultOrException(resultOrExceptionBuilder.build());
                    if (cellScanner == null) continue;
                    this.skipCellsForMutation(action, cellScanner);
                    continue;
                }
                if (action.hasGet()) {
                    long before = EnvironmentEdgeManager.currentTime();
                    try {
                        Get get = ProtobufUtil.toGet((ClientProtos.Get)action.getGet());
                        r = region.get(get);
                    }
                    finally {
                        if (this.regionServer.metricsRegionServer != null) {
                            this.regionServer.metricsRegionServer.updateGet(EnvironmentEdgeManager.currentTime() - before);
                        }
                    }
                } else if (action.hasServiceCall()) {
                    resultOrExceptionBuilder = ClientProtos.ResultOrException.newBuilder();
                    try {
                        Message result = this.execServiceOnRegion(region, action.getServiceCall());
                        ClientProtos.CoprocessorServiceResult.Builder serviceResultBuilder = ClientProtos.CoprocessorServiceResult.newBuilder();
                        resultOrExceptionBuilder.setServiceResult(serviceResultBuilder.setValue(serviceResultBuilder.getValueBuilder().setName(result.getClass().getName()).setValue(result.toByteString())));
                    }
                    catch (IOException ioe) {
                        this.rpcServer.getMetrics().exception(ioe);
                        resultOrExceptionBuilder.setException(ResponseConverter.buildException((Throwable)ioe));
                    }
                } else if (action.hasMutation()) {
                    ClientProtos.MutationProto.MutationType type = action.getMutation().getMutateType();
                    if (type != ClientProtos.MutationProto.MutationType.PUT && type != ClientProtos.MutationProto.MutationType.DELETE && mutations != null && !mutations.isEmpty()) {
                        this.doBatchOp(builder, region, quota, mutations, cellScanner);
                        mutations.clear();
                    }
                    switch (type) {
                        case APPEND: {
                            r = this.append(region, quota, action.getMutation(), cellScanner, nonceGroup);
                            break;
                        }
                        case INCREMENT: {
                            r = this.increment(region, quota, action.getMutation(), cellScanner, nonceGroup);
                            break;
                        }
                        case PUT: 
                        case DELETE: {
                            if (mutations == null) {
                                mutations = new ArrayList<ClientProtos.Action>(actions.getActionCount());
                            }
                            mutations.add(action);
                            break;
                        }
                        default: {
                            throw new DoNotRetryIOException("Unsupported mutate type: " + type.name());
                        }
                    }
                } else {
                    throw new HBaseIOException("Unexpected Action type");
                }
                if (r != null) {
                    ClientProtos.Result pbResult = null;
                    if (this.isClientCellBlockSupport()) {
                        pbResult = ProtobufUtil.toResultNoData((Result)r);
                        if (cellsToReturn == null) {
                            cellsToReturn = new ArrayList<CellScannable>();
                        }
                        cellsToReturn.add((CellScannable)r);
                    } else {
                        pbResult = ProtobufUtil.toResult((Result)r);
                    }
                    lastBlock = this.addSize(context, r, lastBlock);
                    resultOrExceptionBuilder = ClientProtos.ResultOrException.newBuilder().setResult(pbResult);
                }
            }
            catch (IOException ie) {
                this.rpcServer.getMetrics().exception(ie);
                resultOrExceptionBuilder = ClientProtos.ResultOrException.newBuilder().setException(ResponseConverter.buildException((Throwable)ie));
            }
            if (resultOrExceptionBuilder == null) continue;
            resultOrExceptionBuilder.setIndex(action.getIndex());
            builder.addResultOrException(resultOrExceptionBuilder.build());
        }
        if (mutations != null && !mutations.isEmpty()) {
            this.doBatchOp(builder, region, quota, (List<ClientProtos.Action>)mutations, cellScanner);
        }
        return cellsToReturn;
    }

    private void doBatchOp(ClientProtos.RegionActionResult.Builder builder, Region region, OperationQuota quota, List<ClientProtos.Action> mutations, CellScanner cells) {
        Mutation[] mArray = new Mutation[mutations.size()];
        long before = EnvironmentEdgeManager.currentTime();
        boolean batchContainsPuts = false;
        boolean batchContainsDelete = false;
        try {
            int i = 0;
            for (ClientProtos.Action action : mutations) {
                Put mutation;
                ClientProtos.MutationProto m = action.getMutation();
                if (m.getMutateType() == ClientProtos.MutationProto.MutationType.PUT) {
                    mutation = ProtobufUtil.toPut((ClientProtos.MutationProto)m, (CellScanner)cells);
                    batchContainsPuts = true;
                } else {
                    mutation = ProtobufUtil.toDelete((ClientProtos.MutationProto)m, (CellScanner)cells);
                    batchContainsDelete = true;
                }
                mArray[i++] = mutation;
                quota.addMutation((Mutation)mutation);
            }
            if (!region.getRegionInfo().isMetaTable()) {
                this.regionServer.cacheFlusher.reclaimMemStoreMemory();
            }
            OperationStatus[] codes = region.batchMutate(mArray, 0L, 0L);
            block8: for (i = 0; i < codes.length; ++i) {
                int index = mutations.get(i).getIndex();
                NoSuchColumnFamilyException e = null;
                switch (codes[i].getOperationStatusCode()) {
                    case BAD_FAMILY: {
                        e = new NoSuchColumnFamilyException(codes[i].getExceptionMsg());
                        builder.addResultOrException(RSRpcServices.getResultOrException((Exception)e, index));
                        continue block8;
                    }
                    case SANITY_CHECK_FAILURE: {
                        e = new FailedSanityCheckException(codes[i].getExceptionMsg());
                        builder.addResultOrException(RSRpcServices.getResultOrException((Exception)e, index));
                        continue block8;
                    }
                    default: {
                        e = new DoNotRetryIOException(codes[i].getExceptionMsg());
                        builder.addResultOrException(RSRpcServices.getResultOrException((Exception)e, index));
                        continue block8;
                    }
                    case SUCCESS: {
                        builder.addResultOrException(RSRpcServices.getResultOrException(ClientProtos.Result.getDefaultInstance(), index, ((HRegion)region).getRegionStats()));
                    }
                }
            }
        }
        catch (IOException ie) {
            for (int i = 0; i < mutations.size(); ++i) {
                builder.addResultOrException(RSRpcServices.getResultOrException(ie, mutations.get(i).getIndex()));
            }
        }
        if (this.regionServer.metricsRegionServer != null) {
            long after = EnvironmentEdgeManager.currentTime();
            if (batchContainsPuts) {
                this.regionServer.metricsRegionServer.updatePut(after - before);
            }
            if (batchContainsDelete) {
                this.regionServer.metricsRegionServer.updateDelete(after - before);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationStatus[] doReplayBatchOp(Region region, List<WALSplitter.MutationReplay> mutations, long replaySeqId) throws IOException {
        long before = EnvironmentEdgeManager.currentTime();
        boolean batchContainsPuts = false;
        boolean batchContainsDelete = false;
        try {
            Iterator<WALSplitter.MutationReplay> it = mutations.iterator();
            while (it.hasNext()) {
                NavigableMap map;
                List metaCells;
                WALSplitter.MutationReplay m = it.next();
                if (m.type == ClientProtos.MutationProto.MutationType.PUT) {
                    batchContainsPuts = true;
                } else {
                    batchContainsDelete = true;
                }
                if ((metaCells = (List)(map = m.mutation.getFamilyCellMap()).get(WALEdit.METAFAMILY)) == null || metaCells.isEmpty()) continue;
                for (Cell metaCell : metaCells) {
                    WALProtos.CompactionDescriptor compactionDesc = WALEdit.getCompaction(metaCell);
                    boolean isDefaultReplica = RegionReplicaUtil.isDefaultReplica((HRegionInfo)region.getRegionInfo());
                    HRegion hRegion = (HRegion)region;
                    if (compactionDesc != null) {
                        hRegion.replayWALCompactionMarker(compactionDesc, !isDefaultReplica, isDefaultReplica, replaySeqId);
                        continue;
                    }
                    WALProtos.FlushDescriptor flushDesc = WALEdit.getFlushDescriptor(metaCell);
                    if (flushDesc != null && !isDefaultReplica) {
                        hRegion.replayWALFlushMarker(flushDesc, replaySeqId);
                        continue;
                    }
                    WALProtos.RegionEventDescriptor regionEvent = WALEdit.getRegionEventDescriptor(metaCell);
                    if (regionEvent != null && !isDefaultReplica) {
                        hRegion.replayWALRegionEventMarker(regionEvent);
                        continue;
                    }
                    WALProtos.BulkLoadDescriptor bulkLoadEvent = WALEdit.getBulkLoadDescriptor(metaCell);
                    if (bulkLoadEvent == null) continue;
                    hRegion.replayWALBulkLoadEventMarker(bulkLoadEvent);
                }
                it.remove();
            }
            this.requestCount.add((long)mutations.size());
            if (!region.getRegionInfo().isMetaTable()) {
                this.regionServer.cacheFlusher.reclaimMemStoreMemory();
            }
            OperationStatus[] operationStatusArray = region.batchReplay(mutations.toArray(new WALSplitter.MutationReplay[mutations.size()]), replaySeqId);
            return operationStatusArray;
        }
        finally {
            if (this.regionServer.metricsRegionServer != null) {
                long after = EnvironmentEdgeManager.currentTime();
                if (batchContainsPuts) {
                    this.regionServer.metricsRegionServer.updatePut(after - before);
                }
                if (batchContainsDelete) {
                    this.regionServer.metricsRegionServer.updateDelete(after - before);
                }
            }
        }
    }

    private void closeAllScanners() {
        for (Map.Entry<String, RegionScannerHolder> e : this.scanners.entrySet()) {
            try {
                e.getValue().s.close();
            }
            catch (IOException ioe) {
                LOG.warn((Object)("Closing scanner " + e.getKey()), (Throwable)ioe);
            }
        }
    }

    public RSRpcServices(HRegionServer rs) throws IOException {
        InetSocketAddress bindAddress;
        InetSocketAddress initialIsa;
        int port;
        String hostname;
        RpcSchedulerFactory rpcSchedulerFactory;
        this.regionServer = rs;
        try {
            Class rpcSchedulerFactoryClass = rs.conf.getClass(REGION_SERVER_RPC_SCHEDULER_FACTORY_CLASS, SimpleRpcSchedulerFactory.class);
            rpcSchedulerFactory = (RpcSchedulerFactory)rpcSchedulerFactoryClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
        if (this instanceof MasterRpcServices) {
            hostname = RSRpcServices.getHostname(rs.conf, true);
            port = rs.conf.getInt("hbase.master.port", 16000);
            initialIsa = new InetSocketAddress(hostname, port);
            bindAddress = new InetSocketAddress(rs.conf.get("hbase.master.ipc.address", hostname), port);
        } else {
            hostname = RSRpcServices.getHostname(rs.conf, false);
            port = rs.conf.getInt("hbase.regionserver.port", 16020);
            initialIsa = new InetSocketAddress(hostname, port);
            bindAddress = new InetSocketAddress(rs.conf.get("hbase.regionserver.ipc.address", hostname), port);
        }
        if (initialIsa.getAddress() == null) {
            throw new IllegalArgumentException("Failed resolve of " + initialIsa);
        }
        this.priority = this.createPriority();
        String name = rs.getProcessName() + "/" + initialIsa.toString();
        ConnectionUtils.setServerSideHConnectionRetriesConfig((Configuration)rs.conf, (String)name, (Log)LOG);
        try {
            this.rpcServer = new RpcServer(rs, name, this.getServices(), bindAddress, rs.conf, rpcSchedulerFactory.create(rs.conf, this, rs));
        }
        catch (BindException be) {
            String configName = this instanceof MasterRpcServices ? "hbase.master.port" : "hbase.regionserver.port";
            throw new IOException(be.getMessage() + ". To switch ports use the '" + configName + "' configuration property.", be.getCause() != null ? be.getCause() : be);
        }
        this.scannerLeaseTimeoutPeriod = rs.conf.getInt("hbase.client.scanner.timeout.period", 60000);
        this.maxScannerResultSize = rs.conf.getLong("hbase.server.scanner.max.result.size", 0x6400000L);
        this.rpcTimeout = rs.conf.getInt("hbase.rpc.timeout", 60000);
        this.minimumScanTimeLimitDelta = rs.conf.getLong(REGION_SERVER_RPC_MINIMUM_SCAN_TIME_LIMIT_DELTA, 10L);
        InetSocketAddress address = this.rpcServer.getListenerAddress();
        if (address == null) {
            throw new IOException("Listener channel is closed");
        }
        this.isa = new InetSocketAddress(initialIsa.getHostName(), address.getPort());
        this.rpcServer.setErrorHandler(this);
        rs.setName(name);
    }

    @Override
    public void onConfigurationChange(Configuration newConf) {
        if (this.rpcServer instanceof ConfigurationObserver) {
            ((ConfigurationObserver)((Object)this.rpcServer)).onConfigurationChange(newConf);
        }
    }

    protected PriorityFunction createPriority() {
        return new AnnotationReadingPriorityFunction(this);
    }

    public static String getHostname(Configuration conf, boolean isMaster) throws UnknownHostException {
        String hostname = conf.get(isMaster ? "hbase.master.hostname" : "hbase.regionserver.hostname");
        if (hostname == null || hostname.isEmpty()) {
            String masterOrRS = isMaster ? "master" : "regionserver";
            return Strings.domainNamePointerToHostName((String)DNS.getDefaultHost((String)conf.get("hbase." + masterOrRS + ".dns.interface", "default"), (String)conf.get("hbase." + masterOrRS + ".dns.nameserver", "default")));
        }
        LOG.info((Object)("hostname is configured to be " + hostname));
        return hostname;
    }

    RegionScanner getScanner(long scannerId) {
        String scannerIdString = Long.toString(scannerId);
        RegionScannerHolder scannerHolder = this.scanners.get(scannerIdString);
        if (scannerHolder != null) {
            return scannerHolder.s;
        }
        return null;
    }

    long getScannerVirtualTime(long scannerId) {
        String scannerIdString = Long.toString(scannerId);
        RegionScannerHolder scannerHolder = this.scanners.get(scannerIdString);
        if (scannerHolder != null) {
            return scannerHolder.getNextCallSeq();
        }
        return 0L;
    }

    long addScanner(RegionScanner s, Region r) throws Leases.LeaseStillHeldException {
        long scannerId = this.scannerIdGen.incrementAndGet();
        String scannerName = String.valueOf(scannerId);
        RegionScannerHolder existing = this.scanners.putIfAbsent(scannerName, new RegionScannerHolder(s, r));
        assert (existing == null) : "scannerId must be unique within regionserver's whole lifecycle!";
        this.regionServer.leases.createLease(scannerName, this.scannerLeaseTimeoutPeriod, new ScannerListener(scannerName));
        return scannerId;
    }

    Object addSize(RpcCallContext context, Result r, Object lastBlock) {
        if (context != null && !r.isEmpty()) {
            for (Cell c : r.rawCells()) {
                context.incrementResponseCellSize(CellUtil.estimatedHeapSizeOf((Cell)c));
                byte[] valueArray = c.getValueArray();
                if (valueArray == lastBlock) continue;
                context.incrementResponseBlockSize(valueArray.length);
                lastBlock = valueArray;
            }
        }
        return lastBlock;
    }

    Region getRegion(HBaseProtos.RegionSpecifier regionSpecifier) throws IOException {
        return this.regionServer.getRegionByEncodedName(regionSpecifier.getValue().toByteArray(), ProtobufUtil.getRegionEncodedName((HBaseProtos.RegionSpecifier)regionSpecifier));
    }

    @VisibleForTesting
    public PriorityFunction getPriority() {
        return this.priority;
    }

    @VisibleForTesting
    public Configuration getConfiguration() {
        return this.regionServer.getConfiguration();
    }

    private RegionServerQuotaManager getQuotaManager() {
        return this.regionServer.getRegionServerQuotaManager();
    }

    void start() {
        this.rpcServer.start();
    }

    void stop() {
        this.closeAllScanners();
        this.rpcServer.stop();
    }

    protected void checkOpen() throws IOException {
        if (this.regionServer.isAborted()) {
            throw new RegionServerAbortedException("Server " + this.regionServer.serverName + " aborting");
        }
        if (this.regionServer.isStopped()) {
            throw new RegionServerStoppedException("Server " + this.regionServer.serverName + " stopping");
        }
        if (!this.regionServer.fsOk) {
            throw new RegionServerStoppedException("File system not available");
        }
        if (!this.regionServer.isOnline()) {
            throw new ServerNotRunningYetException("Server is not running yet");
        }
    }

    protected List<RpcServer.BlockingServiceAndInterface> getServices() {
        ArrayList<RpcServer.BlockingServiceAndInterface> bssi = new ArrayList<RpcServer.BlockingServiceAndInterface>(2);
        bssi.add(new RpcServer.BlockingServiceAndInterface(ClientProtos.ClientService.newReflectiveBlockingService((ClientProtos.ClientService.BlockingInterface)this), ClientProtos.ClientService.BlockingInterface.class));
        bssi.add(new RpcServer.BlockingServiceAndInterface(AdminProtos.AdminService.newReflectiveBlockingService((AdminProtos.AdminService.BlockingInterface)this), AdminProtos.AdminService.BlockingInterface.class));
        return bssi;
    }

    public InetSocketAddress getSocketAddress() {
        return this.isa;
    }

    @Override
    public int getPriority(RPCProtos.RequestHeader header, Message param, User user) {
        return this.priority.getPriority(header, param, user);
    }

    @Override
    public long getDeadline(RPCProtos.RequestHeader header, Message param) {
        return this.priority.getDeadline(header, param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkOOME(Throwable e) {
        boolean stop = false;
        try {
            if (e instanceof OutOfMemoryError || e.getCause() != null && e.getCause() instanceof OutOfMemoryError || e.getMessage() != null && e.getMessage().contains("java.lang.OutOfMemoryError")) {
                stop = true;
                LOG.fatal((Object)("Run out of memory; " + this.getClass().getSimpleName() + " will abort itself immediately"), e);
            }
        }
        finally {
            if (stop) {
                Runtime.getRuntime().halt(1);
            }
        }
        return stop;
    }

    @QosPriority(priority=100)
    public AdminProtos.CloseRegionResponse closeRegion(RpcController controller, AdminProtos.CloseRegionRequest request) throws ServiceException {
        ServerName sn = request.hasDestinationServer() ? ProtobufUtil.toServerName((HBaseProtos.ServerName)request.getDestinationServer()) : null;
        try {
            String encodedRegionName;
            Region region;
            this.checkOpen();
            if (request.hasServerStartCode()) {
                long serverStartCode = request.getServerStartCode();
                if (this.regionServer.serverName.getStartcode() != serverStartCode) {
                    throw new ServiceException((Throwable)new DoNotRetryIOException("This RPC was intended for a different server with startCode: " + serverStartCode + ", this server is: " + this.regionServer.serverName));
                }
            }
            if ((region = this.regionServer.getFromOnlineRegions(encodedRegionName = ProtobufUtil.getRegionEncodedName((HBaseProtos.RegionSpecifier)request.getRegion()))) != null && region.getCoprocessorHost() != null) {
                region.getCoprocessorHost().preClose(false);
            }
            this.requestCount.increment();
            LOG.info((Object)("Close " + encodedRegionName + ", moving to " + sn));
            CloseRegionCoordination.CloseRegionDetails crd = this.regionServer.getCoordinatedStateManager().getCloseRegionCoordination().parseFromProtoRequest(request);
            boolean closed = this.regionServer.closeRegion(encodedRegionName, false, crd, sn);
            AdminProtos.CloseRegionResponse.Builder builder = AdminProtos.CloseRegionResponse.newBuilder().setClosed(closed);
            return builder.build();
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
    }

    @QosPriority(priority=100)
    public AdminProtos.CompactRegionResponse compactRegion(RpcController controller, AdminProtos.CompactRegionRequest request) throws ServiceException {
        try {
            String familyLogMsg;
            this.checkOpen();
            this.requestCount.increment();
            Region region = this.getRegion(request.getRegion());
            region.startRegionOperation(Region.Operation.COMPACT_REGION);
            LOG.info((Object)("Compacting " + region.getRegionInfo().getRegionNameAsString()));
            boolean major = false;
            byte[] family = null;
            Store store = null;
            if (request.hasFamily() && (store = region.getStore(family = request.getFamily().toByteArray())) == null) {
                throw new ServiceException((Throwable)new IOException("column family " + Bytes.toString((byte[])family) + " does not exist in region " + region.getRegionInfo().getRegionNameAsString()));
            }
            if (request.hasMajor()) {
                major = request.getMajor();
            }
            if (major) {
                if (family != null) {
                    store.triggerMajorCompaction();
                } else {
                    region.triggerMajorCompaction();
                }
            }
            String string = familyLogMsg = family != null ? " for column family: " + Bytes.toString((byte[])family) : "";
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("User-triggered compaction requested for region " + region.getRegionInfo().getRegionNameAsString() + familyLogMsg));
            }
            String log = "User-triggered " + (major ? "major " : "") + "compaction" + familyLogMsg;
            if (family != null) {
                this.regionServer.compactSplitThread.requestCompaction(region, store, log, 1, null, RpcServer.getRequestUser());
            } else {
                this.regionServer.compactSplitThread.requestCompaction(region, log, 1, null, RpcServer.getRequestUser());
            }
            return AdminProtos.CompactRegionResponse.newBuilder().build();
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
    }

    @QosPriority(priority=100)
    public AdminProtos.FlushRegionResponse flushRegion(RpcController controller, AdminProtos.FlushRegionRequest request) throws ServiceException {
        try {
            this.checkOpen();
            this.requestCount.increment();
            Region region = this.getRegion(request.getRegion());
            LOG.info((Object)("Flushing " + region.getRegionInfo().getRegionNameAsString()));
            boolean shouldFlush = true;
            if (request.hasIfOlderThanTs()) {
                shouldFlush = region.getEarliestFlushTimeForAllStores() < request.getIfOlderThanTs();
            }
            AdminProtos.FlushRegionResponse.Builder builder = AdminProtos.FlushRegionResponse.newBuilder();
            if (shouldFlush) {
                boolean compactionNeeded;
                boolean writeFlushWalMarker = request.hasWriteFlushWalMarker() ? request.getWriteFlushWalMarker() : false;
                long startTime = EnvironmentEdgeManager.currentTime();
                HRegion.FlushResultImpl flushResult = (HRegion.FlushResultImpl)((HRegion)region).flushcache(true, writeFlushWalMarker);
                if (flushResult.isFlushSucceeded()) {
                    long endTime = EnvironmentEdgeManager.currentTime();
                    this.regionServer.metricsRegionServer.updateFlushTime(endTime - startTime);
                }
                if (compactionNeeded = flushResult.isCompactionNeeded()) {
                    this.regionServer.compactSplitThread.requestSystemCompaction(region, "Compaction through user triggered flush");
                }
                builder.setFlushed(flushResult.isFlushSucceeded());
                builder.setWroteFlushWalMarker(flushResult.wroteFlushWalMarker);
            }
            builder.setLastFlushTime(region.getEarliestFlushTimeForAllStores());
            return builder.build();
        }
        catch (DroppedSnapshotException ex) {
            this.regionServer.abort("Replay of WAL required. Forcing server shutdown", ex);
            throw new ServiceException((Throwable)ex);
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
    }

    @QosPriority(priority=100)
    public AdminProtos.GetOnlineRegionResponse getOnlineRegion(RpcController controller, AdminProtos.GetOnlineRegionRequest request) throws ServiceException {
        try {
            this.checkOpen();
            this.requestCount.increment();
            Map<String, Region> onlineRegions = this.regionServer.onlineRegions;
            ArrayList<HRegionInfo> list = new ArrayList<HRegionInfo>(onlineRegions.size());
            for (Region region : onlineRegions.values()) {
                list.add(region.getRegionInfo());
            }
            Collections.sort(list);
            return ResponseConverter.buildGetOnlineRegionResponse(list);
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
    }

    @QosPriority(priority=100)
    public AdminProtos.GetRegionInfoResponse getRegionInfo(RpcController controller, AdminProtos.GetRegionInfoRequest request) throws ServiceException {
        try {
            this.checkOpen();
            this.requestCount.increment();
            Region region = this.getRegion(request.getRegion());
            HRegionInfo info = region.getRegionInfo();
            AdminProtos.GetRegionInfoResponse.Builder builder = AdminProtos.GetRegionInfoResponse.newBuilder();
            builder.setRegionInfo(HRegionInfo.convert((HRegionInfo)info));
            if (request.hasCompactionState() && request.getCompactionState()) {
                builder.setCompactionState(region.getCompactionState());
            }
            builder.setIsRecovering(region.isRecovering());
            return builder.build();
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
    }

    @QosPriority(priority=100)
    public AdminProtos.GetServerInfoResponse getServerInfo(RpcController controller, AdminProtos.GetServerInfoRequest request) throws ServiceException {
        try {
            this.checkOpen();
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
        this.requestCount.increment();
        int infoPort = this.regionServer.infoServer != null ? this.regionServer.infoServer.getPort() : -1;
        return ResponseConverter.buildGetServerInfoResponse((ServerName)this.regionServer.serverName, (int)infoPort);
    }

    @QosPriority(priority=100)
    public AdminProtos.GetStoreFileResponse getStoreFile(RpcController controller, AdminProtos.GetStoreFileRequest request) throws ServiceException {
        try {
            TreeSet<byte[]> columnFamilies;
            this.checkOpen();
            Region region = this.getRegion(request.getRegion());
            this.requestCount.increment();
            if (request.getFamilyCount() == 0) {
                columnFamilies = region.getTableDesc().getFamiliesKeys();
            } else {
                columnFamilies = new TreeSet<byte[]>((Comparator<byte[]>)Bytes.BYTES_RAWCOMPARATOR);
                for (ByteString cf : request.getFamilyList()) {
                    columnFamilies.add(cf.toByteArray());
                }
            }
            int nCF = columnFamilies.size();
            List<String> fileList = region.getStoreFileList((byte[][])columnFamilies.toArray((T[])new byte[nCF][]));
            AdminProtos.GetStoreFileResponse.Builder builder = AdminProtos.GetStoreFileResponse.newBuilder();
            builder.addAllStoreFile(fileList);
            return builder.build();
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
    }

    @QosPriority(priority=100)
    public AdminProtos.MergeRegionsResponse mergeRegions(RpcController controller, AdminProtos.MergeRegionsRequest request) throws ServiceException {
        try {
            long endTime;
            this.checkOpen();
            this.requestCount.increment();
            Region regionA = this.getRegion(request.getRegionA());
            Region regionB = this.getRegion(request.getRegionB());
            boolean forcible = request.getForcible();
            long masterSystemTime = request.hasMasterSystemTime() ? request.getMasterSystemTime() : -1L;
            regionA.startRegionOperation(Region.Operation.MERGE_REGION);
            regionB.startRegionOperation(Region.Operation.MERGE_REGION);
            if (regionA.getRegionInfo().getReplicaId() != 0 || regionB.getRegionInfo().getReplicaId() != 0) {
                throw new ServiceException((Throwable)new MergeRegionException("Can't merge non-default replicas"));
            }
            LOG.info((Object)("Receiving merging request for  " + regionA + ", " + regionB + ",forcible=" + forcible));
            long startTime = EnvironmentEdgeManager.currentTime();
            Region.FlushResult flushResult = regionA.flush(true);
            if (flushResult.isFlushSucceeded()) {
                endTime = EnvironmentEdgeManager.currentTime();
                this.regionServer.metricsRegionServer.updateFlushTime(endTime - startTime);
            }
            startTime = EnvironmentEdgeManager.currentTime();
            flushResult = regionB.flush(true);
            if (flushResult.isFlushSucceeded()) {
                endTime = EnvironmentEdgeManager.currentTime();
                this.regionServer.metricsRegionServer.updateFlushTime(endTime - startTime);
            }
            this.regionServer.compactSplitThread.requestRegionsMerge(regionA, regionB, forcible, masterSystemTime, RpcServer.getRequestUser());
            return AdminProtos.MergeRegionsResponse.newBuilder().build();
        }
        catch (DroppedSnapshotException ex) {
            this.regionServer.abort("Replay of WAL required. Forcing server shutdown", ex);
            throw new ServiceException((Throwable)ex);
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @QosPriority(priority=100)
    public AdminProtos.OpenRegionResponse openRegion(RpcController controller, AdminProtos.OpenRegionRequest request) throws ServiceException {
        this.requestCount.increment();
        if (request.hasServerStartCode()) {
            long serverStartCode = request.getServerStartCode();
            if (this.regionServer.serverName.getStartcode() != serverStartCode) {
                throw new ServiceException((Throwable)new DoNotRetryIOException("This RPC was intended for a different server with startCode: " + serverStartCode + ", this server is: " + this.regionServer.serverName));
            }
        }
        AdminProtos.OpenRegionResponse.Builder builder = AdminProtos.OpenRegionResponse.newBuilder();
        int regionCount = request.getOpenInfoCount();
        HashMap<TableName, HTableDescriptor> htds = new HashMap<TableName, HTableDescriptor>(regionCount);
        boolean isBulkAssign = regionCount > 1;
        try {
            this.checkOpen();
        }
        catch (IOException ie) {
            HBaseProtos.RegionInfo ri;
            TableName tableName = null;
            if (regionCount == 1 && (ri = request.getOpenInfo(0).getRegion()) != null) {
                tableName = ProtobufUtil.toTableName((HBaseProtos.TableName)ri.getTableName());
            }
            if (!TableName.META_TABLE_NAME.equals(tableName)) {
                throw new ServiceException((Throwable)ie);
            }
            int timeout = this.regionServer.conf.getInt("hbase.rpc.timeout", 60000) >> 2;
            long endTime = System.currentTimeMillis() + (long)timeout;
            AtomicBoolean atomicBoolean = this.regionServer.online;
            synchronized (atomicBoolean) {
                try {
                    while (System.currentTimeMillis() <= endTime && !this.regionServer.isStopped() && !this.regionServer.isOnline()) {
                        this.regionServer.online.wait(this.regionServer.msgInterval);
                    }
                    this.checkOpen();
                }
                catch (InterruptedException t) {
                    Thread.currentThread().interrupt();
                    throw new ServiceException((Throwable)t);
                }
                catch (IOException e) {
                    throw new ServiceException((Throwable)e);
                }
            }
        }
        long masterSystemTime = request.hasMasterSystemTime() ? request.getMasterSystemTime() : -1L;
        for (AdminProtos.OpenRegionRequest.RegionOpenInfo regionOpenInfo : request.getOpenInfoList()) {
            HRegionInfo region = HRegionInfo.convert((HBaseProtos.RegionInfo)regionOpenInfo.getRegion());
            OpenRegionCoordination coordination = this.regionServer.getCoordinatedStateManager().getOpenRegionCoordination();
            OpenRegionCoordination.OpenRegionDetails ord = coordination.parseFromProtoRequest(regionOpenInfo);
            try {
                Boolean previous;
                Region onlineRegion = this.regionServer.getFromOnlineRegions(region.getEncodedName());
                if (onlineRegion != null) {
                    Pair p;
                    if (onlineRegion.getCoprocessorHost() != null) {
                        onlineRegion.getCoprocessorHost().preOpen();
                    }
                    if (this.regionServer.serverName.equals((p = MetaTableAccessor.getRegion((Connection)this.regionServer.getConnection(), (byte[])region.getRegionName())).getSecond())) {
                        Boolean closing = (Boolean)this.regionServer.regionsInTransitionInRS.get(region.getEncodedNameAsBytes());
                        if (!Boolean.FALSE.equals(closing) && this.regionServer.getFromOnlineRegions(region.getEncodedName()) != null) {
                            LOG.warn((Object)("Attempted open of " + region.getEncodedName() + " but already online on this server"));
                            builder.addOpeningState(AdminProtos.OpenRegionResponse.RegionOpeningState.ALREADY_OPENED);
                            continue;
                        }
                    } else {
                        LOG.warn((Object)("The region " + region.getEncodedName() + " is online on this server" + " but hbase:meta does not have this server - continue opening."));
                        this.regionServer.removeFromOnlineRegions(onlineRegion, null);
                    }
                }
                LOG.info((Object)("Open " + region.getRegionNameAsString()));
                HTableDescriptor htd = (HTableDescriptor)htds.get(region.getTable());
                if (htd == null) {
                    htd = this.regionServer.tableDescriptors.get(region.getTable());
                    htds.put(region.getTable(), htd);
                }
                if (Boolean.FALSE.equals(previous = this.regionServer.regionsInTransitionInRS.putIfAbsent(region.getEncodedNameAsBytes(), Boolean.TRUE))) {
                    coordination.tryTransitionFromOfflineToFailedOpen(this.regionServer, region, ord);
                    throw new RegionAlreadyInTransitionException("Received OPEN for the region:" + region.getRegionNameAsString() + " , which we are already trying to CLOSE ");
                }
                if (Boolean.TRUE.equals(previous)) {
                    LOG.info((Object)("Receiving OPEN for the region:" + region.getRegionNameAsString() + " , which we are already trying to OPEN" + " - ignoring this new request for this region."));
                }
                this.regionServer.removeFromMovedRegions(region.getEncodedName());
                if (previous == null) {
                    if (ZKSplitLog.isRegionMarkedRecoveringInZK(this.regionServer.getZooKeeper(), region.getEncodedName())) {
                        if (!regionOpenInfo.hasOpenForDistributedLogReplay() || regionOpenInfo.getOpenForDistributedLogReplay()) {
                            this.regionServer.recoveringRegions.put(region.getEncodedName(), null);
                        } else {
                            ArrayList<String> tmpRegions = new ArrayList<String>();
                            tmpRegions.add(region.getEncodedName());
                            ZKSplitLog.deleteRecoveringRegionZNodes(this.regionServer.getZooKeeper(), tmpRegions);
                        }
                    }
                    if (region.isMetaRegion()) {
                        this.regionServer.service.submit(new OpenMetaHandler(this.regionServer, this.regionServer, region, htd, masterSystemTime, coordination, ord));
                    } else {
                        this.regionServer.updateRegionFavoredNodesMapping(region.getEncodedName(), regionOpenInfo.getFavoredNodesList());
                        this.regionServer.service.submit(new OpenRegionHandler(this.regionServer, this.regionServer, region, htd, masterSystemTime, coordination, ord));
                    }
                }
                builder.addOpeningState(AdminProtos.OpenRegionResponse.RegionOpeningState.OPENED);
            }
            catch (KeeperException zooKeeperEx) {
                LOG.error((Object)"Can't retrieve recovering state from zookeeper", (Throwable)zooKeeperEx);
                throw new ServiceException((Throwable)zooKeeperEx);
            }
            catch (IOException ie) {
                LOG.warn((Object)("Failed opening region " + region.getRegionNameAsString()), (Throwable)ie);
                if (isBulkAssign) {
                    builder.addOpeningState(AdminProtos.OpenRegionResponse.RegionOpeningState.FAILED_OPENING);
                    continue;
                }
                throw new ServiceException((Throwable)ie);
            }
        }
        return builder.build();
    }

    public AdminProtos.WarmupRegionResponse warmupRegion(RpcController controller, AdminProtos.WarmupRegionRequest request) throws ServiceException {
        HBaseProtos.RegionInfo regionInfo = request.getRegionInfo();
        HRegionInfo region = HRegionInfo.convert((HBaseProtos.RegionInfo)regionInfo);
        AdminProtos.WarmupRegionResponse response = AdminProtos.WarmupRegionResponse.getDefaultInstance();
        try {
            this.checkOpen();
            String encodedName = region.getEncodedName();
            byte[] encodedNameBytes = region.getEncodedNameAsBytes();
            Region onlineRegion = this.regionServer.getFromOnlineRegions(encodedName);
            if (onlineRegion != null) {
                LOG.info((Object)("Region already online. Skipping warming up " + region));
                return response;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Warming up Region " + region.getRegionNameAsString()));
            }
            HTableDescriptor htd = this.regionServer.tableDescriptors.get(region.getTable());
            if (this.regionServer.getRegionsInTransitionInRS().containsKey(encodedNameBytes)) {
                LOG.info((Object)("Region is in transition. Skipping warmup " + region));
                return response;
            }
            HRegion.warmupHRegion(region, htd, this.regionServer.getWAL(region), this.regionServer.getConfiguration(), this.regionServer, null);
        }
        catch (IOException ie) {
            LOG.error((Object)("Failed warming up region " + region.getRegionNameAsString()), (Throwable)ie);
            throw new ServiceException((Throwable)ie);
        }
        return response;
    }

    @QosPriority(priority=6)
    public AdminProtos.ReplicateWALEntryResponse replay(RpcController controller, AdminProtos.ReplicateWALEntryRequest request) throws ServiceException {
        long before = EnvironmentEdgeManager.currentTime();
        CellScanner cells = ((PayloadCarryingRpcController)controller).cellScanner();
        try {
            this.checkOpen();
            List entries = request.getEntryList();
            if (entries == null || entries.isEmpty()) {
                AdminProtos.ReplicateWALEntryResponse replicateWALEntryResponse = AdminProtos.ReplicateWALEntryResponse.newBuilder().build();
                return replicateWALEntryResponse;
            }
            ByteString regionName = ((AdminProtos.WALEntry)entries.get(0)).getKey().getEncodedRegionName();
            Region region = this.regionServer.getRegionByEncodedName(regionName.toStringUtf8());
            RegionCoprocessorHost coprocessorHost = ServerRegionReplicaUtil.isDefaultReplica((HRegionInfo)region.getRegionInfo()) ? region.getCoprocessorHost() : null;
            ArrayList<Pair> walEntries = new ArrayList<Pair>();
            boolean isPrimary = RegionReplicaUtil.isDefaultReplica((HRegionInfo)region.getRegionInfo());
            Durability durability = isPrimary ? Durability.USE_DEFAULT : Durability.SKIP_WAL;
            for (AdminProtos.WALEntry entry : entries) {
                if (!regionName.equals((Object)entry.getKey().getEncodedRegionName())) {
                    throw new NotServingRegionException("Replay request contains entries from multiple regions. First region:" + regionName.toStringUtf8() + " , other region:" + entry.getKey().getEncodedRegionName());
                }
                if (this.regionServer.nonceManager != null && isPrimary) {
                    long nonceGroup = entry.getKey().hasNonceGroup() ? entry.getKey().getNonceGroup() : 0L;
                    long nonce = entry.getKey().hasNonce() ? entry.getKey().getNonce() : 0L;
                    this.regionServer.nonceManager.reportOperationFromWal(nonceGroup, nonce, entry.getKey().getWriteTime());
                }
                Pair walEntry = coprocessorHost == null ? null : new Pair();
                List<WALSplitter.MutationReplay> edits = WALSplitter.getMutationsFromWALEntry(entry, cells, (Pair<WALKey, WALEdit>)walEntry, durability);
                if (coprocessorHost != null) {
                    if (coprocessorHost.preWALRestore(region.getRegionInfo(), (WALKey)walEntry.getFirst(), (WALEdit)walEntry.getSecond())) continue;
                    walEntries.add(walEntry);
                }
                if (edits == null || edits.isEmpty()) continue;
                long replaySeqId = entry.getKey().hasOrigSequenceNumber() ? entry.getKey().getOrigSequenceNumber() : entry.getKey().getLogSequenceNumber();
                OperationStatus[] result = this.doReplayBatchOp(region, edits, replaySeqId);
                for (int i = 0; result != null && i < result.length; ++i) {
                    if (result[i] == OperationStatus.SUCCESS) continue;
                    throw new IOException(result[i].getExceptionMsg());
                }
            }
            WAL wal = this.getWAL(region);
            if (wal != null) {
                wal.sync();
            }
            if (coprocessorHost != null) {
                for (Pair entry : walEntries) {
                    coprocessorHost.postWALRestore(region.getRegionInfo(), (WALKey)entry.getFirst(), (WALEdit)entry.getSecond());
                }
            }
            AdminProtos.ReplicateWALEntryResponse replicateWALEntryResponse = AdminProtos.ReplicateWALEntryResponse.newBuilder().build();
            return replicateWALEntryResponse;
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
        finally {
            if (this.regionServer.metricsRegionServer != null) {
                this.regionServer.metricsRegionServer.updateReplay(EnvironmentEdgeManager.currentTime() - before);
            }
        }
    }

    WAL getWAL(Region region) {
        return ((HRegion)region).getWAL();
    }

    @QosPriority(priority=5)
    public AdminProtos.ReplicateWALEntryResponse replicateWALEntry(RpcController controller, AdminProtos.ReplicateWALEntryRequest request) throws ServiceException {
        try {
            this.checkOpen();
            if (this.regionServer.replicationSinkHandler != null) {
                this.requestCount.increment();
                List entries = request.getEntryList();
                CellScanner cellScanner = ((PayloadCarryingRpcController)controller).cellScanner();
                this.regionServer.getRegionServerCoprocessorHost().preReplicateLogEntries(entries, cellScanner);
                this.regionServer.replicationSinkHandler.replicateLogEntries(entries, cellScanner);
                this.regionServer.getRegionServerCoprocessorHost().postReplicateLogEntries(entries, cellScanner);
                return AdminProtos.ReplicateWALEntryResponse.newBuilder().build();
            }
            throw new ServiceException("Replication services are not initialized yet");
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
    }

    public AdminProtos.RollWALWriterResponse rollWALWriter(RpcController controller, AdminProtos.RollWALWriterRequest request) throws ServiceException {
        try {
            this.checkOpen();
            this.requestCount.increment();
            this.regionServer.getRegionServerCoprocessorHost().preRollWALWriterRequest();
            this.regionServer.walRoller.requestRollAll();
            this.regionServer.getRegionServerCoprocessorHost().postRollWALWriterRequest();
            AdminProtos.RollWALWriterResponse.Builder builder = AdminProtos.RollWALWriterResponse.newBuilder();
            return builder.build();
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
    }

    @QosPriority(priority=100)
    public AdminProtos.SplitRegionResponse splitRegion(RpcController controller, AdminProtos.SplitRegionRequest request) throws ServiceException {
        try {
            this.checkOpen();
            this.requestCount.increment();
            Region region = this.getRegion(request.getRegion());
            region.startRegionOperation(Region.Operation.SPLIT_REGION);
            if (region.getRegionInfo().getReplicaId() != 0) {
                throw new IOException("Can't split replicas directly. Replicas are auto-split when their primary is split.");
            }
            LOG.info((Object)("Splitting " + region.getRegionInfo().getRegionNameAsString()));
            long startTime = EnvironmentEdgeManager.currentTime();
            Region.FlushResult flushResult = region.flush(true);
            if (flushResult.isFlushSucceeded()) {
                long endTime = EnvironmentEdgeManager.currentTime();
                this.regionServer.metricsRegionServer.updateFlushTime(endTime - startTime);
            }
            byte[] splitPoint = null;
            if (request.hasSplitPoint()) {
                splitPoint = request.getSplitPoint().toByteArray();
            }
            ((HRegion)region).forceSplit(splitPoint);
            this.regionServer.compactSplitThread.requestSplit(region, ((HRegion)region).checkSplit(), RpcServer.getRequestUser());
            return AdminProtos.SplitRegionResponse.newBuilder().build();
        }
        catch (DroppedSnapshotException ex) {
            this.regionServer.abort("Replay of WAL required. Forcing server shutdown", ex);
            throw new ServiceException((Throwable)ex);
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
    }

    @QosPriority(priority=100)
    public AdminProtos.StopServerResponse stopServer(RpcController controller, AdminProtos.StopServerRequest request) throws ServiceException {
        this.requestCount.increment();
        String reason = request.getReason();
        this.regionServer.stop(reason);
        return AdminProtos.StopServerResponse.newBuilder().build();
    }

    public AdminProtos.UpdateFavoredNodesResponse updateFavoredNodes(RpcController controller, AdminProtos.UpdateFavoredNodesRequest request) throws ServiceException {
        List openInfoList = request.getUpdateInfoList();
        AdminProtos.UpdateFavoredNodesResponse.Builder respBuilder = AdminProtos.UpdateFavoredNodesResponse.newBuilder();
        for (AdminProtos.UpdateFavoredNodesRequest.RegionUpdateInfo regionUpdateInfo : openInfoList) {
            HRegionInfo hri = HRegionInfo.convert((HBaseProtos.RegionInfo)regionUpdateInfo.getRegion());
            this.regionServer.updateRegionFavoredNodesMapping(hri.getEncodedName(), regionUpdateInfo.getFavoredNodesList());
        }
        respBuilder.setResponse(openInfoList.size());
        return respBuilder.build();
    }

    public ClientProtos.BulkLoadHFileResponse bulkLoadHFile(RpcController controller, ClientProtos.BulkLoadHFileRequest request) throws ServiceException {
        try {
            this.checkOpen();
            this.requestCount.increment();
            Region region = this.getRegion(request.getRegion());
            ArrayList<Pair<byte[], String>> familyPaths = new ArrayList<Pair<byte[], String>>();
            for (ClientProtos.BulkLoadHFileRequest.FamilyPath familyPath : request.getFamilyPathList()) {
                familyPaths.add((Pair<byte[], String>)new Pair((Object)familyPath.getFamily().toByteArray(), (Object)familyPath.getPath()));
            }
            boolean bypass = false;
            if (region.getCoprocessorHost() != null) {
                bypass = region.getCoprocessorHost().preBulkLoadHFile(familyPaths);
            }
            boolean loaded = false;
            if (!bypass) {
                loaded = region.bulkLoadHFiles(familyPaths, request.getAssignSeqNum(), null);
            }
            if (region.getCoprocessorHost() != null) {
                loaded = region.getCoprocessorHost().postBulkLoadHFile(familyPaths, loaded);
            }
            ClientProtos.BulkLoadHFileResponse.Builder builder = ClientProtos.BulkLoadHFileResponse.newBuilder();
            builder.setLoaded(loaded);
            return builder.build();
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
    }

    public ClientProtos.CoprocessorServiceResponse execService(RpcController controller, ClientProtos.CoprocessorServiceRequest request) throws ServiceException {
        try {
            this.checkOpen();
            this.requestCount.increment();
            Region region = this.getRegion(request.getRegion());
            Message result = this.execServiceOnRegion(region, request.getCall());
            ClientProtos.CoprocessorServiceResponse.Builder builder = ClientProtos.CoprocessorServiceResponse.newBuilder();
            builder.setRegion(RequestConverter.buildRegionSpecifier((HBaseProtos.RegionSpecifier.RegionSpecifierType)HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, (byte[])region.getRegionInfo().getRegionName()));
            builder.setValue(builder.getValueBuilder().setName(result.getClass().getName()).setValue(result.toByteString()));
            return builder.build();
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
    }

    private Message execServiceOnRegion(Region region, ClientProtos.CoprocessorServiceCall serviceCall) throws IOException {
        ServerRpcController execController = new ServerRpcController();
        return region.execService((RpcController)execController, serviceCall);
    }

    public ClientProtos.GetResponse get(RpcController controller, ClientProtos.GetRequest request) throws ServiceException {
        long before = EnvironmentEdgeManager.currentTime();
        OperationQuota quota = null;
        try {
            ClientProtos.Result pbr;
            this.checkOpen();
            this.requestCount.increment();
            Region region = this.getRegion(request.getRegion());
            ClientProtos.GetResponse.Builder builder = ClientProtos.GetResponse.newBuilder();
            ClientProtos.Get get = request.getGet();
            Boolean existence = null;
            Result r = null;
            quota = this.getQuotaManager().checkQuota(region, OperationQuota.OperationType.GET);
            if (get.hasClosestRowBefore() && get.getClosestRowBefore()) {
                if (get.getColumnCount() != 1) {
                    throw new DoNotRetryIOException("get ClosestRowBefore supports one and only one family now, not " + get.getColumnCount() + " families");
                }
                byte[] row = get.getRow().toByteArray();
                byte[] family = get.getColumn(0).getFamily().toByteArray();
                r = region.getClosestRowBefore(row, family);
            } else {
                Get clientGet = ProtobufUtil.toGet((ClientProtos.Get)get);
                if (get.getExistenceOnly() && region.getCoprocessorHost() != null) {
                    existence = region.getCoprocessorHost().preExists(clientGet);
                }
                if (existence == null) {
                    r = region.get(clientGet);
                    if (get.getExistenceOnly()) {
                        boolean exists = r.getExists();
                        if (region.getCoprocessorHost() != null) {
                            exists = region.getCoprocessorHost().postExists(clientGet, exists);
                        }
                        existence = exists;
                    }
                }
            }
            if (existence != null) {
                pbr = ProtobufUtil.toResult((boolean)existence, (region.getRegionInfo().getReplicaId() != 0 ? 1 : 0) != 0);
                builder.setResult(pbr);
            } else if (r != null) {
                pbr = ProtobufUtil.toResult((Result)r);
                builder.setResult(pbr);
            }
            if (r != null) {
                quota.addGetResult(r);
            }
            ClientProtos.GetResponse getResponse = builder.build();
            return getResponse;
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
        finally {
            if (this.regionServer.metricsRegionServer != null) {
                this.regionServer.metricsRegionServer.updateGet(EnvironmentEdgeManager.currentTime() - before);
            }
            if (quota != null) {
                quota.close();
            }
        }
    }

    public ClientProtos.MultiResponse multi(RpcController rpcc, ClientProtos.MultiRequest request) throws ServiceException {
        CellScanner cellScanner;
        try {
            this.checkOpen();
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
        PayloadCarryingRpcController controller = (PayloadCarryingRpcController)rpcc;
        CellScanner cellScanner2 = cellScanner = controller != null ? controller.cellScanner() : null;
        if (controller != null) {
            controller.setCellScanner(null);
        }
        long nonceGroup = request.hasNonceGroup() ? request.getNonceGroup() : 0L;
        List<CellScannable> cellsToReturn = null;
        ClientProtos.MultiResponse.Builder responseBuilder = ClientProtos.MultiResponse.newBuilder();
        ClientProtos.RegionActionResult.Builder regionActionResultBuilder = ClientProtos.RegionActionResult.newBuilder();
        Boolean processed = null;
        for (ClientProtos.RegionAction regionAction : request.getRegionActionList()) {
            OperationQuota quota;
            block14: {
                Region region;
                this.requestCount.add((long)regionAction.getActionCount());
                regionActionResultBuilder.clear();
                try {
                    region = this.getRegion(regionAction.getRegion());
                    quota = this.getQuotaManager().checkQuota(region, regionAction.getActionList());
                }
                catch (IOException e) {
                    this.rpcServer.getMetrics().exception(e);
                    regionActionResultBuilder.setException(ResponseConverter.buildException((Throwable)e));
                    responseBuilder.addRegionActionResult(regionActionResultBuilder.build());
                    if (cellScanner == null) continue;
                    this.skipCellsForMutations(regionAction.getActionList(), cellScanner);
                    continue;
                }
                if (regionAction.hasAtomic() && regionAction.getAtomic()) {
                    try {
                        if (request.hasCondition()) {
                            ClientProtos.Condition condition = request.getCondition();
                            byte[] row = condition.getRow().toByteArray();
                            byte[] family = condition.getFamily().toByteArray();
                            byte[] qualifier = condition.getQualifier().toByteArray();
                            CompareFilter.CompareOp compareOp = CompareFilter.CompareOp.valueOf((String)condition.getCompareType().name());
                            ByteArrayComparable comparator = ProtobufUtil.toComparator((ComparatorProtos.Comparator)condition.getComparator());
                            processed = this.checkAndRowMutate(region, regionAction.getActionList(), cellScanner, row, family, qualifier, compareOp, comparator);
                            break block14;
                        }
                        ClientProtos.RegionLoadStats stats = this.mutateRows(region, regionAction.getActionList(), cellScanner);
                        if (stats != null) {
                            responseBuilder.addRegionActionResult(ClientProtos.RegionActionResult.newBuilder().addResultOrException(ClientProtos.ResultOrException.newBuilder().setLoadStats(stats)));
                        }
                        processed = Boolean.TRUE;
                    }
                    catch (IOException e) {
                        this.rpcServer.getMetrics().exception(e);
                        regionActionResultBuilder.setException(ResponseConverter.buildException((Throwable)e));
                    }
                } else {
                    cellsToReturn = this.doNonAtomicRegionMutation(region, quota, regionAction, cellScanner, regionActionResultBuilder, cellsToReturn, nonceGroup);
                }
            }
            responseBuilder.addRegionActionResult(regionActionResultBuilder.build());
            quota.close();
        }
        if (cellsToReturn != null && !cellsToReturn.isEmpty() && controller != null) {
            controller.setCellScanner(CellUtil.createCellScanner((List)cellsToReturn));
        }
        if (processed != null) {
            responseBuilder.setProcessed(processed.booleanValue());
        }
        return responseBuilder.build();
    }

    private void skipCellsForMutations(List<ClientProtos.Action> actions, CellScanner cellScanner) {
        for (ClientProtos.Action action : actions) {
            this.skipCellsForMutation(action, cellScanner);
        }
    }

    private void skipCellsForMutation(ClientProtos.Action action, CellScanner cellScanner) {
        try {
            ClientProtos.MutationProto m;
            if (action.hasMutation() && (m = action.getMutation()).hasAssociatedCellCount()) {
                for (int i = 0; i < m.getAssociatedCellCount(); ++i) {
                    cellScanner.advance();
                }
            }
        }
        catch (IOException e) {
            LOG.error((Object)"Error while skipping Cells in CellScanner for invalid Region Mutations", (Throwable)e);
        }
    }

    public ClientProtos.MutateResponse mutate(RpcController rpcc, ClientProtos.MutateRequest request) throws ServiceException {
        PayloadCarryingRpcController controller = (PayloadCarryingRpcController)rpcc;
        CellScanner cellScanner = controller != null ? controller.cellScanner() : null;
        OperationQuota quota = null;
        if (controller != null) {
            controller.setCellScanner(null);
        }
        try {
            this.checkOpen();
            this.requestCount.increment();
            Region region = this.getRegion(request.getRegion());
            ClientProtos.MutateResponse.Builder builder = ClientProtos.MutateResponse.newBuilder();
            ClientProtos.MutationProto mutation = request.getMutation();
            if (!region.getRegionInfo().isMetaTable()) {
                this.regionServer.cacheFlusher.reclaimMemStoreMemory();
            }
            long nonceGroup = request.hasNonceGroup() ? request.getNonceGroup() : 0L;
            Result r = null;
            Boolean processed = null;
            ClientProtos.MutationProto.MutationType type = mutation.getMutateType();
            long mutationSize = 0L;
            quota = this.getQuotaManager().checkQuota(region, OperationQuota.OperationType.MUTATE);
            switch (type) {
                case APPEND: {
                    r = this.append(region, quota, mutation, cellScanner, nonceGroup);
                    break;
                }
                case INCREMENT: {
                    r = this.increment(region, quota, mutation, cellScanner, nonceGroup);
                    break;
                }
                case PUT: {
                    Put put = ProtobufUtil.toPut((ClientProtos.MutationProto)mutation, (CellScanner)cellScanner);
                    quota.addMutation((Mutation)put);
                    if (request.hasCondition()) {
                        ClientProtos.Condition condition = request.getCondition();
                        byte[] row = condition.getRow().toByteArray();
                        byte[] family = condition.getFamily().toByteArray();
                        byte[] qualifier = condition.getQualifier().toByteArray();
                        CompareFilter.CompareOp compareOp = CompareFilter.CompareOp.valueOf((String)condition.getCompareType().name());
                        ByteArrayComparable comparator = ProtobufUtil.toComparator((ComparatorProtos.Comparator)condition.getComparator());
                        if (region.getCoprocessorHost() != null) {
                            processed = region.getCoprocessorHost().preCheckAndPut(row, family, qualifier, compareOp, comparator, put);
                        }
                        if (processed != null) break;
                        boolean result = region.checkAndMutate(row, family, qualifier, compareOp, comparator, (Mutation)put, true);
                        if (region.getCoprocessorHost() != null) {
                            result = region.getCoprocessorHost().postCheckAndPut(row, family, qualifier, compareOp, comparator, put, result);
                        }
                        processed = result;
                        break;
                    }
                    region.put(put);
                    processed = Boolean.TRUE;
                    break;
                }
                case DELETE: {
                    Delete delete = ProtobufUtil.toDelete((ClientProtos.MutationProto)mutation, (CellScanner)cellScanner);
                    quota.addMutation((Mutation)delete);
                    if (request.hasCondition()) {
                        ClientProtos.Condition condition = request.getCondition();
                        byte[] row = condition.getRow().toByteArray();
                        byte[] family = condition.getFamily().toByteArray();
                        byte[] qualifier = condition.getQualifier().toByteArray();
                        CompareFilter.CompareOp compareOp = CompareFilter.CompareOp.valueOf((String)condition.getCompareType().name());
                        ByteArrayComparable comparator = ProtobufUtil.toComparator((ComparatorProtos.Comparator)condition.getComparator());
                        if (region.getCoprocessorHost() != null) {
                            processed = region.getCoprocessorHost().preCheckAndDelete(row, family, qualifier, compareOp, comparator, delete);
                        }
                        if (processed != null) break;
                        boolean result = region.checkAndMutate(row, family, qualifier, compareOp, comparator, (Mutation)delete, true);
                        if (region.getCoprocessorHost() != null) {
                            result = region.getCoprocessorHost().postCheckAndDelete(row, family, qualifier, compareOp, comparator, delete, result);
                        }
                        processed = result;
                        break;
                    }
                    region.delete(delete);
                    processed = Boolean.TRUE;
                    break;
                }
                default: {
                    throw new DoNotRetryIOException("Unsupported mutate type: " + type.name());
                }
            }
            if (processed != null) {
                builder.setProcessed(processed.booleanValue());
            }
            this.addResult(builder, r, controller);
            ClientProtos.MutateResponse mutateResponse = builder.build();
            return mutateResponse;
        }
        catch (IOException ie) {
            this.regionServer.checkFileSystem();
            throw new ServiceException((Throwable)ie);
        }
        finally {
            if (quota != null) {
                quota.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientProtos.ScanResponse scan(RpcController controller, ClientProtos.ScanRequest request) throws ServiceException {
        OperationQuota quota = null;
        Leases.Lease lease = null;
        String scannerName = null;
        try {
            ClientProtos.ScanResponse scanResponse;
            ClientProtos.Scan protoScan;
            int rows;
            if (!request.hasScannerId() && !request.hasScan()) {
                throw new DoNotRetryIOException("Missing required input: scannerId or scan");
            }
            long scannerId = -1L;
            if (request.hasScannerId()) {
                scannerId = request.getScannerId();
                scannerName = String.valueOf(scannerId);
            }
            try {
                this.checkOpen();
            }
            catch (IOException e) {
                block76: {
                    if (scannerName != null) {
                        LOG.debug((Object)("Server shutting down and client tried to access missing scanner " + scannerName));
                        if (this.regionServer.leases != null) {
                            try {
                                this.regionServer.leases.cancelLease(scannerName);
                            }
                            catch (LeaseException le) {
                                if (!LOG.isTraceEnabled()) break block76;
                                LOG.trace((Object)"Un-able to cancel lease of scanner. It could already be closed.");
                            }
                        }
                    }
                }
                throw e;
            }
            this.requestCount.increment();
            int ttl = 0;
            Region region = null;
            RegionScanner scanner = null;
            RegionScannerHolder rsh = null;
            boolean moreResults = true;
            boolean closeScanner = false;
            boolean isSmallScan = false;
            RpcCallContext context = RpcServer.getCurrentCall();
            Object lastBlock = null;
            ClientProtos.ScanResponse.Builder builder = ClientProtos.ScanResponse.newBuilder();
            if (request.hasCloseScanner()) {
                closeScanner = request.getCloseScanner();
            }
            int n = rows = closeScanner ? 0 : 1;
            if (request.hasNumberOfRows()) {
                rows = request.getNumberOfRows();
            }
            if (request.hasScannerId()) {
                rsh = this.scanners.get(scannerName);
                if (rsh == null) {
                    LOG.info((Object)("Client tried to access missing scanner " + scannerName));
                    throw new UnknownScannerException("Name: " + scannerName + ", already closed?");
                }
                scanner = rsh.s;
                HRegionInfo hri = scanner.getRegionInfo();
                region = this.regionServer.getRegion(hri.getRegionName());
                if (region != rsh.r) {
                    throw new NotServingRegionException("Region was re-opened after the scanner" + scannerName + " was created: " + hri.getRegionNameAsString());
                }
            } else {
                region = this.getRegion(request.getRegion());
                protoScan = request.getScan();
                boolean isLoadingCfsOnDemandSet = protoScan.hasLoadColumnFamiliesOnDemand();
                Scan scan = ProtobufUtil.toScan((ClientProtos.Scan)protoScan);
                if (!isLoadingCfsOnDemandSet) {
                    scan.setLoadColumnFamiliesOnDemand(region.isLoadingCfsOnDemandDefault());
                }
                isSmallScan = scan.isSmall();
                if (!scan.hasFamilies()) {
                    for (byte[] family : region.getTableDesc().getFamiliesKeys()) {
                        scan.addFamily(family);
                    }
                }
                if (region.getCoprocessorHost() != null) {
                    scanner = region.getCoprocessorHost().preScannerOpen(scan);
                }
                if (scanner == null) {
                    scanner = region.getScanner(scan);
                }
                if (region.getCoprocessorHost() != null) {
                    scanner = region.getCoprocessorHost().postScannerOpen(scan, scanner);
                }
                scannerId = this.addScanner(scanner, region);
                scannerName = String.valueOf(scannerId);
                ttl = this.scannerLeaseTimeoutPeriod;
            }
            if (request.hasRenew() && request.getRenew()) {
                rsh = this.scanners.get(scannerName);
                lease = this.regionServer.leases.removeLease(scannerName);
                if (lease != null && rsh != null) {
                    this.regionServer.leases.addLease(lease);
                    rsh.incNextCallSeq();
                }
                protoScan = builder.build();
                return protoScan;
            }
            quota = this.getQuotaManager().checkQuota(region, OperationQuota.OperationType.SCAN);
            long maxQuotaResultSize = Math.min(this.maxScannerResultSize, quota.getReadAvailable());
            if (rows > 0) {
                if (request.hasNextCallSeq()) {
                    if (rsh == null) {
                        rsh = this.scanners.get(scannerName);
                    }
                    if (rsh != null) {
                        if (request.getNextCallSeq() != rsh.getNextCallSeq()) {
                            throw new OutOfOrderScannerNextException("Expected nextCallSeq: " + rsh.getNextCallSeq() + " But the nextCallSeq got from client: " + request.getNextCallSeq() + "; request=" + TextFormat.shortDebugString((MessageOrBuilder)request));
                        }
                        rsh.incNextCallSeq();
                    }
                }
                try {
                    lease = this.regionServer.leases.removeLease(scannerName);
                    ArrayList<Result> results = new ArrayList<Result>();
                    boolean done = false;
                    if (region != null && region.getCoprocessorHost() != null) {
                        Boolean bypass = region.getCoprocessorHost().preScannerNext(scanner, results, rows);
                        if (!results.isEmpty()) {
                            for (Result r : results) {
                                lastBlock = this.addSize(context, r, lastBlock);
                            }
                        }
                        if (bypass != null && bypass.booleanValue()) {
                            done = true;
                        }
                    }
                    if (!done) {
                        long maxResultSize = Math.min(scanner.getMaxResultSize(), maxQuotaResultSize);
                        if (maxResultSize <= 0L) {
                            maxResultSize = maxQuotaResultSize;
                        }
                        ArrayList<Cell> values = new ArrayList<Cell>(32);
                        region.startRegionOperation(Region.Operation.SCAN);
                        try {
                            int i = 0;
                            RegionScanner regionScanner = scanner;
                            synchronized (regionScanner) {
                                boolean stale = region.getRegionInfo().getReplicaId() != 0;
                                boolean clientHandlesPartials = request.hasClientHandlesPartials() && request.getClientHandlesPartials();
                                boolean clientHandlesHeartbeats = request.hasClientHandlesHeartbeats() && request.getClientHandlesHeartbeats();
                                boolean serverGuaranteesOrderOfPartials = results.isEmpty();
                                boolean allowPartialResults = clientHandlesPartials && serverGuaranteesOrderOfPartials && !isSmallScan;
                                boolean moreRows = false;
                                boolean allowHeartbeatMessages = clientHandlesHeartbeats && allowPartialResults;
                                long timeLimit = -1L;
                                if (allowHeartbeatMessages && (this.scannerLeaseTimeoutPeriod > 0 || this.rpcTimeout > 0)) {
                                    long timeLimitDelta = this.scannerLeaseTimeoutPeriod > 0 && this.rpcTimeout > 0 ? (long)Math.min(this.scannerLeaseTimeoutPeriod, this.rpcTimeout) : (this.scannerLeaseTimeoutPeriod > 0 ? (long)this.scannerLeaseTimeoutPeriod : (long)this.rpcTimeout);
                                    timeLimitDelta = Math.max(timeLimitDelta / 2L, this.minimumScanTimeLimitDelta);
                                    timeLimit = System.currentTimeMillis() + timeLimitDelta;
                                }
                                ScannerContext.LimitScope sizeScope = allowPartialResults ? ScannerContext.LimitScope.BETWEEN_CELLS : ScannerContext.LimitScope.BETWEEN_ROWS;
                                ScannerContext.LimitScope timeScope = allowHeartbeatMessages ? ScannerContext.LimitScope.BETWEEN_CELLS : ScannerContext.LimitScope.BETWEEN_ROWS;
                                boolean trackMetrics = request.hasTrackScanMetrics() && request.getTrackScanMetrics();
                                ScannerContext.Builder contextBuilder = ScannerContext.newBuilder(true);
                                contextBuilder.setSizeLimit(sizeScope, maxResultSize);
                                contextBuilder.setBatchLimit(scanner.getBatch());
                                contextBuilder.setTimeLimit(timeScope, timeLimit);
                                contextBuilder.setTrackMetrics(trackMetrics);
                                ScannerContext scannerContext = contextBuilder.build();
                                boolean limitReached = false;
                                while (i < rows) {
                                    scannerContext.setBatchProgress(0);
                                    moreRows = scanner.nextRaw(values, scannerContext);
                                    if (!values.isEmpty()) {
                                        boolean partial = scannerContext.partialResultFormed();
                                        Result r = Result.create(values, null, (boolean)stale, (boolean)partial);
                                        lastBlock = this.addSize(context, r, lastBlock);
                                        results.add(r);
                                        ++i;
                                    }
                                    boolean sizeLimitReached = scannerContext.checkSizeLimit(ScannerContext.LimitScope.BETWEEN_ROWS);
                                    boolean timeLimitReached = scannerContext.checkTimeLimit(ScannerContext.LimitScope.BETWEEN_ROWS);
                                    boolean rowLimitReached = i >= rows;
                                    boolean bl = limitReached = sizeLimitReached || timeLimitReached || rowLimitReached;
                                    if (limitReached || !moreRows) {
                                        if (LOG.isTraceEnabled()) {
                                            LOG.trace((Object)("Done scanning. limitReached: " + limitReached + " moreRows: " + moreRows + " scannerContext: " + scannerContext));
                                        }
                                        if (!moreRows) break;
                                        builder.setHeartbeatMessage(timeLimitReached);
                                        break;
                                    }
                                    values.clear();
                                }
                                if (limitReached || moreRows) {
                                    builder.setMoreResultsInRegion(true);
                                } else {
                                    builder.setMoreResultsInRegion(false);
                                }
                                if (trackMetrics) {
                                    Map metrics = scannerContext.getMetrics().getMetricsMap();
                                    MapReduceProtos.ScanMetrics.Builder metricBuilder = MapReduceProtos.ScanMetrics.newBuilder();
                                    HBaseProtos.NameInt64Pair.Builder pairBuilder = HBaseProtos.NameInt64Pair.newBuilder();
                                    for (Map.Entry entry : metrics.entrySet()) {
                                        pairBuilder.setName((String)entry.getKey());
                                        pairBuilder.setValue(((Long)entry.getValue()).longValue());
                                        metricBuilder.addMetrics(pairBuilder.build());
                                    }
                                    builder.setScanMetrics(metricBuilder.build());
                                }
                            }
                            region.updateReadRequestsCount(i);
                            long responseCellSize = context != null ? context.getResponseCellSize() : 0L;
                            region.getMetrics().updateScanNext(responseCellSize);
                            if (this.regionServer.metricsRegionServer != null) {
                                this.regionServer.metricsRegionServer.updateScannerNext(responseCellSize);
                            }
                        }
                        finally {
                            region.closeRegionOperation();
                        }
                        if (region != null && region.getCoprocessorHost() != null) {
                            region.getCoprocessorHost().postScannerNext(scanner, results, rows, true);
                        }
                    }
                    quota.addScanResult(results);
                    if (scanner.isFilterDone() && results.isEmpty()) {
                        moreResults = false;
                        results = null;
                    } else {
                        this.addResults(builder, results, controller, RegionReplicaUtil.isDefaultReplica((HRegionInfo)region.getRegionInfo()));
                    }
                }
                catch (IOException e) {
                    if (rsh != null && request.hasNextCallSeq()) {
                        rsh.rollbackNextCallSeq();
                    }
                    throw e;
                }
                finally {
                    if (this.scanners.containsKey(scannerName)) {
                        if (lease != null) {
                            this.regionServer.leases.addLease(lease);
                        }
                        ttl = this.scannerLeaseTimeoutPeriod;
                    }
                }
            }
            if (!moreResults || closeScanner) {
                ttl = 0;
                moreResults = false;
                if (region != null && region.getCoprocessorHost() != null && region.getCoprocessorHost().preScannerClose(scanner)) {
                    scanResponse = builder.build();
                    return scanResponse;
                }
                rsh = this.scanners.remove(scannerName);
                if (rsh != null) {
                    scanner = rsh.s;
                    scanner.close();
                    this.regionServer.leases.cancelLease(scannerName);
                    if (region != null && region.getCoprocessorHost() != null) {
                        region.getCoprocessorHost().postScannerClose(scanner);
                    }
                }
            }
            if (ttl > 0) {
                builder.setTtl(ttl);
            }
            builder.setScannerId(scannerId);
            builder.setMoreResults(moreResults);
            scanResponse = builder.build();
            return scanResponse;
        }
        catch (IOException ie) {
            RegionScannerHolder rsh;
            if (scannerName != null && ie instanceof NotServingRegionException && (rsh = this.scanners.remove(scannerName)) != null) {
                try {
                    RegionScanner scanner = rsh.s;
                    LOG.warn((Object)(scannerName + " encountered " + ie.getMessage() + ", closing ..."));
                    scanner.close();
                    this.regionServer.leases.cancelLease(scannerName);
                }
                catch (IOException e) {
                    LOG.warn((Object)("Getting exception closing " + scannerName), (Throwable)e);
                }
            }
            throw new ServiceException((Throwable)ie);
        }
        finally {
            if (quota != null) {
                quota.close();
            }
        }
    }

    public ClientProtos.CoprocessorServiceResponse execRegionServerService(RpcController controller, ClientProtos.CoprocessorServiceRequest request) throws ServiceException {
        return this.regionServer.execRegionServerService(controller, request);
    }

    public AdminProtos.UpdateConfigurationResponse updateConfiguration(RpcController controller, AdminProtos.UpdateConfigurationRequest request) throws ServiceException {
        try {
            this.regionServer.updateConfiguration();
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
        return AdminProtos.UpdateConfigurationResponse.getDefaultInstance();
    }

    private class ScannerListener
    implements LeaseListener {
        private final String scannerName;

        ScannerListener(String n) {
            this.scannerName = n;
        }

        @Override
        public void leaseExpired() {
            RegionScannerHolder rsh = (RegionScannerHolder)RSRpcServices.this.scanners.remove(this.scannerName);
            if (rsh != null) {
                RegionScanner s = rsh.s;
                LOG.info((Object)("Scanner " + this.scannerName + " lease expired on region " + s.getRegionInfo().getRegionNameAsString()));
                try {
                    Region region = RSRpcServices.this.regionServer.getRegion(s.getRegionInfo().getRegionName());
                    if (region != null && region.getCoprocessorHost() != null) {
                        region.getCoprocessorHost().preScannerClose(s);
                    }
                    s.close();
                    if (region != null && region.getCoprocessorHost() != null) {
                        region.getCoprocessorHost().postScannerClose(s);
                    }
                }
                catch (IOException e) {
                    LOG.error((Object)("Closing scanner for " + s.getRegionInfo().getRegionNameAsString()), (Throwable)e);
                }
            } else {
                LOG.warn((Object)("Scanner " + this.scannerName + " lease expired, but no related" + " scanner found, hence no chance to close that related scanner!"));
            }
        }
    }

    private static class RegionScannerHolder {
        private AtomicLong nextCallSeq = new AtomicLong(0L);
        private RegionScanner s;
        private Region r;

        public RegionScannerHolder(RegionScanner s, Region r) {
            this.s = s;
            this.r = r;
        }

        private long getNextCallSeq() {
            return this.nextCallSeq.get();
        }

        private void incNextCallSeq() {
            this.nextCallSeq.incrementAndGet();
        }

        private void rollbackNextCallSeq() {
            this.nextCallSeq.decrementAndGet();
        }
    }
}

