/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.backup.HFileArchiver;
import org.apache.hadoop.hbase.client.MobCompactPartitionPolicy;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.HFileLink;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.master.TableLockManager;
import org.apache.hadoop.hbase.mob.MobConstants;
import org.apache.hadoop.hbase.mob.MobFileName;
import org.apache.hadoop.hbase.mob.filecompactions.MobFileCompactor;
import org.apache.hadoop.hbase.mob.filecompactions.PartitionedMobFileCompactionRequest;
import org.apache.hadoop.hbase.mob.filecompactions.PartitionedMobFileCompactor;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ChecksumType;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.ReflectionUtils;
import org.apache.hadoop.hbase.util.Threads;

@InterfaceAudience.Private
public class MobUtils {
    private static final Log LOG = LogFactory.getLog(MobUtils.class);
    private static final long WEEKLY_THRESHOLD_MULTIPLIER = 7L;
    private static final long MONTHLY_THRESHOLD_MULTIPLIER = 28L;
    private static final ThreadLocal<SimpleDateFormat> LOCAL_FORMAT = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyyMMdd");
        }
    };

    public static String formatDate(Date date) {
        return LOCAL_FORMAT.get().format(date);
    }

    public static Date parseDate(String dateString) throws ParseException {
        return LOCAL_FORMAT.get().parse(dateString);
    }

    public static Date getFirstDayOfMonth(Calendar calendar, Date date) {
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.set(5, 1);
        Date firstDayInMonth = calendar.getTime();
        return firstDayInMonth;
    }

    public static Date getFirstDayOfWeek(Calendar calendar, Date date) {
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.setFirstDayOfWeek(2);
        calendar.set(7, 2);
        Date firstDayInWeek = calendar.getTime();
        return firstDayInWeek;
    }

    public static boolean isMobReferenceCell(Cell cell) {
        if (cell.getTagsLength() > 0) {
            Tag tag = Tag.getTag((byte[])cell.getTagsArray(), (int)cell.getTagsOffset(), (int)cell.getTagsLength(), (byte)5);
            return tag != null;
        }
        return false;
    }

    public static Tag getTableNameTag(Cell cell) {
        if (cell.getTagsLength() > 0) {
            Tag tag = Tag.getTag((byte[])cell.getTagsArray(), (int)cell.getTagsOffset(), (int)cell.getTagsLength(), (byte)6);
            return tag;
        }
        return null;
    }

    public static boolean hasMobReferenceTag(List<Tag> tags) {
        if (!tags.isEmpty()) {
            for (Tag tag : tags) {
                if (tag.getType() != 5) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isRawMobScan(Scan scan) {
        byte[] raw = scan.getAttribute("hbase.mob.scan.raw");
        try {
            return raw != null && Bytes.toBoolean((byte[])raw);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isRefOnlyScan(Scan scan) {
        byte[] refOnly = scan.getAttribute("hbase.mob.scan.ref.only");
        try {
            return refOnly != null && Bytes.toBoolean((byte[])refOnly);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isCacheMobBlocks(Scan scan) {
        byte[] cache = scan.getAttribute("hbase.mob.cache.blocks");
        try {
            return cache != null && Bytes.toBoolean((byte[])cache);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static void setCacheMobBlocks(Scan scan, boolean cacheBlocks) {
        scan.setAttribute("hbase.mob.cache.blocks", Bytes.toBytes((boolean)cacheBlocks));
    }

    public static void cleanExpiredMobFiles(FileSystem fs, Configuration conf, TableName tableName, HColumnDescriptor columnDescriptor, CacheConfig cacheConfig, long current) throws IOException {
        long timeToLive = columnDescriptor.getTimeToLive();
        if (Integer.MAX_VALUE == timeToLive) {
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(current - timeToLive * 1000L);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        Date expireDate = calendar.getTime();
        LOG.info((Object)("MOB HFiles older than " + expireDate.toGMTString() + " will be deleted!"));
        FileStatus[] stats = null;
        Path mobTableDir = FSUtils.getTableDir(MobUtils.getMobHome(conf), tableName);
        Path path = MobUtils.getMobFamilyPath(conf, tableName, columnDescriptor.getNameAsString());
        try {
            stats = fs.listStatus(path);
        }
        catch (FileNotFoundException e) {
            LOG.warn((Object)("Fail to find the mob file " + path), (Throwable)e);
        }
        if (null == stats) {
            return;
        }
        ArrayList<StoreFile> filesToClean = new ArrayList<StoreFile>();
        int deletedFileCount = 0;
        for (FileStatus file : stats) {
            String fileName = file.getPath().getName();
            try {
                if (HFileLink.isHFileLink(file.getPath())) {
                    HFileLink hfileLink = HFileLink.buildFromHFileLinkPattern(conf, file.getPath());
                    fileName = hfileLink.getOriginPath().getName();
                }
                Date fileDate = MobUtils.parseDate(MobFileName.getDateFromName(fileName));
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Checking file " + fileName));
                }
                if (fileDate.getTime() >= expireDate.getTime()) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(fileName + " is an expired file"));
                }
                filesToClean.add(new StoreFile(fs, file.getPath(), conf, cacheConfig, BloomType.NONE));
            }
            catch (Exception e) {
                LOG.error((Object)("Cannot parse the fileName " + fileName), (Throwable)e);
            }
        }
        if (!filesToClean.isEmpty()) {
            try {
                MobUtils.removeMobFiles(conf, fs, tableName, mobTableDir, columnDescriptor.getName(), filesToClean);
                deletedFileCount = filesToClean.size();
            }
            catch (IOException e) {
                LOG.error((Object)("Fail to delete the mob files " + filesToClean), (Throwable)e);
            }
        }
        LOG.info((Object)(deletedFileCount + " expired mob files are deleted"));
    }

    public static Path getMobHome(Configuration conf) {
        Path hbaseDir = new Path(conf.get("hbase.rootdir"));
        return new Path(hbaseDir, "mobdir");
    }

    public static Path getQualifiedMobRootDir(Configuration conf) throws IOException {
        Path hbaseDir = new Path(conf.get("hbase.rootdir"));
        Path mobRootDir = new Path(hbaseDir, "mobdir");
        FileSystem fs = mobRootDir.getFileSystem(conf);
        return mobRootDir.makeQualified(fs);
    }

    public static Path getMobRegionPath(Configuration conf, TableName tableName) {
        Path tablePath = FSUtils.getTableDir(MobUtils.getMobHome(conf), tableName);
        HRegionInfo regionInfo = MobUtils.getMobRegionInfo(tableName);
        return new Path(tablePath, regionInfo.getEncodedName());
    }

    public static Path getMobFamilyPath(Configuration conf, TableName tableName, String familyName) {
        return new Path(MobUtils.getMobRegionPath(conf, tableName), familyName);
    }

    public static Path getMobFamilyPath(Path regionPath, String familyName) {
        return new Path(regionPath, familyName);
    }

    public static HRegionInfo getMobRegionInfo(TableName tableName) {
        HRegionInfo info = new HRegionInfo(tableName, MobConstants.MOB_REGION_NAME_BYTES, HConstants.EMPTY_END_ROW, false, 0L);
        return info;
    }

    public static boolean isMobRegionInfo(HRegionInfo regionInfo) {
        return regionInfo == null ? false : MobUtils.getMobRegionInfo(regionInfo.getTable()).getEncodedName().equals(regionInfo.getEncodedName());
    }

    public static boolean isMobRegionName(TableName tableName, byte[] regionName) {
        return Bytes.equals((byte[])regionName, (byte[])MobUtils.getMobRegionInfo(tableName).getRegionName());
    }

    public static Path getCompactionWorkingPath(Path root, String jobName) {
        return new Path(root, jobName);
    }

    public static void removeMobFiles(Configuration conf, FileSystem fs, TableName tableName, Path tableDir, byte[] family, Collection<StoreFile> storeFiles) throws IOException {
        HFileArchiver.archiveStoreFiles(conf, fs, MobUtils.getMobRegionInfo(tableName), tableDir, family, storeFiles);
    }

    public static KeyValue createMobRefKeyValue(Cell cell, byte[] fileName, Tag tableNameTag) {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        tags.add(MobConstants.MOB_REF_TAG);
        tags.add(tableNameTag);
        tags.addAll(Tag.asList((byte[])cell.getTagsArray(), (int)cell.getTagsOffset(), (int)cell.getTagsLength()));
        int valueLength = cell.getValueLength();
        byte[] refValue = Bytes.add((byte[])Bytes.toBytes((int)valueLength), (byte[])fileName);
        KeyValue reference = new KeyValue(cell.getRowArray(), cell.getRowOffset(), (int)cell.getRowLength(), cell.getFamilyArray(), cell.getFamilyOffset(), (int)cell.getFamilyLength(), cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength(), cell.getTimestamp(), KeyValue.Type.Put, refValue, 0, refValue.length, tags);
        reference.setSequenceId(cell.getSequenceId());
        return reference;
    }

    public static StoreFile.Writer createWriter(Configuration conf, FileSystem fs, HColumnDescriptor family, String date, Path basePath, long maxKeyCount, Compression.Algorithm compression, String startKey, CacheConfig cacheConfig) throws IOException {
        MobFileName mobFileName = MobFileName.create(startKey, date, UUID.randomUUID().toString().replaceAll("-", ""));
        return MobUtils.createWriter(conf, fs, family, mobFileName, basePath, maxKeyCount, compression, cacheConfig);
    }

    public static StoreFile.Writer createRefFileWriter(Configuration conf, FileSystem fs, HColumnDescriptor family, Path basePath, long maxKeyCount, CacheConfig cacheConfig) throws IOException {
        HFileContext hFileContext = new HFileContextBuilder().withIncludesMvcc(true).withIncludesTags(true).withCompression(family.getCompactionCompression()).withCompressTags(family.shouldCompressTags()).withChecksumType(HStore.getChecksumType(conf)).withBytesPerCheckSum(HStore.getBytesPerChecksum(conf)).withBlockSize(family.getBlocksize()).withHBaseCheckSum(true).withDataBlockEncoding(family.getDataBlockEncoding()).build();
        Path tempPath = new Path(basePath, UUID.randomUUID().toString().replaceAll("-", ""));
        StoreFile.Writer w = new StoreFile.WriterBuilder(conf, cacheConfig, fs).withFilePath(tempPath).withComparator(KeyValue.COMPARATOR).withBloomType(family.getBloomFilterType()).withMaxKeyCount(maxKeyCount).withFileContext(hFileContext).build();
        return w;
    }

    public static StoreFile.Writer createWriter(Configuration conf, FileSystem fs, HColumnDescriptor family, String date, Path basePath, long maxKeyCount, Compression.Algorithm compression, byte[] startKey, CacheConfig cacheConfig) throws IOException {
        MobFileName mobFileName = MobFileName.create(startKey, date, UUID.randomUUID().toString().replaceAll("-", ""));
        return MobUtils.createWriter(conf, fs, family, mobFileName, basePath, maxKeyCount, compression, cacheConfig);
    }

    public static StoreFile.Writer createDelFileWriter(Configuration conf, FileSystem fs, HColumnDescriptor family, String date, Path basePath, long maxKeyCount, Compression.Algorithm compression, byte[] startKey, CacheConfig cacheConfig) throws IOException {
        String suffix = UUID.randomUUID().toString().replaceAll("-", "") + "_del";
        MobFileName mobFileName = MobFileName.create(startKey, date, suffix);
        return MobUtils.createWriter(conf, fs, family, mobFileName, basePath, maxKeyCount, compression, cacheConfig);
    }

    private static StoreFile.Writer createWriter(Configuration conf, FileSystem fs, HColumnDescriptor family, MobFileName mobFileName, Path basePath, long maxKeyCount, Compression.Algorithm compression, CacheConfig cacheConfig) throws IOException {
        HFileContext hFileContext = new HFileContextBuilder().withCompression(compression).withIncludesMvcc(true).withIncludesTags(true).withChecksumType(ChecksumType.getDefaultChecksumType()).withBytesPerCheckSum(16384).withBlockSize(family.getBlocksize()).withHBaseCheckSum(true).withDataBlockEncoding(family.getDataBlockEncoding()).build();
        StoreFile.Writer w = new StoreFile.WriterBuilder(conf, cacheConfig, fs).withFilePath(new Path(basePath, mobFileName.getFileName())).withComparator(KeyValue.COMPARATOR).withBloomType(BloomType.NONE).withMaxKeyCount(maxKeyCount).withFileContext(hFileContext).build();
        return w;
    }

    public static Path commitFile(Configuration conf, FileSystem fs, Path sourceFile, Path targetPath, CacheConfig cacheConfig) throws IOException {
        if (sourceFile == null) {
            return null;
        }
        Path dstPath = new Path(targetPath, sourceFile.getName());
        MobUtils.validateMobFile(conf, fs, sourceFile, cacheConfig);
        String msg = "Renaming flushed file from " + sourceFile + " to " + dstPath;
        LOG.info((Object)msg);
        Path parent = dstPath.getParent();
        if (!fs.exists(parent)) {
            fs.mkdirs(parent);
        }
        if (!fs.rename(sourceFile, dstPath)) {
            throw new IOException("Failed rename of " + sourceFile + " to " + dstPath);
        }
        return dstPath;
    }

    private static void validateMobFile(Configuration conf, FileSystem fs, Path path, CacheConfig cacheConfig) throws IOException {
        StoreFile storeFile = null;
        try {
            storeFile = new StoreFile(fs, path, conf, cacheConfig, BloomType.NONE);
            storeFile.createReader();
        }
        catch (IOException e) {
            LOG.error((Object)("Fail to open mob file[" + path + "], keep it in temp directory."), (Throwable)e);
            throw e;
        }
        finally {
            if (storeFile != null) {
                storeFile.closeReader(false);
            }
        }
    }

    public static boolean hasValidMobRefCellValue(Cell cell) {
        return cell.getValueLength() > 4;
    }

    public static int getMobValueLength(Cell cell) {
        return Bytes.toInt((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)4);
    }

    public static String getMobFileName(Cell cell) {
        return Bytes.toString((byte[])cell.getValueArray(), (int)(cell.getValueOffset() + 4), (int)(cell.getValueLength() - 4));
    }

    public static TableName getTableLockName(TableName tn) {
        byte[] tableName = tn.getName();
        return TableName.valueOf((byte[])Bytes.add((byte[])tableName, (byte[])MobConstants.MOB_TABLE_LOCK_SUFFIX));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doMobFileCompaction(Configuration conf, FileSystem fs, TableName tableName, HColumnDescriptor hcd, ExecutorService pool, TableLockManager tableLockManager, boolean isForceAllFiles) throws IOException {
        if (HFile.getFormatVersion(conf) < 3) {
            throw new IOException("A minimum HFile version of 3 is required for MOB feature. Consider setting hfile.format.version in hbase master's hbase-site.xml accordingly.");
        }
        String className = conf.get("hbase.mob.file.compactor.class", PartitionedMobFileCompactor.class.getName());
        MobFileCompactor compactor = null;
        try {
            compactor = (MobFileCompactor)ReflectionUtils.instantiateWithCustomCtor((String)className, (Class[])new Class[]{Configuration.class, FileSystem.class, TableName.class, HColumnDescriptor.class, ExecutorService.class}, (Object[])new Object[]{conf, fs, tableName, hcd, pool});
        }
        catch (Exception e) {
            throw new IOException("Unable to load configured mob file compactor '" + className + "'", e);
        }
        boolean tableLocked = false;
        TableLockManager.TableLock lock = null;
        try {
            if (tableLockManager != null) {
                lock = tableLockManager.writeLock(MobUtils.getTableLockName(tableName), "Run MobFileCompaction");
                lock.acquire();
            }
            tableLocked = true;
            compactor.compact(isForceAllFiles);
        }
        catch (Exception e) {
            LOG.error((Object)("Fail to compact the mob files for the column " + hcd.getNameAsString() + " in the table " + tableName.getNameAsString()), (Throwable)e);
        }
        finally {
            if (lock != null && tableLocked) {
                try {
                    lock.release();
                }
                catch (IOException e) {
                    LOG.error((Object)("Fail to release the write lock for the table " + tableName.getNameAsString()), (Throwable)e);
                }
            }
        }
    }

    public static ExecutorService createMobFileCompactorThreadPool(Configuration conf) {
        int maxThreads = conf.getInt("hbase.mob.file.compaction.threads.max", 1);
        if (maxThreads == 0) {
            maxThreads = 1;
        }
        final SynchronousQueue<Runnable> queue = new SynchronousQueue<Runnable>();
        ThreadPoolExecutor pool = new ThreadPoolExecutor(1, maxThreads, 60L, TimeUnit.SECONDS, queue, Threads.newDaemonThreadFactory((String)"MobFileCompactor"), new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                try {
                    queue.put(r);
                }
                catch (InterruptedException e) {
                    throw new RejectedExecutionException(e);
                }
            }
        });
        pool.allowCoreThreadTimeOut(true);
        return pool;
    }

    public static boolean hasMobColumns(HTableDescriptor htd) {
        HColumnDescriptor[] hcds;
        for (HColumnDescriptor hcd : hcds = htd.getColumnFamilies()) {
            if (!hcd.isMobEnabled()) continue;
            return true;
        }
        return false;
    }

    public static boolean isReadEmptyValueOnMobCellMiss(Scan scan) {
        byte[] readEmptyValueOnMobCellMiss = scan.getAttribute("empty.value.on.mobcell.miss");
        try {
            return readEmptyValueOnMobCellMiss != null && Bytes.toBoolean((byte[])readEmptyValueOnMobCellMiss);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static void archiveMobStoreFiles(Configuration conf, FileSystem fs, HRegionInfo mobRegionInfo, Path mobFamilyDir, byte[] family) throws IOException {
        Configuration copyOfConf = HBaseConfiguration.create((Configuration)conf);
        copyOfConf.setFloat("hfile.block.cache.size", 0.0f);
        CacheConfig cacheConfig = new CacheConfig(copyOfConf);
        FileStatus[] fileStatus = FSUtils.listStatus(fs, mobFamilyDir);
        ArrayList<StoreFile> storeFileList = new ArrayList<StoreFile>();
        for (FileStatus file : fileStatus) {
            storeFileList.add(new StoreFile(fs, file.getPath(), conf, cacheConfig, BloomType.NONE));
        }
        HFileArchiver.archiveStoreFiles(conf, fs, mobRegionInfo, mobFamilyDir, family, storeFileList);
    }

    public static boolean fillPartitionId(PartitionedMobFileCompactionRequest.CompactionPartitionId id, Date firstDayOfCurrentMonth, Date firstDayOfCurrentWeek, String dateStr, MobCompactPartitionPolicy policy, Calendar calendar, long threshold) {
        Date date;
        boolean skipCompcation = false;
        id.setThreshold(threshold);
        if (threshold <= 0L) {
            id.setDate(dateStr);
            return skipCompcation;
        }
        try {
            date = MobUtils.parseDate(dateStr);
        }
        catch (ParseException e) {
            LOG.warn((Object)("Failed to parse date " + dateStr), (Throwable)e);
            id.setDate(dateStr);
            return true;
        }
        if (policy == MobCompactPartitionPolicy.MONTHLY && date.before(firstDayOfCurrentMonth)) {
            long finalThreshold = threshold < 0x492492492492492L ? 28L * threshold : Long.MAX_VALUE;
            id.setThreshold(finalThreshold);
            id.setDate(MobUtils.formatDate(MobUtils.getFirstDayOfMonth(calendar, date)));
            return skipCompcation;
        }
        if (policy == MobCompactPartitionPolicy.MONTHLY || policy == MobCompactPartitionPolicy.WEEKLY) {
            if (date.before(firstDayOfCurrentWeek)) {
                long finalThreshold = threshold < 1317624576693539401L ? 7L * threshold : Long.MAX_VALUE;
                id.setThreshold(finalThreshold);
                id.setDate(MobUtils.formatDate(MobUtils.getFirstDayOfWeek(calendar, date)));
                return skipCompcation;
            }
            if (policy == MobCompactPartitionPolicy.MONTHLY) {
                skipCompcation = true;
            }
        }
        id.setDate(dateStr);
        return skipCompcation;
    }
}

