/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Service;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.ClusterId;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.CoordinatedStateException;
import org.apache.hadoop.hbase.CoordinatedStateManager;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.MetaMigrationConvertingToPB;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.NamespaceNotFoundException;
import org.apache.hadoop.hbase.PleaseHoldException;
import org.apache.hadoop.hbase.ProcedureInfo;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerLoad;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.TableDescriptors;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotDisabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.UnknownRegionException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.MetaScanner;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.coprocessor.CoprocessorHost;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.executor.ExecutorType;
import org.apache.hadoop.hbase.http.InfoServer;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.ipc.ServerNotRunningYetException;
import org.apache.hadoop.hbase.master.ActiveMasterManager;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.CatalogJanitor;
import org.apache.hadoop.hbase.master.ClusterStatusPublisher;
import org.apache.hadoop.hbase.master.ExpiredMobFileCleanerChore;
import org.apache.hadoop.hbase.master.HMasterCommandLine;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.MasterDumpServlet;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.master.MasterMobFileCompactionThread;
import org.apache.hadoop.hbase.master.MasterRpcServices;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.MasterStatusServlet;
import org.apache.hadoop.hbase.master.MetricsMaster;
import org.apache.hadoop.hbase.master.MetricsMasterWrapperImpl;
import org.apache.hadoop.hbase.master.MobFileCompactionChore;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.RegionStates;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.master.TableNamespaceManager;
import org.apache.hadoop.hbase.master.balancer.BalancerChore;
import org.apache.hadoop.hbase.master.balancer.BaseLoadBalancer;
import org.apache.hadoop.hbase.master.balancer.ClusterStatusChore;
import org.apache.hadoop.hbase.master.balancer.LoadBalancerFactory;
import org.apache.hadoop.hbase.master.cleaner.HFileCleaner;
import org.apache.hadoop.hbase.master.cleaner.LogCleaner;
import org.apache.hadoop.hbase.master.handler.DispatchMergingRegionHandler;
import org.apache.hadoop.hbase.master.normalizer.NormalizationPlan;
import org.apache.hadoop.hbase.master.normalizer.RegionNormalizer;
import org.apache.hadoop.hbase.master.normalizer.RegionNormalizerChore;
import org.apache.hadoop.hbase.master.normalizer.RegionNormalizerFactory;
import org.apache.hadoop.hbase.master.procedure.AddColumnFamilyProcedure;
import org.apache.hadoop.hbase.master.procedure.CreateTableProcedure;
import org.apache.hadoop.hbase.master.procedure.DeleteColumnFamilyProcedure;
import org.apache.hadoop.hbase.master.procedure.DeleteTableProcedure;
import org.apache.hadoop.hbase.master.procedure.DisableTableProcedure;
import org.apache.hadoop.hbase.master.procedure.EnableTableProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureScheduler;
import org.apache.hadoop.hbase.master.procedure.ModifyColumnFamilyProcedure;
import org.apache.hadoop.hbase.master.procedure.ModifyTableProcedure;
import org.apache.hadoop.hbase.master.procedure.ProcedurePrepareLatch;
import org.apache.hadoop.hbase.master.procedure.ProcedureSyncWait;
import org.apache.hadoop.hbase.master.procedure.TruncateTableProcedure;
import org.apache.hadoop.hbase.master.snapshot.SnapshotManager;
import org.apache.hadoop.hbase.monitoring.MemoryBoundedLogMessageBuffer;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.monitoring.TaskMonitor;
import org.apache.hadoop.hbase.procedure.MasterProcedureManagerHost;
import org.apache.hadoop.hbase.procedure.flush.MasterFlushTableProcedureManager;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureRunnableSet;
import org.apache.hadoop.hbase.procedure2.store.ProcedureStore;
import org.apache.hadoop.hbase.procedure2.store.wal.WALProcedureStore;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.quotas.MasterQuotaManager;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.RSRpcServices;
import org.apache.hadoop.hbase.regionserver.RegionCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.RegionSplitPolicy;
import org.apache.hadoop.hbase.regionserver.compactions.ExploringCompactionPolicy;
import org.apache.hadoop.hbase.regionserver.compactions.FIFOCompactionPolicy;
import org.apache.hadoop.hbase.replication.master.TableCFsUpdater;
import org.apache.hadoop.hbase.replication.regionserver.Replication;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.util.Addressing;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CompressionTest;
import org.apache.hadoop.hbase.util.ConfigUtil;
import org.apache.hadoop.hbase.util.EncryptionTest;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.HFileArchiveUtil;
import org.apache.hadoop.hbase.util.HasThread;
import org.apache.hadoop.hbase.util.IdLock;
import org.apache.hadoop.hbase.util.ModifyRegionUtils;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.zookeeper.DrainingServerTracker;
import org.apache.hadoop.hbase.zookeeper.LoadBalancerTracker;
import org.apache.hadoop.hbase.zookeeper.MasterAddressTracker;
import org.apache.hadoop.hbase.zookeeper.MasterMaintenanceModeTracker;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hadoop.hbase.zookeeper.RegionNormalizerTracker;
import org.apache.hadoop.hbase.zookeeper.RegionServerTracker;
import org.apache.hadoop.hbase.zookeeper.SplitOrMergeTracker;
import org.apache.hadoop.hbase.zookeeper.ZKClusterId;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperListener;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.util.VersionInfo;
import org.apache.zookeeper.KeeperException;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;

@InterfaceAudience.LimitedPrivate(value={"Tools"})
public class HMaster
extends HRegionServer
implements MasterServices,
Server {
    private static final Log LOG = LogFactory.getLog((String)HMaster.class.getName());
    public static final String MASTER = "master";
    private final ActiveMasterManager activeMasterManager;
    RegionServerTracker regionServerTracker;
    private DrainingServerTracker drainingServerTracker;
    LoadBalancerTracker loadBalancerTracker;
    private SplitOrMergeTracker splitOrMergeTracker;
    private RegionNormalizerTracker regionNormalizerTracker;
    private TableNamespaceManager tableNamespaceManager;
    private MasterMaintenanceModeTracker maintenanceModeTracker;
    final MetricsMaster metricsMaster;
    private MasterFileSystem fileSystemManager;
    volatile ServerManager serverManager;
    AssignmentManager assignmentManager;
    MemoryBoundedLogMessageBuffer rsFatals;
    private volatile boolean isActiveMaster = false;
    private final MasterProcedureScheduler.ProcedureEvent initialized = new MasterProcedureScheduler.ProcedureEvent("master initialized");
    volatile boolean serviceStarted = false;
    private final MasterProcedureScheduler.ProcedureEvent serverCrashProcessingEnabled = new MasterProcedureScheduler.ProcedureEvent("server crash processing");
    LoadBalancer balancer;
    private RegionNormalizer normalizer;
    private BalancerChore balancerChore;
    private RegionNormalizerChore normalizerChore;
    private ClusterStatusChore clusterStatusChore;
    private ClusterStatusPublisher clusterStatusPublisherChore = null;
    private PeriodicDoMetrics periodicDoMetricsChore = null;
    CatalogJanitor catalogJanitorChore;
    private LogCleaner logCleaner;
    private HFileCleaner hfileCleaner;
    private ExpiredMobFileCleanerChore expiredMobFileCleanerChore;
    private MobFileCompactionChore mobFileCompactChore;
    MasterMobFileCompactionThread mobFileCompactThread;
    private final IdLock mobFileCompactionLock = new IdLock();
    private Map<TableName, AtomicInteger> mobFileCompactionStates = Maps.newConcurrentMap();
    MasterCoprocessorHost cpHost;
    private final boolean preLoadTableDescriptors;
    private long masterActiveTime;
    private final boolean masterCheckCompression;
    private final boolean masterCheckEncryption;
    Map<String, Service> coprocessorServiceHandlers = Maps.newHashMap();
    SnapshotManager snapshotManager;
    MasterProcedureManagerHost mpmHost;
    private volatile MasterQuotaManager quotaManager;
    private ProcedureExecutor<MasterProcedureEnv> procedureExecutor;
    private WALProcedureStore procedureStore;
    private volatile boolean initializationBeforeMetaAssignment = false;
    private org.mortbay.jetty.Server masterJettyServer;

    public HMaster(Configuration conf, CoordinatedStateManager csm) throws IOException, KeeperException, InterruptedException {
        super(conf, csm);
        this.rsFatals = new MemoryBoundedLogMessageBuffer(conf.getLong("hbase.master.buffer.for.rs.fatals", 0x100000L));
        LOG.info((Object)("hbase.rootdir=" + FSUtils.getRootDir(this.conf) + ", hbase.cluster.distributed=" + this.conf.getBoolean("hbase.cluster.distributed", false)));
        this.conf.setBoolean("hbase.meta.replicas.use", false);
        Replication.decorateMasterConfiguration(this.conf);
        if (this.conf.get("mapreduce.task.attempt.id") == null) {
            this.conf.set("mapreduce.task.attempt.id", "hb_m_" + this.serverName.toString());
        }
        this.masterCheckCompression = conf.getBoolean("hbase.master.check.compression", true);
        this.masterCheckEncryption = conf.getBoolean("hbase.master.check.encryption", true);
        this.metricsMaster = new MetricsMaster(new MetricsMasterWrapperImpl(this));
        this.preLoadTableDescriptors = conf.getBoolean("hbase.master.preload.tabledescriptors", true);
        boolean shouldPublish = conf.getBoolean("hbase.status.published", false);
        Class publisherClass = conf.getClass("hbase.status.publisher.class", ClusterStatusPublisher.DEFAULT_STATUS_PUBLISHER_CLASS, ClusterStatusPublisher.Publisher.class);
        if (shouldPublish) {
            if (publisherClass == null) {
                LOG.warn((Object)("hbase.status.published is true, but " + ClusterStatusPublisher.DEFAULT_STATUS_PUBLISHER_CLASS + " is not set - not publishing status"));
            } else {
                this.clusterStatusPublisherChore = new ClusterStatusPublisher(this, conf, publisherClass);
                this.getChoreService().scheduleChore((ScheduledChore)this.clusterStatusPublisherChore);
            }
        }
        if (!conf.getBoolean("hbase.testing.nocluster", false)) {
            this.activeMasterManager = new ActiveMasterManager(this.zooKeeper, this.serverName, this);
            int infoPort = this.putUpJettyServer();
            this.startActiveMasterManager(infoPort);
        } else {
            this.activeMasterManager = null;
        }
    }

    private int putUpJettyServer() throws IOException {
        if (!this.conf.getBoolean("hbase.master.infoserver.redirect", true)) {
            return -1;
        }
        int infoPort = this.conf.getInt("hbase.master.info.port.orig", 60010);
        if (infoPort < 0 || this.infoServer == null) {
            return -1;
        }
        if (infoPort == this.infoServer.getPort()) {
            return infoPort;
        }
        String addr = this.conf.get("hbase.master.info.bindAddress", "0.0.0.0");
        if (!Addressing.isLocalAddress((InetAddress)InetAddress.getByName(addr))) {
            String msg = "Failed to start redirecting jetty server. Address " + addr + " does not belong to this host. Correct configuration parameter: " + "hbase.master.info.bindAddress";
            LOG.error((Object)msg);
            throw new IOException(msg);
        }
        this.masterJettyServer = new org.mortbay.jetty.Server();
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setHost(addr);
        connector.setPort(infoPort);
        this.masterJettyServer.addConnector((Connector)connector);
        this.masterJettyServer.setStopAtShutdown(true);
        String redirectHostname = this.shouldUseThisHostnameInstead() ? this.useThisHostnameInstead : null;
        RedirectServlet redirect = new RedirectServlet(this.infoServer, redirectHostname);
        Context context = new Context((HandlerContainer)this.masterJettyServer, "/", 0);
        context.addServlet(new ServletHolder((Servlet)redirect), "/*");
        try {
            this.masterJettyServer.start();
        }
        catch (Exception e) {
            throw new IOException("Failed to start redirecting jetty server", e);
        }
        return connector.getLocalPort();
    }

    @Override
    protected void login(UserProvider user, String host) throws IOException {
        try {
            super.login(user, host);
        }
        catch (IOException ie) {
            user.login("hbase.master.keytab.file", "hbase.master.kerberos.principal", host);
        }
    }

    @Override
    protected void waitForMasterActive() {
        boolean tablesOnMaster = BaseLoadBalancer.tablesOnMaster(this.conf);
        while (!(tablesOnMaster && this.isActiveMaster || this.isStopped() || this.isAborted())) {
            this.sleeper.sleep();
        }
    }

    @VisibleForTesting
    public MasterRpcServices getMasterRpcServices() {
        return (MasterRpcServices)this.rpcServices;
    }

    public boolean balanceSwitch(boolean b) throws IOException {
        return this.getMasterRpcServices().switchBalancer(b, MasterRpcServices.BalanceSwitchMode.ASYNC);
    }

    @Override
    protected String getProcessName() {
        return MASTER;
    }

    @Override
    protected boolean canCreateBaseZNode() {
        return true;
    }

    @Override
    protected boolean canUpdateTableDescriptor() {
        return true;
    }

    @Override
    protected RSRpcServices createRpcServices() throws IOException {
        return new MasterRpcServices(this);
    }

    @Override
    protected void configureInfoServer() {
        this.infoServer.addServlet("master-status", "/master-status", MasterStatusServlet.class);
        this.infoServer.setAttribute(MASTER, this);
        if (BaseLoadBalancer.tablesOnMaster(this.conf)) {
            super.configureInfoServer();
        }
    }

    @Override
    protected Class<? extends HttpServlet> getDumpServlet() {
        return MasterDumpServlet.class;
    }

    private void doMetrics() {
        try {
            if (this.assignmentManager != null) {
                this.assignmentManager.updateRegionsInTransitionMetrics();
            }
        }
        catch (Throwable e) {
            LOG.error((Object)("Couldn't update metrics: " + e.getMessage()));
        }
    }

    MetricsMaster getMasterMetrics() {
        return this.metricsMaster;
    }

    void initializeZKBasedSystemTrackers() throws IOException, InterruptedException, KeeperException, CoordinatedStateException {
        this.balancer = LoadBalancerFactory.getLoadBalancer(this.conf);
        this.normalizer = RegionNormalizerFactory.getRegionNormalizer(this.conf);
        this.normalizer.setMasterServices(this);
        this.loadBalancerTracker = new LoadBalancerTracker(this.zooKeeper, this);
        this.loadBalancerTracker.start();
        this.regionNormalizerTracker = new RegionNormalizerTracker(this.zooKeeper, this);
        this.regionNormalizerTracker.start();
        this.splitOrMergeTracker = new SplitOrMergeTracker(this.zooKeeper, this.conf, this);
        this.splitOrMergeTracker.start();
        this.assignmentManager = new AssignmentManager(this, this.serverManager, this.balancer, this.service, this.metricsMaster, this.tableLockManager);
        this.zooKeeper.registerListenerFirst((ZooKeeperListener)this.assignmentManager);
        this.regionServerTracker = new RegionServerTracker(this.zooKeeper, this, this.serverManager);
        this.regionServerTracker.start();
        this.drainingServerTracker = new DrainingServerTracker(this.zooKeeper, this, this.serverManager);
        this.drainingServerTracker.start();
        this.maintenanceModeTracker = new MasterMaintenanceModeTracker(this.zooKeeper);
        this.maintenanceModeTracker.start();
        boolean wasUp = this.clusterStatusTracker.isClusterUp();
        if (!wasUp) {
            this.clusterStatusTracker.setClusterUp();
        }
        LOG.info((Object)("Server active/primary master=" + this.serverName + ", sessionid=0x" + Long.toHexString(this.zooKeeper.getRecoverableZooKeeper().getSessionId()) + ", setting cluster-up flag (Was=" + wasUp + ")"));
        this.snapshotManager = new SnapshotManager();
        this.mpmHost = new MasterProcedureManagerHost();
        this.mpmHost.register(this.snapshotManager);
        this.mpmHost.register(new MasterFlushTableProcedureManager());
        this.mpmHost.loadProcedures(this.conf);
        this.mpmHost.initialize(this, this.metricsMaster);
    }

    private void finishActiveMasterInitialization(MonitoredTask status) throws IOException, InterruptedException, KeeperException, CoordinatedStateException {
        this.isActiveMaster = true;
        Thread zombieDetector = new Thread((Runnable)((Object)new InitializationMonitor(this)));
        zombieDetector.start();
        status.setStatus("Initializing Master file system");
        this.masterActiveTime = System.currentTimeMillis();
        this.fileSystemManager = new MasterFileSystem(this, this);
        this.tableDescriptors.setCacheOn();
        this.tableDescriptors.get(TableName.META_TABLE_NAME).setRegionReplication(this.conf.getInt("hbase.meta.replica.count", 1));
        if (this.preLoadTableDescriptors) {
            status.setStatus("Pre-loading table descriptors");
            this.tableDescriptors.getAll();
        }
        status.setStatus("Publishing Cluster ID in ZooKeeper");
        ZKClusterId.setClusterId((ZooKeeperWatcher)this.zooKeeper, (ClusterId)this.fileSystemManager.getClusterId());
        this.serverManager = this.createServerManager(this, this);
        this.setupClusterConnection();
        this.tableLockManager.reapWriteLocks();
        status.setStatus("Initializing ZK system trackers");
        this.initializeZKBasedSystemTrackers();
        if (this.conf.getBoolean("hbase.ReplicationMigrationConvertingToPB", true)) {
            status.setStatus("Update TableCFs node in ZNode");
            TableCFsUpdater tableCFsUpdater = new TableCFsUpdater(this.zooKeeper, this.conf, (Abortable)this.clusterConnection);
            tableCFsUpdater.update();
        }
        status.setStatus("Initializing master coprocessors");
        this.cpHost = new MasterCoprocessorHost(this, this.conf);
        status.setStatus("Initializing master service threads");
        this.startServiceThreads();
        this.sleeper.skipSleepCycle();
        this.serverManager.waitForRegionServers(status);
        for (ServerName sn : this.regionServerTracker.getOnlineServers()) {
            if (this.serverManager.isServerOnline(sn) || !this.serverManager.checkAndRecordNewServer(sn, ServerLoad.EMPTY_SERVERLOAD)) continue;
            LOG.info((Object)("Registered server found up in zk but who has not yet reported in: " + sn));
        }
        Set<ServerName> previouslyFailedServers = this.fileSystemManager.getFailedServersFromLogFolders();
        ServerName oldMetaServerLocation = this.metaTableLocator.getMetaRegionLocation(this.getZooKeeper());
        if (oldMetaServerLocation != null && previouslyFailedServers.contains(oldMetaServerLocation)) {
            this.splitMetaLogBeforeAssignment(oldMetaServerLocation);
        }
        Set<ServerName> previouslyFailedMetaRSs = this.getPreviouselyFailedMetaServersFromZK();
        previouslyFailedMetaRSs.addAll(previouslyFailedServers);
        this.initializationBeforeMetaAssignment = true;
        if (BaseLoadBalancer.tablesOnMaster(this.conf)) {
            this.waitForServerOnline();
        }
        this.balancer.setClusterStatus(this.getClusterStatus());
        this.balancer.setMasterServices(this);
        this.balancer.initialize();
        if (this.isStopped()) {
            return;
        }
        status.setStatus("Assigning Meta Region");
        this.assignMeta(status, previouslyFailedMetaRSs, 0);
        if (this.isStopped()) {
            return;
        }
        status.setStatus("Submitting log splitting work for previously failed region servers");
        for (ServerName tmpServer : previouslyFailedServers) {
            this.serverManager.processDeadServer(tmpServer, true);
        }
        if (this.conf.getBoolean("hbase.MetaMigrationConvertingToPB", true)) {
            MetaMigrationConvertingToPB.updateMetaIfNecessary(this);
        }
        status.setStatus("Starting assignment manager");
        this.assignmentManager.joinCluster();
        this.balancer.setClusterStatus(this.getClusterStatus());
        status.setStatus("Starting balancer and catalog janitor");
        this.clusterStatusChore = new ClusterStatusChore(this, this.balancer);
        this.getChoreService().scheduleChore((ScheduledChore)this.clusterStatusChore);
        this.balancerChore = new BalancerChore(this);
        this.getChoreService().scheduleChore((ScheduledChore)this.balancerChore);
        this.normalizerChore = new RegionNormalizerChore(this);
        this.getChoreService().scheduleChore((ScheduledChore)this.normalizerChore);
        this.catalogJanitorChore = new CatalogJanitor(this, this);
        this.getChoreService().scheduleChore((ScheduledChore)this.catalogJanitorChore);
        this.periodicDoMetricsChore = new PeriodicDoMetrics(this.msgInterval, this);
        this.getChoreService().scheduleChore((ScheduledChore)this.periodicDoMetricsChore);
        status.setStatus("Starting namespace manager");
        this.initNamespace();
        if (this.cpHost != null) {
            try {
                this.cpHost.preMasterInitialization();
            }
            catch (IOException e) {
                LOG.error((Object)"Coprocessor preMasterInitialization() hook failed", (Throwable)e);
            }
        }
        status.markComplete("Initialization successful");
        LOG.info((Object)"Master has completed initialization");
        this.configurationManager.registerObserver(this.balancer);
        this.setInitialized(true);
        status.setStatus("Starting quota manager");
        this.initQuotaManager();
        HashSet<ServerName> EMPTY_SET = new HashSet<ServerName>();
        int numReplicas = this.conf.getInt("hbase.meta.replica.count", 1);
        for (int i = 1; i < numReplicas; ++i) {
            this.assignMeta(status, EMPTY_SET, i);
        }
        this.unassignExcessMetaReplica(this.zooKeeper, numReplicas);
        this.serverManager.clearDeadServersWithSameHostNameAndPortOfOnlineServer();
        status.setStatus("Checking ZNode ACLs");
        this.zooKeeper.checkAndSetZNodeAcls();
        status.setStatus("Calling postStartMaster coprocessors");
        this.expiredMobFileCleanerChore = new ExpiredMobFileCleanerChore(this);
        this.getChoreService().scheduleChore((ScheduledChore)this.expiredMobFileCleanerChore);
        this.mobFileCompactChore = new MobFileCompactionChore(this);
        this.getChoreService().scheduleChore((ScheduledChore)this.mobFileCompactChore);
        this.mobFileCompactThread = new MasterMobFileCompactionThread(this);
        if (this.cpHost != null) {
            try {
                this.cpHost.postStartMaster();
            }
            catch (IOException ioe) {
                LOG.error((Object)"Coprocessor postStartMaster() hook failed", (Throwable)ioe);
            }
        }
        zombieDetector.interrupt();
    }

    private void initQuotaManager() throws IOException {
        this.quotaManager = new MasterQuotaManager(this);
        this.assignmentManager.setRegionStateListener(this.quotaManager);
        this.quotaManager.start();
    }

    ServerManager createServerManager(Server master, MasterServices services) throws IOException {
        return new ServerManager(master, services);
    }

    private void unassignExcessMetaReplica(ZooKeeperWatcher zkw, int numMetaReplicasConfigured) {
        try {
            List metaReplicaZnodes = this.zooKeeper.getMetaReplicaNodes();
            for (String metaReplicaZnode : metaReplicaZnodes) {
                int replicaId = this.zooKeeper.getMetaReplicaIdFromZnode(metaReplicaZnode);
                if (replicaId < numMetaReplicasConfigured) continue;
                RegionState r = MetaTableLocator.getMetaRegionState((ZooKeeperWatcher)zkw, (int)replicaId);
                LOG.info((Object)("Closing excess replica of meta region " + r.getRegion()));
                ServerManager.closeRegionSilentlyAndWait(this.getConnection(), r.getServerName(), r.getRegion(), 30000L);
                ZKUtil.deleteNode((ZooKeeperWatcher)zkw, (String)zkw.getZNodeForReplica(replicaId));
            }
        }
        catch (Exception ex) {
            LOG.warn((Object)("Ignoring exception " + ex));
        }
    }

    void assignMeta(MonitoredTask status, Set<ServerName> previouslyFailedMetaRSs, int replicaId) throws InterruptedException, IOException, KeeperException {
        int assigned = 0;
        long timeout = this.conf.getLong("hbase.catalog.verification.timeout", 1000L);
        if (replicaId == 0) {
            status.setStatus("Assigning hbase:meta region");
        } else {
            status.setStatus("Assigning hbase:meta region, replicaId " + replicaId);
        }
        RegionStates regionStates = this.assignmentManager.getRegionStates();
        RegionState metaState = MetaTableLocator.getMetaRegionState((ZooKeeperWatcher)this.getZooKeeper(), (int)replicaId);
        HRegionInfo hri = RegionReplicaUtil.getRegionInfoForReplica((HRegionInfo)HRegionInfo.FIRST_META_REGIONINFO, (int)replicaId);
        ServerName currentMetaServer = metaState.getServerName();
        if (!ConfigUtil.useZKForAssignment(this.conf)) {
            regionStates.createRegionState(hri, metaState.getState(), currentMetaServer, null);
        } else {
            regionStates.createRegionState(hri);
        }
        boolean rit = this.assignmentManager.processRegionInTransitionAndBlockUntilAssigned(hri);
        boolean metaRegionLocation = this.metaTableLocator.verifyMetaRegionLocation((HConnection)this.getConnection(), this.getZooKeeper(), timeout, replicaId);
        if (!metaRegionLocation || !metaState.isOpened()) {
            ++assigned;
            if (!ConfigUtil.useZKForAssignment(this.conf)) {
                this.assignMetaZkLess(regionStates, metaState, timeout, previouslyFailedMetaRSs);
            } else if (!rit) {
                if (currentMetaServer != null) {
                    if (this.serverManager.isServerOnline(currentMetaServer)) {
                        LOG.info((Object)("Forcing expire of " + currentMetaServer));
                        this.serverManager.expireServer(currentMetaServer);
                    }
                    if (replicaId == 0) {
                        this.splitMetaLogBeforeAssignment(currentMetaServer);
                        previouslyFailedMetaRSs.add(currentMetaServer);
                    }
                }
                this.assignmentManager.assignMeta(hri);
            }
        } else {
            regionStates.updateRegionState(hri, RegionState.State.OPEN, currentMetaServer);
            this.assignmentManager.regionOnline(hri, currentMetaServer);
        }
        if (replicaId == 0) {
            this.enableMeta(TableName.META_TABLE_NAME);
        }
        if (ZooKeeperProtos.SplitLogTask.RecoveryMode.LOG_REPLAY == this.getMasterFileSystem().getLogRecoveryMode() && !previouslyFailedMetaRSs.isEmpty()) {
            status.setStatus("replaying log for Meta Region");
            this.fileSystemManager.splitMetaLog(previouslyFailedMetaRSs);
        }
        if (replicaId == 0) {
            this.enableCrashedServerProcessing(assigned != 0);
        }
        LOG.info((Object)("hbase:meta with replicaId " + replicaId + " assigned=" + assigned + ", rit=" + rit + ", location=" + this.metaTableLocator.getMetaRegionLocation(this.getZooKeeper(), replicaId)));
        status.setStatus("META assigned.");
    }

    private void assignMetaZkLess(RegionStates regionStates, RegionState regionState, long timeout, Set<ServerName> previouslyFailedRs) throws IOException, KeeperException {
        ServerName currentServer = regionState.getServerName();
        if (this.serverManager.isServerOnline(currentServer)) {
            LOG.info((Object)("Meta was in transition on " + currentServer));
            this.assignmentManager.processRegionInTransitionZkLess();
        } else {
            if (currentServer != null && regionState.getRegion().getReplicaId() == 0) {
                this.splitMetaLogBeforeAssignment(currentServer);
                regionStates.logSplit(HRegionInfo.FIRST_META_REGIONINFO);
                previouslyFailedRs.add(currentServer);
            }
            LOG.info((Object)("Re-assigning hbase:meta, it was on " + currentServer));
            regionStates.updateRegionState(regionState.getRegion(), RegionState.State.OFFLINE);
            this.assignmentManager.assignMeta(regionState.getRegion());
        }
    }

    void initNamespace() throws IOException {
        this.tableNamespaceManager = new TableNamespaceManager(this);
        this.tableNamespaceManager.start();
    }

    boolean isCatalogJanitorEnabled() {
        return this.catalogJanitorChore != null ? this.catalogJanitorChore.getEnabled() : false;
    }

    private void splitMetaLogBeforeAssignment(ServerName currentMetaServer) throws IOException {
        if (ZooKeeperProtos.SplitLogTask.RecoveryMode.LOG_REPLAY == this.getMasterFileSystem().getLogRecoveryMode()) {
            HashSet<HRegionInfo> regions = new HashSet<HRegionInfo>();
            regions.add(HRegionInfo.FIRST_META_REGIONINFO);
            this.fileSystemManager.prepareLogReplay(currentMetaServer, regions);
        } else {
            this.fileSystemManager.splitMetaLog(currentMetaServer);
        }
    }

    private void enableCrashedServerProcessing(boolean waitForMeta) throws IOException, InterruptedException {
        if (!this.isServerCrashProcessingEnabled()) {
            this.setServerCrashProcessingEnabled(true);
            this.serverManager.processQueuedDeadServers();
        }
        if (waitForMeta) {
            this.metaTableLocator.waitMetaRegionLocation(this.getZooKeeper());
            this.assignmentManager.waitForAssignment(HRegionInfo.FIRST_META_REGIONINFO);
        }
    }

    private void enableMeta(TableName metaTableName) {
        if (!this.assignmentManager.getTableStateManager().isTableState(metaTableName, ZooKeeperProtos.Table.State.ENABLED)) {
            this.assignmentManager.setEnabledTable(metaTableName);
        }
    }

    private Set<ServerName> getPreviouselyFailedMetaServersFromZK() throws KeeperException {
        HashSet<ServerName> result = new HashSet<ServerName>();
        String metaRecoveringZNode = ZKUtil.joinZNode((String)this.zooKeeper.recoveringRegionsZNode, (String)HRegionInfo.FIRST_META_REGIONINFO.getEncodedName());
        List regionFailedServers = ZKUtil.listChildrenNoWatch((ZooKeeperWatcher)this.zooKeeper, (String)metaRecoveringZNode);
        if (regionFailedServers == null) {
            return result;
        }
        for (String failedServer : regionFailedServers) {
            ServerName server = ServerName.parseServerName((String)failedServer);
            result.add(server);
        }
        return result;
    }

    @Override
    public TableDescriptors getTableDescriptors() {
        return this.tableDescriptors;
    }

    @Override
    public ServerManager getServerManager() {
        return this.serverManager;
    }

    @Override
    public MasterFileSystem getMasterFileSystem() {
        return this.fileSystemManager;
    }

    private void startServiceThreads() throws IOException {
        this.service.startExecutorService(ExecutorType.MASTER_OPEN_REGION, this.conf.getInt("hbase.master.executor.openregion.threads", 5));
        this.service.startExecutorService(ExecutorType.MASTER_CLOSE_REGION, this.conf.getInt("hbase.master.executor.closeregion.threads", 5));
        this.service.startExecutorService(ExecutorType.MASTER_SERVER_OPERATIONS, this.conf.getInt("hbase.master.executor.serverops.threads", 5));
        this.service.startExecutorService(ExecutorType.MASTER_META_SERVER_OPERATIONS, this.conf.getInt("hbase.master.executor.serverops.threads", 5));
        this.service.startExecutorService(ExecutorType.M_LOG_REPLAY_OPS, this.conf.getInt("hbase.master.executor.logreplayops.threads", 10));
        this.service.startExecutorService(ExecutorType.MASTER_TABLE_OPERATIONS, 1);
        this.startProcedureExecutor();
        int cleanerInterval = this.conf.getInt("hbase.master.cleaner.interval", 60000);
        this.logCleaner = new LogCleaner(cleanerInterval, this, this.conf, this.getMasterFileSystem().getOldLogDir().getFileSystem(this.conf), this.getMasterFileSystem().getOldLogDir());
        this.getChoreService().scheduleChore((ScheduledChore)this.logCleaner);
        Path archiveDir = HFileArchiveUtil.getArchivePath(this.conf);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(MASTER, this);
        this.hfileCleaner = new HFileCleaner(cleanerInterval, this, this.conf, this.getMasterFileSystem().getFileSystem(), archiveDir, params);
        this.getChoreService().scheduleChore((ScheduledChore)this.hfileCleaner);
        this.serviceStarted = true;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"Started service threads");
        }
    }

    @Override
    protected void sendShutdownInterrupt() {
        super.sendShutdownInterrupt();
        this.stopProcedureExecutor();
    }

    @Override
    protected void stopServiceThreads() {
        if (this.masterJettyServer != null) {
            LOG.info((Object)"Stopping master jetty server");
            try {
                this.masterJettyServer.stop();
            }
            catch (Exception e) {
                LOG.error((Object)"Failed to stop master jetty server", (Throwable)e);
            }
        }
        super.stopServiceThreads();
        this.stopChores();
        if (!this.isAborted() && this.serverManager != null && this.serverManager.isClusterShutdown()) {
            this.serverManager.letRegionServersShutdown();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Stopping service threads");
        }
        if (this.logCleaner != null) {
            this.logCleaner.cancel(true);
        }
        if (this.hfileCleaner != null) {
            this.hfileCleaner.cancel(true);
        }
        if (this.quotaManager != null) {
            this.quotaManager.stop();
        }
        if (this.activeMasterManager != null) {
            this.activeMasterManager.stop();
        }
        if (this.serverManager != null) {
            this.serverManager.stop();
        }
        if (this.assignmentManager != null) {
            this.assignmentManager.stop();
        }
        if (this.fileSystemManager != null) {
            this.fileSystemManager.stop();
        }
        if (this.mpmHost != null) {
            this.mpmHost.stop("server shutting down.");
        }
    }

    private void startProcedureExecutor() throws IOException {
        MasterProcedureEnv procEnv = new MasterProcedureEnv(this);
        Path walDir = new Path(FSUtils.getWALRootDir(this.conf), "MasterProcWALs");
        this.procedureStore = new WALProcedureStore(this.conf, walDir.getFileSystem(this.conf), walDir, (WALProcedureStore.LeaseRecovery)new MasterProcedureEnv.WALStoreLeaseRecovery(this));
        this.procedureStore.registerListener((ProcedureStore.ProcedureStoreListener)new MasterProcedureEnv.MasterProcedureStoreListener(this));
        this.procedureExecutor = new ProcedureExecutor(this.conf, (Object)procEnv, (ProcedureStore)this.procedureStore, (ProcedureRunnableSet)procEnv.getProcedureQueue());
        int numThreads = this.conf.getInt("hbase.master.procedure.threads", Math.max(Runtime.getRuntime().availableProcessors(), 4));
        boolean abortOnCorruption = this.conf.getBoolean("hbase.procedure.abort.on.corruption", false);
        this.procedureStore.start(numThreads);
        this.procedureExecutor.start(numThreads, abortOnCorruption);
    }

    private void stopProcedureExecutor() {
        if (this.procedureExecutor != null) {
            this.procedureExecutor.stop();
        }
        if (this.procedureStore != null) {
            this.procedureStore.stop(this.isAborted());
        }
    }

    private void stopChores() {
        if (this.expiredMobFileCleanerChore != null) {
            this.expiredMobFileCleanerChore.cancel(true);
        }
        if (this.mobFileCompactChore != null) {
            this.mobFileCompactChore.cancel(true);
        }
        if (this.balancerChore != null) {
            this.balancerChore.cancel(true);
        }
        if (this.normalizerChore != null) {
            this.normalizerChore.cancel(true);
        }
        if (this.clusterStatusChore != null) {
            this.clusterStatusChore.cancel(true);
        }
        if (this.catalogJanitorChore != null) {
            this.catalogJanitorChore.cancel(true);
        }
        if (this.clusterStatusPublisherChore != null) {
            this.clusterStatusPublisherChore.cancel(true);
        }
        if (this.mobFileCompactThread != null) {
            this.mobFileCompactThread.close();
        }
        if (this.periodicDoMetricsChore != null) {
            this.periodicDoMetricsChore.cancel();
        }
    }

    InetAddress getRemoteInetAddress(int port, long serverStartCode) throws UnknownHostException {
        InetSocketAddress isa;
        InetAddress ia = RpcServer.getRemoteIp();
        if (ia == null && serverStartCode == this.startcode && (isa = this.rpcServices.getSocketAddress()) != null && isa.getPort() == port) {
            ia = isa.getAddress();
        }
        return ia;
    }

    private int getBalancerCutoffTime() {
        int balancerPeriod;
        int balancerCutoffTime = this.getConfiguration().getInt("hbase.balancer.max.balancing", -1);
        if (balancerCutoffTime == -1 && (balancerCutoffTime = (balancerPeriod = this.getConfiguration().getInt("hbase.balancer.period", 300000))) <= 0) {
            balancerCutoffTime = balancerPeriod;
        }
        return balancerCutoffTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean balance() throws IOException {
        if (!this.isInitialized()) {
            LOG.debug((Object)"Master has not been initialized, don't run balancer.");
            return false;
        }
        if (this.isInMaintenanceMode()) {
            LOG.info((Object)"Master is in maintenanceMode mode, don't run balancer.");
            return false;
        }
        int maximumBalanceTime = this.getBalancerCutoffTime();
        LoadBalancer loadBalancer = this.balancer;
        synchronized (loadBalancer) {
            if (!this.loadBalancerTracker.isBalancerOn()) {
                return false;
            }
            if (this.assignmentManager.getRegionStates().isRegionsInTransition()) {
                Map<String, RegionState> regionsInTransition = this.assignmentManager.getRegionStates().getRegionsInTransition();
                LOG.debug((Object)("Not running balancer because " + regionsInTransition.size() + " region(s) in transition: " + StringUtils.abbreviate((String)regionsInTransition.toString(), (int)256)));
                return false;
            }
            if (this.serverManager.areDeadServersInProgress()) {
                LOG.debug((Object)("Not running balancer because processing dead regionserver(s): " + this.serverManager.getDeadServers()));
                return false;
            }
            if (this.cpHost != null) {
                try {
                    if (this.cpHost.preBalance()) {
                        LOG.debug((Object)"Coprocessor bypassing balancer request");
                        return false;
                    }
                }
                catch (IOException ioe) {
                    LOG.error((Object)"Error invoking master coprocessor preBalance()", (Throwable)ioe);
                    return false;
                }
            }
            Map<TableName, Map<ServerName, List<HRegionInfo>>> assignmentsByTable = this.assignmentManager.getRegionStates().getAssignmentsByTable();
            ArrayList<RegionPlan> plans = new ArrayList<RegionPlan>();
            this.balancer.setClusterStatus(this.getClusterStatus());
            for (Map<ServerName, List<HRegionInfo>> assignments : assignmentsByTable.values()) {
                List<RegionPlan> partialPlans = this.balancer.balanceCluster(assignments);
                if (partialPlans == null) continue;
                plans.addAll(partialPlans);
            }
            long cutoffTime = System.currentTimeMillis() + (long)maximumBalanceTime;
            int rpCount = 0;
            long totalRegPlanExecTime = 0L;
            if (plans != null && !plans.isEmpty()) {
                for (RegionPlan plan : plans) {
                    LOG.info((Object)("balance " + plan));
                    long balStartTime = System.currentTimeMillis();
                    this.assignmentManager.balance(plan);
                    if (++rpCount >= plans.size() || System.currentTimeMillis() + (totalRegPlanExecTime += System.currentTimeMillis() - balStartTime) / (long)rpCount <= cutoffTime) continue;
                    LOG.debug((Object)("No more balancing till next balance run; maximumBalanceTime=" + maximumBalanceTime));
                    break;
                }
            }
            if (this.cpHost != null) {
                try {
                    this.cpHost.postBalance(rpCount < plans.size() ? plans.subList(0, rpCount) : plans);
                }
                catch (IOException ioe) {
                    LOG.error((Object)"Error invoking master coprocessor postBalance()", (Throwable)ioe);
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean normalizeRegions() throws IOException, CoordinatedStateException {
        if (!this.isInitialized()) {
            LOG.debug((Object)"Master has not been initialized, don't run region normalizer.");
            return false;
        }
        if (this.isInMaintenanceMode()) {
            LOG.info((Object)"Master is in maintenance mode, don't run region normalizer.");
            return false;
        }
        if (!this.regionNormalizerTracker.isNormalizerOn()) {
            LOG.debug((Object)"Region normalization is disabled, don't run region normalizer.");
            return false;
        }
        RegionNormalizer regionNormalizer = this.normalizer;
        synchronized (regionNormalizer) {
            ArrayList<TableName> allEnabledTables = new ArrayList<TableName>(this.assignmentManager.getTableStateManager().getTablesInStates(ZooKeeperProtos.Table.State.ENABLED));
            Collections.shuffle(allEnabledTables);
            for (TableName table : allEnabledTables) {
                if (this.isInMaintenanceMode()) {
                    LOG.debug((Object)"Master is in maintenance mode, stop running region normalizer.");
                    return false;
                }
                if (this.quotaManager.getNamespaceQuotaManager() != null && this.quotaManager.getNamespaceQuotaManager().getState(table.getNamespaceAsString()) != null) {
                    LOG.debug((Object)("Skipping normalizing " + table + " since its namespace has quota"));
                    continue;
                }
                if (table.isSystemTable() || this.getTableDescriptors().get(table) != null && !this.getTableDescriptors().get(table).isNormalizationEnabled()) {
                    LOG.debug((Object)("Skipping normalization for table: " + table + ", as it's either system" + " table or doesn't have auto normalization turned on"));
                    continue;
                }
                List<NormalizationPlan> plans = this.normalizer.computePlanForTable(table);
                if (plans == null) continue;
                for (NormalizationPlan plan : plans) {
                    plan.execute(this.clusterConnection.getAdmin());
                }
            }
        }
        return true;
    }

    String getClientIdAuditPrefix() {
        return "Client=" + RpcServer.getRequestUserName() + "/" + RpcServer.getRemoteAddress();
    }

    public void setCatalogJanitorEnabled(boolean b) {
        this.catalogJanitorChore.setEnabled(b);
    }

    @Override
    public void dispatchMergingRegions(HRegionInfo region_a, HRegionInfo region_b, boolean forcible) throws IOException {
        this.checkInitialized();
        this.service.submit(new DispatchMergingRegionHandler(this, this.catalogJanitorChore, region_a, region_b, forcible));
    }

    void move(byte[] encodedRegionName, byte[] destServerName) throws HBaseIOException {
        ServerName dest;
        RegionState regionState = this.assignmentManager.getRegionStates().getRegionState(Bytes.toString((byte[])encodedRegionName));
        if (regionState == null) {
            throw new UnknownRegionException(Bytes.toStringBinary((byte[])encodedRegionName));
        }
        HRegionInfo hri = regionState.getRegion();
        if (destServerName == null || destServerName.length == 0) {
            LOG.info((Object)"Passed destination servername is null/empty so choosing a server at random");
            List<ServerName> destServers = this.serverManager.createDestinationServersList(regionState.getServerName());
            dest = this.balancer.randomAssignment(hri, destServers);
            if (dest == null) {
                LOG.debug((Object)("Unable to determine a plan to assign " + hri));
                return;
            }
        } else {
            ServerName candidate = ServerName.valueOf((String)Bytes.toString((byte[])destServerName));
            dest = this.balancer.randomAssignment(hri, Lists.newArrayList((Object[])new ServerName[]{candidate}));
            if (dest == null) {
                LOG.debug((Object)("Unable to determine a plan to assign " + hri));
                return;
            }
            if (dest.equals((Object)this.serverName) && this.balancer instanceof BaseLoadBalancer && !((BaseLoadBalancer)this.balancer).shouldBeOnMaster(hri)) {
                LOG.debug((Object)("Skipping move of region " + hri.getRegionNameAsString() + " to avoid unnecessary region moving later by load balancer," + " because it should not be on master"));
                return;
            }
        }
        if (dest.equals((Object)regionState.getServerName())) {
            LOG.debug((Object)("Skipping move of region " + hri.getRegionNameAsString() + " because region already assigned to the same server " + dest + "."));
            return;
        }
        RegionPlan rp = new RegionPlan(hri, regionState.getServerName(), dest);
        try {
            this.checkInitialized();
            if (this.cpHost != null && this.cpHost.preMove(hri, rp.getSource(), rp.getDestination())) {
                return;
            }
            this.serverManager.sendRegionWarmup(rp.getDestination(), hri);
            LOG.info((Object)(this.getClientIdAuditPrefix() + " move " + rp + ", running balancer"));
            this.assignmentManager.balance(rp);
            if (this.cpHost != null) {
                this.cpHost.postMove(hri, rp.getSource(), rp.getDestination());
            }
        }
        catch (IOException ioe) {
            if (ioe instanceof HBaseIOException) {
                throw (HBaseIOException)((Object)ioe);
            }
            throw new HBaseIOException((Throwable)ioe);
        }
    }

    @Override
    public long createTable(HTableDescriptor hTableDescriptor, byte[][] splitKeys, long nonceGroup, long nonce) throws IOException {
        if (this.isStopped()) {
            throw new MasterNotRunningException();
        }
        String namespace = hTableDescriptor.getTableName().getNamespaceAsString();
        this.ensureNamespaceExists(namespace);
        HRegionInfo[] newRegions = ModifyRegionUtils.createHRegionInfos(hTableDescriptor, splitKeys);
        this.checkInitialized();
        this.sanityCheckTableDescriptor(hTableDescriptor);
        if (this.cpHost != null) {
            this.cpHost.preCreateTable(hTableDescriptor, newRegions);
        }
        LOG.info((Object)(this.getClientIdAuditPrefix() + " create " + hTableDescriptor));
        ProcedurePrepareLatch latch = ProcedurePrepareLatch.createLatch();
        long procId = this.procedureExecutor.submitProcedure((Procedure)new CreateTableProcedure((MasterProcedureEnv)this.procedureExecutor.getEnvironment(), hTableDescriptor, newRegions, latch), nonceGroup, nonce);
        latch.await();
        if (this.cpHost != null) {
            this.cpHost.postCreateTable(hTableDescriptor, newRegions);
        }
        return procId;
    }

    private void sanityCheckTableDescriptor(HTableDescriptor htd) throws IOException {
        String message;
        String tableVal;
        String CONF_KEY = "hbase.table.sanity.checks";
        boolean logWarn = false;
        if (!this.conf.getBoolean("hbase.table.sanity.checks", true)) {
            logWarn = true;
        }
        if ((tableVal = htd.getConfigurationValue("hbase.table.sanity.checks")) != null && !Boolean.valueOf(tableVal).booleanValue()) {
            logWarn = true;
        }
        long maxFileSizeLowerLimit = 0x200000L;
        long maxFileSize = htd.getMaxFileSize();
        if (maxFileSize < 0L) {
            maxFileSize = this.conf.getLong("hbase.hregion.max.filesize", maxFileSizeLowerLimit);
        }
        if (maxFileSize < this.conf.getLong("hbase.hregion.max.filesize.limit", maxFileSizeLowerLimit)) {
            String message2 = "MAX_FILESIZE for table descriptor or \"hbase.hregion.max.filesize\" (" + maxFileSize + ") is too small, which might cause over splitting into unmanageable " + "number of regions.";
            HMaster.warnOrThrowExceptionForFailure(logWarn, "hbase.table.sanity.checks", message2, null);
        }
        long flushSizeLowerLimit = 0x100000L;
        long flushSize = htd.getMemStoreFlushSize();
        if (flushSize < 0L) {
            flushSize = this.conf.getLong("hbase.hregion.memstore.flush.size", flushSizeLowerLimit);
        }
        if (flushSize < this.conf.getLong("hbase.hregion.memstore.flush.size.limit", flushSizeLowerLimit)) {
            message = "MEMSTORE_FLUSHSIZE for table descriptor or \"hbase.hregion.memstore.flush.size\" (" + flushSize + ") is too small, which might cause" + " very frequent flushing.";
            HMaster.warnOrThrowExceptionForFailure(logWarn, "hbase.table.sanity.checks", message, null);
        }
        try {
            this.checkClassLoading(this.conf, htd);
        }
        catch (Exception ex) {
            HMaster.warnOrThrowExceptionForFailure(logWarn, "hbase.table.sanity.checks", ex.getMessage(), null);
        }
        try {
            this.checkCompression(htd);
        }
        catch (IOException e) {
            HMaster.warnOrThrowExceptionForFailure(logWarn, "hbase.table.sanity.checks", e.getMessage(), e);
        }
        try {
            this.checkEncryption(this.conf, htd);
        }
        catch (IOException e) {
            HMaster.warnOrThrowExceptionForFailure(logWarn, "hbase.table.sanity.checks", e.getMessage(), e);
        }
        try {
            this.checkCompactionPolicy(this.conf, htd);
        }
        catch (IOException e) {
            HMaster.warnOrThrowExceptionForFailure(false, "hbase.table.sanity.checks", e.getMessage(), e);
        }
        if (htd.getColumnFamilies().length == 0) {
            message = "Table should have at least one column family.";
            HMaster.warnOrThrowExceptionForFailure(logWarn, "hbase.table.sanity.checks", message, null);
        }
        for (HColumnDescriptor hcd : htd.getColumnFamilies()) {
            String message3;
            if (hcd.getTimeToLive() <= 0) {
                message3 = "TTL for column family " + hcd.getNameAsString() + " must be positive.";
                HMaster.warnOrThrowExceptionForFailure(logWarn, "hbase.table.sanity.checks", message3, null);
            }
            if (hcd.getBlocksize() < 1024 || hcd.getBlocksize() > 0x1000000) {
                message3 = "Block size for column family " + hcd.getNameAsString() + "  must be between 1K and 16MB.";
                HMaster.warnOrThrowExceptionForFailure(logWarn, "hbase.table.sanity.checks", message3, null);
            }
            if (hcd.getMinVersions() < 0) {
                message3 = "Min versions for column family " + hcd.getNameAsString() + "  must be positive.";
                HMaster.warnOrThrowExceptionForFailure(logWarn, "hbase.table.sanity.checks", message3, null);
            }
            if (hcd.getMinVersions() > hcd.getMaxVersions()) {
                message3 = "Min versions for column family " + hcd.getNameAsString() + " must be less than the Max versions.";
                HMaster.warnOrThrowExceptionForFailure(logWarn, "hbase.table.sanity.checks", message3, null);
            }
            if (hcd.getScope() < 0) {
                message3 = "Replication scope for column family " + hcd.getNameAsString() + "  must be positive.";
                HMaster.warnOrThrowExceptionForFailure(logWarn, "hbase.table.sanity.checks", message3, null);
            }
            if (hcd.getDFSReplication() >= 0) continue;
            message3 = "HFile Replication for column family " + hcd.getNameAsString() + "  must be greater than zero.";
            HMaster.warnOrThrowExceptionForFailure(logWarn, "hbase.table.sanity.checks", message3, null);
        }
    }

    private void checkCompactionPolicy(Configuration conf, HTableDescriptor htd) throws IOException {
        String className = htd.getConfigurationValue("hbase.hstore.defaultengine.compactionpolicy.class");
        if (className == null) {
            className = conf.get("hbase.hstore.defaultengine.compactionpolicy.class", ExploringCompactionPolicy.class.getName());
        }
        int blockingFileCount = 7;
        String sv = htd.getConfigurationValue("hbase.hstore.blockingStoreFiles");
        blockingFileCount = sv != null ? Integer.parseInt(sv) : conf.getInt("hbase.hstore.blockingStoreFiles", blockingFileCount);
        for (HColumnDescriptor hcd : htd.getColumnFamilies()) {
            String compactionPolicy = hcd.getConfigurationValue("hbase.hstore.defaultengine.compactionpolicy.class");
            if (compactionPolicy == null) {
                compactionPolicy = className;
            }
            if (!compactionPolicy.equals(FIFOCompactionPolicy.class.getName())) continue;
            String message = null;
            if (hcd.getTimeToLive() == Integer.MAX_VALUE) {
                message = "Default TTL is not supported for FIFO compaction";
                throw new IOException(message);
            }
            if (hcd.getMinVersions() > 0) {
                message = "MIN_VERSION > 0 is not supported for FIFO compaction";
                throw new IOException(message);
            }
            String sbfc = htd.getConfigurationValue("hbase.hstore.blockingStoreFiles");
            if (sbfc != null) {
                blockingFileCount = Integer.parseInt(sbfc);
            }
            if (blockingFileCount >= 1000) continue;
            message = "blocking file count 'hbase.hstore.blockingStoreFiles' " + blockingFileCount + " is below recommended minimum of 1000";
            throw new IOException(message);
        }
    }

    private static void warnOrThrowExceptionForFailure(boolean logWarn, String confKey, String message, Exception cause) throws IOException {
        if (!logWarn) {
            throw new DoNotRetryIOException(message + " Set " + confKey + " to false at conf or table descriptor if you want to bypass sanity checks", (Throwable)cause);
        }
        LOG.warn((Object)message);
    }

    private void startActiveMasterManager(int infoPort) throws KeeperException {
        String backupZNode = ZKUtil.joinZNode((String)this.zooKeeper.backupMasterAddressesZNode, (String)this.serverName.toString());
        LOG.info((Object)("Adding backup master ZNode " + backupZNode));
        if (!MasterAddressTracker.setMasterAddress((ZooKeeperWatcher)this.zooKeeper, (String)backupZNode, (ServerName)this.serverName, (int)infoPort)) {
            LOG.warn((Object)("Failed create of " + backupZNode + " by " + this.serverName));
        }
        this.activeMasterManager.setInfoPort(infoPort);
        Threads.setDaemonThreadRunning((Thread)new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                int timeout = HMaster.this.conf.getInt("zookeeper.session.timeout", 180000);
                if (HMaster.this.conf.getBoolean("hbase.master.backup", false)) {
                    LOG.debug((Object)"HMaster started in backup mode. Stalling until master znode is written.");
                    while (!HMaster.this.activeMasterManager.hasActiveMaster()) {
                        LOG.debug((Object)"Waiting for master address ZNode to be written (Also watching cluster state node)");
                        Threads.sleep((long)timeout);
                    }
                }
                MonitoredTask status = TaskMonitor.get().createStatus("Master startup");
                status.setDescription("Master startup");
                try {
                    if (HMaster.this.activeMasterManager.blockUntilBecomingActiveMaster(timeout, status)) {
                        HMaster.this.finishActiveMasterInitialization(status);
                    }
                }
                catch (Throwable t) {
                    status.setStatus("Failed to become active: " + t.getMessage());
                    LOG.fatal((Object)"Failed to become active master", t);
                    if (t instanceof NoClassDefFoundError && t.getMessage().contains("org/apache/hadoop/hdfs/protocol/HdfsConstants$SafeModeAction")) {
                        HMaster.this.abort("HBase is having a problem with its Hadoop jars.  You may need to recompile HBase against Hadoop version " + VersionInfo.getVersion() + " or change your hadoop jars to start properly", t);
                    } else {
                        HMaster.this.abort("Unhandled exception. Starting shutdown.", t);
                    }
                }
                finally {
                    status.cleanup();
                }
            }
        }, this.getServerName().toShortString() + ".activeMasterManager"));
    }

    private void checkCompression(HTableDescriptor htd) throws IOException {
        if (!this.masterCheckCompression) {
            return;
        }
        for (HColumnDescriptor hcd : htd.getColumnFamilies()) {
            this.checkCompression(hcd);
        }
    }

    private void checkCompression(HColumnDescriptor hcd) throws IOException {
        if (!this.masterCheckCompression) {
            return;
        }
        CompressionTest.testCompression(hcd.getCompression());
        CompressionTest.testCompression(hcd.getCompactionCompression());
    }

    private void checkEncryption(Configuration conf, HTableDescriptor htd) throws IOException {
        if (!this.masterCheckEncryption) {
            return;
        }
        for (HColumnDescriptor hcd : htd.getColumnFamilies()) {
            this.checkEncryption(conf, hcd);
        }
    }

    private void checkEncryption(Configuration conf, HColumnDescriptor hcd) throws IOException {
        if (!this.masterCheckEncryption) {
            return;
        }
        EncryptionTest.testEncryption(conf, hcd.getEncryptionType(), hcd.getEncryptionKey());
    }

    private void checkClassLoading(Configuration conf, HTableDescriptor htd) throws IOException {
        RegionSplitPolicy.getSplitPolicyClass(htd, conf);
        RegionCoprocessorHost.testTableCoprocessorAttrs(conf, htd);
    }

    private static boolean isCatalogTable(TableName tableName) {
        return tableName.equals((Object)TableName.META_TABLE_NAME);
    }

    @Override
    public long deleteTable(TableName tableName, long nonceGroup, long nonce) throws IOException {
        this.checkInitialized();
        if (this.cpHost != null) {
            this.cpHost.preDeleteTable(tableName);
        }
        LOG.info((Object)(this.getClientIdAuditPrefix() + " delete " + tableName));
        ProcedurePrepareLatch latch = ProcedurePrepareLatch.createLatch();
        long procId = this.procedureExecutor.submitProcedure((Procedure)new DeleteTableProcedure((MasterProcedureEnv)this.procedureExecutor.getEnvironment(), tableName, latch), nonceGroup, nonce);
        latch.await();
        if (this.cpHost != null) {
            this.cpHost.postDeleteTable(tableName);
        }
        return procId;
    }

    @Override
    public void truncateTable(TableName tableName, boolean preserveSplits, long nonceGroup, long nonce) throws IOException {
        this.checkInitialized();
        if (this.cpHost != null) {
            this.cpHost.preTruncateTable(tableName);
        }
        LOG.info((Object)(this.getClientIdAuditPrefix() + " truncate " + tableName));
        long procId = this.procedureExecutor.submitProcedure((Procedure)new TruncateTableProcedure((MasterProcedureEnv)this.procedureExecutor.getEnvironment(), tableName, preserveSplits), nonceGroup, nonce);
        ProcedureSyncWait.waitForProcedureToComplete(this.procedureExecutor, procId);
        if (this.cpHost != null) {
            this.cpHost.postTruncateTable(tableName);
        }
    }

    @Override
    public void addColumn(TableName tableName, HColumnDescriptor columnDescriptor, long nonceGroup, long nonce) throws IOException {
        this.checkInitialized();
        this.checkCompression(columnDescriptor);
        this.checkEncryption(this.conf, columnDescriptor);
        if (this.cpHost != null && this.cpHost.preAddColumn(tableName, columnDescriptor)) {
            return;
        }
        long procId = this.procedureExecutor.submitProcedure((Procedure)new AddColumnFamilyProcedure((MasterProcedureEnv)this.procedureExecutor.getEnvironment(), tableName, columnDescriptor), nonceGroup, nonce);
        ProcedureSyncWait.waitForProcedureToComplete(this.procedureExecutor, procId);
        if (this.cpHost != null) {
            this.cpHost.postAddColumn(tableName, columnDescriptor);
        }
    }

    @Override
    public void modifyColumn(TableName tableName, HColumnDescriptor descriptor, long nonceGroup, long nonce) throws IOException {
        this.checkInitialized();
        this.checkCompression(descriptor);
        this.checkEncryption(this.conf, descriptor);
        if (this.cpHost != null && this.cpHost.preModifyColumn(tableName, descriptor)) {
            return;
        }
        LOG.info((Object)(this.getClientIdAuditPrefix() + " modify " + descriptor));
        long procId = this.procedureExecutor.submitProcedure((Procedure)new ModifyColumnFamilyProcedure((MasterProcedureEnv)this.procedureExecutor.getEnvironment(), tableName, descriptor), nonceGroup, nonce);
        ProcedureSyncWait.waitForProcedureToComplete(this.procedureExecutor, procId);
        if (this.cpHost != null) {
            this.cpHost.postModifyColumn(tableName, descriptor);
        }
    }

    @Override
    public void deleteColumn(TableName tableName, byte[] columnName, long nonceGroup, long nonce) throws IOException {
        this.checkInitialized();
        if (this.cpHost != null && this.cpHost.preDeleteColumn(tableName, columnName)) {
            return;
        }
        LOG.info((Object)(this.getClientIdAuditPrefix() + " delete " + Bytes.toString((byte[])columnName)));
        long procId = this.procedureExecutor.submitProcedure((Procedure)new DeleteColumnFamilyProcedure((MasterProcedureEnv)this.procedureExecutor.getEnvironment(), tableName, columnName), nonceGroup, nonce);
        ProcedureSyncWait.waitForProcedureToComplete(this.procedureExecutor, procId);
        if (this.cpHost != null) {
            this.cpHost.postDeleteColumn(tableName, columnName);
        }
    }

    @Override
    public long enableTable(TableName tableName, long nonceGroup, long nonce) throws IOException {
        this.checkInitialized();
        if (this.cpHost != null) {
            this.cpHost.preEnableTable(tableName);
        }
        LOG.info((Object)(this.getClientIdAuditPrefix() + " enable " + tableName));
        ProcedurePrepareLatch prepareLatch = ProcedurePrepareLatch.createLatch();
        long procId = this.procedureExecutor.submitProcedure((Procedure)new EnableTableProcedure((MasterProcedureEnv)this.procedureExecutor.getEnvironment(), tableName, false, prepareLatch), nonceGroup, nonce);
        prepareLatch.await();
        if (this.cpHost != null) {
            this.cpHost.postEnableTable(tableName);
        }
        return procId;
    }

    @Override
    public long disableTable(TableName tableName, long nonceGroup, long nonce) throws IOException {
        this.checkInitialized();
        if (this.cpHost != null) {
            this.cpHost.preDisableTable(tableName);
        }
        LOG.info((Object)(this.getClientIdAuditPrefix() + " disable " + tableName));
        ProcedurePrepareLatch prepareLatch = ProcedurePrepareLatch.createLatch();
        long procId = this.procedureExecutor.submitProcedure((Procedure)new DisableTableProcedure((MasterProcedureEnv)this.procedureExecutor.getEnvironment(), tableName, false, prepareLatch), nonceGroup, nonce);
        prepareLatch.await();
        if (this.cpHost != null) {
            this.cpHost.postDisableTable(tableName);
        }
        return procId;
    }

    @VisibleForTesting
    Pair<HRegionInfo, ServerName> getTableRegionForRow(final TableName tableName, byte[] rowKey) throws IOException {
        final AtomicReference<Object> result = new AtomicReference<Object>(null);
        MetaScanner.MetaScannerVisitorBase visitor = new MetaScanner.MetaScannerVisitorBase(){

            public boolean processRow(Result data) throws IOException {
                if (data == null || data.size() <= 0) {
                    return true;
                }
                Pair pair = HRegionInfo.getHRegionInfoAndServerName((Result)data);
                if (pair == null) {
                    return false;
                }
                if (!((HRegionInfo)pair.getFirst()).getTable().equals((Object)tableName)) {
                    return false;
                }
                result.set(pair);
                return true;
            }
        };
        MetaScanner.metaScan((Connection)this.clusterConnection, (MetaScanner.MetaScannerVisitor)visitor, (TableName)tableName, (byte[])rowKey, (int)1);
        return result.get();
    }

    @Override
    public void modifyTable(TableName tableName, HTableDescriptor descriptor, long nonceGroup, long nonce) throws IOException {
        this.checkInitialized();
        this.sanityCheckTableDescriptor(descriptor);
        if (this.cpHost != null) {
            this.cpHost.preModifyTable(tableName, descriptor);
        }
        LOG.info((Object)(this.getClientIdAuditPrefix() + " modify " + tableName));
        long procId = this.procedureExecutor.submitProcedure((Procedure)new ModifyTableProcedure((MasterProcedureEnv)this.procedureExecutor.getEnvironment(), descriptor), nonceGroup, nonce);
        ProcedureSyncWait.waitForProcedureToComplete(this.procedureExecutor, procId);
        if (this.cpHost != null) {
            this.cpHost.postModifyTable(tableName, descriptor);
        }
    }

    @Override
    public void checkTableModifiable(TableName tableName) throws IOException, TableNotFoundException, TableNotDisabledException {
        if (HMaster.isCatalogTable(tableName)) {
            throw new IOException("Can't modify catalog tables");
        }
        if (!MetaTableAccessor.tableExists((Connection)this.getConnection(), (TableName)tableName)) {
            throw new TableNotFoundException(tableName);
        }
        if (!this.getAssignmentManager().getTableStateManager().isTableState(tableName, ZooKeeperProtos.Table.State.DISABLED)) {
            throw new TableNotDisabledException(tableName);
        }
    }

    public ClusterStatus getClusterStatus() throws InterruptedIOException {
        List backupMasterStrings;
        try {
            backupMasterStrings = ZKUtil.listChildrenNoWatch((ZooKeeperWatcher)this.zooKeeper, (String)this.zooKeeper.backupMasterAddressesZNode);
        }
        catch (KeeperException e) {
            LOG.warn((Object)this.zooKeeper.prefix("Unable to list backup servers"), (Throwable)e);
            backupMasterStrings = null;
        }
        ArrayList<ServerName> backupMasters = null;
        if (backupMasterStrings != null && !backupMasterStrings.isEmpty()) {
            backupMasters = new ArrayList<ServerName>(backupMasterStrings.size());
            for (String s : backupMasterStrings) {
                try {
                    ServerName sn;
                    byte[] bytes;
                    try {
                        bytes = ZKUtil.getData((ZooKeeperWatcher)this.zooKeeper, (String)ZKUtil.joinZNode((String)this.zooKeeper.backupMasterAddressesZNode, (String)s));
                    }
                    catch (InterruptedException e) {
                        throw new InterruptedIOException();
                    }
                    if (bytes == null) continue;
                    try {
                        sn = ServerName.parseFrom((byte[])bytes);
                    }
                    catch (DeserializationException e) {
                        LOG.warn((Object)"Failed parse, skipping registering backup server", (Throwable)e);
                        continue;
                    }
                    backupMasters.add(sn);
                }
                catch (KeeperException e) {
                    LOG.warn((Object)this.zooKeeper.prefix("Unable to get information about backup servers"), (Throwable)e);
                }
            }
            Collections.sort(backupMasters, new Comparator<ServerName>(){

                @Override
                public int compare(ServerName s1, ServerName s2) {
                    return s1.getServerName().compareTo(s2.getServerName());
                }
            });
        }
        String clusterId = this.fileSystemManager != null ? this.fileSystemManager.getClusterId().toString() : null;
        Map<String, RegionState> regionsInTransition = this.assignmentManager != null ? this.assignmentManager.getRegionStates().getRegionsInTransition() : null;
        String[] coprocessors = this.cpHost != null ? this.getMasterCoprocessors() : null;
        boolean balancerOn = this.loadBalancerTracker != null ? this.loadBalancerTracker.isBalancerOn() : false;
        Map<ServerName, ServerLoad> onlineServers = null;
        Set<ServerName> deadServers = null;
        if (this.serverManager != null) {
            deadServers = this.serverManager.getDeadServers().copyServerNames();
            onlineServers = this.serverManager.getOnlineServers();
        }
        return new ClusterStatus(org.apache.hadoop.hbase.util.VersionInfo.getVersion(), clusterId, onlineServers, deadServers, this.serverName, backupMasters, regionsInTransition, coprocessors, Boolean.valueOf(balancerOn));
    }

    public static String getLoadedCoprocessors() {
        return CoprocessorHost.getLoadedCoprocessors().toString();
    }

    public long getMasterStartTime() {
        return this.startcode;
    }

    public long getMasterActiveTime() {
        return this.masterActiveTime;
    }

    public int getNumWALFiles() {
        return this.procedureStore != null ? this.procedureStore.getActiveLogs().size() : 0;
    }

    public WALProcedureStore getWalProcedureStore() {
        return this.procedureStore;
    }

    public int getRegionServerInfoPort(ServerName sn) {
        HBaseProtos.RegionServerInfo info = this.regionServerTracker.getRegionServerInfo(sn);
        if (info == null || info.getInfoPort() == 0) {
            return this.conf.getInt("hbase.regionserver.info.port", 60030);
        }
        return info.getInfoPort();
    }

    public String getRegionServerVersion(ServerName sn) {
        HBaseProtos.RegionServerInfo info = this.regionServerTracker.getRegionServerInfo(sn);
        if (info != null && info.hasVersionInfo()) {
            return info.getVersionInfo().getVersion();
        }
        return "Unknown";
    }

    public String[] getMasterCoprocessors() {
        Set<String> masterCoprocessors = this.getMasterCoprocessorHost().getCoprocessors();
        return masterCoprocessors.toArray(new String[masterCoprocessors.size()]);
    }

    @Override
    public void abort(String msg, Throwable t) {
        if (this.isAborted() || this.isStopped()) {
            return;
        }
        if (this.cpHost != null) {
            LOG.fatal((Object)("Master server abort: loaded coprocessors are: " + HMaster.getLoadedCoprocessors()));
        }
        if (t != null) {
            LOG.fatal((Object)msg, t);
        }
        try {
            this.stopMaster();
        }
        catch (IOException e) {
            LOG.error((Object)"Exception occurred while stopping master", (Throwable)e);
        }
    }

    @Override
    public ZooKeeperWatcher getZooKeeper() {
        return this.zooKeeper;
    }

    @Override
    public MasterCoprocessorHost getMasterCoprocessorHost() {
        return this.cpHost;
    }

    @Override
    public MasterQuotaManager getMasterQuotaManager() {
        return this.quotaManager;
    }

    @Override
    public ProcedureExecutor<MasterProcedureEnv> getMasterProcedureExecutor() {
        return this.procedureExecutor;
    }

    @Override
    public ServerName getServerName() {
        return this.serverName;
    }

    @Override
    public AssignmentManager getAssignmentManager() {
        return this.assignmentManager;
    }

    public MemoryBoundedLogMessageBuffer getRegionServerFatalLogBuffer() {
        return this.rsFatals;
    }

    public void shutdown() throws IOException {
        if (this.cpHost != null) {
            this.cpHost.preShutdown();
        }
        if (this.serverManager != null) {
            this.serverManager.shutdownCluster();
        }
        if (this.clusterStatusTracker != null) {
            try {
                this.clusterStatusTracker.setClusterDown();
            }
            catch (KeeperException e) {
                LOG.error((Object)"ZooKeeper exception trying to set cluster as down in ZK", (Throwable)e);
            }
        }
    }

    public void stopMaster() throws IOException {
        if (this.cpHost != null) {
            this.cpHost.preStopMaster();
        }
        this.stop("Stopped by " + Thread.currentThread().getName());
    }

    void checkServiceStarted() throws ServerNotRunningYetException {
        if (!this.serviceStarted) {
            throw new ServerNotRunningYetException("Server is not running yet");
        }
    }

    void checkInitialized() throws PleaseHoldException, ServerNotRunningYetException {
        this.checkServiceStarted();
        if (!this.isInitialized()) {
            throw new PleaseHoldException("Master is initializing");
        }
    }

    void checkNamespaceManagerReady() throws IOException {
        this.checkInitialized();
        if (this.tableNamespaceManager == null || !this.tableNamespaceManager.isTableAvailableAndInitialized()) {
            throw new IOException("Table Namespace Manager not ready yet, try again later");
        }
    }

    public boolean isActiveMaster() {
        return this.isActiveMaster;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized.isReady();
    }

    @Override
    public boolean isInMaintenanceMode() {
        return this.maintenanceModeTracker.isInMaintenanceMode();
    }

    @VisibleForTesting
    public void setInitialized(boolean isInitialized) {
        ((MasterProcedureEnv)this.procedureExecutor.getEnvironment()).setEventReady(this.initialized, isInitialized);
    }

    public MasterProcedureScheduler.ProcedureEvent getInitializedEvent() {
        return this.initialized;
    }

    @Override
    public boolean isServerCrashProcessingEnabled() {
        return this.serverCrashProcessingEnabled.isReady();
    }

    @VisibleForTesting
    public void setServerCrashProcessingEnabled(boolean b) {
        ((MasterProcedureEnv)this.procedureExecutor.getEnvironment()).setEventReady(this.serverCrashProcessingEnabled, b);
    }

    public MasterProcedureScheduler.ProcedureEvent getServerCrashProcessingEnabledEvent() {
        return this.serverCrashProcessingEnabled;
    }

    public boolean isInitializationStartsMetaRegionAssignment() {
        return this.initializationBeforeMetaAssignment;
    }

    public void assignRegion(HRegionInfo hri) {
        this.assignmentManager.assign(hri, true);
    }

    public double getAverageLoad() {
        if (this.assignmentManager == null) {
            return 0.0;
        }
        RegionStates regionStates = this.assignmentManager.getRegionStates();
        if (regionStates == null) {
            return 0.0;
        }
        return regionStates.getAverageLoad();
    }

    @Override
    public boolean registerService(Service instance) {
        Descriptors.ServiceDescriptor serviceDesc = instance.getDescriptorForType();
        if (this.coprocessorServiceHandlers.containsKey(serviceDesc.getFullName())) {
            LOG.error((Object)("Coprocessor service " + serviceDesc.getFullName() + " already registered, rejecting request from " + instance));
            return false;
        }
        this.coprocessorServiceHandlers.put(serviceDesc.getFullName(), instance);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Registered master coprocessor service: service=" + serviceDesc.getFullName()));
        }
        return true;
    }

    public static HMaster constructMaster(Class<? extends HMaster> masterClass, Configuration conf, CoordinatedStateManager cp) {
        try {
            Constructor<? extends HMaster> c = masterClass.getConstructor(Configuration.class, CoordinatedStateManager.class);
            return c.newInstance(conf, cp);
        }
        catch (Exception e) {
            Throwable error = e;
            if (e instanceof InvocationTargetException && ((InvocationTargetException)e).getTargetException() != null) {
                error = ((InvocationTargetException)e).getTargetException();
            }
            throw new RuntimeException("Failed construction of Master: " + masterClass.toString() + ". ", error);
        }
    }

    public static void main(String[] args) {
        org.apache.hadoop.hbase.util.VersionInfo.logVersion();
        new HMasterCommandLine(HMaster.class).doMain(args);
    }

    public HFileCleaner getHFileCleaner() {
        return this.hfileCleaner;
    }

    @Override
    public SnapshotManager getSnapshotManager() {
        return this.snapshotManager;
    }

    @Override
    public void createNamespace(NamespaceDescriptor descriptor) throws IOException {
        TableName.isLegalNamespaceName((byte[])Bytes.toBytes((String)descriptor.getName()));
        this.checkNamespaceManagerReady();
        if (this.cpHost != null && this.cpHost.preCreateNamespace(descriptor)) {
            return;
        }
        LOG.info((Object)(this.getClientIdAuditPrefix() + " creating " + descriptor));
        this.tableNamespaceManager.create(descriptor);
        if (this.cpHost != null) {
            this.cpHost.postCreateNamespace(descriptor);
        }
    }

    @Override
    public void modifyNamespace(NamespaceDescriptor descriptor) throws IOException {
        TableName.isLegalNamespaceName((byte[])Bytes.toBytes((String)descriptor.getName()));
        this.checkNamespaceManagerReady();
        if (this.cpHost != null && this.cpHost.preModifyNamespace(descriptor)) {
            return;
        }
        LOG.info((Object)(this.getClientIdAuditPrefix() + " modify " + descriptor));
        this.tableNamespaceManager.update(descriptor);
        if (this.cpHost != null) {
            this.cpHost.postModifyNamespace(descriptor);
        }
    }

    @Override
    public void deleteNamespace(String name) throws IOException {
        this.checkNamespaceManagerReady();
        if (this.cpHost != null && this.cpHost.preDeleteNamespace(name)) {
            return;
        }
        LOG.info((Object)(this.getClientIdAuditPrefix() + " delete " + name));
        this.tableNamespaceManager.remove(name);
        if (this.cpHost != null) {
            this.cpHost.postDeleteNamespace(name);
        }
    }

    protected void ensureNamespaceExists(String name) throws IOException, NamespaceNotFoundException {
        this.checkNamespaceManagerReady();
        NamespaceDescriptor nsd = this.tableNamespaceManager.get(name);
        if (nsd == null) {
            throw new NamespaceNotFoundException(name);
        }
    }

    @Override
    public NamespaceDescriptor getNamespaceDescriptor(String name) throws IOException {
        NamespaceDescriptor nsd;
        this.checkNamespaceManagerReady();
        if (this.cpHost != null) {
            this.cpHost.preGetNamespaceDescriptor(name);
        }
        if ((nsd = this.tableNamespaceManager.get(name)) == null) {
            throw new NamespaceNotFoundException(name);
        }
        if (this.cpHost != null) {
            this.cpHost.postGetNamespaceDescriptor(nsd);
        }
        return nsd;
    }

    @Override
    public List<NamespaceDescriptor> listNamespaceDescriptors() throws IOException {
        this.checkNamespaceManagerReady();
        ArrayList<NamespaceDescriptor> descriptors = new ArrayList<NamespaceDescriptor>();
        boolean bypass = false;
        if (this.cpHost != null) {
            bypass = this.cpHost.preListNamespaceDescriptors(descriptors);
        }
        if (!bypass) {
            descriptors.addAll(this.tableNamespaceManager.list());
            if (this.cpHost != null) {
                this.cpHost.postListNamespaceDescriptors(descriptors);
            }
        }
        return descriptors;
    }

    @Override
    public boolean abortProcedure(long procId, boolean mayInterruptIfRunning) throws IOException {
        if (this.cpHost != null) {
            this.cpHost.preAbortProcedure(this.procedureExecutor, procId);
        }
        boolean result = this.procedureExecutor.abort(procId, mayInterruptIfRunning);
        if (this.cpHost != null) {
            this.cpHost.postAbortProcedure();
        }
        return result;
    }

    @Override
    public List<ProcedureInfo> listProcedures() throws IOException {
        if (this.cpHost != null) {
            this.cpHost.preListProcedures();
        }
        List procInfoList = this.procedureExecutor.listProcedures();
        if (this.cpHost != null) {
            this.cpHost.postListProcedures(procInfoList);
        }
        return procInfoList;
    }

    @Override
    public List<HTableDescriptor> listTableDescriptorsByNamespace(String name) throws IOException {
        this.ensureNamespaceExists(name);
        return this.listTableDescriptors(name, null, null, true);
    }

    @Override
    public List<TableName> listTableNamesByNamespace(String name) throws IOException {
        this.ensureNamespaceExists(name);
        return this.listTableNames(name, null, true);
    }

    public List<HTableDescriptor> listTableDescriptors(String namespace, String regex, List<TableName> tableNameList, boolean includeSysTables) throws IOException {
        ArrayList<HTableDescriptor> descriptors = new ArrayList<HTableDescriptor>();
        boolean bypass = false;
        if (this.cpHost != null) {
            bypass = this.cpHost.preGetTableDescriptors(tableNameList, descriptors);
            bypass |= this.cpHost.preGetTableDescriptors(tableNameList, descriptors, regex);
        }
        if (!bypass) {
            if (tableNameList == null || tableNameList.size() == 0) {
                Collection<HTableDescriptor> htds = namespace != null && namespace.length() > 0 ? this.tableDescriptors.getByNamespace(namespace).values() : this.tableDescriptors.getAll().values();
                for (HTableDescriptor desc : htds) {
                    if (!includeSysTables && desc.getTableName().isSystemTable()) continue;
                    descriptors.add(desc);
                }
            } else {
                for (TableName s : tableNameList) {
                    HTableDescriptor desc = this.tableDescriptors.get(s);
                    if (desc == null) continue;
                    descriptors.add(desc);
                }
            }
            if (regex != null) {
                HMaster.filterTablesByRegex(descriptors, Pattern.compile(regex));
            }
            if (this.cpHost != null) {
                this.cpHost.postGetTableDescriptors(descriptors);
                this.cpHost.postGetTableDescriptors(tableNameList, descriptors, regex);
            }
        }
        return descriptors;
    }

    public List<TableName> listTableNames(String namespace, String regex, boolean includeSysTables) throws IOException {
        ArrayList<HTableDescriptor> descriptors = new ArrayList<HTableDescriptor>();
        boolean bypass = false;
        if (this.cpHost != null) {
            bypass = this.cpHost.preGetTableNames(descriptors, regex);
        }
        if (!bypass) {
            Collection<HTableDescriptor> htds = namespace != null && namespace.length() > 0 ? this.tableDescriptors.getByNamespace(namespace).values() : this.tableDescriptors.getAll().values();
            for (HTableDescriptor htd : htds) {
                if (!includeSysTables && htd.getTableName().isSystemTable()) continue;
                descriptors.add(htd);
            }
            if (regex != null) {
                HMaster.filterTablesByRegex(descriptors, Pattern.compile(regex));
            }
            if (this.cpHost != null) {
                this.cpHost.postGetTableNames(descriptors, regex);
            }
        }
        ArrayList<TableName> result = new ArrayList<TableName>(descriptors.size());
        for (HTableDescriptor htd : descriptors) {
            result.add(htd.getTableName());
        }
        return result;
    }

    private static void filterTablesByRegex(Collection<HTableDescriptor> descriptors, Pattern pattern) {
        String defaultNS = NamespaceDescriptor.DEFAULT_NAMESPACE_NAME_STR;
        Iterator<HTableDescriptor> itr = descriptors.iterator();
        while (itr.hasNext()) {
            HTableDescriptor htd = itr.next();
            String tableName = htd.getTableName().getNameAsString();
            boolean matched = pattern.matcher(tableName).matches();
            if (!matched && htd.getTableName().getNamespaceAsString().equals(defaultNS)) {
                matched = pattern.matcher(defaultNS + ':' + tableName).matches();
            }
            if (matched) continue;
            itr.remove();
        }
    }

    @Override
    public long getLastMajorCompactionTimestamp(TableName table) throws IOException {
        return this.getClusterStatus().getLastMajorCompactionTsForTable(table);
    }

    @Override
    public long getLastMajorCompactionTimestampForRegion(byte[] regionName) throws IOException {
        return this.getClusterStatus().getLastMajorCompactionTsForRegion(regionName);
    }

    public boolean isBalancerOn() {
        if (null == this.loadBalancerTracker || this.isInMaintenanceMode()) {
            return false;
        }
        return this.loadBalancerTracker.isBalancerOn();
    }

    public boolean isNormalizerOn() {
        return null == this.regionNormalizerTracker || this.isInMaintenanceMode() ? false : this.regionNormalizerTracker.isNormalizerOn();
    }

    public boolean isSplitOrMergeEnabled(Admin.MasterSwitchType switchType) {
        if (null == this.splitOrMergeTracker || this.isInMaintenanceMode()) {
            return false;
        }
        return this.splitOrMergeTracker.isSplitOrMergeEnabled(switchType);
    }

    public String getLoadBalancerClassName() {
        return this.conf.get("hbase.master.loadbalancer.class", LoadBalancerFactory.getDefaultLoadBalancerClass().getName());
    }

    public RegionNormalizerTracker getRegionNormalizerTracker() {
        return this.regionNormalizerTracker;
    }

    public AdminProtos.GetRegionInfoResponse.CompactionState getMobCompactionState(TableName tableName) {
        AtomicInteger compactionsCount = this.mobFileCompactionStates.get(tableName);
        if (compactionsCount != null && compactionsCount.get() != 0) {
            return AdminProtos.GetRegionInfoResponse.CompactionState.MAJOR_AND_MINOR;
        }
        return AdminProtos.GetRegionInfoResponse.CompactionState.NONE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportMobFileCompactionStart(TableName tableName) throws IOException {
        IdLock.Entry lockEntry = null;
        try {
            lockEntry = this.mobFileCompactionLock.getLockEntry(tableName.hashCode());
            AtomicInteger compactionsCount = this.mobFileCompactionStates.get(tableName);
            if (compactionsCount == null) {
                compactionsCount = new AtomicInteger(0);
                this.mobFileCompactionStates.put(tableName, compactionsCount);
            }
            compactionsCount.incrementAndGet();
        }
        finally {
            if (lockEntry != null) {
                this.mobFileCompactionLock.releaseLockEntry(lockEntry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportMobFileCompactionEnd(TableName tableName) throws IOException {
        IdLock.Entry lockEntry = null;
        try {
            int count;
            lockEntry = this.mobFileCompactionLock.getLockEntry(tableName.hashCode());
            AtomicInteger compactionsCount = this.mobFileCompactionStates.get(tableName);
            if (compactionsCount != null && (count = compactionsCount.decrementAndGet()) == 0) {
                this.mobFileCompactionStates.remove(tableName);
            }
        }
        finally {
            if (lockEntry != null) {
                this.mobFileCompactionLock.releaseLockEntry(lockEntry);
            }
        }
    }

    @Override
    public LoadBalancer getLoadBalancer() {
        return this.balancer;
    }

    public SplitOrMergeTracker getSplitOrMergeTracker() {
        return this.splitOrMergeTracker;
    }

    private static class PeriodicDoMetrics
    extends ScheduledChore {
        private final HMaster server;

        public PeriodicDoMetrics(int doMetricsInterval, HMaster server) {
            super(server.getServerName() + "-DoMetricsChore", (Stoppable)server, doMetricsInterval);
            this.server = server;
        }

        protected void chore() {
            this.server.doMetrics();
        }
    }

    public static class RedirectServlet
    extends HttpServlet {
        private static final long serialVersionUID = 2894774810058302473L;
        private final int regionServerInfoPort;
        private final String regionServerHostname;

        public RedirectServlet(InfoServer infoServer, String hostname) {
            this.regionServerInfoPort = infoServer.getPort();
            this.regionServerHostname = hostname;
        }

        public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            String redirectHost = this.regionServerHostname;
            if (redirectHost == null && !Addressing.isLocalAddress((InetAddress)InetAddress.getByName(redirectHost = request.getServerName()))) {
                LOG.warn((Object)("Couldn't resolve '" + redirectHost + "' as an address local to this node and '" + "hbase.master.hostname" + "' is not set; client will get a HTTP 400 response. If " + "your HBase deployment relies on client accessible names that the region server process " + "can't resolve locally, then you should set the previously mentioned configuration variable " + "to an appropriate hostname."));
                response.sendError(400, "Request was to a host that I can't resolve for any of the network interfaces on this node. If this is due to an intermediary such as an HTTP load balancer or other proxy, your HBase administrator can set 'hbase.master.hostname' to point to the correct hostname.");
                return;
            }
            String redirectUrl = request.getScheme() + "://" + redirectHost + ":" + this.regionServerInfoPort + request.getRequestURI();
            response.sendRedirect(redirectUrl);
        }
    }

    private static class InitializationMonitor
    extends HasThread {
        public static final String TIMEOUT_KEY = "hbase.master.initializationmonitor.timeout";
        public static final long TIMEOUT_DEFAULT = TimeUnit.MILLISECONDS.convert(15L, TimeUnit.MINUTES);
        public static final String HALT_KEY = "hbase.master.initializationmonitor.haltontimeout";
        public static final boolean HALT_DEFAULT = false;
        private final HMaster master;
        private final long timeout;
        private final boolean haltOnTimeout;

        InitializationMonitor(HMaster master) {
            super("MasterInitializationMonitor");
            this.master = master;
            this.timeout = master.getConfiguration().getLong(TIMEOUT_KEY, TIMEOUT_DEFAULT);
            this.haltOnTimeout = master.getConfiguration().getBoolean(HALT_KEY, false);
            this.setDaemon(true);
        }

        public void run() {
            try {
                while (!this.master.isStopped() && this.master.isActiveMaster()) {
                    Thread.sleep(this.timeout);
                    if (this.master.isInitialized()) {
                        LOG.debug((Object)"Initialization completed within allotted tolerance. Monitor exiting.");
                        continue;
                    }
                    LOG.error((Object)("Master failed to complete initialization after " + this.timeout + "ms. Please" + " consider submitting a bug report including a thread dump of this process."));
                    if (!this.haltOnTimeout) continue;
                    LOG.error((Object)"Zombie Master exiting. Thread dump to stdout");
                    Threads.printThreadInfo((PrintStream)System.out, (String)"Zombie HMaster");
                    System.exit(-1);
                }
            }
            catch (InterruptedException ie) {
                LOG.trace((Object)"InitMonitor thread interrupted. Existing.");
            }
        }
    }
}

