/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.util.MD5Hash;

@InterfaceAudience.Private
public class MobFileName {
    private final String date;
    private final String startKey;
    private final String uuid;
    private final String fileName;
    private static final int STARTKEY_END_INDEX = 32;
    private static final int DATE_END_INDEX = 40;
    private static final int UUID_END_INDEX = 72;

    private MobFileName(byte[] startKey, String date, String uuid) {
        this.startKey = MD5Hash.getMD5AsHex((byte[])startKey, (int)0, (int)startKey.length);
        this.uuid = uuid;
        this.date = date;
        this.fileName = this.startKey + this.date + this.uuid;
    }

    private MobFileName(String startKey, String date, String uuid) {
        this.startKey = startKey;
        this.uuid = uuid;
        this.date = date;
        this.fileName = this.startKey + this.date + this.uuid;
    }

    public static MobFileName create(byte[] startKey, String date, String uuid) {
        return new MobFileName(startKey, date, uuid);
    }

    public static MobFileName create(String startKey, String date, String uuid) {
        return new MobFileName(startKey, date, uuid);
    }

    public static MobFileName create(String fileName) {
        String startKey = fileName.substring(0, 32);
        String date = fileName.substring(32, 40);
        String uuid = fileName.substring(40, 72);
        return new MobFileName(startKey, date, uuid);
    }

    public static String getStartKeyFromName(String fileName) {
        return fileName.substring(0, 32);
    }

    public static String getDateFromName(String fileName) {
        return fileName.substring(32, 40);
    }

    public String getStartKey() {
        return this.startKey;
    }

    public String getDate() {
        return this.date;
    }

    public int hashCode() {
        return this.fileName.hashCode();
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject instanceof MobFileName) {
            MobFileName another = (MobFileName)anObject;
            return this.getFileName().equals(another.getFileName());
        }
        return false;
    }

    public String getFileName() {
        return this.fileName;
    }
}

