/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.replication.ReplicationPeers;
import org.apache.hadoop.hbase.replication.ReplicationPeersZKImpl;
import org.apache.hadoop.hbase.replication.ReplicationQueues;
import org.apache.hadoop.hbase.replication.ReplicationQueuesArguments;
import org.apache.hadoop.hbase.replication.ReplicationQueuesClient;
import org.apache.hadoop.hbase.replication.ReplicationQueuesClientArguments;
import org.apache.hadoop.hbase.replication.ReplicationQueuesClientZKImpl;
import org.apache.hadoop.hbase.replication.ReplicationQueuesZKImpl;
import org.apache.hadoop.hbase.replication.ReplicationTracker;
import org.apache.hadoop.hbase.replication.ReplicationTrackerZKImpl;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ReplicationFactory {
    public static final Class defaultReplicationQueueClass = ReplicationQueuesZKImpl.class;

    public static ReplicationQueues getReplicationQueues(ReplicationQueuesArguments args) throws Exception {
        Class classToBuild = args.getConf().getClass("hbase.region.replica.replication.replicationQueues.class", defaultReplicationQueueClass);
        return (ReplicationQueues)ConstructorUtils.invokeConstructor((Class)classToBuild, (Object[])new Object[]{args});
    }

    public static ReplicationQueuesClient getReplicationQueuesClient(ReplicationQueuesClientArguments args) throws Exception {
        Class classToBuild = args.getConf().getClass("hbase.region.replica.replication.replicationQueuesClient.class", ReplicationQueuesClientZKImpl.class);
        return (ReplicationQueuesClient)ConstructorUtils.invokeConstructor((Class)classToBuild, (Object[])new Object[]{args});
    }

    public static ReplicationPeers getReplicationPeers(ZooKeeperWatcher zk, Configuration conf, Abortable abortable) {
        return ReplicationFactory.getReplicationPeers(zk, conf, null, abortable);
    }

    public static ReplicationPeers getReplicationPeers(ZooKeeperWatcher zk, Configuration conf, ReplicationQueuesClient queuesClient, Abortable abortable) {
        return new ReplicationPeersZKImpl(zk, conf, queuesClient, abortable);
    }

    public static ReplicationTracker getReplicationTracker(ZooKeeperWatcher zookeeper, ReplicationPeers replicationPeers, Configuration conf, Abortable abortable, Stoppable stopper) {
        return new ReplicationTrackerZKImpl(zookeeper, replicationPeers, conf, abortable, stopper);
    }
}

